/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.mutex.MutexServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.enums.PermEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.faranalysis.AbstractDesignTreePlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.design.AnalysisDesignExportPlugin;
import kd.epm.far.formplugin.faranalysis.myanalysis.MyAnalysisHelper;
import kd.epm.far.formplugin.faranalysis.themeanalysis.ThemeAnalysisHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;

public class AnalysisDesignListPlugin
extends AbstractDesignTreePlugin {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String FOCUS_NODE_ID = "focusnodeid";
    private static final String TREE_CHECK_BOX = "treecheckbox";
    private static final String TEMPLATE_CATALOG = "templatecatalog";
    private static final String CTL_MODEL = "modelbd";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.setBillFormId(this.getBizEntityNumber());
        billList.addHyperClickListener(this::hyperLinkClick);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long dmModelId = this.getDMModelId();
        this.addCatalogRoot(dmModelId);
        super.afterCreateNewData(e);
        this.getModel().setValue(CTL_MODEL, (Object)dmModelId);
        this.getPageCache().put("dmmodelid", dmModelId.toString());
        this.refrushBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        String key = e.getProperty().getName();
        if (key.equals(TREE_CHECK_BOX)) {
            this.refrushBillList();
        } else if (key.equals(CTL_MODEL)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
                return;
            }
            this.getPageCache().put("KEY_MODEL_ID", this.getDMModelId().toString());
            this.addCatalogRoot(this.getDMModelId());
            TreeView tree = (TreeView)this.getControl(TEMPLATE_CATALOG);
            tree.deleteAllNodes();
            this.initTree();
            this.refrushBillList();
        }
    }

    private void addCatalogRoot(Long dmModelId) {
        QFilter mqFilter = new QFilter("model", "=", (Object)dmModelId);
        QFilter nqFilter = new QFilter("number", "=", (Object)"root");
        boolean exists = QueryServiceHelper.exists((String)"fidm_tmplcatalog", (QFilter[])new QFilter[]{mqFilter, nqFilter, this.getCatalogtypeQFilter()});
        if (!exists) {
            this.createRootNode(dmModelId);
        }
    }

    private void createRootNode(Long dmModelId) {
        DiscTemplateCatalogTypeEnum catalogTypeEnum = DiscTemplateCatalogTypeEnum.getCatalogByAppId((String)this.getBizAppId());
        DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)"fidm_tmplcatalog");
        catalog.set("model", (Object)dmModelId);
        catalog.set("number", (Object)"root");
        catalog.set("longnumber", (Object)"root");
        catalog.set("name", catalogTypeEnum.getLanguageName());
        catalog.set("isleaf", (Object)Boolean.TRUE);
        catalog.set("catalogtype", (Object)catalogTypeEnum.getType());
        catalog.set("status", (Object)"C");
        catalog.set("enable", (Object)"1");
        SaveServiceHelper.save((IDataEntityType)catalog.getDynamicObjectType(), (Object[])new Object[]{catalog});
        this.refrushTree();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "bar_add": {
                String catelogId = this.getPageCache().get(FOCUS_NODE_ID);
                if (catelogId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7c7b\u540e\u518d\u64cd\u4f5c\u3002", (String)"AnalysisDesignListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("modelId", Long.valueOf(this.getPageCache().get("dmmodelid")));
                params.put("templateCatalogId", Long.valueOf(this.getPageCache().get(FOCUS_NODE_ID)));
                String title = ResManager.loadKDString((String)"\u65b0\u589e\u770b\u677f", (String)"AnalysisDesignListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
                this.openFormPage("fidm_template", title, params);
                break;
            }
            case "bar_delete": {
                this.deleteTemplate();
                break;
            }
            case "bar_copy": {
                this.copyTempalte();
                break;
            }
            case "bar_enable": {
                this.setStatus(true);
                break;
            }
            case "bar_disable": {
                DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                if (tempObjs != null && !tempObjs[0].getBoolean("status")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u8bbe\u8ba1\u5df2\u7981\u7528\u3002", (String)"AnalysisDesignListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (tempObjs == null) break;
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7981\u7528\u5206\u6790\u8bbe\u8ba1\u201c%s\u201d\u540e\u5c06\u4e0d\u80fd\u53d1\u5e03\uff0c\u786e\u8ba4\u7981\u7528\uff1f", (String)"AnalysisDesignListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), tempObjs[0].getString("name")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disableTempalte_comfirm", (IFormPlugin)this));
                break;
            }
            case "bar_preview": {
                Object[] selectedIds = this.getSelectedIds();
                if (selectedIds == null) break;
                ModelInfo modelInfo = this.getDiscModel();
                if (Objects.isNull(modelInfo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u4f53\u7cfb\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"AnalysisDesignListPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    break;
                }
                AnalysisServiceHelper.previewSelect((AbstractFormPlugin)this, this.getDMModelId(), modelInfo.getId(), this.getView().getPageId(), LongUtil.toLong((Object)selectedIds[0]));
                break;
            }
            case "bar_refresh": {
                this.refrushTree();
                this.refreshPermCache();
                this.refrushBillList();
                break;
            }
            case "my_analysis": {
                DynamicObject[] tempSelectObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                if (tempSelectObjs == null || tempSelectObjs.length <= 0) break;
                if (!tempSelectObjs[0].getBoolean("status")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5f53\u524d\u5206\u6790\u770b\u677f\u540e\u518d\u53d1\u5e03\u3002", (String)"AnalysisDesignListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                MyAnalysisHelper.openAdd((AbstractFormPlugin)this, this.getDMModelId(), tempSelectObjs[0].getLong("id"));
                break;
            }
            case "subject_analysis": {
                DynamicObject[] tempThemSelectObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                if (tempThemSelectObjs == null || tempThemSelectObjs.length <= 0) break;
                if (!tempThemSelectObjs[0].getBoolean("status")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u5df2\u88ab\u7981\u7528\u3002", (String)"AnalysisDesignListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                ThemeAnalysisHelper.openAdd((AbstractFormPlugin)this, this.getDMModelId(), tempThemSelectObjs[0].getLong("id"));
                break;
            }
            case "bar_baseinfo": {
                this.modifyBaseInfo();
                break;
            }
            case "bar_import": {
                String catelogId = this.getPageCache().get(FOCUS_NODE_ID);
                if (catelogId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7c7b\u540e\u518d\u64cd\u4f5c\u3002", (String)"AnalysisDesignListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("dmmodelid", Long.valueOf(this.getPageCache().get("dmmodelid")));
                params.put("templateCatalogId", Long.valueOf(this.getPageCache().get(FOCUS_NODE_ID)));
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("far_analysisdesignimport");
                showParameter.setCustomParams(params);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "far_analysisdesignimport"));
                this.getView().showForm(showParameter);
                break;
            }
            case "bar_export": {
                BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
                ListSelectedRowCollection collection = billList.getSelectedRows();
                if (collection.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListSelectedRow row = collection.get(0);
                this.exportTemplate(row);
                break;
            }
            case "bar_importlog": {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("modelId", Long.valueOf(this.getPageCache().get("dmmodelid")));
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("far_analysisimportloglist");
                showParameter.setCustomParams(params);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void exportTemplate(ListSelectedRow row) {
        AnalysisDesignExportPlugin exportPlugin = new AnalysisDesignExportPlugin(this.getModelId(), (Long)row.getPrimaryKeyValue());
        try {
            String url = exportPlugin.exportTemplate();
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.getClientViewProxy().addAction("download", (Object)url);
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5206\u6790\u770b\u677f \u201c%1$s\u201d \u5bfc\u51fa\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_24", (String)"epm-far-formplugin", (Object[])new Object[0]), row.getNumber()));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void modifyBaseInfo() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null && selectedIds.length > 0) {
            Object templateID = selectedIds[0];
            this.openAnalysisBaseInfo(templateID);
        }
    }

    private void refreshPermCache() {
        this.getPageCache().remove("readonlylist");
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (!StringUtils.isEmpty((CharSequence)nodeId) && this.isNodeReadOnly(nodeId)) {
            this.getPageCache().put("nodeperm", "2");
            this.setButtonEnable(Boolean.FALSE, Boolean.TRUE);
        } else {
            this.getPageCache().put("nodeperm", "3");
            this.setButtonEnable(Boolean.TRUE, Boolean.TRUE);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() > 0 && !StringUtils.equals((CharSequence)"2", (CharSequence)this.getPageCache().get("nodeperm"))) {
            DynamicObject template;
            String cataLogId;
            boolean isCatalogOnlyRead;
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            Long selectNodeId = 0L;
            if (selectNodeIds != null) {
                selectNodeId = LongUtil.toLong((Object)selectNodeIds[0]);
            }
            if (isCatalogOnlyRead = this.isNodeReadOnly(cataLogId = (template = BusinessDataServiceHelper.loadSingle((Object)selectNodeId, (String)"fidm_template")).getString("templatecatalog.id"))) {
                this.setButtonEnable(Boolean.FALSE, Boolean.TRUE);
                this.getPageCache().put("template", "true");
            } else {
                String perm = PermClassEntityHelper.getSingleDiscPermission((String)"fidm_template", (Long)selectNodeId, (Long)this.getDMModelId(), (Long)this.getUserId(), (String)"fidmmodel", (String)this.getBizAppId());
                if (PermEnum.READONLY.getValue() == Integer.parseInt(perm)) {
                    this.setButtonEnable(Boolean.FALSE, Boolean.FALSE);
                    this.getPageCache().put("template", "true");
                } else {
                    this.setButtonEnable(Boolean.TRUE, Boolean.FALSE);
                    this.getPageCache().put("template", "false");
                }
            }
        } else if (billList.getSelectedRows().size() == 0 && !StringUtils.equals((CharSequence)"2", (CharSequence)this.getPageCache().get("nodeperm"))) {
            this.setButtonEnable(Boolean.TRUE, Boolean.FALSE);
        }
    }

    private void copyTempalte() {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            String newNumber = tempObjs[0].getString("number").concat("copy");
            String newName = tempObjs[0].getString("name").concat("copy");
            QFilter qf = new QFilter("model", "=", (Object)tempObjs[0].getLong("model.id"));
            qf.and("number", "=", (Object)newNumber);
            if (newNumber.length() > 50 || newName.length() > 100) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u8d85\u8fc7\u957f\u5ea6\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u3002", (String)"AnalysisDesignListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("copyTempalte_comfirm", (IFormPlugin)this));
            } else if (QueryServiceHelper.exists((String)"fidm_template", (QFilter[])qf.toArray())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u3002", (String)"AnalysisDesignListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("copyTempalte_comfirm", (IFormPlugin)this));
            } else {
                AnalysisCommonOperateHelper.copyTempalte(tempObjs[0], newNumber, newName, this.getBizAppId());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.refrushBillList();
            }
        }
    }

    private Map<String, Object> buildOpenFormPageParams() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("modelId", Long.valueOf(this.getPageCache().get("dmmodelid")));
            params.put("templateId", selectedIds[0]);
            params.put("type", "generate");
            return params;
        }
        return null;
    }

    private void deleteTemplate() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds != null) {
            String pageId;
            IFormView openTemplateView;
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)selectedIds[0], (DynamicObjectType)billList.getEntityType());
            Boolean status = dynamicObject.getBoolean("status");
            if (status.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u770b\u677f\u5df2\u542f\u7528\uff0c\u8bf7\u5148\u7981\u7528\u540e\u518d\u5220\u9664\u3002", (String)"AnalysisDesignListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            IFormView mainPageView = this.getView().getMainView();
            if (Objects.nonNull(mainPageView) && Objects.nonNull(openTemplateView = mainPageView.getView(pageId = this.getView().getPageId() + selectedIds[0] + "far_analysisdesign"))) {
                String templateNum = dynamicObject.getString("number");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u770b\u677f\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\uff0c\u8bf7\u5148\u5173\u95ed\u5206\u6790\u770b\u677f\u201c%s\u201d\u9875\u7b7e\u3002", (String)"AnalysisDesignListPlugin_21", (String)"epm-far-formplugin", (Object[])new Object[0]), templateNum));
                return;
            }
            Map lockInfo = MutexServiceHelper.getLockInfo((String)String.valueOf(selectedIds[0]), (String)"far_analysisdesign", (String)"ANALYSIS_DESIGN");
            if (Objects.nonNull(lockInfo)) {
                String lockedUserId = (String)lockInfo.get("userid");
                Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(lockedUserId));
                String currentUserName = (String)userInfo.get("name");
                String templateNum = dynamicObject.getString("number");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AnalysisDesignListPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]), templateNum, currentUserName));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"AnalysisDesignListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteTemplate_comfirm", (IFormPlugin)this));
        }
    }

    private void setStatus(boolean status) {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if (tempObjs != null) {
            if (status && tempObjs[0].getBoolean("status")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u8bbe\u8ba1\u5df2\u542f\u7528\u3002", (String)"AnalysisDesignListPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            tempObjs[0].set("status", (Object)(status ? "1" : "0"));
            try {
                SaveServiceHelper.save((DynamicObject[])tempObjs);
                if (status) {
                    this.writeOpLog(OperationResult.SUCCESS, OperationName.ENABLE, tempObjs[0]);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
                } else {
                    this.writeOpLog(OperationResult.SUCCESS, OperationName.DISABLE, tempObjs[0]);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                if (status) {
                    this.writeOpLog(OperationResult.FAILURE, OperationName.ENABLE, tempObjs[0]);
                } else {
                    this.writeOpLog(OperationResult.FAILURE, OperationName.DISABLE, tempObjs[0]);
                }
                throw e;
            }
            this.refrushBillList();
        }
    }

    private void doDeleteTemplate() {
        Object[] selectedIds = this.getSelectedIds();
        if (selectedIds == null) {
            return;
        }
        QFilter filter = new QFilter("id", "in", selectedIds[0]);
        DeleteServiceHelper.delete((String)"fidm_template", (QFilter[])filter.toArray());
        QFilter permFilter = new QFilter("entityid", "in", selectedIds[0]);
        permFilter.and("fidmmodel", "=", (Object)this.getDMModelId());
        DeleteServiceHelper.delete((String)"bcm_permclass_entity", (QFilter[])permFilter.toArray());
        QFilter qf = new QFilter("template", "=", selectedIds[0]);
        DeleteServiceHelper.delete((String)"fidm_report", (QFilter[])qf.toArray());
        QFilter chapterfilter = new QFilter("template", "=", selectedIds[0]);
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])chapterfilter.toArray());
        ArrayList chapterIds = new ArrayList(2);
        chapters.stream().forEach(m -> chapterIds.add(m.getLong("id")));
        for (Long chapterId : chapterIds) {
            DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
            DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
            List moduleIds = chapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
            if (moduleIds.size() <= 0) continue;
            DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])new QFilter[]{new QFilter("id", "in", moduleIds)});
        }
        DeleteServiceHelper.delete((String)"fidm_disc_variable", (QFilter[])new QFilter("chapterid", "in", chapterIds).toArray());
        DeleteServiceHelper.delete((String)"fidm_dataset", (QFilter[])new QFilter("chapterid", "in", chapterIds).toArray());
        DeleteServiceHelper.delete((String)"fidm_chapter", (QFilter[])chapterfilter.toArray());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
        this.refrushBillList();
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return null;
        }
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (actionId.equals("fidm_template")) {
            if (returnData != null) {
                this.showAnyliscTemplateEdit((Long)returnData);
            }
            this.refrushBillList();
        } else if (actionId.equals("far_analysiscopy") && returnData != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.refrushBillList();
        } else if (Objects.equals("far_myanalysis", actionId)) {
            if (Objects.nonNull(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if (Objects.equals("far_themeanalysisboard", actionId)) {
            if (Objects.nonNull(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if (actionId.equals("fidm_tmpl_modifyBaseInfo") && returnData != null) {
            this.refrushBillList();
        } else if (Objects.equals("far_analysis_preview", actionId) || Objects.equals("far_preview_config", actionId)) {
            if (Objects.nonNull(returnData)) {
                Object[] selectedIds = this.getSelectedIds();
                if (selectedIds == null || selectedIds.length == 0) {
                    return;
                }
                Map returnInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)String.valueOf(returnData));
                String previewResult = (String)returnInfo.get("previewresult");
                if (Objects.nonNull(previewResult)) {
                    AnalysisServiceHelper.previewWindow((AbstractFormPlugin)this, this.getDMModelId(), previewResult, LongUtil.toLong((Object)selectedIds[0]));
                }
            }
        } else if ("openAnalysisBaseInfo".equals(actionId)) {
            this.refrushBillList();
            if (Objects.nonNull(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalysisTemplateInfoPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else if ("far_analysisdesignimport".equals(actionId)) {
            this.refrushBillList();
            if (Objects.nonNull(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u6790\u770b\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"AnalysisDesignImportPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("deleteTemplate_comfirm".equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            Object[] selectedIds = this.getSelectedIds();
            if (Objects.isNull(selectedIds)) {
                return;
            }
            QFilter filter = new QFilter("id", "in", selectedIds[0]);
            DynamicObject template = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
            try {
                this.doDeleteTemplate();
                this.writeOpLog(OperationResult.SUCCESS, OperationName.DELETE, template);
            }
            catch (Exception e) {
                this.writeOpLog(OperationResult.FAILURE, OperationName.DELETE, template);
                throw e;
            }
        } else if ("copyTempalte_comfirm".equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            Map<String, Object> preview = this.buildOpenFormPageParams();
            if (preview != null) {
                this.openFormPage("far_analysiscopy", ResManager.loadKDString((String)"\u7f16\u7801\u540d\u79f0\u7ef4\u62a4", (String)"AnalysisDesignListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), preview);
            }
        } else if ("disableTempalte_comfirm".equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.setStatus(false);
        } else if ("settingmodel".equals(callBackId)) {
            ListShowParameter lShowParameter = new ListShowParameter();
            lShowParameter.setBillFormId("fidm_model");
            HashMap parameter = new HashMap();
            lShowParameter.setCustomParams(parameter);
            lShowParameter.setCustomParam("billFormId", (Object)"fidm_model");
            lShowParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
            lShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)lShowParameter);
            this.getView().invokeOperation("close");
        }
    }

    @Override
    protected void refrushBillList() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        QFilter filter = new QFilter("model", "=", (Object)this.getDMModelId());
        this.getCatalogqFilter(filter);
        this.addPermClassFilter(filter);
        billList.clearSelection();
        billList.setFilterParameter(new FilterParameter(filter, "sequence asc,number asc"));
        billList.refresh();
    }

    private void addPermClassFilter(QFilter qFilter) {
        ArrayList noPermIds = new ArrayList();
        noPermIds.addAll(PermClassEntityHelper.getDiscPermissionMap((String)"fidm_template", (Long)this.getDMModelId(), (Long)this.getUserId(), (String)this.getBizAppId()).get((Object)"1"));
        qFilter.and(new QFilter("id", "not in", noPermIds));
    }

    private void getCatalogqFilter(QFilter filter) {
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (nodeId != null) {
            QFilter qFilter1 = new QFilter(TEMPLATE_CATALOG, "=", (Object)LongUtil.toLong((Object)nodeId));
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(TREE_CHECK_BOX).toString());
            if (isallchild) {
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                ArrayList<String> list = new ArrayList<String>(16);
                this.queryAllChildNodeList(nodeId, treeList, list);
                if (list.size() > 0) {
                    qFilter1.or(TEMPLATE_CATALOG, "in", (Object)LongUtil.toLongList(list));
                }
            }
            filter.and(qFilter1);
        } else {
            filter.and(new QFilter("1", "!=", (Object)1));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)arg).getCurrentRow();
        this.showAnyliscTemplateEdit((Long)currentRow.getPrimaryKeyValue());
    }

    private void showAnyliscTemplateEdit(Long templateId) {
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getView().getPageId() + templateId + "far_analysisdesign";
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"fidm_template", (String)"id, name, number");
            customParams.put("templateID", templateDy.get("id"));
            customParams.put("number", templateDy.getString("number"));
            customParams.put("fileName", templateDy.getString("name"));
            customParams.put("appId", this.getBizAppId());
            customParams.put("chapterId", AnalysisServiceHelper.getDefaultChapterId(this.getDMModelId(), templateId).toString());
            customParams.put("dmmodelid", this.getDMModelId());
            customParams.put("template", this.getPageCache().get("template"));
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("far_analysisdesign");
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCaption(templateDy.getString("name"));
            formShowParameter.setPageId(pageId);
            if (parentView != null) {
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void checkPerm(String opkey) {
        if ((opkey.equals("btn_addnew") || opkey.equals("btn_modify") || opkey.equals("btn_delete") || opkey.equals("btn_up") || opkey.equals("btn_down")) && this.getPageCache().get("categoryReadOnly") != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"AnalysisDesignListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        super.checkPerm(opkey);
    }

    private void openAnalysisBaseInfo(Object templateID) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("far_analysis_baseinfo");
        param.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AnalysisDesignListPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        param.setCustomParam("analysis_id", templateID);
        if (Objects.nonNull(this.getModel().getValue(CTL_MODEL))) {
            Long modelId = LongUtil.toLong((Object)((DynamicObject)this.getModel().getValue(CTL_MODEL)).getLong("id"));
            param.setCustomParam("model", (Object)modelId);
        }
        param.setCustomParam("template", (Object)this.getPageCache().get("template"));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openAnalysisBaseInfo"));
        param.setAppId((String)this.getFormCustomParam("appId"));
        this.getView().showForm(param);
    }

    private void openFormPage(String formId, String caption, Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        params.put("classname", AnalysisDesignListPlugin.class.getName());
        formShowParameter.setCustomParams(params);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(caption);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public String getModelSign() {
        return CTL_MODEL;
    }

    private void writeOpLog(OperationResult result, OperationName opName, DynamicObject template) {
        String templateNumber = template != null ? template.getString("number") : "";
        super.writeOpLog(OperationCategory.ANALYSIS_DESIGN, opName, result, "far_analysisdesign", templateNumber);
    }
}

