/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.mutex.MutexServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.faranalysis.AbstractAnalysisPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.ai.TaskServiceHelper;
import kd.epm.far.formplugin.faranalysis.myanalysis.MyAnalysisHelper;
import kd.epm.far.formplugin.faranalysis.themeanalysis.ThemeAnalysisHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisDesignVarsHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisVariableHelper;
import org.apache.commons.collections.CollectionUtils;

public class AnalysisDesignPlugin
extends AbstractAnalysisPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    protected static final String ANALYSIS_DESIGN = "ANALYSIS_DESIGN";
    protected static final String ISLOCKED = "ISLOCKED";
    protected static final String ISTEMPLATEONLYREAD = "template";
    private static final String PARAM_TEMPLATEID = "templateID";
    private static final String KEY_DESIGN_CHAPTER_ID = "defaultChapterId";
    private static final String KEY_DESIGN_TEMPLATE_ID = "KEY_DESIGN_TEMPLATE_ID";
    private static final String CTL_TOOLBAR_AP = "toolbarap";
    private static final String DATASET_BASEDATA = "dataset_basedata";
    private static final String DATASET_BASEDATA_FORMULA = "dataset_basedata_formula";
    private static final String FLEXPANELAPQUERY = "flexpanelapquery";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_PREVIEW = "btn_preview";
    private static final String BTN_CLEAR = "btn_clear";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_RETURN = "btn_return";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BTN_FORWARD = "btn_forward";
    private static final String BTN_BACKWARD = "btn_backward";
    private static final String BTN_ALLSCREEN = "btn_allscreen";
    private static final String BTN_BASEINFO = "btn_baseinfo";
    private static final String BTN_CAT_PUBLISHLOG = "btn_cat_publishlog";
    private static final String BTN_MYANALYSIS = "btn_myanalysis";
    private static final String BTN_THEMEANALYSIS = "btn_themeanalysis";
    private static final String ANALYSIS_TEMPLATE_ID = "analysistemplateid";
    private static final String CLOSEDCALLBACK_ADD_VARIABLE = "dm_disc_variable_close";
    private static final String CLOSEDCALLBACK_ADD_DATASET = "closedcallback_add_dataset";
    private static final String CALLBACKID_DEL_CONFIRM = "callbackid_delVar_confirm";
    private static final String CALLBACKID_DELDATASET_CONFIRM = "callbackid_delDataSet_confirm";
    private static final String FIMDMODEL = "fidmmodel";
    private static final String IS_OPENED_PAGE = "isOpenedPage";

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit datasetBasedata;
        super.registerListener(e);
        this.addItemClickListeners(CTL_TOOLBAR_AP);
        this.addClickListeners(BTN_SAVE, BTN_PREVIEW, BTN_CLEAR);
        if (this.getControl(DATASET_BASEDATA) != null) {
            datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA);
            datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            datasetBasedata.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if (this.getControl(DATASET_BASEDATA_FORMULA) != null) {
            datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA_FORMULA);
            datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            datasetBasedata.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (Objects.isNull(this.getDmModelId()) || this.getDmModelId() <= 0L) {
            return;
        }
        Long t = (Long)this.getFormCustomParam(PARAM_TEMPLATEID);
        if (Objects.isNull(t) || t.equals(0L)) {
            return;
        }
        this.initTemplate();
        this.initDefaultChapter();
        this.changeView(true);
        this.dataInit();
        this.lockToolBar();
        String msg = this.checkAnalysisTemplatePerm();
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
        }
    }

    @Override
    public void customEvent(CustomEventArgs evt) {
        super.customEvent(evt);
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        try {
            AnalysisDesignConstants.CallBackType callBackType = AnalysisDesignConstants.CallBackType.valueOf(eventName);
            this.putCallBackType(callBackType, eventArgs);
        }
        catch (Exception ex) {
            AbstractBaseFormPlugin.log.error((Throwable)ex);
            return;
        }
    }

    protected void lockToolBar() {
        if (this.isLockedAnalysisView()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_CLEAR, BTN_BASEINFO, "bar_publish", BTN_PREVIEW});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_SAVE, BTN_CLEAR, BTN_BASEINFO, "bar_publish", BTN_PREVIEW});
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.releaseLock();
    }

    protected boolean isLockedAnalysisView() {
        String lockId = this.getCurrTmpId();
        Map lockInfo = MutexServiceHelper.getLockInfo((String)lockId, (String)"far_analysisdesign", (String)ANALYSIS_DESIGN);
        if (Objects.isNull(lockInfo) || CollectionUtils.isEmpty(Collections.singleton(lockInfo))) {
            Boolean isLocked = MutexServiceHelper.request((String)lockId, (String)"far_analysisdesign", (String)ANALYSIS_DESIGN);
            if (isLocked.booleanValue()) {
                this.getView().getPageCache().put(ISLOCKED, ISLOCKED);
                return false;
            }
        } else {
            String lockedUserId = (String)lockInfo.get("userid");
            Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(lockedUserId));
            String currentUserName = (String)userInfo.get("name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d \u6b63\u5728\u7f16\u8f91\u8be5\u5206\u6790\u770b\u677f\uff0c\u5f53\u524d\u4ec5\u4e3a\u67e5\u770b\u3002", (String)"AnalysisDesignPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]), currentUserName));
            return true;
        }
        return true;
    }

    protected void releaseLock() {
        boolean isRelease;
        Map lockInfo;
        String lockId;
        QFilter lockedFilter;
        boolean lockedExist;
        if (StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get(ISLOCKED)) && (lockedExist = QueryServiceHelper.exists((String)"bos_datalock", (QFilter[])new QFilter[]{lockedFilter = new QFilter("objectid", "=", (Object)(lockId = this.getCurrTmpId()))})) && (lockInfo = MutexServiceHelper.getLockInfo((String)lockId, (String)"far_analysisdesign", (String)ANALYSIS_DESIGN)) != null && lockInfo.size() > 0 && (isRelease = MutexServiceHelper.release((String)lockId, (String)"far_analysisdesign", (String)ANALYSIS_DESIGN))) {
            this.getView().getPageCache().remove(ISLOCKED);
        }
    }

    private String getCurrTmpId() {
        String lockId = null;
        if (Objects.nonNull(this.getFormCustomParam(PARAM_TEMPLATEID))) {
            lockId = this.getFormCustomParam(PARAM_TEMPLATEID) + "";
        }
        return lockId;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "fidm_dsfilter_entry": {
                this.datasetFilterEntryCallback(returnData);
                break;
            }
            case "dm_disc_variable_close": {
                this.varRefresh(AnalysisDesignConstants.CallBackType.EVENT_VAR_ADD);
                break;
            }
            case "closedcallback_add_dataset": {
                this.dsRefresh(AnalysisDesignConstants.CallBackType.EVENT_DS_ADD);
                break;
            }
            case "far_myanalysis": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AnalysisDesignPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "far_themeanalysisboard": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"AnalysisDesignPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "far_module_reportity_bak": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalysisDesignPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "far_analysis_baseinfo": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalysisTemplateInfoPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Override
    protected void previewWithNoDeSerialized(String eventArgs, boolean isDesignMode) {
        if (Objects.nonNull(eventArgs)) {
            JSONObject jsonObject;
            JSONArray itemList;
            if (this.getView() != null) {
                this.changeView(false);
            }
            if (Objects.isNull(itemList = (jsonObject = JSON.parseObject((String)eventArgs)).getJSONArray("itemList"))) {
                JSONObject item = jsonObject.getJSONObject("item");
                itemList = new JSONArray();
                itemList.add((Object)item);
            }
            Object result = AnalysisDesignHelper.dataPreviewResult(isDesignMode, itemList, jsonObject.getJSONObject("pageConfig"), jsonObject.getJSONObject("queryConfig"), jsonObject.getJSONObject("i18n"), jsonObject.getLong("chapterId"));
            this.SendToVue(result);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "callbackid_delVar_confirm": {
                String id;
                JSONObject jsonObject;
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult()) || !Objects.nonNull(jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_VAR_DELETE)) || StringUtils.isEmpty((CharSequence)(id = jsonObject.getString("id")))) break;
                HashSet<Long> ids = new HashSet<Long>(10);
                ids.add(Long.parseLong(id));
                QFilter filter = new QFilter("id", "in", ids);
                int delete = BusinessDataWriter.delete((String)"fidm_disc_variable", (QFilter[])new QFilter[]{filter});
                if (delete != 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalysisDesignPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                this.varRefresh(AnalysisDesignConstants.CallBackType.EVENT_VAR_DELETE);
                break;
            }
            case "callbackid_delDataSet_confirm": {
                String id;
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                HashSet<Long> ids = new HashSet<Long>(10);
                JSONObject jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_DS_DELETE);
                if (!Objects.nonNull(jsonObject) || StringUtils.isEmpty((CharSequence)(id = jsonObject.getString("id"))) || !StringUtils.isEmpty((CharSequence)this.checkDataSetPerm(id))) break;
                ids.add(Long.parseLong(id));
                if (QueryServiceHelper.exists((String)"fidm_modulerepository", (QFilter[])new QFilter[]{new QFilter("datasetid", "=", (Object)LongUtil.toLong((Object)id))})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\"%s\"\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean res = DatasetServiceHelper.deleteDataSet(ids);
                if (res) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AnalysisDesignPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"AnalysisDesignPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                this.dsRefresh(AnalysisDesignConstants.CallBackType.EVENT_DS_DELETE);
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        super.beforeF7Select(evt);
        if (Objects.isNull(this.getDmModelId())) {
            return;
        }
        switch (key = evt.getProperty().getName()) {
            case "dataset_basedata": {
                String typeStr;
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter filter = DatasetServiceHelper.getAllDataSetAndChapterDataSetQFilter((Long)this.getDmModelId(), (Long)this.getDefaultChapterId(), (String)ApplicationTypeEnum.FAR.getAppnum());
                JSONObject jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_DS_F7);
                if (Objects.nonNull(jsonObject) && !StringUtils.isEmpty((CharSequence)(typeStr = jsonObject.getString("type")))) {
                    filter.and("type", "in", Arrays.asList(ModuleEnum.getModuleByNumber((String)typeStr).getDatasetTypes()));
                }
                ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
                listFilterParameter.setOrderBy("createtime desc");
                break;
            }
            case "dataset_basedata_formula": {
                ListShowParameter formParameter = (ListShowParameter)evt.getFormShowParameter();
                JSONObject json = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_DATASET_FORMULA);
                if (!Objects.nonNull(json)) break;
                QFilter formulaFilter = new QFilter("dataset", "=", (Object)json.getLong("id"));
                formParameter.getListFilterParameter().setFilter(formulaFilter);
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afevt) {
        Object newVaule;
        String key = ((BasedataEdit)afevt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)DATASET_BASEDATA)) {
            Object newVaule2 = this.getModel().getValue(DATASET_BASEDATA);
            if (Objects.nonNull(newVaule2)) {
                String primaryKey = this.getCallBackPrimaryKey(AnalysisDesignConstants.CallBackType.EVENT_DS_F7);
                Object data = AnalysisServiceHelper.dsF7Result(this.getDmModelId(), this.getSourceModelId(), this.getDefaultChapterId(), (DynamicObject)newVaule2, primaryKey);
                this.SendToVue(data);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)DATASET_BASEDATA_FORMULA) && Objects.nonNull(newVaule = this.getModel().getValue(DATASET_BASEDATA_FORMULA))) {
            String primaryKey = this.getCallBackPrimaryKey(AnalysisDesignConstants.CallBackType.EVENT_DATASET_FORMULA);
            String cache = this.getPageCache().get("KEY_EVENT_DATASET_FORMULA");
            Object data = AnalysisServiceHelper.datasetFormulaResult((DynamicObject)newVaule, primaryKey, cache, this.getDmModelId());
            this.SendToVue(data);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                String msg = this.checkAnalysisTemplatePerm();
                if (!StringUtils.isEmpty((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_SAVE));
                break;
            }
            case "btn_preview": {
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_PREVIEW));
                break;
            }
            case "btn_allscreen": {
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_FULLSCREEN));
                break;
            }
            case "btn_refresh": {
                if (StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get(ISLOCKED))) {
                    this.lockToolBar();
                }
                this.dataInit();
                break;
            }
            case "btn_clear": {
                this.dataReset();
                break;
            }
            case "btn_return": {
                this.previewReturn();
                break;
            }
            case "btn_baseinfo": {
                this.modifyBaseInfo();
                break;
            }
            case "test": {
                this.evSelectImage("");
                break;
            }
            case "btn_cat_publishlog": {
                this.catPublishLogView();
                break;
            }
            case "btn_myanalysis": {
                MyAnalysisHelper.openAdd(this, this.getDMModelId(), this.getTemplateId());
                break;
            }
            case "btn_themeanalysis": {
                ThemeAnalysisHelper.openAdd(this, this.getDMModelId(), this.getTemplateId());
                break;
            }
            case "btn_forward": {
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_REDO));
                break;
            }
            case "btn_backward": {
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_UNDO));
                break;
            }
            case "btn_ai": {
                TaskServiceHelper.sideBarInit(this.getView(), "process-24081325DDCB8C");
                break;
            }
        }
    }

    private void dataInit() {
        try {
            Object result = AnalysisServiceHelper.dataInit(this.getDmModelId(), this.getSourceModelId(), this.getDefaultChapterId(), false);
            Map lockInfo = MutexServiceHelper.getLockInfo((String)this.getCurrTmpId(), (String)"far_analysisdesign", (String)ANALYSIS_DESIGN);
            if (Objects.nonNull(lockInfo) && CollectionUtils.isNotEmpty(Collections.singleton(lockInfo))) {
                ((JSONObject)result).put(IS_OPENED_PAGE, (Object)true);
            }
            this.SendToVue(result);
        }
        catch (Exception ex) {
            this.dataError(ex);
        }
    }

    private void dataReset() {
        Object result = AnalysisServiceHelper.dataInit(this.getDmModelId(), this.getSourceModelId(), this.getDefaultChapterId(), true);
        this.SendToVue(result);
    }

    private void previewReturn() {
        this.changeView(true);
        this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_PREVIEW_CLOSE));
    }

    private void modifyBaseInfo() {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("far_analysis_baseinfo");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "far_analysis_baseinfo"));
        param.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"AnalysisDesignPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        Long analysis_id = (Long)this.getFormCustomParam(PARAM_TEMPLATEID);
        param.setCustomParam("analysis_id", (Object)analysis_id);
        param.setCustomParam("model", (Object)this.getDMModelId());
        param.setCustomParam(ISTEMPLATEONLYREAD, this.getView().getFormShowParameter().getCustomParam(ISTEMPLATEONLYREAD));
        param.setAppId((String)this.getFormCustomParam("appId"));
        this.getView().showForm(param);
    }

    @Override
    protected void evDSF7(String eventArgs) {
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA);
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        datasetBasedata.click();
    }

    @Override
    protected void evDatasetFormula(String eventArgs) {
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(DATASET_BASEDATA_FORMULA);
        if (Objects.nonNull(datasetBasedata)) {
            datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            datasetBasedata.click();
        }
    }

    @Override
    protected void evSave(String eventArgs) {
        JSONArray jsonArray = JSONObject.parseObject((String)eventArgs).getJSONArray("itemList");
        for (Object o : jsonArray) {
            JSONObject object = (JSONObject)o;
            String name = object.getString("name");
            if (Objects.nonNull(name) && name.length() > 50) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u4ef6\u540d\u79f0\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"AnalysisDesignPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!Objects.nonNull(name) || name.length() != 0) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisDesignPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            if (AnalysisServiceHelper.save(this.getDmModelId(), this.getDefaultChapterId(), eventArgs)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AnalysisDesignPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            this.writeOpLog(OperationResult.SUCCESS, OperationName.EDIT);
        }
        catch (Exception e) {
            this.writeOpLog(OperationResult.FAILURE, OperationName.EDIT);
            throw e;
        }
    }

    @Override
    protected void evVarAdd(String eventArgs) {
        this.checkPerm("btn_var_add");
        VariableService.openVariableEditView((IFormView)this.getView(), (IFormPlugin)this, null, (String)this.getDmModelId().toString(), (Long)this.getDefaultChapterId());
    }

    @Override
    protected void evVarDelete(String eventArgs) {
        this.checkPerm("btn_var_delete");
        String id = JSON.parseObject((String)eventArgs).getString("id");
        VariableService.showDelVarConfirmView((IFormView)this.getView(), (IFormPlugin)this, (String)id);
    }

    @Override
    protected void evVarEdit(String eventArgs) {
        this.checkPerm("btn_var_edit");
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        String id = JSON.parseObject((String)eventArgs).getString("id");
        VariableService.openVariableEditView((IFormView)this.getView(), (IFormPlugin)this, (String)id, (String)this.getDmModelId().toString(), (Long)this.getDefaultChapterId());
    }

    @Override
    protected void evDSAdd(String eventArgs) {
        this.checkPerm("btn_dataset_add");
        DatasetServiceHelper.openAddNewDataSetView((IFormView)this.getView(), (IFormPlugin)this, (String)this.getDmModelId().toString(), (Long)this.getDefaultChapterId(), (boolean)Boolean.TRUE);
    }

    @Override
    protected void evDSDelete(String eventArgs) {
        this.checkPerm("btn_dataset_delete");
        if (StringUtils.isEmpty((CharSequence)eventArgs)) {
            return;
        }
        String id = JSON.parseObject((String)eventArgs).getString("id");
        String msg = this.checkDataSetPerm(id);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            return;
        }
        DatasetServiceHelper.showDelDataSetConfirmView((IFormView)this.getView(), (IFormPlugin)this, (String)id);
    }

    @Override
    protected void evDSEdit(String eventArgs) {
        this.checkPerm("btn_dataset_edit");
        String id = JSON.parseObject((String)eventArgs).getString("id");
        String msg = this.checkDataSetPerm(id);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getPageCache().put("chapterDataSetPerm", "true");
        }
        DatasetServiceHelper.openEditDataSetView((IFormView)this.getView(), (IFormPlugin)this, (Long)Long.parseLong(id), (String)"fidm_dataset", (boolean)Boolean.TRUE);
    }

    @Override
    protected void evDatasetView(String eventArgs) {
        String id = JSON.parseObject((String)eventArgs).getString("id");
        DatasetServiceHelper.openPreviewPage((IFormView)this.getView(), (IFormPlugin)this, (long)this.getDmModelId(), (long)LongUtil.toLong((Object)id));
    }

    @Override
    protected void evDSFilter(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String datesetFilterItemsStr = "[]";
        Long datasetId = LongUtil.toLong((Object)jsonObject.getString("dsId"));
        JSONArray datesetFilterItems = jsonObject.getJSONArray("datesetFilterItems");
        if (!Objects.isNull(datesetFilterItems)) {
            datesetFilterItemsStr = datesetFilterItems.toJSONString();
        }
        if (Objects.isNull(datasetId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6570\u636e\u96c6\u201d\u3002", (String)"AnalysisDesignPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!DatasetServiceHelper.isMultiRowDataset((Long)datasetId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u201c\u6570\u636e\u96c6\u201d\u5fc5\u987b\u662f\u591a\u884c\u6570\u636e\u96c6\u3002", (String)"AnalysisDesignPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DatasetFilterHelper.openEdit((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getDmModelId(), (Long)datasetId, (String)datesetFilterItemsStr);
    }

    @Override
    protected void evSaveModule(String eventArgs) {
        this.checkPerm("btn_module_save");
        AnalysisServiceHelper.saveModule(this, this.getDmModelId(), this.getView().getPageId(), eventArgs);
    }

    @Override
    protected void evModuleAddItem(String eventArgs) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            Object newItem = AnalysisServiceHelper.moduleAddItem(this.getDmModelId(), this.getDefaultChapterId(), eventArgs);
            if (Objects.nonNull(newItem)) {
                Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_MODULE_ADDITEM_RESULT, newItem, jsonObject.getString("primaryKey"));
                this.SendToVue(result);
            }
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void initTemplate() {
        Long templateId = (Long)this.getFormCustomParam(PARAM_TEMPLATEID);
        this.getPageCache().put(KEY_DESIGN_TEMPLATE_ID, Objects.nonNull(templateId) ? templateId.toString() : "0");
    }

    private Long initDefaultChapter() {
        long modelId = this.getDmModelId();
        if (Objects.isNull(modelId) || modelId == 0L) {
            return 0L;
        }
        Long templateId = this.getTemplateId();
        Long defaultChapterId = AnalysisServiceHelper.getDefaultChapterId(modelId, templateId);
        this.getView().getPageCache().put(KEY_DESIGN_CHAPTER_ID, defaultChapterId + "");
        return defaultChapterId;
    }

    private Long getDefaultChapterId() {
        Long defaultChapterId = null;
        String defaultChapterIdStr = this.getPageCache().get(KEY_DESIGN_CHAPTER_ID);
        if (!StringUtils.isNotEmpty((CharSequence)defaultChapterIdStr) || Objects.equals("0", defaultChapterIdStr)) {
            return this.initDefaultChapter();
        }
        defaultChapterId = Long.valueOf(defaultChapterIdStr);
        return defaultChapterId;
    }

    private Long getTemplateId() {
        Long templateId = null;
        String templateIdTemp = this.getPageCache().get(KEY_DESIGN_TEMPLATE_ID);
        templateId = StringUtils.isNotEmpty((CharSequence)templateIdTemp) && !Objects.equals("0", templateIdTemp) ? Long.valueOf(templateIdTemp) : (Long)this.getFormCustomParam(PARAM_TEMPLATEID);
        return templateId;
    }

    private void changeView(boolean designView) {
        this.getView().setVisible(Boolean.valueOf(designView), new String[]{BTN_SAVE, BTN_PREVIEW, BTN_CLEAR, BTN_REFRESH, BTN_CLOSE, BTN_BASEINFO, BTN_FORWARD, BTN_BACKWARD});
        this.getView().setVisible(Boolean.valueOf(!designView), new String[]{BTN_RETURN, BTN_ALLSCREEN});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAPQUERY});
    }

    private void varRefresh(AnalysisDesignConstants.CallBackType callBackType) {
        List<Map<String, String>> chapterTreeList = AnalysisVariableHelper.getChapterVariableList(this.getDmModelId(), this.getDefaultChapterId());
        List<Map<String, Object>> localNewVarList = AnalysisDesignVarsHelper.buildCommonVarParams(chapterTreeList, this.getDmModelId());
        String primaryKey = this.getCallBackPrimaryKey(callBackType);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_VAR_REFRESH, localNewVarList, primaryKey);
        this.SendToVue(result);
    }

    private void dsRefresh(AnalysisDesignConstants.CallBackType callBackType) {
        List chapterTreeList = DatasetServiceHelper.getChapterTreeList((Long)this.getDmModelId(), (Long)this.getDefaultChapterId(), (String)ApplicationTypeEnum.FAR.getAppnum());
        String primaryKey = this.getCallBackPrimaryKey(callBackType);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_DS_REFRESH, chapterTreeList, primaryKey);
        this.SendToVue(result);
    }

    private void datasetFilterEntryCallback(Object returnData) {
        if (Objects.isNull(returnData)) {
            return;
        }
        List filterEntry = (List)JacksonUtils.fromJson((String)((String)returnData), (TypeReference)new TypeReference<List<DatasetFilterItem>>(){});
        String itemId = "";
        String datasetId = "";
        String filterView = "";
        JSONObject jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_DS_FILTER);
        if (Objects.nonNull(jsonObject)) {
            itemId = jsonObject.getString("itemId");
            datasetId = jsonObject.getString("dsId");
            filterView = DatasetFilterHelper.getFilterView((Long)this.getDmModelId(), (Long)LongUtil.toLong((Object)datasetId), (List)filterEntry);
        }
        JSONArray filterEntryJson = JSON.parseArray((String)JSON.toJSONString((Object)filterEntry));
        for (Object filter : filterEntryJson) {
            JSONObject filterObject = (JSONObject)filter;
            filterObject.put("dimensionId", (Object)filterObject.getString("dimensionId"));
            filterObject.put("memberId", (Object)filterObject.getString("memberId"));
        }
        JSONObject data = new JSONObject(4);
        data.fluentPut("itemId", (Object)itemId);
        data.fluentPut("dsId", (Object)datasetId);
        data.fluentPut("datesetFilterItems", (Object)filterEntryJson);
        data.fluentPut("datesetFilterItemsStr", (Object)filterView);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_DS_FILTER_RESULT, data, this.getCallBackPrimaryKey(AnalysisDesignConstants.CallBackType.EVENT_DS_FILTER));
        this.SendToVue(result);
    }

    @Override
    protected boolean previewCallBack(Object returnData) {
        if (super.previewCallBack(returnData)) {
            this.changeView(false);
            return true;
        }
        return false;
    }

    @Override
    protected void evDataPointFormula(String eventArgs) {
        Long datasetIdForSingle;
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject itemObject = jsonObject.getJSONObject("item");
        JSONObject dataset = itemObject.getJSONObject("dataset");
        if ("1".equals(dataset.getString("type"))) {
            datasetIdForSingle = dataset.getLong("id");
        } else {
            JSONObject formula = dataset.getJSONObject("formula");
            long datasetId = formula.getLong("id");
            DynamicObject multiDS = DatasetDataReader.getMultiDataSetValue((Long)datasetId, (boolean)false);
            if (Objects.isNull(multiDS)) {
                this.SendToVue(new JSONObject(2));
                return;
            }
            DynamicObject singleDS = multiDS.getDynamicObject("single");
            if (Objects.isNull(singleDS)) {
                this.SendToVue(new JSONObject(2));
                return;
            }
            DynamicObject datasetForSingle = singleDS.getDynamicObject("dataset");
            datasetIdForSingle = datasetForSingle.getLong("id");
        }
        DynamicObject singleDB = DatasetDataReader.getSingleDS((Long)datasetIdForSingle);
        Object data = AnalysisServiceHelper.singleDatasetResolve(singleDB);
        JSONObject result = new JSONObject(2);
        result.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.DATA_POINT_FORMULA_RESULT);
        result.put("columns", data);
        result.put("id", (Object)itemObject.getString("id"));
        result.put("pid", (Object)itemObject.getString("pid"));
        this.SendToVue(result);
    }

    public void catPublishLogView() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCaption(ResManager.loadKDString((String)"\u53d1\u5e03\u8bb0\u5f55", (String)"AnalysisPublishLog_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        fsp.setFormId("far_analysislog_list");
        fsp.setCustomParam(ANALYSIS_TEMPLATE_ID, (Object)this.getTemplateId());
        this.getView().showForm(fsp);
    }

    private String checkDataSetPerm(String dataSetId) {
        String msg = "";
        String perm = PermClassEntityHelper.getSingleFIDMPermission((String)"fidm_dataset", (Long)LongUtil.toLong((Object)dataSetId), (Long)this.getDmModelId(), (Long)this.getUserId(), (String)FIMDMODEL);
        if (StringUtils.equals((CharSequence)"2", (CharSequence)perm)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"AnalysisDesignListPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
        }
        return msg;
    }

    private void writeOpLog(OperationResult result, OperationName opName) {
        Long analysis_id = (Long)this.getFormCustomParam(PARAM_TEMPLATEID);
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)analysis_id, (String)"fidm_template", (String)"id,number,name");
        String templateNumber = template != null ? template.getString("number") : "";
        String templateName = template != null ? template.getString("name") : "";
        super.writeOpLog(OperationCategory.ANALYSIS_DESIGN, opName, result, "far_analysisdesign", templateNumber, templateName);
    }
}

