/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import org.apache.commons.collections.CollectionUtils;

public class AnalysisMapMappingPlugin
extends AbstractBaseDMFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String AREA = "area";
    private static final String MEMBER_ID = "member_id";
    private static final String MEMBER_NUMBER = "member_number";
    private static final String MEMBER_NAME = "member_name";
    private static final String SINGLE_MEMBER_F7 = "singleMemberF7";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = (Map)this.getFormCustomParam("mapping");
        JSONArray address = (JSONArray)this.getFormCustomParam("address");
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        entryEntities.clear();
        for (Object curAddress : address) {
            DynamicObject entryEntity = entryEntities.addNew();
            entryEntity.set(AREA, (Object)curAddress.toString());
            if (!map.containsKey(curAddress.toString())) continue;
            JSONObject jsonObject = (JSONObject)map.get(curAddress.toString());
            entryEntity.set(MEMBER_ID, (Object)jsonObject.getString("id"));
            entryEntity.set(MEMBER_NAME, (Object)jsonObject.getString("name"));
            entryEntity.set(MEMBER_NUMBER, (Object)jsonObject.getString("number"));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_select_member", "btn_reset_all", "btn_ok");
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btn_select_member": {
                EntryGrid entryentity = (EntryGrid)this.getControl("ENTRYENTITY");
                int[] selectRows = entryentity.getSelectRows();
                if (selectRows == null || selectRows.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"AnalysisMapMappingPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openF7();
                break;
            }
            case "btn_reset_all": {
                this.clearMember();
                break;
            }
            case "btn_ok": {
                this.buildResultToVue();
            }
        }
    }

    private void buildResultToVue() {
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(ENTRYENTITY);
        List lists = entryEntities.stream().filter(dy -> LongUtil.isvalidLong((Object)dy.getLong(MEMBER_ID))).map(dy -> dy.getLong(MEMBER_ID)).collect(Collectors.toList());
        HashMap map = Maps.newHashMap();
        JSONObject returnValue = new JSONObject();
        returnValue.put("mappingDim", this.getFormCustomParam("dimNumber"));
        JSONObject emptyJson = new JSONObject();
        if (CollectionUtils.isEmpty(lists)) {
            for (DynamicObject entryEntity : entryEntities) {
                map.put(entryEntity.getString(AREA), emptyJson);
            }
            returnValue.put("data", (Object)map);
            this.getView().returnDataToParent((Object)returnValue);
            this.getView().close();
            return;
        }
        HashSet sets = new HashSet(lists);
        if (!Objects.equals(lists.size(), sets.size())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u6210\u5458,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AnalysisMapMappingPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject entryEntity : entryEntities) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)entryEntity.getString(MEMBER_ID));
            jsonObject.put("name", (Object)entryEntity.getString(MEMBER_NAME));
            jsonObject.put("number", (Object)entryEntity.getString(MEMBER_NUMBER));
            map.put(entryEntity.getString(AREA), jsonObject);
        }
        returnValue.put("data", (Object)map);
        this.getView().returnDataToParent((Object)returnValue);
        this.getView().close();
    }

    private void openF7() {
        Long datasetId = Long.parseLong((String)this.getFormCustomParam("datasetId"));
        DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)datasetId);
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)singleDS.getString("datasrctype"), (Long)singleDS.getLong("datasrcid"));
        IModel strategy = ModelStrategy.getStrategy((DisModelTypeEnum)modelType);
        Long dimId = strategy.getDimId(Long.valueOf(singleDS.getLong("datasrcid")), (String)this.getFormCustomParam("dimNumber"));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(Long.valueOf(singleDS.getLong("datasrcid")));
        DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(false), (Long)dimId);
        modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, SINGLE_MEMBER_F7, this.getClass().getName(), true, "");
    }

    private void clearMember() {
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(ENTRYENTITY);
        for (DynamicObject dynamicObject : entryEntities) {
            dynamicObject.set(MEMBER_ID, null);
            dynamicObject.set(MEMBER_NAME, null);
            dynamicObject.set(MEMBER_NUMBER, null);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)e.getReturnData();
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        int selectRows = entryentity.getSelectRows()[0];
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(ENTRYENTITY);
        DynamicObject dy = (DynamicObject)entryEntities.get(selectRows);
        dy.set(MEMBER_ID, (Object)dynamicObject.getLong("id"));
        dy.set(MEMBER_NAME, (Object)dynamicObject.getString("name"));
        dy.set(MEMBER_NUMBER, (Object)dynamicObject.getString("number"));
        this.getView().updateView(ENTRYENTITY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!args.getOperateKey().equals("donothing")) {
            return;
        }
        EntryGrid entryentity = (EntryGrid)this.getControl("ENTRYENTITY");
        int selectRows = entryentity.getSelectRows()[0];
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(selectRows);
        dynamicObject.set(MEMBER_ID, null);
        dynamicObject.set(MEMBER_NAME, null);
        dynamicObject.set(MEMBER_NUMBER, null);
        this.getView().updateView(ENTRYENTITY);
    }
}

