/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.control.TextEditElement;
import kd.epm.far.business.common.dataset.dto.DatasetVarAndDim;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.util.StringLengthUtil;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.business.far.enums.DynamicControlSourceEnum;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.business.far.model.MemberData;
import kd.epm.far.business.far.model.ParamData;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisSingleF7ServiceHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;

public class AnalysisPreviewConfig
extends AbstractBaseDMFormPlugin
implements DynamicPage {
    private static final String PREVIEWDATA = "previewData";
    private static final String DIMF7INFO = "dimf7info";
    private static final String VARINFO = "varinfo";
    private static final String DIMVARINFO = "dimvarinfo";
    private static final String DIMFLEXPANEL = "dimflexpanel";
    private static final String VARFLEXPANEL = "varflexpanel";
    private static final String LOCALVARFLEXPANEL = "localvarflexpanel";
    private static final String DIMPANEL = "dimpanel";
    private static final String VARPANEL = "varpanel";
    private static final String PREVIEWSOURCE = "previewsource";
    private static final String DATASRCTYPE = "dataSrcType";
    private static final String ISCCACHE = "isccache";
    private static final Pair<String, String> DYNF7TYPE = Pair.onePair((Object)"DIMF7", (Object)"VARF7");

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners("btnok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        List<ParamData> initializedData = this.getInitializedData();
        String previewSource = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEWSOURCE);
        Boolean isISC = Boolean.FALSE;
        if (DynamicControlSourceEnum.DESIGNANALYSIS.getSourceName().equals(previewSource)) {
            AnalysisCommonOperateHelper.createDynamicControl(initializedData, this.getView(), (IFormPlugin)this, this.getPageCache());
        } else if (DynamicControlSourceEnum.MODULEANALYSIS.getSourceName().equals(previewSource) || DynamicControlSourceEnum.ICONPARAMETERS.getSourceName().equals(previewSource)) {
            JSONObject jsonObject;
            JSONObject item;
            JSONObject dataSet;
            if (initializedData.size() > 0) {
                this.createGBVarDynamicControl(initializedData);
            } else if (DynamicControlSourceEnum.ICONPARAMETERS.getSourceName().equals(previewSource) && Objects.nonNull((dataSet = (item = (jsonObject = JSON.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam(PREVIEWDATA)))).getJSONObject("item")).getJSONObject("dataset")).getString(DATASRCTYPE)) && "isc_metadata_schema".equals(dataSet.getString(DATASRCTYPE))) {
                isISC = Boolean.TRUE;
                this.createISCDynamicControl(dataSet, isISC);
            }
        }
        if (!isISC.booleanValue()) {
            this.setDefaultValue(initializedData);
        }
    }

    private List<ParamData> getInitializedData() {
        String eventArgs = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEWDATA);
        List<ParamData> dimList = AnalysisCommonOperateHelper.getDimList(eventArgs);
        return dimList;
    }

    public void onGetControl(OnGetControlArgs e) {
        if (this.getPage(this.getView()) != null) {
            Element element = this.getPage(this.getView()).findElementBySign(e.getKey());
            Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
            AnalysisCommonOperateHelper.getControl(e, element, dmModelId, this.getView(), this.getModel(), this.getPageCache(), this, (ClickListener)this, this.getDatasetId());
            if (!(element instanceof BaseEditElement) && element instanceof MultiBaseEditElement) {
                String f7KeyNum;
                String dimF7InfoCache = this.getPageCache().get(DIMF7INFO);
                if (Objects.isNull(dimF7InfoCache)) {
                    return;
                }
                Map f7DimInfo = (Map)SerializationUtils.fromJsonString((String)dimF7InfoCache, Map.class);
                Long dimensionId = (Long)f7DimInfo.get(f7KeyNum = e.getKey().toLowerCase());
                if (Objects.isNull(dimensionId)) {
                    return;
                }
                ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
                List allDim = modelStrategyEx.getDim().getDimList(false);
                DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)allDim, (Long)dimensionId);
                DynamicObjectCollection selected = Objects.isNull(this.getModel().getValue(e.getKey())) ? new DynamicObjectCollection() : (DynamicObjectCollection)this.getModel().getValue(e.getKey());
                boolean isEb = DisModelTypeEnum.EB.getType().equals(modelStrategyEx.getModel().getModelInfo().getModelType());
                String ebDatset = null;
                DynamicObject dataSet = DatasetDataReader.getDataSet((Long)this.getDatasetId());
                if (!Objects.equals(DataSetTypeEnum.MULTIPLE_VALUED.getType(), dataSet.getString("type"))) {
                    DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)this.getDatasetId());
                    ebDatset = singleDS.getString("ebdataset");
                } else {
                    ebDatset = isEb ? "default" : null;
                }
                MulBasedataEdit mulF7 = modelStrategyEx.getDimensionF7().openComMutilF7(this.getView(), selected, dimensionInfo, isEb ? ebDatset : null, (BeforeF7SelectListener)this, e.getKey(), null);
                e.setControl((Control)mulF7);
            }
        }
    }

    private Long getDatasetId() {
        Long datasetId = (Long)this.getFormCustomParam("dataset_id");
        return datasetId;
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            Map<String, Object> customControlInfo = this.putCustomControlInfo();
            String eventArgs = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEWDATA);
            String previewSource = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEWSOURCE);
            if (DynamicControlSourceEnum.MODULEANALYSIS.getSourceName().equals(previewSource)) {
                eventArgs = AnalysisServiceHelper.moduleStyleRest(eventArgs);
            }
            String previewResult = this.changeToPreviewResult(eventArgs, customControlInfo);
            HashMap retuanData = Maps.newHashMapWithExpectedSize((int)2);
            retuanData.put("previewresult", previewResult);
            retuanData.put(PREVIEWSOURCE, previewSource);
            this.returnDataToParent(retuanData);
            this.getView().close();
        }
    }

    public String changeToPreviewResult(String eventArgs, Map<String, Object> memberSource) {
        JSONArray dimListObject;
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray itemListObject = jsonObject.getJSONArray("itemList");
        boolean notSelectDefaultParam = false;
        for (Map.Entry<String, Object> entry : memberSource.entrySet()) {
            Set memberSet;
            Object tempValue = entry.getValue();
            if (tempValue instanceof Map) {
                Map memberMap = (Map)entry.getValue();
                if (!Objects.isNull(memberMap)) continue;
                notSelectDefaultParam = true;
                break;
            }
            if (!(tempValue instanceof Set) || !Objects.isNull(memberSet = (Set)entry.getValue()) && !memberSet.isEmpty()) continue;
            notSelectDefaultParam = true;
            break;
        }
        if (Objects.nonNull(memberSource.get(VARINFO)) || Objects.nonNull(memberSource.get(DIMVARINFO))) {
            JSONArray dimList;
            Map varInfo = (Map)memberSource.get(VARINFO);
            Map dimVarInfo = (Map)memberSource.get(DIMVARINFO);
            if ((Objects.nonNull(varInfo) || Objects.nonNull(dimVarInfo)) && Objects.nonNull(dimList = jsonObject.getJSONObject("queryConfig").getJSONArray("dimList"))) {
                dimList.forEach(globalVar -> {
                    JSONObject globalVarObject = (JSONObject)globalVar;
                    String globalNum = globalVarObject.getString("number");
                    if (Objects.nonNull(varInfo) && Objects.nonNull(varInfo.get(globalNum))) {
                        globalVarObject.put("defaultvalue", varInfo.get(globalNum));
                    }
                    if (Objects.nonNull(dimVarInfo) && Objects.nonNull(dimVarInfo.get(globalNum))) {
                        ParamData paremData = (ParamData)dimVarInfo.get(globalNum);
                        String memberNumber = paremData.getMembernum();
                        String memberName = paremData.getMembername();
                        String defaultValue = paremData.getDefaultvalue();
                        globalVarObject.put("membername", (Object)memberName);
                        globalVarObject.put("defaultvalue", (Object)defaultValue);
                        globalVarObject.put("membernum", (Object)memberNumber);
                        JSONObject member = new JSONObject();
                        MemberData memberData = paremData.getMember();
                        if (Objects.isNull(memberData)) {
                            member.put("id", (Object)paremData.getDefaultvalue());
                            member.put("name", (Object)paremData.getMembername());
                            member.put("number", (Object)paremData.getMembernum());
                        } else {
                            member.put("id", (Object)memberData.getId());
                            member.put("name", (Object)memberData.getName());
                            member.put("number", (Object)memberData.getNumber());
                        }
                        globalVarObject.put("member", (Object)member);
                    }
                });
            }
        }
        if (Objects.nonNull(itemListObject)) {
            for (Object item : itemListObject) {
                JSONObject itemObject = (JSONObject)item;
                JSONObject datasetObject = itemObject.getJSONObject("dataset");
                if (!Objects.nonNull(datasetObject)) continue;
                if (notSelectDefaultParam) {
                    HashMap<String, String> error = new HashMap<String, String>();
                    error.put("msg", ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AnalysisServiceHelper_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    itemObject.put("error", error);
                    continue;
                }
                itemObject.remove((Object)"data");
            }
        }
        if ((dimListObject = jsonObject.getJSONObject("queryConfig").getJSONArray("dimList")).size() > 0) {
            for (Object dimOrVar : dimListObject) {
                JSONObject dimOrVarObject = (JSONObject)dimOrVar;
                if (Objects.nonNull(dimOrVarObject.getString("isDim")) && !"0".equals(dimOrVarObject.getString("isDim"))) {
                    String shortNumber = dimOrVarObject.getString("shortNumber");
                    if ("1".equals(dimOrVarObject.getString("isDim")) && Objects.nonNull(memberSource.get(shortNumber))) {
                        dimOrVarObject.put("member", memberSource.get(shortNumber));
                    }
                    if ("2".equals(dimOrVarObject.getString("isDim")) && Objects.nonNull(memberSource.get(shortNumber))) {
                        dimOrVarObject.put("members", memberSource.get(shortNumber));
                    }
                    if (Objects.nonNull(dimOrVarObject.getJSONObject("member")) && (dimOrVarObject.getJSONObject("member").size() == 0 || memberSource.size() == 0 || Objects.isNull(memberSource.get(shortNumber)))) {
                        dimOrVarObject.remove((Object)"member");
                    }
                    if (!Objects.nonNull(dimOrVarObject.getJSONArray("members")) || dimOrVarObject.getJSONArray("members").size() != 0 && memberSource.size() != 0 && !Objects.isNull(memberSource.get(shortNumber))) continue;
                    dimOrVarObject.remove((Object)"members");
                    continue;
                }
                if (!VariableTypeEnum.DIM.getStringCode().equals(dimOrVarObject.getString("valuetype"))) continue;
                String varParamNumber = dimOrVarObject.getString("number");
                Map dimVarInfo = (Map)memberSource.get(DIMVARINFO);
                if (!Objects.isNull(dimVarInfo) && !Objects.isNull(dimVarInfo.get(varParamNumber))) continue;
                dimOrVarObject.remove((Object)"member");
                dimOrVarObject.remove((Object)"membername");
                dimOrVarObject.remove((Object)"defaultvalue");
                dimOrVarObject.remove((Object)"membernum");
            }
        }
        jsonObject.put("i18n", AnalysisServiceHelper.getI18n());
        jsonObject.put("primaryKey", (Object)jsonObject.getString("primaryKey"));
        return jsonObject.toJSONString();
    }

    private void setF7BaseEditElement(Area varArea, String F7Type, ParamData paramData, Integer index, String sourceName) {
        String dimNumber = paramData.getNumber();
        String dimName = StringLengthUtil.cropNameString((String)paramData.getName(), (int)20);
        String entityName = "";
        if (((String)AnalysisPreviewConfig.DYNF7TYPE.p1).equals(F7Type)) {
            entityName = paramData.getEntityName();
        } else if (((String)AnalysisPreviewConfig.DYNF7TYPE.p2).equals(F7Type)) {
            entityName = paramData.getDimentity();
        }
        BaseEditElement baseEdit = new BaseEditElement(dimName, dimNumber.toLowerCase(), entityName);
        AnalysisSingleF7ServiceHelper.BuildF7StyleForPreview((Element)baseEdit, index, sourceName);
        varArea.addElement((Element)baseEdit);
    }

    private void setF7MultiBaseEditElement(Area varArea, ParamData paramData, Integer index, String sourceName) {
        String dimNumber = paramData.getNumber();
        String dimName = StringLengthUtil.cropNameString((String)paramData.getName(), (int)20);
        String entityName = paramData.getEntityName();
        MultiBaseEditElement baseEdit = new MultiBaseEditElement(dimName, dimNumber.toLowerCase(), entityName);
        baseEdit.setBtnFontClass("kdfont kdfont-zidingyi");
        AnalysisSingleF7ServiceHelper.BuildF7StyleForPreview((Element)baseEdit, index, sourceName);
        varArea.addElement((Element)baseEdit);
    }

    public void addGBDimensionPage(Area F7DIMArea, Area varArea, List<ParamData> dimList, String sourceName) {
        Integer dimIndex = 1;
        Integer varIndex = 1;
        HashMap dimListInfo = Maps.newHashMapWithExpectedSize((int)7);
        for (ParamData paramData : dimList) {
            Number paramId;
            Object paramNumber;
            Integer n;
            Integer n2;
            if (AnalysisCommonOperateHelper.isDimQueryConfig(paramData)) {
                if (Objects.equals("1", paramData.getIsDim())) {
                    this.setF7BaseEditElement(F7DIMArea, (String)AnalysisPreviewConfig.DYNF7TYPE.p1, paramData, dimIndex, sourceName);
                } else if (Objects.equals("2", paramData.getIsDim())) {
                    this.setF7MultiBaseEditElement(F7DIMArea, paramData, dimIndex, sourceName);
                }
                n2 = dimIndex;
                n = dimIndex = Integer.valueOf(dimIndex + 1);
                paramNumber = paramData.getNumber();
                paramId = Long.valueOf(paramData.getId());
                dimListInfo.put(((String)paramNumber).toLowerCase(), paramId);
                continue;
            }
            if (AnalysisCommonOperateHelper.isF7VarQueryConfig(paramData)) {
                this.setF7BaseEditElement(varArea, (String)AnalysisPreviewConfig.DYNF7TYPE.p2, paramData, varIndex, sourceName);
                paramNumber = varIndex;
                paramId = varIndex = Integer.valueOf(varIndex + 1);
                Long dimId = Long.valueOf(paramData.getDimid());
                String paramNumber2 = paramData.getNumber();
                dimListInfo.put(paramNumber2.toLowerCase(), dimId);
                continue;
            }
            if (AnalysisCommonOperateHelper.isTextVarQueryConfig(paramData)) {
                AnalysisCommonOperateHelper.setTextEditElement(varArea, paramData, varIndex, sourceName);
                n2 = varIndex;
                n = varIndex = Integer.valueOf(varIndex + 1);
                continue;
            }
            if (!AnalysisCommonOperateHelper.isEnumVarQueryConfig(paramData)) continue;
            AnalysisCommonOperateHelper.setEnumEditElement(varArea, paramData, varIndex, sourceName);
            n2 = varIndex;
            n = varIndex = Integer.valueOf(varIndex + 1);
        }
        if (F7DIMArea.getElementListList().size() > 0 || dimListInfo.size() > 0) {
            this.getPageCache().put(DIMF7INFO, SerializationUtils.toJsonString((Object)dimListInfo));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        Control scenarioControl = this.getView().getControl(DimTypesEnum.SCENARIO.getNumber().toLowerCase());
        if (DimTypesEnum.PERIOD.getNumber().equalsIgnoreCase(dimKey) && Objects.nonNull(scenarioControl) && this.getModel().getValue(DimTypesEnum.SCENARIO.getNumber().toLowerCase(Locale.ENGLISH)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"AnalysisSingleF7ServiceHelper_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        Object previewData = this.getView().getFormShowParameter().getCustomParam(PREVIEWDATA);
        Long convertModelId = AnalysisServiceHelper.convertModelId(previewData);
        if (convertModelId != 0L) {
            dmModelId = convertModelId;
        }
        AnalysisCommonOperateHelper.addF7Filter(beforeF7SelectEvent, this.getModel(), this.getPageCache(), this.getView(), dimKey, dmModelId);
    }

    private Map<String, Object> putCustomControlInfo() {
        HashMap customControlInfo = Maps.newHashMapWithExpectedSize((int)8);
        HashMap varInfo = Maps.newHashMapWithExpectedSize((int)8);
        HashMap dimVarInfo = Maps.newHashMapWithExpectedSize((int)6);
        String eventArgs = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEWDATA);
        List<ParamData> dimList = AnalysisCommonOperateHelper.getDimList(eventArgs);
        for (ParamData paramData : dimList) {
            String paramNumber = paramData.getNumber();
            IDataEntityProperty paramProperty = this.getModel().getProperty(paramNumber);
            if (!Objects.nonNull(paramProperty)) continue;
            if (AnalysisCommonOperateHelper.isDimQueryConfig(paramData)) {
                DynamicObjectCollection memberCollection;
                Iterator dy2;
                String shortNum;
                Object dimValue;
                String shortNum2;
                if (Objects.equals("1", paramData.getIsDim())) {
                    DynamicObject memberDynamicObject;
                    MemberData memberData = paramData.getMember();
                    if (Objects.nonNull(memberData)) {
                        DynamicObject memberDynamicObject2 = (DynamicObject)this.getModel().getValue(paramNumber.toLowerCase());
                        if (!Objects.nonNull(memberDynamicObject2)) continue;
                        HashMap member = Maps.newHashMapWithExpectedSize((int)3);
                        member.put("id", memberDynamicObject2.getString("id"));
                        member.put("number", memberDynamicObject2.getString("number"));
                        member.put("name", memberDynamicObject2.getString("name"));
                        shortNum2 = paramData.getShortNumber();
                        customControlInfo.put(shortNum2, member);
                        continue;
                    }
                    dimValue = this.getModel().getValue(paramNumber.toLowerCase());
                    if (!Objects.nonNull(dimValue) || !Objects.nonNull(memberDynamicObject = (DynamicObject)this.getModel().getValue(paramNumber.toLowerCase()))) continue;
                    HashMap member = Maps.newHashMapWithExpectedSize((int)3);
                    member.put("id", memberDynamicObject.getString("id"));
                    member.put("number", memberDynamicObject.getString("number"));
                    member.put("name", memberDynamicObject.getString("name"));
                    shortNum = paramData.getShortNumber();
                    customControlInfo.put(shortNum, member);
                    continue;
                }
                if (!Objects.equals("2", paramData.getIsDim())) continue;
                List memberDataList = paramData.getMembers();
                if (Objects.nonNull(memberDataList) && !memberDataList.isEmpty()) {
                    DynamicObjectCollection memberCollection2 = (DynamicObjectCollection)this.getModel().getValue(paramNumber.toLowerCase());
                    if (Objects.isNull(memberCollection2) || memberCollection2.isEmpty()) continue;
                    HashSet memberSet = Sets.newHashSetWithExpectedSize((int)memberCollection2.size());
                    for (Iterator dy2 : memberCollection2) {
                        DynamicObject fbasedataid = dy2.getDynamicObject("fbasedataid");
                        if (Objects.isNull(fbasedataid)) continue;
                        HashMap member = Maps.newHashMapWithExpectedSize((int)3);
                        member.put("id", fbasedataid.getString("id"));
                        member.put("number", fbasedataid.getString("number"));
                        member.put("name", fbasedataid.getString("name"));
                        memberSet.add(member);
                    }
                    shortNum2 = paramData.getShortNumber();
                    customControlInfo.put(shortNum2, memberSet);
                    continue;
                }
                dimValue = this.getModel().getValue(paramNumber.toLowerCase());
                if (!Objects.nonNull(dimValue) || Objects.isNull(memberCollection = (DynamicObjectCollection)this.getModel().getValue(paramNumber.toLowerCase())) || memberCollection.isEmpty()) continue;
                HashSet memberSet = Sets.newHashSetWithExpectedSize((int)memberCollection.size());
                dy2 = memberCollection.iterator();
                while (dy2.hasNext()) {
                    DynamicObject dy3 = (DynamicObject)dy2.next();
                    DynamicObject fbasedataid = dy3.getDynamicObject("fbasedataid");
                    if (Objects.isNull(fbasedataid)) continue;
                    HashMap member = Maps.newHashMapWithExpectedSize((int)3);
                    member.put("id", fbasedataid.getString("id"));
                    member.put("number", fbasedataid.getString("number"));
                    member.put("name", fbasedataid.getString("name"));
                    memberSet.add(member);
                }
                shortNum = paramData.getShortNumber();
                customControlInfo.put(shortNum, memberSet);
                continue;
            }
            if (AnalysisCommonOperateHelper.isF7VarQueryConfig(paramData)) {
                DynamicObject modelObject = (DynamicObject)this.getModel().getValue(paramNumber);
                if (!Objects.nonNull(modelObject)) continue;
                DynamicObject dimension = modelObject.getDynamicObject("dimension");
                String id = String.valueOf(modelObject.getPkValue());
                String modelName = modelObject.getLocaleString("name").getLocaleValue();
                String modelNumber = dimension.getString("shortnumber") + "." + modelObject.getString("number");
                paramData.setDefaultvalue(id);
                paramData.setMembernum(modelNumber);
                paramData.setMembername(modelName);
                MemberData memberData = paramData.getMember();
                if (Objects.isNull(memberData)) {
                    memberData = new MemberData();
                }
                memberData.setId(id);
                memberData.setName(modelName);
                memberData.setNumber(modelNumber);
                paramData.setMember(memberData);
                dimVarInfo.put(paramNumber, paramData);
                continue;
            }
            if (!AnalysisCommonOperateHelper.isTextVarQueryConfig(paramData) && !AnalysisCommonOperateHelper.isEnumVarQueryConfig(paramData)) continue;
            String modelName = (String)this.getModel().getValue(paramNumber);
            varInfo.put(paramNumber, modelName);
        }
        if (varInfo.size() > 0) {
            customControlInfo.put(VARINFO, varInfo);
        }
        if (dimVarInfo.size() > 0) {
            customControlInfo.put(DIMVARINFO, dimVarInfo);
        }
        return customControlInfo;
    }

    private void setDefaultValue(List<ParamData> dimList) {
        String previewSource = (String)this.getView().getFormShowParameter().getCustomParam(PREVIEWSOURCE);
        AnalysisCommonOperateHelper.setDefaultValue(dimList, this.getView(), this.getModel(), previewSource);
    }

    private void createGBVarDynamicControl(List<ParamData> dimList) {
        Page page = new Page();
        Area F7DIMArea = new Area(DIMPANEL);
        Area varArea = new Area(VARPANEL);
        this.addGBDimensionPage(F7DIMArea, varArea, dimList, "");
        if (F7DIMArea.getElementListList().size() > 0) {
            page.addArea(F7DIMArea);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{DIMFLEXPANEL});
        }
        if (varArea.getElementListList().size() > 0) {
            page.addArea(varArea);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{VARFLEXPANEL});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{LOCALVARFLEXPANEL});
        if (F7DIMArea.getElementListList().size() > 0 || varArea.getElementListList().size() > 0) {
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
        }
    }

    private void createISCDynamicControl(JSONObject dataSet, Boolean isISC) {
        this.getPageCache().put(ISCCACHE, "true");
        List<String> curs = this.getISCCur(dataSet, isISC);
        Page page = new Page();
        Integer varIndex = 0;
        Area F7DIMArea = new Area(DIMPANEL);
        JSONArray details = dataSet.getJSONArray("detail");
        for (Object detail : details) {
            String name = ((JSONObject)detail).getString("name");
            String number = ((JSONObject)detail).getString("number");
            if (!curs.contains(number)) continue;
            Integer n = varIndex;
            Integer n2 = varIndex = Integer.valueOf(varIndex + 1);
            TextEditElement textEditElement = AnalysisDesignHelper.createTextEditElement(name, number, varIndex, "");
            F7DIMArea.addElement((Element)textEditElement);
        }
        if (F7DIMArea.getElementListList().size() > 0) {
            page.addArea(F7DIMArea);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{DIMFLEXPANEL});
        }
        Area varArea = new Area(VARPANEL);
        if (varArea.getElementListList().size() > 0) {
            page.addArea(varArea);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{VARFLEXPANEL});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{LOCALVARFLEXPANEL});
        if (F7DIMArea.getElementListList().size() > 0 || varArea.getElementListList().size() > 0) {
            this.setPage(this.getView(), page);
            page.updatePage(this.getView());
        }
    }

    private List<String> getISCCur(JSONObject dataSet, Boolean isISC) {
        Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        Long dataSetId = dataSet.getLong("id");
        DatasetVarAndDim result = DatasetServiceHelper.getVarAndDimVar((long)dmModelId, (long)dataSetId, (long)0L, (boolean)true, (boolean)isISC);
        List curs = result.getCurShortNumberList();
        return curs;
    }
}

