/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.faranalysis.AbstractAnalysisPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;

public class AnalysisPreviewPlugin
extends AbstractAnalysisPlugin
implements BeforeF7SelectListener {
    private static final String CTL_TOOLBAR_AP = "toolbarap";
    private static final String FLEXPANELAPQUERY = "flexpanelapquery";
    private static final String KEY_PREVIEW_RESULT_STR = "KEY_PREVIEW_RESULT_STR";
    private static final String BTN_PREVIEW = "btn_preview";
    private static final String BTN_ALLSCREEN = "btn_allscreen";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_CLOSE = "btn_close";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(CTL_TOOLBAR_AP);
        this.addClickListeners(BTN_PREVIEW, BTN_ALLSCREEN, BTN_REFRESH, BTN_CLOSE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.changeView(true);
        this.dataInit();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_preview": {
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_PREVIEW));
                break;
            }
            case "btn_refresh": {
                this.dataInit();
                break;
            }
            case "btn_allscreen": {
                this.allScreen();
                break;
            }
        }
    }

    @Override
    public void customEvent(CustomEventArgs evt) {
        super.customEvent(evt);
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        try {
            AnalysisDesignConstants.CallBackType callBackType = AnalysisDesignConstants.CallBackType.valueOf(eventName);
            this.putCallBackType(callBackType, eventArgs);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return;
        }
        if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DOSEARCH.toString())) {
            this.doSearch(eventArgs);
        }
    }

    private String getPreviewResultStr() {
        String previewResultStr = this.getView().getPageCache().get(KEY_PREVIEW_RESULT_STR);
        if (StringUtils.isEmpty((CharSequence)previewResultStr)) {
            previewResultStr = (String)this.getFormCustomParam("previewResultStr");
            this.getView().getPageCache().put(KEY_PREVIEW_RESULT_STR, previewResultStr);
        }
        return previewResultStr;
    }

    private void dataInit() {
        try {
            String previewResultStr = this.getPreviewResultStr();
            if (!StringUtils.isEmpty((CharSequence)previewResultStr)) {
                this.previewCallBack(ObjectSerialUtil.toByteSerialized((Object)previewResultStr));
            }
        }
        catch (Exception ex) {
            this.dataError(ex);
        }
    }

    private void allScreen() {
        this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_FULLSCREEN));
    }

    private void changeView(boolean designView) {
        this.getView().setVisible(Boolean.valueOf(designView), new String[]{BTN_PREVIEW, BTN_ALLSCREEN, BTN_REFRESH});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAPQUERY});
    }

    @Override
    protected boolean previewCallBack(Object returnData) {
        if (Objects.isNull(returnData)) {
            return false;
        }
        String eventArgs = (String)this.deSerializedBytes((String)returnData);
        this.getView().getPageCache().put(KEY_PREVIEW_RESULT_STR, eventArgs);
        return super.previewCallBack(returnData, false);
    }
}

