/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetVarAndDim;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.far.enums.CardType;
import kd.epm.far.business.far.enums.DynamicControlSourceEnum;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.business.far.model.AnalysisDataHandler;
import kd.epm.far.business.fidm.module.DisclosureOldModuleHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisCalcHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignChapterServiceHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisSingleF7ServiceHelper;
import kd.epm.far.formplugin.faranalysis.components.AbstractCompoments;
import kd.epm.far.formplugin.faranalysis.components.ComponentsFactory;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisDesignVarsHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisVariableHelper;

public class AnalysisServiceHelper {
    public static final String VARINFO = "varinfo";
    public static final String VARTYPE = "vartype";
    public static final String DIMVARINFO = "dimvarinfo";
    public static final String DIMLIST = "dimList";
    public static final String DIMID = "dimid";
    public static final List<String> BCM_FIXEDDIM = Arrays.asList("entity", "year", "period");
    public static final List<String> EPM_FIXEDDIM = Arrays.asList("entity", "budgetperiod", "version");

    public static Long getDefaultChapterId(Long dmModelId, Long templateId) {
        boolean havDefaultChapter = AnalysisDesignChapterServiceHelper.isHavDefaultChapter(dmModelId, templateId);
        if (!havDefaultChapter) {
            AnalysisDesignChapterServiceHelper.initDefaultChapter(dmModelId, templateId);
        }
        return AnalysisDesignChapterServiceHelper.getDefaultChapterId(dmModelId, templateId);
    }

    public static Object dataInit(Long dmModelId, Long modelId, Long chapterId, boolean isReset) {
        Map<String, Object> dataInit = AnalysisServiceHelper.getDataInit(dmModelId, modelId, chapterId, isReset);
        List<Map<String, String>> localVarList = AnalysisVariableHelper.getChapterVariableList(dmModelId, chapterId);
        List<Map<String, String>> gbVarList = AnalysisVariableHelper.getGlobalVariableList(dmModelId);
        List<Map<String, Object>> localNewVarList = AnalysisDesignVarsHelper.buildCommonVarParams(localVarList, dmModelId);
        List<Map<String, Object>> gbNewVarList = AnalysisDesignVarsHelper.buildCommonVarParams(gbVarList, dmModelId);
        List localDatasetList = DatasetServiceHelper.getChapterTreeList((Long)dmModelId, (Long)chapterId, (String)ApplicationTypeEnum.FAR.getAppnum());
        List gbDatasetList = DatasetServiceHelper.getTreeList((Long)dmModelId, (String)ApplicationTypeEnum.FAR.getAppnum());
        List<Map<String, Object>> dimList = AnalysisSingleF7ServiceHelper.getDimList(dmModelId, modelId);
        List moduleList = ModuleServiceHelper.getModuleList((Long)dmModelId);
        return AnalysisDesignHelper.dataInit(dataInit.get("itemList"), dataInit.get("pageConfig"), dataInit.get("queryConfig"), gbNewVarList, localNewVarList, gbDatasetList, localDatasetList, dimList, moduleList, AnalysisServiceHelper.getI18n(), isReset, chapterId);
    }

    public static Map<String, Object> getDataInit(Long dmModelId, Long modelId, Long chapterId, boolean isReset) {
        Object queryConfig;
        ArrayList realModules = Lists.newArrayListWithCapacity((int)1);
        Map<String, Object> config = AnalysisServiceHelper.getQueryConfig(isReset, chapterId, realModules);
        Object pageConfig = config.get("pageconfig");
        if (Objects.isNull(pageConfig)) {
            pageConfig = AnalysisServiceHelper.getDefaultPageConfig();
        }
        if (Objects.isNull(queryConfig = config.get("queryconfig"))) {
            queryConfig = AnalysisServiceHelper.getDefaultQueryConfig(dmModelId, modelId);
        } else {
            JSONObject queryConfigObject = (JSONObject)queryConfig;
            JSONArray dimList = queryConfigObject.getJSONArray(DIMLIST);
            JSONObject floatButtonObject = queryConfigObject.getJSONObject("floatButton");
            if (floatButtonObject != null && floatButtonObject.getBoolean("hidden") == null) {
                floatButtonObject.put("hidden", (Object)false);
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)5);
        result.put("pageConfig", pageConfig);
        result.put("queryConfig", queryConfig);
        result.put("itemList", realModules);
        result.put("chapterId", Objects.isNull(chapterId) ? null : chapterId.toString());
        return result;
    }

    private static Map<String, Object> getQueryConfig(boolean isReset, Long chapterId, List<JSONObject> realModules) {
        DynamicObject dynamicObject;
        HashMap config = Maps.newHashMapWithExpectedSize((int)2);
        if (!isReset && Objects.nonNull(dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (String)"entryentity.key, entryentity.module,entryentity.module.type,entryentity.module.number,entryentity.module.name,entryentity.module.properties", (QFilter[])new QFilter("id", "=", (Object)chapterId).toArray()))) {
            DynamicObjectCollection modules = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject m : modules) {
                String jsonStr = m.getString("module.properties");
                if (StringUtils.isEmpty((CharSequence)jsonStr)) continue;
                JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                if (ModuleEnum.Analysis_PAGE.getNumber().equals(jsonObject.getString("type"))) {
                    config.put("pageconfig", jsonObject);
                    continue;
                }
                if (ModuleEnum.Analysis_QUERY.getNumber().equals(jsonObject.getString("type"))) {
                    config.put("queryconfig", jsonObject);
                    continue;
                }
                realModules.add(jsonObject);
            }
        }
        return config;
    }

    public static JSONObject setItemListAndQueryConfig(Long dmModelId, Long modelId, Long moduleId, List<JSONObject> realModules) {
        DynamicObject moduleDy = BusinessDataServiceHelper.loadSingle((Object)moduleId, (String)"fidm_modulerepository");
        JSONObject queryConfig = null;
        if (Objects.nonNull(moduleDy)) {
            String moduleProperties = moduleDy.getString("properties");
            String type = moduleDy.getString("type");
            if (ModuleServiceHelper.FIDMCOMBOITEM.contains(type)) {
                AbstractCompoments compoments = ComponentsFactory.getInstance(moduleDy);
                HashMap<String, String> moduleMap = new HashMap<String, String>(2);
                moduleMap.put("id", moduleDy.getString("id"));
                moduleMap.put("name", moduleDy.getString("name"));
                moduleMap.put("number", moduleDy.getString("number"));
                moduleMap.put("parent", moduleDy.getString("catalog.id"));
                moduleMap.put("type", moduleDy.getString("type"));
                moduleMap.put("properties", moduleDy.getString("properties"));
                JSONObject moduleControl = DisclosureOldModuleHelper.converToNewVersion((Long)dmModelId, (Long)0L, moduleMap);
                moduleProperties = moduleControl == null ? "" : moduleControl.toJSONString();
                moduleProperties = compoments.changeToAnalysisProporties(moduleProperties, dmModelId, modelId, 0L);
            }
            try {
                if (moduleProperties.charAt(0) == '[') {
                    JSONArray itemList = JSON.parseArray((String)moduleProperties);
                    for (Object o : itemList) {
                        realModules.add((JSONObject)o);
                    }
                } else {
                    realModules.add(JSON.parseObject((String)moduleProperties));
                }
            }
            catch (Exception e) {
                realModules.add(JSON.parseObject((String)moduleProperties));
            }
        }
        if (Objects.isNull(queryConfig)) {
            queryConfig = (JSONObject)AnalysisServiceHelper.getDefaultQueryConfig(dmModelId, modelId);
            queryConfig.put(DIMLIST, new ArrayList());
        }
        return queryConfig;
    }

    public static boolean saveDesginDefaultParam(Long dmModelId, Long chapterId, String shortDimNumber, Map<String, Object> memberMap) {
        JSONObject queryConfig;
        String queryConfigStr;
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)chapterId);
        String colStr = "entryentity.key, entryentity.module,entryentity.module.id,entryentity.module.type,entryentity.module.number,entryentity.module.name,entryentity.module.properties";
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (String)colStr, (QFilter[])new QFilter[]{filter});
        if (Objects.isNull(chapter)) {
            return false;
        }
        DynamicObjectCollection anlysisList = chapter.getDynamicObjectCollection("entryentity");
        if (anlysisList.size() == 0) {
            return false;
        }
        DynamicObject anlysis = anlysisList.stream().filter(x -> ModuleEnum.Analysis_QUERY.getType().equals(x.getString("module.type"))).findAny().orElse(null);
        if (Objects.nonNull(anlysis) && !StringUtils.isEmpty((CharSequence)(queryConfigStr = anlysis.getString("module.properties"))) && Objects.nonNull((queryConfig = JSONObject.parseObject((String)queryConfigStr)).get((Object)DIMLIST))) {
            JSONArray dimListObject = queryConfig.getJSONArray(DIMLIST);
            for (Object dim : dimListObject) {
                JSONObject dimObject = (JSONObject)dim;
                String shortNumber = dimObject.getString("shortNumber");
                if (!Objects.nonNull(shortNumber) || !shortNumber.equals(shortDimNumber)) continue;
                if (memberMap.isEmpty() && Objects.nonNull(dimObject.get((Object)"member"))) {
                    dimObject.remove((Object)"member");
                    break;
                }
                dimObject.put("member", memberMap);
                break;
            }
            try (TXHandle tx = TX.required();){
                try {
                    DynamicObject module = BusinessDataServiceHelper.loadSingle((String)"fidm_modulerepository", (String)"id,type,number,name,properties", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)anlysis.getLong("module.id"))});
                    module.set("properties", (Object)queryConfig.toJSONString());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{module});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    public static String getDataInitByMyAnlysis(Long dmModelId, Long modelId, Long myAnlysisId, boolean modelFilter) {
        DynamicObject myAnlysis;
        QFilter filter = new QFilter("id", "=", (Object)myAnlysisId);
        if (modelFilter) {
            filter.and("model", "=", (Object)dmModelId);
        }
        if (Objects.nonNull(myAnlysis = QueryServiceHelper.queryOne((String)"far_myanalysis", (String)"viewdata,defaultparam", (QFilter[])new QFilter[]{filter}))) {
            String viewdataStr = myAnlysis.getString("viewdata");
            String defaultparamStr = myAnlysis.getString("defaultparam");
            Map<String, Object> dimMemberList = new HashMap<String, Object>(5);
            if (!StringUtils.isEmpty((CharSequence)defaultparamStr)) {
                dimMemberList = (Map)SerializationUtils.fromJsonString((String)defaultparamStr, Map.class);
            }
            return AnalysisServiceHelper.previewResult(viewdataStr, dimMemberList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        ArrayList realModules = new ArrayList();
        result.put("pageConfig", AnalysisServiceHelper.getDefaultPageConfig());
        result.put("queryConfig", AnalysisServiceHelper.getDefaultQueryConfig(dmModelId, modelId));
        result.put("itemList", realModules);
        result.put("i18n", AnalysisServiceHelper.getI18n());
        return JSON.toJSONString(result);
    }

    public static String getDataInitByMyAnlysis(Long dmModelId, Long modelId, Long myAnlysisId) {
        return AnalysisServiceHelper.getDataInitByMyAnlysis(dmModelId, modelId, myAnlysisId, true);
    }

    public static boolean saveMyAnlysisDefaultParam(Long dmModelId, Long myAnlysisId, String shortDimNumber, Map<String, Object> memberMap) {
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)myAnlysisId);
        DynamicObject myAnlysis = BusinessDataServiceHelper.loadSingle((String)"far_myanalysis", (String)"id,defaultparam", (QFilter[])new QFilter[]{filter});
        if (Objects.nonNull(myAnlysis)) {
            String defaultparamStr = myAnlysis.getString("defaultparam");
            Map<String, Map<String, Object>> dimMemberList = new HashMap(5);
            if (!StringUtils.isEmpty((CharSequence)defaultparamStr) && (dimMemberList = (Map)SerializationUtils.fromJsonString((String)defaultparamStr, Map.class)).containsKey(shortDimNumber)) {
                dimMemberList.put(shortDimNumber, memberMap);
                myAnlysis.set("defaultparam", (Object)SerializationUtils.toJsonString(dimMemberList));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{myAnlysis});
                return true;
            }
        }
        return false;
    }

    public static boolean isExistThemeData(Long dmModelId, Long themeAnlysisId) {
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)themeAnlysisId);
        return Objects.nonNull(QueryServiceHelper.queryOne((String)"far_themeanalysis", (String)"id", (QFilter[])new QFilter[]{filter}));
    }

    public static boolean isExistMyAnalysisData(Long dmModelId, Long myAnlysisId) {
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)myAnlysisId);
        return Objects.nonNull(QueryServiceHelper.queryOne((String)"far_myanalysis", (String)"id", (QFilter[])new QFilter[]{filter}));
    }

    private static Map<String, Object> getThemeData(Long dmModelId, Long themeAnlysisId, String boardId) {
        HashMap<String, Object> result = new HashMap<String, Object>(6);
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)themeAnlysisId);
        DynamicObject themeAnlysis = QueryServiceHelper.queryOne((String)"far_themeanalysis", (String)"id,number,name,description,viewdata", (QFilter[])new QFilter[]{filter});
        if (Objects.nonNull(themeAnlysis)) {
            result.put("id", themeAnlysis.getString("id"));
            result.put("number", themeAnlysis.getString("number"));
            result.put("name", themeAnlysis.getString("name"));
            result.put("description", themeAnlysis.getString("description"));
            result.put("viewdata", themeAnlysis.getString("viewdata"));
        }
        ArrayList pageList = new ArrayList(6);
        QFilter boardfilter = new QFilter("model", "=", (Object)dmModelId);
        boardfilter.and("themeanalysis", "=", (Object)themeAnlysisId);
        DynamicObjectCollection boardAnlysisList = QueryServiceHelper.query((String)"far_themeanalysisboard", (String)"id,name,number", (QFilter[])new QFilter[]{boardfilter}, (String)"sequence");
        HashMap currentBoard = new HashMap(3);
        boolean isFirst = true;
        for (DynamicObject m : boardAnlysisList) {
            HashMap<String, String> board = new HashMap<String, String>(3);
            board.put("id", m.getString("id"));
            board.put("number", m.getString("number"));
            board.put("name", m.getString("name"));
            pageList.add(board);
            if (!isFirst && !m.getString("id").equals(boardId)) continue;
            currentBoard = board;
            isFirst = false;
        }
        result.put("pageList", pageList);
        if (!isFirst) {
            result.put("currentPage", currentBoard);
        }
        return result;
    }

    public static Map<String, Object> getDataEditByThemeAnalysis(Long dmModelId, Long themeAnlysisId) {
        Map<String, Object> themeAnalysis = AnalysisServiceHelper.getThemeData(dmModelId, themeAnlysisId, "");
        if (Objects.nonNull(themeAnalysis.get("id"))) {
            List pageList = (List)themeAnalysis.get("pageList");
            for (Map page : pageList) {
                Object resultObject = AnalysisServiceHelper.getPageDataThemeAnalysis(dmModelId, LongUtil.toLong(page.get("id")));
                if (!Objects.nonNull(resultObject)) continue;
                page.put("data_init", resultObject);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Object viewdataTag = themeAnalysis.get("viewdata");
        if (Objects.isNull(viewdataTag) || StringUtils.isEmpty((CharSequence)viewdataTag.toString())) {
            result.put("pageConfig", AnalysisServiceHelper.getThemeDefaultPageConfig());
        } else {
            JSONObject viewData = JSON.parseObject((String)viewdataTag.toString());
            result.put("pageConfig", viewData.get((Object)"pageConfig"));
        }
        themeAnalysis.remove("viewdata");
        result.put("i18n", AnalysisServiceHelper.getI18n());
        result.put("theme", themeAnalysis);
        return result;
    }

    private static Object getPageDataThemeAnalysis(Long dmModelId, Long boardId) {
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)boardId);
        DynamicObject themeAnlysis = BusinessDataServiceHelper.loadSingle((String)"far_themeanalysisboard", (String)"viewdata,defaultparam", (QFilter[])new QFilter[]{filter});
        if (Objects.nonNull(themeAnlysis)) {
            String viewdataStr = themeAnlysis.getString("viewdata");
            String defaultparamStr = themeAnlysis.getString("defaultparam");
            Map<String, Object> dimMemberList = new HashMap<String, Object>(5);
            if (!StringUtils.isEmpty((CharSequence)defaultparamStr)) {
                dimMemberList = (Map)SerializationUtils.fromJsonString((String)defaultparamStr, Map.class);
            }
            String previewResultStr = AnalysisServiceHelper.previewThemeResult(viewdataStr, dimMemberList);
            return JSON.parseObject((String)previewResultStr);
        }
        return null;
    }

    public static boolean saveThemeAnlysisDefaultParam(Long dmModelId, Long boardId, String shortDimNumber, Map<String, Object> memberMap) {
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)boardId);
        DynamicObject themeBoard = BusinessDataServiceHelper.loadSingle((String)"far_themeanalysisboard", (String)"id,defaultparam", (QFilter[])new QFilter[]{filter});
        if (Objects.nonNull(themeBoard)) {
            String defaultparamStr = themeBoard.getString("defaultparam");
            Map<String, Map<String, Object>> dimMemberList = new HashMap(5);
            if (!StringUtils.isEmpty((CharSequence)defaultparamStr) && (dimMemberList = (Map)SerializationUtils.fromJsonString((String)defaultparamStr, Map.class)).containsKey(shortDimNumber)) {
                dimMemberList.put(shortDimNumber, memberMap);
                themeBoard.set("defaultparam", (Object)SerializationUtils.toJsonString(dimMemberList));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{themeBoard});
                return true;
            }
        }
        return false;
    }

    public static boolean themeSave(Long dmModelId, Long themeAnlysisId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        JSONObject themeObject = jsonObject.getJSONObject("theme");
        if (Objects.isNull(themeObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u9898\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"AnalysisServiceHelper_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!themeAnlysisId.toString().equals(themeObject.getString("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u9898\u6570\u636e\u4e0d\u4e00\u81f4", (String)"AnalysisServiceHelper_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        JSONArray themePageListObject = themeObject.getJSONArray("pageList");
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and("id", "=", (Object)themeAnlysisId);
        DynamicObject themeAnlysis = BusinessDataServiceHelper.loadSingle((String)"far_themeanalysis", (String)"id,number,name,viewdata", (QFilter[])new QFilter[]{filter});
        if (Objects.isNull(themeAnlysis)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u9898\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"AnalysisServiceHelper_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, JSONObject> saveViewdata = new HashMap<String, JSONObject>(2);
        saveViewdata.put("pageConfig", pageConfig);
        themeAnlysis.set("viewdata", (Object)JSON.toJSONString(saveViewdata));
        QFilter boardfilter = new QFilter("model", "=", (Object)dmModelId);
        boardfilter.and("themeanalysis", "=", (Object)themeAnlysisId);
        DynamicObject[] boardAnlysisList = BusinessDataServiceHelper.load((String)"far_themeanalysisboard", (String)"id,name,number,viewdata,sequence", (QFilter[])new QFilter[]{boardfilter});
        if (boardAnlysisList.length == 0) {
            return false;
        }
        ArrayList<Long> deleteIdList = new ArrayList<Long>(5);
        ArrayList<DynamicObject> saveBoardList = new ArrayList<DynamicObject>(10);
        int sequence = 0;
        for (Object page : themePageListObject) {
            JSONObject pageObject = (JSONObject)page;
            String boardId = pageObject.getString("id");
            DynamicObject findBoard = Arrays.stream(boardAnlysisList).filter(x -> Objects.equals(x.getString("id"), boardId)).findAny().orElse(null);
            if (!Objects.nonNull(findBoard)) continue;
            findBoard.set("name", (Object)pageObject.getString("name"));
            findBoard.set("viewdata", (Object)pageObject.getJSONObject("data_init").toJSONString());
            findBoard.set("sequence", (Object)(++sequence));
            saveBoardList.add(findBoard);
        }
        for (DynamicObject board : boardAnlysisList) {
            String boardId = board.getString("id");
            DynamicObject findBoard = saveBoardList.stream().filter(x -> Objects.equals(x.getString("id"), boardId)).findAny().orElse(null);
            if (!Objects.isNull(findBoard)) continue;
            deleteIdList.add(LongUtil.toLong((Object)boardId));
        }
        try (TXHandle tx = TX.required();){
            try {
                if (deleteIdList.size() > 0) {
                    DeleteServiceHelper.delete((String)"far_themeanalysisboard", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIdList)});
                }
                if (saveBoardList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveBoardList.toArray(new DynamicObject[0]));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{themeAnlysis});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
        return true;
    }

    public static boolean save(Long dmModelId, Long chapterId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        JSONObject queryConfig = jsonObject.getJSONObject("queryConfig");
        JSONArray itemList = jsonObject.getJSONArray("itemList");
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
        List moduleIds = chapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)chapter.getLong("template.id"), (String)"fidm_template");
        ArrayList<Long> deleteModules = new ArrayList<Long>(10);
        ArrayList<DynamicObject> saveModules = new ArrayList<DynamicObject>(10);
        chapterModules.clear();
        for (Object item : itemList) {
            JSONObject itemObject = (JSONObject)item;
            AnalysisServiceHelper.saveToModule(deleteModules, chapterModules, saveModules, itemObject);
        }
        AnalysisServiceHelper.saveToModule(deleteModules, chapterModules, saveModules, queryConfig);
        AnalysisServiceHelper.saveToModule(deleteModules, chapterModules, saveModules, pageConfig);
        template.set("modifier", (Object)RequestContext.get().getCurrUserId());
        template.set("modifytime", (Object)TimeServiceHelper.now());
        if (saveModules.size() > 0) {
            moduleIds.addAll(saveModules.stream().map(e -> e.getLong("id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList()));
            moduleIds = moduleIds.stream().distinct().collect(Collectors.toList());
        }
        try (TXHandle tx = TX.required();){
            try {
                if (moduleIds.size() > 0) {
                    DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])new QFilter[]{new QFilter("id", "in", moduleIds)});
                }
                SaveServiceHelper.save((DynamicObject[])saveModules.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
            }
            catch (Exception e2) {
                tx.markRollback();
                throw new KDBizException((Throwable)e2, new ErrorCode("", e2.getMessage()), new Object[0]);
            }
        }
        return true;
    }

    public static void saveToModule(List<Long> deleteModules, DynamicObjectCollection chapterModules, List<DynamicObject> saveModules, JSONObject itemObject) {
        DynamicObject module = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
        module.set("id", (Object)itemObject.getString("id"));
        module.set("number", (Object)itemObject.getString("number"));
        module.set("name", (Object)itemObject.getString("name"));
        module.set("type", (Object)ModuleEnum.getModuleByNumber((String)itemObject.getString("type")).getType());
        module.set("datasetid", (Object)AnalysisServiceHelper.getDatasetId(itemObject));
        module.set("scope", (Object)"2");
        module.set("properties", (Object)itemObject.toJSONString());
        deleteModules.add(itemObject.getLong("id"));
        DynamicObject dyn = new DynamicObject(chapterModules.getDynamicObjectType());
        dyn.set("module", (Object)itemObject.getString("id"));
        dyn.set("key", (Object)"");
        dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        chapterModules.add((Object)dyn);
        saveModules.add(module);
    }

    public static Boolean isF7Var(JSONObject itemObject) {
        if (itemObject.get((Object)VARTYPE) != null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String getResult(JSONObject jsonObject, boolean isNeedSelectWindow, String eventArgs, boolean isEmptyDimMember) {
        JSONArray dimListObject = jsonObject.getJSONObject("queryConfig").getJSONArray(DIMLIST);
        boolean needSelected = isNeedSelectWindow;
        if (!needSelected) {
            HashMap memberInfo = Maps.newHashMapWithExpectedSize((int)10);
            HashMap varInfo = Maps.newHashMapWithExpectedSize((int)4);
            HashMap dimVarInfo = Maps.newHashMapWithExpectedSize((int)4);
            if (dimListObject.size() > 0) {
                for (Object item : dimListObject) {
                    JSONObject itemObject = (JSONObject)item;
                    JSONObject memberObject = itemObject.getJSONObject("member");
                    if (AnalysisServiceHelper.isF7Var(itemObject).booleanValue()) {
                        if (Objects.isNull(memberObject)) {
                            needSelected = true;
                            continue;
                        }
                        HashMap member = Maps.newHashMapWithExpectedSize((int)3);
                        member.put("id", memberObject.getString("id"));
                        member.put("number", memberObject.getString("number"));
                        member.put("name", memberObject.getString("name"));
                        memberInfo.put(itemObject.getString("shortNumber"), member);
                        continue;
                    }
                    String dimId = itemObject.getString(DIMID);
                    String varNum = itemObject.getString("number");
                    String defaultValue = itemObject.getString("defaultvalue");
                    if (Objects.nonNull(dimId)) {
                        dimVarInfo.put(varNum, itemObject);
                        continue;
                    }
                    varInfo.put(varNum, defaultValue);
                }
            }
            if (!needSelected) {
                if (varInfo.size() > 0) {
                    memberInfo.put(VARINFO, varInfo);
                }
                if (dimVarInfo.size() > 0) {
                    memberInfo.put(DIMVARINFO, dimVarInfo);
                }
                return AnalysisServiceHelper.previewResult(eventArgs, memberInfo);
            }
            if (isEmptyDimMember && needSelected) {
                return "emptydimmember";
            }
        }
        return "";
    }

    public static String getPreviwResult(JSONObject jsonObject, boolean isNeedSelectWindow, String eventArgs) {
        return AnalysisServiceHelper.getResult(jsonObject, isNeedSelectWindow, eventArgs, false);
    }

    private static String getDimListResult(JSONObject jsonObject, String eventArgs) {
        return AnalysisServiceHelper.getResult(jsonObject, false, eventArgs, true);
    }

    public static String previewSelect(AbstractFormPlugin plugin, Long dmModelId, Long modelId, String pageId, Long templateId) {
        Long defaultChapterId = AnalysisServiceHelper.getDefaultChapterId(dmModelId, templateId);
        Map<String, Object> dataInit = AnalysisServiceHelper.getDataInit(dmModelId, modelId, defaultChapterId, false);
        List itemList = (List)dataInit.get("itemList");
        for (Object o : itemList) {
            JSONObject item = (JSONObject)o;
            JSONObject dataSet = item.getJSONObject("dataset");
            if (!Objects.nonNull(dataSet) || dataSet.isEmpty() || !StringUtils.isEmpty((CharSequence)dataSet.getString("id"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u770b\u677f\u5b58\u5728\u6ca1\u6709\u9009\u62e9\u6570\u636e\u96c6\u7684\u7ec4\u4ef6\uff0c\u8bf7\u5148\u7f16\u8f91\u518d\u9884\u89c8\u3002", (String)"AnalysisServiceHelper_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        dataInit.put("primaryKey", "normal");
        return AnalysisServiceHelper.previewList(plugin, dmModelId, pageId, JSON.toJSONString(dataInit), true);
    }

    public static String preview(AbstractFormPlugin plugin, Long dmModelId, String pageId, String eventArgs, boolean isNeedSelectWindow) {
        return AnalysisServiceHelper.previewDesign(plugin, dmModelId, pageId, eventArgs, isNeedSelectWindow, "far_preview_config", "");
    }

    public static String previewList(AbstractFormPlugin plugin, Long dmModelId, String pageId, String eventArgs, boolean isNeedSelectWindow) {
        return AnalysisServiceHelper.previewDesign(plugin, dmModelId, pageId, eventArgs, isNeedSelectWindow, "far_preview_config", DynamicControlSourceEnum.DESIGNANALYSIS.getSourceName());
    }

    public static String doSearch(String eventArgs) {
        return AnalysisServiceHelper.searchDimList(eventArgs);
    }

    private static String searchDimList(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String previewResult = AnalysisServiceHelper.getDimListResult(jsonObject, eventArgs);
        if (StringUtils.isNotEmpty((CharSequence)previewResult)) {
            return previewResult;
        }
        return "";
    }

    public static String previewDesign(AbstractFormPlugin plugin, Long dmModelId, String pageId, String eventArgs, boolean isNeedSelectWindow, String formId, String previewSource) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        String previewResult = AnalysisServiceHelper.getPreviwResult(jsonObject, isNeedSelectWindow, eventArgs);
        if (StringUtils.isNotEmpty((CharSequence)previewResult)) {
            return previewResult;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelId", dmModelId);
        params.put("previewData", eventArgs);
        if (StringUtils.isNotEmpty((CharSequence)previewSource)) {
            params.put("previewsource", DynamicControlSourceEnum.DESIGNANALYSIS.getSourceName());
        }
        params.put("chapterId", jsonObject.get((Object)"chapterId"));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("far_preview_config");
        formShowParameter.setCustomParams(params);
        formShowParameter.setParentPageId(pageId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(formShowParameter);
        return "";
    }

    public static String previewResult(String eventArgs, Map<String, Object> memberSource) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray itemListObject = jsonObject.getJSONArray("itemList");
        boolean notSelectDefaultParam = false;
        for (Map.Entry<String, Object> entry : memberSource.entrySet()) {
            Map memberMap = (Map)entry.getValue();
            if (!Objects.isNull(memberMap)) continue;
            notSelectDefaultParam = true;
        }
        for (Object item : itemListObject) {
            JSONObject itemObject = (JSONObject)item;
            JSONObject datasetObject = itemObject.getJSONObject("dataset");
            if (!Objects.nonNull(datasetObject)) continue;
            if (notSelectDefaultParam) {
                HashMap<String, String> error = new HashMap<String, String>();
                error.put("msg", ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AnalysisServiceHelper_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                itemObject.put("error", error);
                continue;
            }
            itemObject.remove((Object)"data");
        }
        JSONArray dimList = jsonObject.getJSONObject("queryConfig").getJSONArray(DIMLIST);
        if (Objects.nonNull(memberSource.get(VARINFO)) || Objects.nonNull(memberSource.get(DIMVARINFO))) {
            Map varInfo = (Map)memberSource.get(VARINFO);
            Map dimVarInfo = (Map)memberSource.get(DIMVARINFO);
            if (Objects.nonNull(dimList)) {
                dimList.forEach(dim -> {
                    String shortNumber;
                    JSONObject dimObject = (JSONObject)dim;
                    String globalNum = dimObject.getString("number");
                    if (Objects.nonNull(varInfo) && Objects.nonNull(varInfo.get(globalNum))) {
                        dimObject.put("defaultvalue", varInfo.get(globalNum));
                    }
                    if (Objects.nonNull(dimVarInfo) && Objects.nonNull(dimVarInfo.get(globalNum))) {
                        JSONObject dimVarObject = (JSONObject)dimVarInfo.get(globalNum);
                        String memeberName = dimVarObject.getString("membername");
                        String memberNumber = dimVarObject.getString("membernum");
                        String defaultValue = dimVarObject.getString("defaultvalue");
                        JSONObject member = (JSONObject)dimVarObject.get((Object)"member");
                        dimObject.put("membername", (Object)memeberName);
                        dimObject.put("membernum", (Object)memberNumber);
                        dimObject.put("defaultvalue", (Object)defaultValue);
                        dimObject.put("member", (Object)member);
                    }
                    if (Objects.nonNull(memberSource.get(shortNumber = dimObject.getString("shortNumber")))) {
                        dimObject.put("member", memberSource.get(shortNumber));
                    }
                });
            }
        }
        jsonObject.put("i18n", AnalysisServiceHelper.getI18n());
        jsonObject.put("primaryKey", (Object)jsonObject.getString("primaryKey"));
        return jsonObject.toJSONString();
    }

    public static String previewThemeResult(String eventArgs, Map<String, Object> memberSource) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray dimList = jsonObject.getJSONObject("queryConfig").getJSONArray(DIMLIST);
        if (Objects.nonNull(memberSource.get(VARINFO)) || Objects.nonNull(memberSource.get(DIMVARINFO))) {
            Map varInfo = (Map)memberSource.get(VARINFO);
            Map dimVarInfo = (Map)memberSource.get(DIMVARINFO);
            if (Objects.nonNull(dimList)) {
                dimList.forEach(dim -> {
                    String shortNumber;
                    JSONObject dimObject = (JSONObject)dim;
                    String globalNum = dimObject.getString("number");
                    if (Objects.nonNull(varInfo) && Objects.nonNull(varInfo.get(globalNum))) {
                        dimObject.put("defaultvalue", varInfo.get(globalNum));
                    }
                    if (Objects.nonNull(dimVarInfo) && Objects.nonNull(dimVarInfo.get(globalNum))) {
                        JSONObject dimVarObject = (JSONObject)dimVarInfo.get(globalNum);
                        String memeberName = dimVarObject.getString("membername");
                        String memberNumber = dimVarObject.getString("membernum");
                        String defaultValue = dimVarObject.getString("defaultvalue");
                        JSONObject member = (JSONObject)dimVarObject.get((Object)"member");
                        dimObject.put("membername", (Object)memeberName);
                        dimObject.put("membernum", (Object)memberNumber);
                        dimObject.put("defaultvalue", (Object)defaultValue);
                        dimObject.put("member", (Object)member);
                    }
                    if (Objects.nonNull(memberSource.get(shortNumber = dimObject.getString("shortNumber")))) {
                        dimObject.put("member", memberSource.get(shortNumber));
                    }
                });
            }
        }
        jsonObject.put("i18n", AnalysisServiceHelper.getI18n());
        jsonObject.put("primaryKey", (Object)jsonObject.getString("primaryKey"));
        return jsonObject.toJSONString();
    }

    public static String previewModule(AbstractFormPlugin plugin, Long dmModelId, Long modelId, String pageId, Long moduleId) {
        Map<String, Object> dataInit = AnalysisServiceHelper.getMoudleDataInit(dmModelId, modelId, moduleId);
        dataInit.put("primaryKey", "normal");
        return AnalysisServiceHelper.openPreviewParamView(plugin, dmModelId, pageId, JSON.toJSONString(dataInit), DynamicControlSourceEnum.MODULEANALYSIS.getSourceName());
    }

    public static Map<String, Object> getMoudleDataInit(Long dmModelId, Long modelId, Long moduleId) {
        Object pageConfig = AnalysisServiceHelper.getDefaultPageConfig();
        ArrayList realModules = Lists.newArrayListWithCapacity((int)1);
        JSONObject queryConfig = AnalysisServiceHelper.setItemListAndQueryConfig(dmModelId, modelId, moduleId, realModules);
        HashMap result = Maps.newHashMapWithExpectedSize((int)5);
        result.put("pageConfig", pageConfig);
        result.put("queryConfig", queryConfig);
        result.put("itemList", realModules);
        return result;
    }

    public static String previewModuleResult(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray itemListObject = jsonObject.getJSONArray("itemList");
        if (Objects.nonNull(itemListObject)) {
            for (Object item : itemListObject) {
                JSONObject itemObject = (JSONObject)item;
                JSONObject datasetObject = itemObject.getJSONObject("dataset");
                if (!Objects.nonNull(datasetObject)) continue;
                itemObject.remove((Object)"data");
            }
        }
        jsonObject.put("i18n", AnalysisServiceHelper.getI18n());
        jsonObject.put("primaryKey", (Object)jsonObject.getString("primaryKey"));
        return jsonObject.toJSONString();
    }

    public static String openPreviewParamView(AbstractFormPlugin plugin, Long dmModelId, String pageId, String eventArgs, String previewSource) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray itemListInfo = jsonObject.getJSONArray("itemList");
        JSONObject itemList = null;
        if (Objects.nonNull(itemListInfo)) {
            itemList = (JSONObject)itemListInfo.get(0);
        }
        if (itemList == null) {
            itemList = jsonObject.getJSONObject("item");
        }
        JSONArray dimList = jsonObject.getJSONObject("queryConfig").getJSONArray(DIMLIST);
        JSONObject dataSet = itemList.getJSONObject("dataset");
        List variableList = Lists.newArrayListWithCapacity((int)4);
        Long dataSetId = null;
        if (Objects.nonNull(dataSet)) {
            dimList.clear();
            AnalysisServiceHelper.addDimListVarInfo(dataSet, dmModelId, dimList);
            dataSetId = dataSet.getLong("id");
            Boolean isISC = Boolean.FALSE;
            if (Objects.nonNull(dataSet.getString("dataSrcType")) && "isc_metadata_schema".equals(dataSet.getString("dataSrcType"))) {
                isISC = Boolean.TRUE;
            }
            DatasetVarAndDim result = DatasetServiceHelper.getVarAndDimVar((long)dmModelId, (long)dataSetId, (long)0L, (boolean)true, (boolean)isISC);
            variableList = result.getVariableList();
        }
        if (dimList.isEmpty() && variableList.isEmpty()) {
            return AnalysisServiceHelper.previewModuleResult(AnalysisServiceHelper.moduleStyleRest(eventArgs));
        }
        AnalysisServiceHelper.setModulePreviewForm(dmModelId, variableList, jsonObject, plugin, pageId, previewSource, dataSetId);
        return "";
    }

    private static void addDimListVarInfo(JSONObject dataSet, Long dmModelId, JSONArray dimList) {
        ModelInfo dmmodel;
        Long dataSetId = dataSet.getLong("id");
        DynamicObject[] dynamicObjectCollection = DatasetServiceHelper.queryDatasetVariable((Long)dataSetId, null, (Long)0L);
        if (dynamicObjectCollection != null && dynamicObjectCollection.length > 0 && Objects.nonNull(dmmodel = new ModelStrategyEx(dmModelId).getModel().getModelInfo())) {
            Long modelId = dmmodel.getModelId();
            DynamicObjectCollection newDynamicObjectCollection = new DynamicObjectCollection();
            boolean existCollection = newDynamicObjectCollection.addAll(Arrays.asList(dynamicObjectCollection));
            if (existCollection) {
                List<Map<String, String>> sourceData = AnalysisVariableHelper.setVarStructure(newDynamicObjectCollection, modelId, AnalysisVariableHelper.VariableType.GLOBAL.getType());
                List<Map<String, Object>> dimVarList = AnalysisDesignVarsHelper.buildCommonVarParams(sourceData, modelId);
                dimVarList.forEach(divVar -> dimList.add(divVar));
            }
        }
        if (dataSet.getJSONArray("dimParams").size() > 0) {
            dataSet.getJSONArray("dimParams").forEach(dataset -> {
                JSONObject dateSetObject = (JSONObject)dataset;
                dimList.add((Object)dateSetObject);
            });
        }
    }

    public static Object singleDatasetResolve(DynamicObject singleDB) {
        Long datasetSrcModelId = singleDB.getLong("datasrcid");
        Long datasetId = singleDB.getLong("dataset.id");
        List sourceColumnMapList = new DatasetServiceHelper().getDimListWithMemberName(datasetId, true, datasetSrcModelId.longValue());
        return sourceColumnMapList;
    }

    private static void setModulePreviewForm(Long dmModelId, List<Map<String, Object>> variableList, JSONObject jsonObject, AbstractFormPlugin plugin, String pageId, String previewSource, Long datasetId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelId", dmModelId);
        params.put("previewData", SerializationUtils.toJsonString((Object)jsonObject));
        params.put("variablelist", variableList);
        params.put("previewsource", previewSource);
        params.put("dataset_id", datasetId);
        params.put("chapterId", jsonObject.get((Object)"chapterId"));
        String formId = "far_preview_config";
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(params);
        formShowParameter.setParentPageId(pageId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(formShowParameter);
    }

    public static JSONObject moduleCalcute(Long dmModelId, String eventArgs, AnalysisDataHandler anaLysisDataHandler) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject itemObject = jsonObject.getJSONObject("item");
        HashMap<String, String> error = new HashMap<String, String>();
        itemObject.remove((Object)"data");
        JSONObject datasetObject = itemObject.getJSONObject("dataset");
        if (Objects.nonNull(datasetObject)) {
            Map<String, Object> dataMap = AnalysisCalcHelper.getPreviewDataSetInfo(dmModelId, jsonObject, anaLysisDataHandler);
            if (dataMap.containsKey("errorMsg")) {
                error.put("msg", dataMap.get("errorMsg").toString());
            } else {
                itemObject.remove((Object)"error");
            }
            if (dataMap.containsKey("data")) {
                itemObject.put("data", dataMap.get("data"));
            }
        }
        if (error.size() > 0) {
            itemObject.put("error", error);
        }
        return itemObject;
    }

    public static void previewWindow(AbstractFormPlugin plugin, Long dmModelId, String previewResult, Long templateId) {
        JSONObject queryConfig = JSONObject.parseObject((String)previewResult).getJSONObject("queryConfig");
        if (Objects.nonNull(queryConfig)) {
            Long defaultChapterId = AnalysisServiceHelper.getDefaultChapterId(dmModelId, templateId);
            JSONArray dimListObject = queryConfig.getJSONArray(DIMLIST);
            for (Object dim : dimListObject) {
                JSONObject dimObject = (JSONObject)dim;
                String shortNumber = dimObject.getString("shortNumber");
                JSONObject memberObject = dimObject.getJSONObject("member");
                Map memberMap = Collections.EMPTY_MAP;
                if (Objects.nonNull(memberObject)) {
                    memberMap = (Map)SerializationUtils.fromJsonString((String)memberObject.toJSONString(), Map.class);
                }
                AnalysisServiceHelper.saveDesginDefaultParam(dmModelId, defaultChapterId, shortNumber, memberMap);
            }
        }
        String formId = "far_analysispreviewresult";
        IFormView parentView = plugin.getView().getParentView();
        String newPageId = GlobalIdUtil.genGlobalLongId() + "_" + formId;
        HashMap customParams = new HashMap(8);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCustomParam("dmmodelid", (Object)dmModelId);
        formShowParameter.setCustomParam("templateId", (Object)templateId);
        formShowParameter.setCustomParam("previewResultStr", (Object)previewResult);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8", (String)"AnalysisServiceHelper_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        formShowParameter.setPageId(newPageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            plugin.getView().sendFormAction(parentView);
        }
    }

    public static void openPreviewModuleView(AbstractFormPlugin plugin, Long dmModelId, String previewResult, String scope) {
        String formId = "far_module_preview";
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)4);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams((Map)customParams);
        formShowParameter.setCustomParam("dmmodelid", (Object)dmModelId);
        JSONObject jsonObject = JSONObject.parseObject((String)previewResult);
        JSONArray modules = jsonObject.getJSONArray("itemList");
        JSONObject module = new JSONObject();
        if (modules.size() == 1) {
            module = (JSONObject)modules.get(0);
        } else {
            for (Object o : modules) {
                if (!(o instanceof JSONObject) || !"0".equals(((JSONObject)o).get((Object)"pid"))) continue;
                module = (JSONObject)o;
                break;
            }
        }
        String moduleType = module.getString("type");
        if ("10".equals(moduleType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5207\u7247\u7c7b\u578b\u7ec4\u4ef6\u65e0\u6cd5\u9884\u89c8\u3002", (String)"AnalysisServiceHelper_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(module.get((Object)"h")) || Objects.isNull(module.get((Object)"w"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u4ef6\u4e0d\u652f\u6301\u9884\u89c8\u3002", (String)"AnalysisServiceHelper_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        AnalysisServiceHelper.addModuleCGTheme(jsonObject, modules, CardType.MODULE.getType());
        formShowParameter.setCustomParam("previewResultStr", (Object)JSONObject.toJSONString((Object)jsonObject));
        Integer minHeight = (Integer)module.get((Object)"h") + 56;
        Integer minWidth = (Integer)module.get((Object)"w") + 18;
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight(minHeight + "px");
        inlineStyleCss.setWidth(minWidth + "px");
        formShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u4ef6\u9884\u89c8", (String)"AnalysisServiceHelper_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        plugin.getView().showForm(formShowParameter);
    }

    public static Object dsF7Result(Long dmModelId, Long modelId, Long chapterId, DynamicObject newVaule, String primaryKey) {
        if (!Objects.nonNull(newVaule)) {
            return null;
        }
        Long datasetId = newVaule.getLong("id");
        DynamicObject dataset = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"fidm_dataset");
        if (dataset == null) {
            return null;
        }
        String type = dataset.getString("type");
        List columnList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList dimParamList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList variableList = Lists.newArrayListWithExpectedSize((int)10);
        Boolean isMetadataSet = DatasetUtil.isMetadataDataSet((Long)datasetId);
        if (isMetadataSet.booleanValue()) {
            columnList = DatasetUtil.getColumnsByCustom((Long)datasetId);
        } else {
            Map findDim;
            DatasetExpressionHelper.checkExpression((Long)dmModelId, (Long)datasetId);
            if ("2".equals(type)) {
                columnList = DatasetFilterHelper.invokeDatasetFilterColumn((Long)dmModelId, (Long)datasetId);
                columnList.forEach(m -> m.put("id", m.get("number").toString()));
            }
            List<Map<String, Object>> dimList = AnalysisSingleF7ServiceHelper.getDimList(dmModelId, modelId);
            DatasetVarAndDim varAndDimResult = DatasetServiceHelper.getVarAndDimVar((long)dmModelId, (long)datasetId, (long)chapterId, (boolean)false);
            List varSourceList = varAndDimResult.getVariableList();
            List curShortNumberList = varAndDimResult.getCurShortNumberList();
            List cursShortNumberList = varAndDimResult.getCursShortNumberList();
            for (Map varObject : varSourceList) {
                varObject.put("modifyvalue", null);
                if (varObject.get("valuetype").equals(DmVariableTypeEnum.DIM.getIndex())) {
                    findDim = dimList.stream().filter(m -> m.get("id").equals(varObject.get("disc_dim"))).findAny().orElse(null);
                    if (Objects.nonNull(findDim)) {
                        varObject.put("dim", findDim);
                    } else {
                        varObject.put("dim", dimList.get(0));
                    }
                    Map dim = (Map)varObject.get("dim");
                    if (Objects.nonNull(dim)) {
                        varObject.put("dimShortNumber", dim.get("shortNumber"));
                    }
                }
                ArrayList entryentity = new ArrayList();
                if (Objects.nonNull(varObject.get("entryentity"))) {
                    for (DynamicObject entry : (DynamicObjectCollection)varObject.get("entryentity")) {
                        HashMap<String, String> newItem = new HashMap<String, String>(3);
                        newItem.put("id", entry.getString("id"));
                        newItem.put("enum_number", new LocaleString(entry.getString("enum_number")).getLocaleValue());
                        newItem.put("enum_name", new LocaleString(entry.getString("enum_name")).getLocaleValue());
                        entryentity.add(newItem);
                    }
                    varObject.put("entryentity", entryentity);
                }
                variableList.add(varObject);
            }
            for (String shortNumber : curShortNumberList) {
                findDim = dimList.stream().filter(m -> shortNumber.equalsIgnoreCase(m.get("shortNumber").toString())).findAny().orElse(null);
                if (!Objects.nonNull(findDim)) continue;
                findDim.put("member", new LinkedHashMap(1));
                dimParamList.add(findDim);
            }
            for (String shortNumber : cursShortNumberList) {
                findDim = dimList.stream().filter(m -> shortNumber.equalsIgnoreCase(m.get("shortNumber").toString())).findAny().orElse(null);
                if (!Objects.nonNull(findDim)) continue;
                findDim.put("members", new ArrayList(0));
                findDim.put("isDim", "2");
                dimParamList.add(findDim);
            }
        }
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)newVaule.getString("id"));
        dataObj.put("name", (Object)newVaule.getString("name"));
        dataObj.put("number", (Object)newVaule.getString("number"));
        dataObj.put("type", (Object)type);
        dataObj.put("columns", columnList);
        dataObj.put("varParams", (Object)variableList);
        dataObj.put("dimParams", (Object)dimParamList);
        dataObj.put("datesetFilterItems", new ArrayList());
        if (!"3".equals(type)) {
            DynamicObject discModel = dataset.getDynamicObject("discmodel");
            String dataSrcType = DatasetServiceHelper.getDataSourceTypeOfSingleDS((long)datasetId, (DynamicObject)discModel);
            dataObj.put("dataSrcType", (Object)dataSrcType);
        }
        return AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_DS_F7_RESULT, dataObj, primaryKey);
    }

    public static Object datasetFormulaResult(DynamicObject newValue, String primaryKey, String cache, Long discModelId) {
        Map map;
        if (!Objects.nonNull(newValue)) {
            return null;
        }
        DynamicObject searchAgainMulDataset = QueryServiceHelper.queryOne((String)newValue.getDataEntityType().getName(), (String)"single.dataset.id,formulatype", (QFilter[])new QFilter[]{new QFilter("id", "=", newValue.getPkValue())});
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)newValue.getString("id"));
        dataObj.put("name", (Object)newValue.getString("name"));
        dataObj.put("number", (Object)newValue.getString("number"));
        dataObj.put("formulatype", (Object)searchAgainMulDataset.getString("formulatype"));
        if ("1".equals(searchAgainMulDataset.getString("formulatype"))) {
            String dataSrcType = DatasetServiceHelper.getDataSourceTypeOfSingleDS((long)searchAgainMulDataset.getLong("single.dataset.id"), (long)discModelId);
            dataObj.put("dataSrcType", (Object)dataSrcType);
        }
        if (StringUtils.isNotBlank((CharSequence)cache) && (map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class)).containsKey("mark")) {
            dataObj.put("mark", map.get("mark"));
        }
        return AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_DATASET_FORMULA_RESULT, dataObj, primaryKey);
    }

    public static void saveModule(AbstractBaseFormPlugin plugin, Long dmModelId, String pageId, String eventArgs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelId", dmModelId);
        params.put("itemJsonData", eventArgs);
        String formId = "far_module_reportity_bak";
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(params);
        formShowParameter.setParentPageId(pageId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u4ef6\u53e6\u5b58\u4e3a", (String)"AnalysisServiceHelper_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(formShowParameter);
    }

    public static Object moduleAddItem(Long dmModelId, Long chapterId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        Long moduleId = LongUtil.toLong((Object)jsonObject.getString("moduleId"));
        Map module = ModuleServiceHelper.getModule((Long)dmModelId, (Long)moduleId);
        if (!Objects.nonNull(module)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728", (String)"AnalysisServiceHelper_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        JSONObject itemObject = new JSONObject();
        String moduleStr = module.get("properties").toString();
        JSONObject datasetObject = itemObject.getJSONObject("dataset");
        JSONArray resultJsonArray = new JSONArray();
        if (moduleStr.charAt(0) == '[') {
            JSONArray jsonArray = JSON.parseArray((String)moduleStr);
            HashMap<String, String> idMap = new HashMap<String, String>();
            for (Object object : jsonArray) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject jo = (JSONObject)object;
                resultJsonArray.add((Object)AnalysisServiceHelper.buildItem(jo, datasetObject, chapterId, moduleId, idMap));
            }
            resultJsonArray.forEach(a -> {
                JSONObject joc;
                JSONObject joa = (JSONObject)a;
                if (!"0".equals(joa.getString("pid"))) {
                    joa.put("pid", idMap.get(joa.getString("pid")));
                }
                if ((joc = joa.getJSONObject("c")) != null) {
                    String currTabId;
                    JSONArray lineList = joc.getJSONArray("lineList");
                    if (lineList != null && lineList.size() > 0) {
                        lineList.forEach(b -> {
                            JSONObject job = (JSONObject)b;
                            String from = job.getString("from");
                            job.put("from", (Object)AnalysisServiceHelper.replaceLineList(job, from, idMap));
                            String to = job.getString("to");
                            job.put("to", (Object)AnalysisServiceHelper.replaceLineList(job, to, idMap));
                        });
                    }
                    if ((currTabId = joc.getString("currTabId")) != null && !"".equals(currTabId)) {
                        joc.put("currTabId", idMap.get(currTabId));
                    }
                }
            });
            return resultJsonArray;
        }
        itemObject = JSON.parseObject((String)moduleStr);
        return AnalysisServiceHelper.buildItem(itemObject, datasetObject, chapterId, moduleId, null);
    }

    private static String replaceLineList(JSONObject job, String from, Map<String, String> idMap) {
        if (!"".equals(from)) {
            Pattern patternId = Pattern.compile("\\d+");
            Matcher matcherId = patternId.matcher(from);
            String id = "";
            while (matcherId.find()) {
                id = matcherId.group();
            }
            return from.replace(id, idMap.get(id));
        }
        return "";
    }

    private static JSONObject buildItem(JSONObject itemObject, JSONObject datasetObject, Long chapterId, Long moduleId, Map<String, String> idMap) {
        long datasetId;
        if (Objects.nonNull(datasetObject) && (datasetId = LongUtil.toLong((Object)datasetObject.get((Object)"id")).longValue()) > 0L) {
            long[] dsList = DatasetServiceHelper.copyChapterDataset((Long)datasetId, (Long)chapterId);
            if (Objects.isNull(dsList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728", (String)"AnalysisServiceHelper_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (dsList.length > 0) {
                itemObject.getJSONObject("dataset").put("id", (Object)Long.valueOf(dsList[0]).toString());
            }
        }
        LinkedHashMap<String, String> copyfrom = new LinkedHashMap<String, String>(2);
        copyfrom.put("id", moduleId.toString());
        copyfrom.put("type", "module");
        String itemId = String.valueOf(ID.genLongId());
        if (idMap != null) {
            idMap.put(itemObject.getString("id"), itemId);
        }
        itemObject.put("id", (Object)itemId);
        itemObject.put("copyfrom", copyfrom);
        return itemObject;
    }

    public static Object getDefaultQueryConfig(Long dmModelId, Long modelId) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)Long.valueOf(GlobalIdUtil.genGlobalLongId()).toString());
        dataObj.put("name", (Object)"QueryConfig");
        dataObj.put("number", (Object)"QueryConfig");
        dataObj.put("type", (Object)ModuleEnum.Analysis_QUERY.getNumber());
        List<Map<String, Object>> dimList = AnalysisServiceHelper.getDimList(dmModelId, modelId);
        dataObj.put(DIMLIST, dimList);
        Map<String, Object> floatButton = AnalysisServiceHelper.getDefaultFloatButton();
        dataObj.put("floatButton", floatButton);
        return dataObj;
    }

    public static List<Map<String, Object>> getDimList(Long dmModelId, Long modelId) {
        List<Map<String, Object>> dimSourceList = AnalysisSingleF7ServiceHelper.getDimList(dmModelId, modelId);
        ArrayList dimList = Lists.newArrayListWithCapacity((int)6);
        DynamicObject dmmodel = BusinessDataServiceHelper.loadSingleFromCache((Object)dmModelId, (String)"fidm_model");
        String modelType = dmmodel.getString("modeltype");
        List<Object> defaultDim = Lists.newArrayListWithCapacity((int)5);
        if ("1".equals(modelType)) {
            defaultDim = BCM_FIXEDDIM;
        } else if ("2".equals(modelType)) {
            defaultDim = EPM_FIXEDDIM;
        }
        for (Map<String, Object> dim : dimSourceList) {
            String dimNumber;
            if (!Objects.nonNull(dim.get("number")) || !defaultDim.contains(dimNumber = dim.get("number").toString().toLowerCase())) continue;
            dimList.add(dim);
        }
        return dimList;
    }

    public static Map<String, Object> getDefaultFloatButton() {
        HashMap floatButton = Maps.newHashMapWithExpectedSize((int)4);
        floatButton.put("hidden", false);
        floatButton.put("X", 10);
        floatButton.put("Y", 500);
        return floatButton;
    }

    public static Object getDefaultPageConfig() {
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)Long.valueOf(GlobalIdUtil.genGlobalLongId()).toString());
        dataObj.put("name", (Object)"PageConfig");
        dataObj.put("number", (Object)"PageConfig");
        dataObj.put("type", (Object)ModuleEnum.Analysis_PAGE.getNumber());
        dataObj.put("url", (Object)"");
        dataObj.put("size", (Object)"2");
        dataObj.put("width", (Object)"1024");
        dataObj.put("height", (Object)"768");
        dataObj.put("backgroundSize", (Object)"100% 100%");
        return dataObj;
    }

    private static Object getThemeDefaultPageConfig() {
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)Long.valueOf(GlobalIdUtil.genGlobalLongId()).toString());
        dataObj.put("name", (Object)"PageConfig");
        dataObj.put("number", (Object)"PageConfig");
        dataObj.put("type", (Object)ModuleEnum.Analysis_PAGE.getNumber());
        dataObj.put("url", (Object)"");
        dataObj.put("size", (Object)"2");
        dataObj.put("width", (Object)"1024");
        dataObj.put("height", (Object)"768");
        dataObj.put("backgroundSize", (Object)"100% 100%");
        dataObj.put("switchMode", (Object)"hand");
        dataObj.put("switchTime", (Object)10);
        dataObj.put("tabPosition", (Object)"bottom");
        dataObj.put("tabHeight", (Object)"40");
        HashMap<String, String> tabStyle = new HashMap<String, String>(5);
        tabStyle.put("fontStyle", "normal");
        tabStyle.put("fontWeight", "normal");
        tabStyle.put("underline", "none");
        tabStyle.put("fontSize", "16");
        tabStyle.put("foreColor", "#000000");
        tabStyle.put("backColor", "rgba(211, 203, 183, 0.5)");
        dataObj.put("tabStyle", tabStyle);
        HashMap<String, String> selectedTabStyle = new HashMap<String, String>(5);
        selectedTabStyle.put("fontStyle", "normal");
        selectedTabStyle.put("fontWeight", "normal");
        selectedTabStyle.put("underline", "none");
        selectedTabStyle.put("fontSize", "16");
        selectedTabStyle.put("foreColor", "#000000");
        selectedTabStyle.put("backColor", "rgba(255, 255, 255, 1)");
        dataObj.put("selectedTabStyle", selectedTabStyle);
        return dataObj;
    }

    public static Object getI18n() {
        Lang lang = Lang.get();
        JSONObject dataObj = new JSONObject();
        dataObj.put("lang", (Object)lang.getLangTag());
        return dataObj;
    }

    public static Long getDatasetId(JSONObject itemObject) {
        Long retVal = 0L;
        JSONObject dataset = itemObject.getJSONObject("dataset");
        if (Objects.nonNull(dataset)) {
            retVal = LongUtil.toLong((Object)itemObject.getJSONObject("dataset").getLong("id"));
        }
        return retVal;
    }

    public static Map<String, Object> getDefaultparamData(JSONArray dimListArray) {
        HashMap<String, Object> dimMemberMap = new HashMap<String, Object>(5);
        for (Object dim : dimListArray) {
            HashMap dimMap;
            if (dim instanceof JSONObject) {
                JSONObject dimObject = (JSONObject)dim;
                if (!AnalysisServiceHelper.isDimQueryConfig(dimObject)) continue;
                JSONObject memberObject = dimObject.getJSONObject("member");
                dimMemberMap.put(dimObject.getString("shortNumber"), Objects.isNull(memberObject) ? null : memberObject);
                continue;
            }
            if (!(dim instanceof Map) || !AnalysisServiceHelper.isDimQueryConfig(dimMap = (HashMap)dim)) continue;
            dimMemberMap.put((String)dimMap.get("shortNumber"), dimMap.get("id"));
        }
        return dimMemberMap;
    }

    public static String moduleStyleRest(String newEventArgs) {
        JSONObject jsonObject = JSONObject.parseObject((String)newEventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        pageConfig.put("backgroundColor", (Object)"rgba(255, 255, 255, 1)");
        JSONArray modules = jsonObject.getJSONArray("itemList");
        if (Objects.nonNull(modules)) {
            for (Object module : modules) {
                JSONObject m = (JSONObject)module;
                if (!"0".equals(m.get((Object)"pid"))) continue;
                if (StringUtils.equals((CharSequence)m.getString("type"), (CharSequence)"analysis_divided_line")) {
                    JSONObject c = m.getJSONObject("c");
                    m.put("w", (Object)400);
                    m.put("h", (Object)150);
                    c.put("lw", (Object)600);
                }
                m.put("x", (Object)0);
                m.put("y", (Object)48);
            }
        }
        return JSONObject.toJSONString((Object)jsonObject);
    }

    public static boolean isDimQueryConfig(JSONObject dimObject) {
        Integer valuetype = dimObject.getInteger("valuetype");
        if (Objects.nonNull(valuetype)) {
            String dimId = dimObject.getString(DIMID);
            if (valuetype.intValue() == VariableTypeEnum.DIM.getCode() && Objects.isNull(dimId)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDimQueryConfig(Map dimMap) {
        if (dimMap.get("valuetype") != null) {
            int valueType = Integer.parseInt(String.valueOf(dimMap.get("valuetype")));
            String dimId = (String)dimMap.get(DIMID);
            if (valueType == VariableTypeEnum.DIM.getCode() && Objects.isNull(dimId)) {
                return true;
            }
        }
        return false;
    }

    public static void updateDynamicObject(String eventArgs, String formId, String formNum) {
        DynamicObject dynamicObject;
        String dbViewData;
        JSONObject dbJsonObject;
        JSONObject dbQueryConfig;
        JSONArray dbDimList;
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject viewQueryConfig = jsonObject.getJSONObject("queryConfig");
        JSONArray viewDimList = viewQueryConfig.getJSONArray(DIMLIST);
        if (!viewDimList.equals((Object)(dbDimList = (dbQueryConfig = (dbJsonObject = JSON.parseObject((String)(dbViewData = (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)formId), (String)formNum)).getString("viewdata")))).getJSONObject("queryConfig")).getJSONArray(DIMLIST)))) {
            dbQueryConfig.remove((Object)DIMLIST);
            dbQueryConfig.put(DIMLIST, (Object)viewDimList);
            dynamicObject.set("viewdata", (Object)SerializationUtils.toJsonString((Object)dbJsonObject));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    public static void addModuleCGTheme(JSONObject jsonObject, JSONArray modules, String type) {
        if (CardType.MODULE.getType().equals(type) && !modules.isEmpty()) {
            JSONObject module = (JSONObject)modules.get(0);
            JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
            if (Objects.nonNull(module.getJSONObject("CGTheme"))) {
                pageConfig.put("CGTheme", (Object)module.getJSONObject("CGTheme"));
            }
        }
    }

    public static Long convertModelId(Object previewData) {
        Long dmModelId = 0L;
        Long primaryKey = 0L;
        if (!ObjectUtils.isEmpty((Object)previewData)) {
            JSONObject jsonObject = JSON.parseObject((String)previewData.toString());
            Object chapterId = jsonObject.get((Object)"chapterId");
            if (!ObjectUtils.isEmpty((Object)chapterId)) {
                return dmModelId;
            }
            Object primaryKeyData = jsonObject.get((Object)"primaryKey");
            if (ObjectUtils.isEmpty((Object)primaryKeyData) || "normal".equals(primaryKeyData)) {
                return dmModelId;
            }
            primaryKey = jsonObject.getLong("primaryKey");
        }
        if (primaryKey != 0L) {
            Long datasetid;
            QFBuilder modelBuilder = new QFBuilder("id", "=", (Object)primaryKey);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fidm_modulerepository", (String)"id,datasetid", (QFilter[])modelBuilder.toArray());
            long model = 0L;
            if (dynamicObject != null && (dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fidm_dataset", (String)"id,discmodel", (QFilter[])(modelBuilder = new QFBuilder("id", "=", (Object)(datasetid = Long.valueOf(dynamicObject.getLong("datasetid.id"))))).toArray())) != null) {
                model = dynamicObject.getLong("discmodel.id");
            }
            if (model != 0L) {
                dmModelId = model;
            }
        }
        return dmModelId;
    }
}

