/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.far.enums.ModelSourceEnum;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;

public class AnalysisSingleF7ServiceHelper {
    public static void BuildF7StyleForPreview(Element F7, int index, String sourceName) {
        Style style = AnalysisCommonOperateHelper.setCustomControlStyle(index, sourceName);
        String name = F7.getName();
        String LabelLength = (name.length() + 1) * 12 + "px";
        F7.setLabelWidth(new LocaleString(LabelLength));
        F7.setHeight(new LocaleString("40px"));
        F7.setStyle(style);
        F7.setWidth(new LocaleString("210px"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
        F7.setLabelDirection("v");
    }

    public static List<Map<String, Object>> getDimList(Long dmModelId, Long modelId) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        for (DimensionInfo dim : modelStrategyEx.getDim().getDimList()) {
            String dimNum = dim.getNumber();
            HashMap<String, Object> item = new HashMap<String, Object>(16);
            item.put("id", dim.getId().toString());
            item.put("number", dimNum);
            item.put("shortNumber", dim.getShortNumber());
            item.put("name", dim.getName());
            item.put("valuetype", 4);
            item.put("isDim", "1");
            item.put("entityName", dim.getEntityName());
            list.add(item);
        }
        return list;
    }

    public static List<Map<String, Object>> getDimList(Long dmModelId) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List list = Collections.EMPTY_LIST;
        List allDims = modelStrategyEx.getDim().getDimList();
        if (allDims.size() > 0) {
            list = Lists.newArrayListWithExpectedSize((int)allDims.size());
            for (DimensionInfo dim : allDims) {
                String dimNum = dim.getNumber();
                HashMap item = Maps.newHashMapWithExpectedSize((int)7);
                item.put("id", dim.getId().toString());
                item.put("name", dim.getName());
                item.put("number", dimNum);
                item.put("shortNumber", dim.getShortNumber());
                item.put("valuetype", 4);
                item.put("isDim", "1");
                item.put("entityName", dim.getEntityName());
                list.add(item);
            }
        }
        return list;
    }

    public static List<Map<String, Object>> getVarDimList(Long dmModelId, List<Long> dimensionIds) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List allDims = modelStrategyEx.getDim().getDimList();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)5);
        List filters = allDims.stream().filter(m -> dimensionIds.contains(m.getId())).collect(Collectors.toList());
        for (DimensionInfo dimensionInfo : filters) {
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("id", dimensionInfo.getId().toString());
            String dimNum = dimensionInfo.getNumber();
            item.put("number", dimNum);
            item.put("shortNumber", dimensionInfo.getShortNumber());
            item.put("name", dimensionInfo.getName());
            item.put("valuetype", VariableTypeEnum.DIM.getCode());
            item.put("entityName", dimensionInfo.getEntityName());
            ids.add(item);
        }
        return ids;
    }

    public static Map<String, Set<Long>> getDimDataMap(Long dmModelId, Long modelId, Set<String> filterDimIdList) {
        return AnalysisSingleF7ServiceHelper.getMyAndDesignAnalysisDim(dmModelId, modelId, filterDimIdList, Boolean.FALSE);
    }

    public static Map<String, Set<Long>> getMyAndDesignAnalysisDim(Long dmModelId, Long modelId, Set<String> filterDimIdList, Boolean isMyAndDesignAnalysisDim) {
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)16);
        if (isMyAndDesignAnalysisDim.booleanValue() && filterDimIdList.size() == 0) {
            return dimMap;
        }
        List<Map<String, Object>> dimList = AnalysisSingleF7ServiceHelper.getDimList(dmModelId, modelId);
        for (Map<String, Object> dimInfo : dimList) {
            if (Objects.nonNull(filterDimIdList) && filterDimIdList.size() > 0 && !filterDimIdList.contains(dimInfo.get("id").toString())) continue;
            String dimKey = dimInfo.get("id").toString() + "/" + dimInfo.get("number").toString().toLowerCase() + "/" + dimInfo.get("name").toString() + "/" + dimInfo.get("entityName").toString() + "/" + dimInfo.get("shortNumber").toString();
            HashSet allMemberIds = new HashSet(1);
            if (dimMap.get(dimKey) == null) {
                dimMap.put(dimKey, allMemberIds);
                continue;
            }
            Set hasMemberIds = (Set)dimMap.get(dimKey);
            hasMemberIds.addAll(allMemberIds);
        }
        if (Objects.nonNull(filterDimIdList) && filterDimIdList.size() > 0) {
            LinkedHashMap dimOrderMap = Maps.newLinkedHashMapWithExpectedSize((int)filterDimIdList.size());
            for (String id : filterDimIdList) {
                String findKey = dimMap.keySet().stream().filter(x -> x.split("/")[0].equals(id)).findAny().orElse(null);
                if (StringUtils.isEmpty((CharSequence)findKey)) continue;
                dimOrderMap.put(findKey, dimMap.get(findKey));
            }
            dimMap = dimOrderMap;
        }
        return dimMap;
    }

    public static void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent, Long modelid, Map<String, Set<Long>> templateDimMap, Map<String, Long> f7DimMap, Object scenario, String dimKey) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelid);
        ModelInfo model = modelStrategyEx.getModel().getModelInfo();
        if (Objects.equals(model.getModelType(), ModelSourceEnum.EB.getType())) {
            return;
        }
        if ("period".equals(dimKey) && f7DimMap.containsKey("scenario") && scenario == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"AnalysisSingleF7ServiceHelper_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        Long dimId = 0L;
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        for (Map.Entry<String, Set<Long>> templateDim : templateDimMap.entrySet()) {
            String templatMapKey = templateDim.getKey();
            String[] splitDimKey = templatMapKey.split("/");
            String dimNumber = splitDimKey[1];
            dimId = LongUtil.toLong((Object)splitDimKey[0]);
            if (!dimKey.equals(dimNumber)) continue;
            HashSet memberList = new HashSet();
            memberList.addAll(templateDim.getValue());
            if (memberList.size() != 0) {
                qFilter.and(new QFilter("id", "in", memberList));
            }
            qFilter.and(new QFilter("dimension", "=", (Object)dimId));
            break;
        }
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        if (DmDimMemberEntityEnum.BCM_YEAR.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter("number", "!=", (Object)"LastYear").and(new QFilter("number", "!=", (Object)"CurrentYear")));
        } else if (DmDimMemberEntityEnum.BCM_PERIOD.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter("number", "!=", (Object)"LastPeriod").and(new QFilter("number", "!=", (Object)"CurrentPeriod")));
        }
        BcmPermService bcmPermService = new BcmPermService(modelid, dimId);
        QFilter filter = bcmPermService.getPermQFilter("id");
        filterList.add(filter);
        beforeF7SelectEvent.setCustomQFilters(filterList);
    }
}

