/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;

public class AnalysisUploadImagePlugin
extends AbstractBaseFormPlugin {
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String BTN_CLOSE = "btn_close";
    private static final String ATTACHMENT_PANEL = "attchment";

    public static Map<String, String> uploadTempFile(String url, String filePath, String fileName, Map fileNameData, String type) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String appId = (String)fileNameData.get("appId");
        String formId = (String)fileNameData.get("formId");
        Object pkId = fileNameData.get("pkId");
        String turl = "";
        if (url.contains("tempfile")) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            FileItem fileItem = null;
            String utf8FileName = fileName;
            try {
                utf8FileName = URLEncoder.encode(utf8FileName, "utf-8");
            }
            catch (UnsupportedEncodingException var18) {
                AbstractBaseFormPlugin.log.info(var18.getMessage());
            }
            fileItem = new FileItem(utf8FileName, AnalysisUploadImagePlugin.getAttachmentFileName(appId, formId, pkId, fileName), in);
            fileItem.setCreateNewFileWhenExists(false);
            turl = service.upload(fileItem);
            cache.remove(url);
            url = turl;
            try {
                in.close();
            }
            catch (IOException var17) {
                AbstractBaseFormPlugin.log.info(var17.getMessage());
            }
        }
        dataMap.put("fileName", fileName);
        dataMap.put("filePath", filePath);
        url = AnalysisCommonOperateHelper.urlAddTicket(url);
        String docUrl = UrlService.getAttachmentFullUrl((String)url);
        dataMap.put("url", docUrl);
        return dataMap;
    }

    public static String getAttachmentFileName(String appId, String formId, Object pkId, String filename) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)pkId, (String)filename);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CONFIRM, BTN_CLOSE);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_confirm": {
                this.confirm();
                break;
            }
            case "btn_close": {
                this.getView().close();
            }
        }
    }

    private void confirm() {
        Control attachmentControl = this.getView().getControl(ATTACHMENT_PANEL);
        AttachmentPanel panel = (AttachmentPanel)attachmentControl;
        List attachmentData = panel.getAttachmentData();
        if (CollectionUtils.isEmpty((Collection)attachmentData) || attachmentData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6", (String)"AnalysisUploadImagePlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        String pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
        String url = (String)((Map)attachmentData.get(0)).get("url");
        String fileName = (String)((Map)attachmentData.get(0)).get("name");
        String type = (String)((Map)attachmentData.get(0)).get("type");
        HashMap<String, String> filePathDataMap = new HashMap<String, String>(4);
        filePathDataMap.put("appId", "far");
        filePathDataMap.put("formId", formId);
        filePathDataMap.put("pkId", pkId);
        Map<String, String> uploaDataMap = AnalysisUploadImagePlugin.uploadTempFile(url, url, fileName, filePathDataMap, type);
        this.returnDataToParent(uploaDataMap);
        this.getView().close();
    }
}

