/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.ai.test.charts;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.ai.test.charts.IGService;

public class GPTGenerateIframePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GPTGenerateIframePlugin.class);
    public static final String APPLY = "apply";
    public static final String OUTPUT = "output";
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{APPLY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String promptResult = this.getGPTPromptResult();
        this.pageInit(promptResult);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        if (APPLY.equals(button.getKey())) {
            this.returnResToForm();
        }
    }

    private void pageInit(String data) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)"AiShow");
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("i18n", AnalysisServiceHelper.getI18n());
        dataObj.put("data", (Object)data);
        this.SendToVue(dataObj, this.getView());
    }

    protected void SendToVue(Object data, IFormView view) {
        CustomControl custom = (CustomControl)view.getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    private void returnResToForm() {
        IFormView formView = SessionManager.getCurrent().getView(this.getNoticeFormPageId());
        if (formView != null) {
            String gptPromptResult = this.getGPTPromptResult();
            this.buildData(gptPromptResult, formView);
            IGService.sendFormActionByWS(formView);
        } else {
            this.getView().showTipNotification("Please Apply in DesignView");
        }
    }

    public void buildData(String data, IFormView view) {
        JSONObject aiInsert = (JSONObject)AnalysisDesignHelper.getPropsDataResult("Ai_Insert");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ai", (Object)data);
        String itemId = String.valueOf(ID.genLongId());
        jsonObject.fluentPut("type", (Object)"analysis_pie_chart_pie");
        jsonObject.fluentPut("itemId", (Object)itemId);
        aiInsert.put("data", (Object)jsonObject);
        this.SendToVue(aiInsert, view);
    }

    private String getGPTPromptResult() {
        String noticeFormPageId = this.getNoticeFormPageId();
        IPageCache pageCache = SessionManager.getCurrent().getPageCache(noticeFormPageId);
        if (pageCache == null) {
            logger.error("IPageCache is not exist");
            return "";
        }
        return pageCache.get("prompt_output");
    }

    private String getNoticeFormPageId() {
        String noticeFormPageId = (String)this.getView().getFormShowParameter().getCustomParam("PAGE_ID");
        if (noticeFormPageId == null) {
            throw new KDBizException("ParentView is not exist");
        }
        return noticeFormPageId;
    }

    public String getTestData() {
        return "{ \n    A: { \n        one: 520, \n        two: 634, \n        three: 434 \n    }, \n    B: { \n        one: 634, \n        two: 588, \n        three: 834 \n    }, \n    C: { \n        one: 934, \n        two: 334, \n        three: 188 \n    } \n}";
    }
}

