/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.ai.test.charts;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.faranalysis.ai.test.charts.GaiInitConfig;

public class GenerateChartViewPlugin
extends AbstractBaseFormPlugin {
    private final WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());
    public static final String GENERATE_CHART = "generate_chart";
    public static final String PROCESS_NUMBER = "process-240812DE750247";
    public static final String GAI_PROCESS_KEY = "gai_process";
    public static final String DATA_JSON = "DATA_JSON";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(GENERATE_CHART);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        if (button.getKey().equals(GENERATE_CHART)) {
            this.sideBarInit();
        }
    }

    public void sideBarInit() {
        IFormView iFormView = this.getView().getMainView();
        if (iFormView == null) {
            iFormView = this.getView().getParentView();
        }
        String rootPageId = iFormView.getPageId();
        GaiInitConfig gaiInitConfig = new GaiInitConfig();
        gaiInitConfig.setSwitchSide(true);
        gaiInitConfig.setLockSide(true);
        String taskNumber = StringUtils.isEmpty((CharSequence)this.getNumberPage()) ? PROCESS_NUMBER : this.getNumberPage();
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)taskNumber)};
        DynamicObject gaiProcess = BusinessDataServiceHelper.loadSingleFromCache((String)GAI_PROCESS_KEY, (QFilter[])filters);
        if (gaiProcess == null) {
            throw new KDBizException("process_number is not exist");
        }
        long processId = gaiProcess.getLong("id");
        gaiInitConfig.setSelectedProcessId(String.valueOf(processId));
        if (this.getStartAll() || this.getStartParams()) {
            gaiInitConfig.setStartProcessId(String.valueOf(processId));
        }
        HashMap<String, String> startParams = new HashMap<String, String>(2);
        if (this.getStartAll() || this.getStartVar()) {
            startParams.put("PAGE_ID", this.getView().getPageId());
            String data = StringUtils.isEmpty((CharSequence)this.getDataFromPage()) ? this.getTestData() : this.getDataFromPage();
            startParams.put(DATA_JSON, data);
            gaiInitConfig.setStartParams(startParams);
            this.getView().getPageCache().put(DATA_JSON, data);
        }
        this.logger.info("kd.epm.far.formplugin.faranalysis.ai.test.charts.GenerateChartViewPlugin === startParams" + startParams);
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, JSON.toJSONString((Object)gaiInitConfig)});
    }

    public boolean getStartParams() {
        return Boolean.parseBoolean(this.getModel().getValue("startparams").toString());
    }

    public boolean getStartVar() {
        return Boolean.parseBoolean(this.getModel().getValue("startvar").toString());
    }

    public boolean getStartAll() {
        return Boolean.parseBoolean(this.getModel().getValue("startall").toString());
    }

    public String getDataFromPage() {
        return this.getModel().getValue("data") == null ? "" : this.getModel().getValue("data").toString();
    }

    public String getNumberPage() {
        return this.getModel().getValue("number") == null ? "" : this.getModel().getValue("number").toString();
    }

    public String getTestData() {
        return "{ \n    A: { \n        one: 520, \n        two: 634, \n        three: 434 \n    }, \n    B: { \n        one: 634, \n        two: 588, \n        three: 834 \n    }, \n    C: { \n        one: 934, \n        two: 334, \n        three: 188 \n    } \n}";
    }
}

