/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.apphome;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.far.enums.CardType;
import kd.epm.far.business.far.enums.DynamicControlSourceEnum;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.faranalysis.AbstractAnalysisPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;

public class FarCardApphomePlugin
extends AbstractAnalysisPlugin {
    private static final String CARDID = "cardId";
    private static final String CARD = "card";
    private static final String CARDTYPE = "cardtype";
    private static final String LISTCLOSECALLBACK = "listclosecallback";
    private static final String MODELID = "model.id";
    private static final String MODULEREPOSITORYID = "modulerepository.id";
    private static final String THEMATICANALYSISID = "thematicanalysis.id";
    private static final String MYANALYSISID = "myanalysis.id";
    private static final String MODULEANDCARDSELECTINFO = "modulerepository.id,myanalysis.id,cardtype,thematicanalysis.id";
    private static final String CACHE_ALLCARDCONFIG = "cache_allCardConfig";
    private static final String IFDESIGNMODE = "ifDesignMode";
    private static final String LEFTSIDE = "[";
    private static final String RIGHTSIDE = "]";
    private static final String COMMA = ",";
    private static final String FARCARD = "farcard";
    private static final String CARDSMALLID = "cardid";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(FarCardApphomePlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        Map custParam = this.getView().getFormShowParameter().getOpenStyle().getCustParam();
        if (Objects.nonNull(custParam.get(CARDID))) {
            String ifDesignMode;
            Long cardId = Long.valueOf((String)custParam.get(CARDID));
            QFilter cardQFilter = new QFilter(CARD, "=", (Object)cardId);
            QFilter[] filter = new QFilter[]{cardQFilter};
            boolean exists = QueryServiceHelper.exists((String)"far_moduleandcard", (QFilter[])filter);
            if (exists) {
                QFilter filterData;
                DynamicObject modelObject;
                ModelInfo dynamicObject = null;
                DynamicObject moduleObject = QueryServiceHelper.queryOne((String)"far_moduleandcard", (String)MODULEANDCARDSELECTINFO, (QFilter[])filter);
                String cardType = moduleObject.getString(CARDTYPE);
                Long thematicaAnalysisId = 0L;
                Long searchId = 0L;
                String entityName = "";
                if (Objects.nonNull(cardType) && (CardType.MYANALYSIS.getType().equals(cardType) || CardType.THEMATICANALYSIS.getType().equals(cardType))) {
                    thematicaAnalysisId = CardType.MYANALYSIS.getType().equals(cardType) ? Long.valueOf(moduleObject.getLong(MYANALYSISID)) : Long.valueOf(moduleObject.getLong(THEMATICANALYSISID));
                    searchId = thematicaAnalysisId;
                    entityName = "far_themeanalysis";
                } else {
                    searchId = moduleObject.getLong(MODULEREPOSITORYID);
                    entityName = "fidm_modulerepository";
                }
                if (!StringUtils.isBlank((CharSequence)entityName) && Objects.nonNull(modelObject = QueryServiceHelper.queryOne((String)entityName, (String)"model", (QFilter[])new QFilter[]{filterData = new QFilter("id", "=", (Object)searchId)}))) {
                    Long id = modelObject.getLong("model");
                    dynamicObject = new ModelStrategyEx(id).getModel().getModelInfo();
                }
                if (dynamicObject == null) {
                    dynamicObject = this.getDMModel();
                }
                if (dynamicObject != null) {
                    Long dmModelId = dynamicObject.getId();
                    this.getPageCache().put("dmmodelid", String.valueOf(dmModelId));
                    Long sourceModelId = dynamicObject.getModelId();
                    if (Objects.nonNull(cardType) && (CardType.MYANALYSIS.getType().equals(cardType) || CardType.THEMATICANALYSIS.getType().equals(cardType))) {
                        String permClass = PermClassEntityHelper.getSingleDiscPermission((String)"far_themeanalysis", (Long)thematicaAnalysisId, (Long)dmModelId, (Long)this.getUserId(), (String)"fidmmodel", (String)ApplicationTypeEnum.FAR.getAppnum());
                        if ("1".equals(permClass)) {
                            this.buildErrAndSend();
                        } else {
                            Map<String, Object> themeResult = AnalysisServiceHelper.getDataEditByThemeAnalysis(dmModelId, thematicaAnalysisId);
                            this.sendThemeAnalysisInfo(false, themeResult.get("pageConfig"), themeResult.get("i18n"), themeResult.get("theme"));
                        }
                    } else {
                        Long moduleId = moduleObject.getLong(MODULEREPOSITORYID);
                        String permClass = PermClassEntityHelper.getSingleDiscPermission((String)"fidm_modulerepository", (Long)moduleId, (Long)dmModelId, (Long)this.getUserId(), (String)"fidmmodel", (String)ApplicationTypeEnum.FAR.getAppnum());
                        if ("1".equals(permClass)) {
                            HashMap data = Maps.newHashMapWithExpectedSize((int)1);
                            HashMap error = Maps.newHashMapWithExpectedSize((int)1);
                            error.put("msg", ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u67e5\u770b\u5f53\u524d\u5361\u7247\u3002", (String)"FarCardApphomePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                            data.put("error", error);
                            Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ERROR, data, "");
                            this.SendToVue(result);
                        } else {
                            Map<String, Object> dataInit = AnalysisServiceHelper.getMoudleDataInit(dmModelId, sourceModelId, moduleId);
                            String dagaInit = AnalysisServiceHelper.previewModuleResult(JSON.toJSONString(dataInit));
                            this.sendAnalysisInfo(dagaInit, CardType.MODULE.getType());
                        }
                    }
                } else {
                    HashMap data = Maps.newHashMapWithExpectedSize((int)1);
                    HashMap error = Maps.newHashMapWithExpectedSize((int)1);
                    error.put("msg", ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"FarCardApphomePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    data.put("error", error);
                    Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ERROR, data, "");
                    this.SendToVue(result);
                }
            } else if (Objects.nonNull(custParam.get(IFDESIGNMODE)) && "1".equals(ifDesignMode = (String)custParam.get(IFDESIGNMODE))) {
                this.showPublishCardContent(cardId);
            }
        }
    }

    private void showPublishCardContent(Long cardId) {
        LocaleString cardTitle;
        Map allCardConfigMap;
        String cardInfo;
        String allCardConfigStr;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("far_publishcardcontent");
        parameter.setCustomParam(CARD, (Object)cardId);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        IPageCache parentPageCache = (IPageCache)parentView.getService(IPageCache.class);
        if (parentPageCache != null && StringUtils.isNotEmpty((CharSequence)(allCardConfigStr = parentPageCache.get(CACHE_ALLCARDCONFIG))) && StringUtils.isNotEmpty((CharSequence)(cardInfo = (String)(allCardConfigMap = (Map)SerializationUtils.fromJsonString((String)allCardConfigStr, Map.class)).get(String.valueOf(cardId)))) && Objects.nonNull(cardTitle = this.getLocaleStrFromMapEntryStr(cardInfo))) {
            String cardLocaleTitle = cardTitle.getLocaleValue();
            String caption = String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u7684\u53d1\u5e03\u9996\u9875\u914d\u7f6e\u3002", (String)"FarCardApphomePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), cardLocaleTitle);
            parameter.setCaption(caption);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, LISTCLOSECALLBACK);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }

    private void deleteNotExistCardIdInfo(Long currentCardId) {
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        String farCardCache = parentPageCache.get(FARCARD);
        if (Objects.isNull(farCardCache)) {
            parentPageCache.put(FARCARD, FARCARD);
            DynamicObjectCollection moduleAndCardCollection = QueryServiceHelper.query((String)"far_moduleandcard", (String)"id,card", null);
            if (Objects.nonNull(moduleAndCardCollection) && moduleAndCardCollection.size() > 0) {
                HashMap moduleAndCardInfo = Maps.newHashMapWithExpectedSize((int)moduleAndCardCollection.size());
                HashSet cardList = Sets.newHashSetWithExpectedSize((int)moduleAndCardCollection.size());
                moduleAndCardCollection.forEach(moduleAndCard -> {
                    Long cardId = moduleAndCard.getLong(CARD);
                    moduleAndCardInfo.put(moduleAndCard.getLong("id"), cardId);
                    cardList.add(cardId);
                });
                QFilter cardIdQFilter = new QFilter(CARDSMALLID, "in", (Object)cardList);
                QFilter[] filters = new QFilter[]{cardIdQFilter};
                DynamicObjectCollection pageCardConfigCollection = QueryServiceHelper.query((String)"bos_mainpagecardconfig", (String)CARDSMALLID, (QFilter[])filters);
                if (Objects.nonNull(pageCardConfigCollection) && pageCardConfigCollection.size() > 0) {
                    HashSet existCardIds = Sets.newHashSetWithExpectedSize((int)pageCardConfigCollection.size());
                    pageCardConfigCollection.forEach(pageCardConfig -> {
                        Long existCardId = pageCardConfig.getLong(CARDSMALLID);
                        existCardIds.add(existCardId);
                    });
                    cardList.remove(currentCardId);
                    Boolean isFlag = cardList.removeAll(existCardIds);
                    if (cardList.size() == 0) {
                        return;
                    }
                    HashSet removeIds = Sets.newHashSetWithExpectedSize((int)cardList.size());
                    moduleAndCardInfo.forEach((k, v) -> {
                        if (cardList.contains(v)) {
                            removeIds.add(k);
                        }
                    });
                    try (TXHandle tx = TX.required((String)"FarCardApphomePlugin.deleteNotExistCardIdInfo");){
                        try {
                            if (isFlag.booleanValue()) {
                                MainEntityType iDataEntityType = EntityMetadataCache.getDataEntityType((String)"far_moduleandcard");
                                DeleteServiceHelper.delete((IDataEntityType)iDataEntityType, (Object[])removeIds.toArray());
                            }
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error((Throwable)e);
                            parentPageCache.remove(FARCARD);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (LISTCLOSECALLBACK.equals(e.getActionId())) {
            Map returnMap;
            if (Objects.nonNull(e.getReturnData()) && (returnMap = (Map)e.getReturnData()).get("dmmodel") != null) {
                Long dmModelId = (Long)returnMap.get("dmmodel");
                ModelInfo dmmodel = new ModelStrategyEx(dmModelId).getModel().getModelInfo();
                Long sourceModelId = dmmodel.getModelId();
                for (Map.Entry entry : returnMap.entrySet()) {
                    String cardType = (String)entry.getKey();
                    Long carId = (Long)entry.getValue();
                    if (CardType.MODULE.getType().equals(cardType)) {
                        Map<String, Object> dataInit = AnalysisServiceHelper.getMoudleDataInit(dmModelId, sourceModelId, carId);
                        String dagaInit = AnalysisServiceHelper.previewModuleResult(JSON.toJSONString(dataInit));
                        this.sendAnalysisInfo(dagaInit, CardType.MODULE.getType());
                        continue;
                    }
                    if (!CardType.MYANALYSIS.getType().equals(cardType) && !CardType.THEMATICANALYSIS.getType().equals(cardType)) continue;
                    Map<String, Object> themeResult = AnalysisServiceHelper.getDataEditByThemeAnalysis(dmModelId, carId);
                    this.sendThemeAnalysisInfo(false, themeResult.get("pageConfig"), themeResult.get("i18n"), themeResult.get("theme"));
                }
                this.deleteNotExistCardIdInfo((Long)returnMap.get(CARDSMALLID));
            }
        } else if ("far_preview_config".equals(e.getActionId()) && Objects.nonNull(e.getReturnData())) {
            Map returnInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)String.valueOf(e.getReturnData()));
            String previewSource = (String)returnInfo.get("previewsource");
            String previewResult = (String)returnInfo.get("previewresult");
            if (DynamicControlSourceEnum.ICONPARAMETERS.getSourceName().equals(previewSource)) {
                if (Objects.isNull(previewResult)) {
                    return;
                }
                JSONObject jsonObject = JSON.parseObject((String)previewResult);
                JSONObject data = new JSONObject(2);
                JSONObject item = jsonObject.getJSONObject("item");
                data.fluentPut("item", (Object)item);
                Object result = AnalysisDesignHelper.paramPreviewResult(false, data, jsonObject.getJSONObject("pageConfig"), jsonObject.getJSONObject("queryConfig"), jsonObject.getJSONObject("i18n"), jsonObject.getString("primaryKey"));
                this.SendToVue(result);
            } else {
                this.previewWithNoDeSerialized(previewResult, false);
            }
        }
    }

    private void sendThemeAnalysisInfo(boolean isDesignMode, Object pageConfig, Object ii18n, Object theme) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.DATA_HOME_INIT);
        dataObj.put("designMode", (Object)false);
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("i18n", ii18n);
        dataObj.put("theme", theme);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("isThematicAnalysis", (Object)true);
        AnalysisDesignHelper.buildThemePreviewParams(dataObj);
        this.SendToVue(dataObj);
    }

    private void sendAnalysisInfo(String dataInit, String cardType) {
        JSONObject jsonObject = JSON.parseObject((String)dataInit);
        JSONObject pageConifg = jsonObject.getJSONObject("pageConfig");
        JSONObject I18N = jsonObject.getJSONObject("i18n");
        JSONArray itemList = jsonObject.getJSONArray("itemList");
        JSONObject queryConfig = jsonObject.getJSONObject("queryConfig");
        Object result = this.finalData(false, itemList, pageConifg, queryConfig, I18N, cardType);
        this.SendToVue(result);
    }

    private Object finalData(boolean isDesignMode, Object itemList, Object pageConfig, Object queryConfig, Object ii18n, String type) {
        JSONObject dataObj = new JSONObject();
        if (CardType.MODULE.getType().equals(type) && itemList instanceof JSONArray) {
            JSONObject pageConfigJo = (JSONObject)pageConfig;
            pageConfigJo.put("cardType", (Object)type);
        }
        dataObj.put("dataType", (Object)AnalysisDesignConstants.PropsDataType.DATA_HOME_INIT);
        dataObj.put("designMode", (Object)isDesignMode);
        dataObj.put("pageConfig", pageConfig);
        dataObj.put("queryConfig", queryConfig);
        dataObj.put("i18n", ii18n);
        dataObj.put("itemList", itemList);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("isThematicAnalysis", (Object)false);
        return dataObj;
    }

    private LocaleString getLocaleStrFromMapEntryStr(String mapEntryStr) {
        if (kd.bos.util.StringUtils.isEmpty((String)mapEntryStr)) {
            return null;
        }
        LocaleString localeString = this.getLocaleStringValue(mapEntryStr);
        return localeString;
    }

    private LocaleString getLocaleStringValue(String mapEntryStr) {
        int leftStartIdx = mapEntryStr.indexOf(LEFTSIDE);
        int rightStartIdx = mapEntryStr.indexOf(RIGHTSIDE);
        if (leftStartIdx != -1 && rightStartIdx != -1) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            String entryContentStr = mapEntryStr.substring(leftStartIdx + 1, rightStartIdx);
            if (kd.bos.util.StringUtils.isEmpty((String)entryContentStr)) {
                return null;
            }
            String[] entryMapArr = entryContentStr.split(COMMA);
            for (int i = 0; i < entryMapArr.length; ++i) {
                String[] keyValueArr;
                if (kd.bos.util.StringUtils.isEmpty((String)entryMapArr[i]) || (keyValueArr = entryMapArr[i].split("=")) == null || keyValueArr.length == 1) continue;
                map.put(keyValueArr[0].trim(), entryMapArr[i].substring(keyValueArr[0].length() + 1).trim());
            }
            LocaleString localeString = LocaleString.fromMap((Map)map);
            return localeString;
        }
        return null;
    }

    private void buildErrAndSend() {
        HashMap data = Maps.newHashMapWithExpectedSize((int)1);
        HashMap error = Maps.newHashMapWithExpectedSize((int)1);
        error.put("msg", ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u67e5\u770b\u5f53\u524d\u5361\u7247\u3002", (String)"FarCardApphomePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        data.put("error", error);
        Object result = AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_ERROR, data, "");
        this.SendToVue(result);
    }
}

