/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.apphome;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.far.enums.CardType;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.util.ModelUtil;
import org.apache.commons.collections.CollectionUtils;

public class FarPublishContentPlugin
extends AbstractBaseDMListPlugin {
    private static final String BILLLISTAP = "billlistap";
    private static final String MYANALYSISBILLLIST = "myanalysisbilllist";
    private static final String BEFORESTEP = "beforestep";
    private static final String CONFIRM = "confirm";
    private static final String MYANALYSIS = "myanalysis";
    private static final String MYANALYSISIMG = "myanalysisimg";
    private static final String MODULEANALYSIS = "moduleanalysis";
    private static final String MODULEANALYSISIMG = "moduleanalysisimg";
    private static final String THEMEANALYSIS = "themeanalysis";
    private static final String THEMEANALYSISIMG = "themeanalysisimg";
    private static final String CARD = "card";
    private static final String CARDTYPE = "cardtype";
    private static final String MODULEREPOSITORY = "modulerepository";
    private static final String HOMETYPE = "hometype";
    private static final String PUBLISHCONTENT = "publishcontent";
    private static final String TABAP = "tabap";
    private static final String APPLYTYPE = "applytype";
    private static final String ANALYSISTYPE = "16";
    private static final String CONTENTTYPE = "contenttype";
    private static final String FARAPPID = "2K++OWYYMS5J";
    private static final String CONFIRMITEMID = "0=KX5+QVF5+R";
    private static final String THEMATICANALYSIS = "thematicanalysis";
    private static final List<String> CONFIRMLIST = Lists.newArrayList((Object[])new String[]{"myanalysis", "moduleanalysis"});

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean hasViewPermission = PermissionServiceHelper.checkPermission((Long)this.getUserId(), (String)FARAPPID, (String)"far_publishcardcontent", (String)"47150e89000000ac");
        if (!hasViewPermission) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u67e5\u770b\u5f53\u524d\u5361\u7247\u3002", (String)"FarCardApphomePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (Objects.nonNull(basedataEdit)) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addBeforePackageDataListener(this::setCatalogText);
        this.addClickListeners(BEFORESTEP, CONFIRM, MYANALYSISIMG, THEMEANALYSISIMG, MODULEANALYSISIMG, MYANALYSIS, THEMEANALYSIS, MODULEANALYSIS);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && StringUtils.isNotEmpty((String)this.getModelSign()) && Objects.nonNull(this.getControl(this.getModelSign()))) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (Objects.isNull(qFilterList)) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)16);
            }
            qFilterList.addAll(ModelUtil.getFarPubModelFilter(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long dmModelId = this.getDMModelId();
        this.getModel().setValue("dmmodel", (Object)dmModelId);
        this.getView().setVisible(Boolean.FALSE, new String[]{MYANALYSISBILLLIST, BILLLISTAP});
    }

    @Override
    public String getModelSign() {
        return "dmmodel";
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey().toLowerCase();
        DynamicObject dmModel = (DynamicObject)this.getModel().getValue("dmmodel");
        Long dmModelId = 0L;
        if (Objects.nonNull(dmModel)) {
            dmModelId = dmModel.getLong("id");
        }
        ModelInfo dmmodel = new ModelStrategyEx(dmModelId).getModel().getModelInfo();
        switch (key) {
            case "confirm": {
                boolean hasViewPermission = PermissionServiceHelper.checkPermission((Long)this.getUserId(), (String)FARAPPID, (String)"far_publishcardcontent", (String)CONFIRMITEMID);
                if (hasViewPermission) {
                    this.chooseSelectModule();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u53d1\u5e03\u9996\u9875\u5361\u7247\u201d\u7684\u4fdd\u5b58\u6743\u9650\u3002", (String)"FarPublishContentPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
            case "moduleanalysisimg": 
            case "moduleanalysis": {
                if (!Objects.nonNull(dmmodel)) break;
                Long modeId = dmmodel.getModelId();
                this.doCheckPermission("fidm_modulerepositorylist", "47150e89000000ac", modeId, FARAPPID);
                this.goToModuleAnalysis(key, dmModelId);
                break;
            }
            case "myanalysisimg": 
            case "myanalysis": {
                if (!Objects.nonNull(dmmodel)) break;
                Long modeId = dmmodel.getModelId();
                this.doCheckPermission("far_themeanalysis", "47150e89000000ac", modeId, FARAPPID);
                this.goToThematicAnalysis(key, dmModelId);
                break;
            }
            case "beforestep": {
                this.goToBeforeStep(key);
                break;
            }
        }
    }

    private void goToBeforeStep(String key) {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        if (BEFORESTEP.equals(key)) {
            tab.activeTab(HOMETYPE);
        }
    }

    private void goToThematicAnalysis(String key, Long dmModelId) {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        if (MYANALYSISIMG.equals(key) || MYANALYSIS.equals(key)) {
            tab.activeTab(PUBLISHCONTENT);
            this.setThematicAnalysisListFilter(dmModelId);
            this.getPageCache().put(CONTENTTYPE, MYANALYSIS);
            this.getView().setVisible(Boolean.FALSE, new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{MYANALYSISBILLLIST});
        }
    }

    private void goToModuleAnalysis(String key, Long dmModelId) {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        if (MODULEANALYSISIMG.equals(key) || MODULEANALYSIS.equals(key)) {
            tab.activeTab(PUBLISHCONTENT);
            this.setModuleListFilter(dmModelId);
            this.getPageCache().put(CONTENTTYPE, MODULEANALYSIS);
            this.getView().setVisible(Boolean.TRUE, new String[]{BILLLISTAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{MYANALYSISBILLLIST});
        }
    }

    public void setFilter(SetFilterEvent e) {
        DynamicObject dmModel;
        super.setFilter(e);
        String contentType = this.getPageCache().get(CONTENTTYPE);
        if (MYANALYSIS.equals(contentType) && Objects.nonNull(dmModel = (DynamicObject)this.getModel().getValue("dmmodel"))) {
            Long dmModelId = dmModel.getLong("id");
            QFilter filter = new QFilter("model", "=", (Object)dmModelId);
            e.setCustomQFilters(Collections.singletonList(filter));
        }
    }

    private void setMyAnalysisListFilter(Long dmModelId) {
        if (dmModelId != 0L) {
            FilterParameter filterParameter = new FilterParameter();
            QFilter filter = new QFilter("model", "=", (Object)dmModelId);
            List list = PermClassEntityHelper.getFARPermissionMap((String)"far_myanalysis", (Long)dmModelId, (Long)RequestContext.get().getCurrUserId()).get((Object)"1");
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                filter.and(new QFilter("id", "not in", (Object)list));
            }
            filterParameter.setFilter(filter);
            BillList billList = (BillList)this.getView().getControl(MYANALYSISBILLLIST);
            billList.setFilterParameter(filterParameter);
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void setThematicAnalysisListFilter(Long dmModelId) {
        if (dmModelId != 0L) {
            FilterParameter filterParameter = new FilterParameter();
            QFilter filter = new QFilter("model", "=", (Object)dmModelId);
            List list = PermClassEntityHelper.getFARPermissionMap((String)"far_themeanalysis", (Long)dmModelId, (Long)RequestContext.get().getCurrUserId()).get((Object)"1");
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                filter.and(new QFilter("id", "not in", (Object)list));
            }
            filterParameter.setFilter(filter);
            BillList billList = (BillList)this.getView().getControl(MYANALYSISBILLLIST);
            billList.setFilterParameter(filterParameter);
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void setModuleListFilter(Long dmModelId) {
        if (dmModelId != 0L) {
            FilterParameter filterParameter = new FilterParameter();
            QFilter filter = new QFilter("model", "=", (Object)dmModelId);
            HashSet noPermIds = Sets.newHashSetWithExpectedSize((int)16);
            this.addNoPermIds(dmModelId, noPermIds);
            if (CollectionUtils.isNotEmpty((Collection)noPermIds)) {
                filter.and(new QFilter("id", "not in", (Object)noPermIds));
            }
            QFilter applyTypeFilter = new QFilter(APPLYTYPE, ">=", (Object)ANALYSISTYPE);
            filterParameter.setFilter(filter.and(applyTypeFilter));
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.setFilterParameter(filterParameter);
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void addNoPermIds(Long dmModelId, Set<Long> noPermIds) {
        List far = PermClassEntityHelper.getFARPermissionMap((String)"fidm_modulerepository", (Long)dmModelId, (Long)RequestContext.get().getCurrUserId()).get((Object)"1");
        if (CollectionUtils.isNotEmpty((Collection)far)) {
            noPermIds.addAll(far);
        }
    }

    private void chooseSelectModule() {
        String contentType = this.getPageCache().get(CONTENTTYPE);
        if (!CONFIRMLIST.contains(contentType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u5584\u201c\u53d1\u5e03\u5230\u9996\u9875\u914d\u7f6e\u201d\u3002", (String)"FarPublishContentPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dmModel = (DynamicObject)this.getModel().getValue("dmmodel");
        Long dmModelId = 0L;
        if (Objects.nonNull(dmModel)) {
            dmModelId = dmModel.getLong("id");
        }
        if (MYANALYSIS.equals(contentType)) {
            this.returnThematicAnalysisInfo(dmModelId);
        } else if (MODULEANALYSIS.equals(contentType)) {
            this.returnModuleListInfo(dmModelId);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("dmmodel".equals(propertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
                return;
            }
            if (Objects.isNull(newValue)) {
                return;
            }
            String contentType = this.getPageCache().get(CONTENTTYPE);
            if (Objects.isNull(contentType)) {
                return;
            }
            Long newDmModelId = (Long)newValue.getPkValue();
            if (MYANALYSIS.equals(contentType)) {
                this.setMyAnalysisListFilter(newDmModelId);
            } else if (MODULEANALYSIS.equals(contentType)) {
                this.setModuleListFilter(newDmModelId);
            }
        }
    }

    private void returnModuleListInfo(Long dmModeId) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed1\u5b9a\u7684\u7ec4\u4ef6\u6570\u636e\u3002", (String)"FarPublishContentPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long moduleId = (Long)listSelectedRow.getPrimaryKeyValue();
        Long cardId = (Long)this.getView().getFormShowParameter().getCustomParam(CARD);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"far_moduleandcard");
        QFilter cardQFilter = new QFilter(CARD, "=", (Object)cardId);
        QFilter moduleFilter = new QFilter(MODULEREPOSITORY, "=", (Object)moduleId);
        QFilter[] filters = new QFilter[]{cardQFilter, moduleFilter};
        boolean exists = QueryServiceHelper.exists((String)"far_moduleandcard", (QFilter[])filters);
        if (!exists) {
            dynamicObject.set(MODULEREPOSITORY, (Object)moduleId);
            dynamicObject.set(CARD, (Object)cardId);
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set(CARDTYPE, (Object)CardType.MODULE.getType());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)1);
        returnMap.put(CardType.MODULE.getType(), moduleId);
        returnMap.put("dmmodel", dmModeId);
        returnMap.put("cardid", cardId);
        this.getView().returnDataToParent((Object)returnMap);
        this.getView().close();
    }

    private void returnThematicAnalysisInfo(Long dmModeId) {
        BillList billList = (BillList)this.getView().getControl(MYANALYSISBILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed1\u5b9a\u7684\u5206\u6790\u6570\u636e\u3002", (String)"FarPublishContentPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Long thematicaAnalysisId = (Long)listSelectedRow.getPrimaryKeyValue();
        Long cardId = (Long)this.getView().getFormShowParameter().getCustomParam(CARD);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"far_moduleandcard");
        QFilter cardQFilter = new QFilter(CARD, "=", (Object)cardId);
        QFilter moduleFilter = new QFilter(MODULEREPOSITORY, "=", (Object)thematicaAnalysisId);
        QFilter[] filters = new QFilter[]{cardQFilter, moduleFilter};
        boolean exists = QueryServiceHelper.exists((String)"far_moduleandcard", (QFilter[])filters);
        if (!exists) {
            dynamicObject.set(THEMATICANALYSIS, (Object)thematicaAnalysisId);
            dynamicObject.set(CARD, (Object)cardId);
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set(CARDTYPE, (Object)CardType.THEMATICANALYSIS.getType());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)1);
        returnMap.put(CardType.THEMATICANALYSIS.getType(), thematicaAnalysisId);
        returnMap.put("dmmodel", dmModeId);
        returnMap.put("cardid", cardId);
        this.getView().returnDataToParent((Object)returnMap);
        this.getView().close();
    }

    private void setCatalogText(BeforePackageDataEvent e) {
        for (DynamicObject object : e.getPageData()) {
            object.set(APPLYTYPE, (Object)ModuleServiceHelper.getDisplayApplyType((String)object.getString(APPLYTYPE)));
        }
    }

    private void writeOpLogComponent(OperationResult result, OperationName opName, ListSelectedRow selectedRow) {
        String templateNumber = selectedRow != null ? selectedRow.getNumber() : "";
        String templateName = selectedRow != null ? selectedRow.getName() : "";
        super.writeOpLog(OperationCategory.HOME, opName, result, "far_publishcardcontent", templateNumber, templateName);
    }

    private void writeOpLogMyAnalysis(OperationResult result, OperationName opName, ListSelectedRow selectedRow) {
        String templateNumber = selectedRow != null ? selectedRow.getNumber() : "";
        String templateName = selectedRow != null ? selectedRow.getName() : "";
        super.writeOpLog(OperationCategory.HOME, opName, result, "far_publishcardcontent", templateNumber, templateName);
    }

    private void writeOpLog(OperationResult result, OperationName opName, ListSelectedRow selectedRow) {
        String templateNumber = selectedRow != null ? selectedRow.getNumber() : "";
        String templateName = selectedRow != null ? selectedRow.getName() : "";
        super.writeOpLog(OperationCategory.HOME, opName, result, "far_publishcardcontent", templateNumber, templateName);
    }
}

