/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.baseinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class AnalysisTemplateInfoPlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener {
    private static final String CATALOG = "catalog";
    private static final String PERMCLASS = "permclass";
    private static final String ANALYSIS_ID = "analysis_id";
    private static final String btn_save = "btnok";
    private static final String SELECT_FIELDS = "number,name,templatecatalog,permclass,description,model";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TEMPLATECATALOG = "templatecatalog";
    private static final String DESCRIPTION = "description";
    private static final String FIDMMODEL = "fidmmodel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_save);
        BasedataEdit catalog = (BasedataEdit)this.getControl(CATALOG);
        catalog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERMCLASS)), (Object)modelId, (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initAnalysisBaseInfo();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "catalog": {
                this.setCatalogQfilter(evt);
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (btn_save.equals(key)) {
            String permMsg = this.checkAnalysisTemplatePerm();
            if (!StringUtils.isEmpty((CharSequence)permMsg)) {
                this.getView().showTipNotification(permMsg);
                return;
            }
            Object catalog = this.getModel().getValue(CATALOG);
            if (Objects.isNull(catalog) || StringUtils.isEmpty((CharSequence)catalog.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AnalysisTemplateInfoPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            Long analysis_id = (Long)this.getView().getFormShowParameter().getCustomParam(ANALYSIS_ID);
            DynamicObject dns = BusinessDataServiceHelper.loadSingle((Object)analysis_id, (String)"fidm_template", (String)SELECT_FIELDS);
            Object number = this.getModel().getValue(NUMBER);
            if (number == null || StringUtils.isEmpty((CharSequence)String.valueOf(number))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleReportityBakPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter(NUMBER, "=", (Object)String.valueOf(number));
            filter.and("id", "!=", (Object)analysis_id);
            filter.and("model", "=", (Object)dns.getLong("model.id"));
            boolean existRepeatNumber = QueryServiceHelper.exists((String)"fidm_template", (QFilter[])new QFilter[]{filter});
            if (existRepeatNumber) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"ModuleReportityBakPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            Object name = this.getModel().getValue(NAME);
            if (name == null || StringUtils.isEmpty((CharSequence)String.valueOf(name))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleReportityBakPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkAnalysisNumber(String.valueOf(number))) {
                return;
            }
            try {
                this.saveAnalysisBaseInfo(dns, number);
                this.writeOpLog(OperationResult.SUCCESS, dns);
            }
            catch (Exception e) {
                this.writeOpLog(OperationResult.FAILURE, dns);
                throw e;
            }
            this.getView().close();
        }
    }

    private void initAnalysisBaseInfo() {
        Long analysis_id = (Long)this.getView().getFormShowParameter().getCustomParam(ANALYSIS_ID);
        DynamicObject dns = BusinessDataServiceHelper.loadSingle((Object)analysis_id, (String)"fidm_template", (String)SELECT_FIELDS);
        Object number = dns.get(NUMBER);
        Object name = dns.get(NAME);
        Object description = dns.get(DESCRIPTION);
        Object templatecatalog = dns.get(TEMPLATECATALOG);
        Long modelId = dns.getDynamicObject("model").getLong("id");
        DynamicObject permClassEntity = PermClassEntityHelper.getDiscPermissionClassEntity((String)"fidm_template", (Long)analysis_id, (Object)modelId, (String)FIDMMODEL, (String)ApplicationTypeEnum.FAR.getAppnum());
        if (permClassEntity != null) {
            Long permClassId = permClassEntity.getLong("permclass.id");
            this.getModel().setValue(PERMCLASS, (Object)permClassId);
        }
        this.getModel().setValue(NUMBER, number);
        this.getModel().setValue(NAME, name);
        this.getModel().setValue(CATALOG, templatecatalog);
        this.getModel().setValue(DESCRIPTION, description);
    }

    private void saveAnalysisBaseInfo(DynamicObject dns, Object number) {
        Object name = this.getModel().getValue(NAME);
        Object catalog = this.getModel().getValue(CATALOG);
        Object description = this.getModel().getValue(DESCRIPTION);
        Long modelId = dns.getLong("model.id");
        dns.set(NUMBER, number);
        dns.set(NAME, name);
        dns.set(TEMPLATECATALOG, catalog);
        dns.set(DESCRIPTION, description);
        SaveServiceHelper.save((IDataEntityType)dns.getDynamicObjectType(), (Object[])new Object[]{dns});
        PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)"fidm_template", (Long)dns.getLong("id"), (Object)modelId, (OperationStatus)OperationStatus.EDIT, (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
        this.returnDataToParent("Successful");
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("model", "=", (Object)this.getDMModelId());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        if (AppCatalogTypeEnum.FAR_CATALOG.getAppId().equals(this.getBizAppId())) {
            qFilter.and("catalogtype", "in", Arrays.asList("0", "2"));
        } else {
            qFilter.and("catalogtype", "in", Arrays.asList("0", "1"));
        }
        fsp.getListFilterParameter().getQFilters().add(qFilter);
        fsp.getTreeFilterParameter().setQFilters(qFilters);
    }

    private boolean checkAnalysisNumber(String number) {
        Matcher matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9.]+$").matcher(number);
        if (!matcherNumber.matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DiscTemplateEditPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void writeOpLog(OperationResult result, DynamicObject template) {
        String templateNumber = template != null ? template.getString(NUMBER) : "";
        super.writeOpLog(OperationCategory.ANALYSIS_DESIGN, OperationName.EDIT_BASEINFO, result, "far_analysisdesign", this.getDMModelId(), templateNumber);
    }
}

