/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.design;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.util.DownFileUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;

public class AnalysisDesignExportPlugin {
    private long modelId;
    private long templateId;
    private long chapterId;

    public AnalysisDesignExportPlugin(long modelId, long templateId) {
        this.modelId = modelId;
        this.templateId = templateId;
        this.chapterId = AnalysisServiceHelper.getDefaultChapterId(modelId, templateId);
    }

    public String exportTemplate() throws IOException {
        JSONObject exportJson = new JSONObject();
        JSONObject templateInfo = this.getTemplateInfo();
        String templateNum = templateInfo.getString("number");
        String fileNamePrefix = String.format(ResManager.loadKDString((String)"%s_\u5206\u6790\u770b\u677f_", (String)"AnalysisDesignExportPlugin_01", (String)"epm-far-formplugin", (Object[])new Object[0]), templateNum);
        exportJson.put("templateInfo", (Object)templateInfo);
        exportJson.put("chapterVariable", (Object)this.getChapterVariable());
        exportJson.put("itemInfo", this.getItemList());
        exportJson.put("boardDataset", (Object)this.getDatasetInfo());
        exportJson.put("templateVersion", (Object)"2024/05/19");
        String exportString = ObjectSerialUtil.toByteSerialized((Object)exportJson.toJSONString());
        String fileName = this.getFileName(fileNamePrefix);
        return this.createJsonFile(exportString, fileName);
    }

    private Map<String, Object> getItemList() {
        Map<String, Object> dataInit = AnalysisServiceHelper.getDataInit(this.modelId, this.modelId, this.chapterId, false);
        List itemList = (List)dataInit.get("itemList");
        for (Object o : itemList) {
            JSONObject item = (JSONObject)o;
            JSONObject dataSet = item.getJSONObject("dataset");
            if (!Objects.nonNull(dataSet) || dataSet.isEmpty() || !StringUtils.isEmpty((CharSequence)dataSet.getString("id"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u770b\u677f\u5b58\u5728\u6ca1\u6709\u9009\u62e9\u6570\u636e\u96c6\u7684\u7ec4\u4ef6\uff0c\u8bf7\u5148\u7f16\u8f91\u518d\u5bfc\u51fa\u3002", (String)"AnalysisDesignExportPlugin_02", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return dataInit;
    }

    private JSONObject getTemplateInfo() {
        QFilter filter = new QFilter("id", "=", (Object)this.templateId);
        DynamicObject template = QueryServiceHelper.queryOne((String)"fidm_template", (String)"number,name", (QFilter[])new QFilter[]{filter});
        JSONObject jsonObject = new JSONObject();
        jsonObject.fluentPut("number", (Object)template.getString("number"));
        jsonObject.fluentPut("name", (Object)template.getString("name"));
        return jsonObject;
    }

    private JSONArray getChapterVariable() {
        DynamicObject[] variableList = VariableService.queryChapterVariablesWithoutDimension((Long)this.chapterId);
        JSONArray variableJson = new JSONArray();
        for (DynamicObject var : variableList) {
            variableJson.add((Object)ObjectSerialUtil.toSerializedToDynaObj((DynamicObject)var));
        }
        return variableJson;
    }

    private JSONObject getDatasetInfo() {
        List localDatasetList = DatasetServiceHelper.getChapterTreeList((Long)this.modelId, (Long)this.chapterId, (String)ApplicationTypeEnum.FAR.getAppnum());
        JSONObject jsonObject = new JSONObject();
        JSONArray singleDataset = new JSONArray();
        JSONArray multiRowDataset = new JSONArray();
        JSONArray multiValueDataset = new JSONArray();
        JSONObject getDatasetBindVariableInfo = new JSONObject();
        JSONObject getDatasetBindSourceModel = new JSONObject();
        jsonObject.fluentPut("singleDataset", (Object)singleDataset).fluentPut("multiRowDataset", (Object)multiRowDataset).fluentPut("multiValueDataset", (Object)multiValueDataset).fluentPut("getDatasetBindVariableInfo", (Object)getDatasetBindVariableInfo).fluentPut("getDatasetBindSourceModel", (Object)getDatasetBindSourceModel);
        for (Map localDataset : localDatasetList) {
            String datasetType = (String)localDataset.get("parentid");
            Long datasetId = Long.parseLong((String)localDataset.get("id"));
            if (DataSetTypeEnum.MULTIPLE_VALUED.getType().equals(datasetType)) {
                Collection multiDatasets = DatasetDataReader.getMultiDataSetValues((QFilter[])new QFBuilder("dataset.id", "=", (Object)datasetId).toArray());
                List multiValues = multiDatasets.stream().map(ObjectSerialUtil::toSerializedToDynaObj).collect(Collectors.toList());
                multiValueDataset.add(multiValues);
                continue;
            }
            DynamicObject sgDataset = DatasetDataReader.getSingleDS((Long)datasetId);
            DynamicObject dataset = DatasetDataReader.getDataSet((Long)sgDataset.getLong("dataset.id"));
            sgDataset.set("dataset", (Object)dataset);
            String oneDataset = ObjectSerialUtil.toSerializedToDynaObj((DynamicObject)sgDataset);
            if (DataSrcTypeEnum.EB_MODEL.getType().equals(sgDataset.get("datasrctype"))) continue;
            JSONObject modelInfo = new JSONObject(4);
            getDatasetBindSourceModel.put(sgDataset.getString("dataset.number"), (Object)modelInfo);
            if (!DataSrcTypeEnum.CURRENT_MODEL.getType().equals(sgDataset.get("datasrctype"))) {
                Long sourceModelId = sgDataset.getLong("datasrcid");
                ModelStrategyEx modelStrategyEx = new ModelStrategyEx(sourceModelId);
                modelInfo.put("modelNumber", (Object)modelStrategyEx.getModel().getModelInfo().getNumber());
                modelInfo.put("modelType", (Object)modelStrategyEx.getModel().getModelInfo().getModelType());
            }
            if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(datasetType)) {
                singleDataset.add((Object)oneDataset);
            } else {
                multiRowDataset.add((Object)oneDataset);
                if (Objects.nonNull(sgDataset.get("extendsmodelnumber"))) {
                    modelInfo.put("extendsModelNumber", sgDataset.get("extendsmodelnumber"));
                }
            }
            Collection datasetBindVariable = DatasetDataReader.getDataSetVars((QFilter[])new QFBuilder("dataset.id", "=", (Object)datasetId).toArray());
            JSONArray variables = new JSONArray();
            getDatasetBindVariableInfo.put(sgDataset.getString("dataset.number"), (Object)variables);
            for (DynamicObject dy : datasetBindVariable) {
                JSONObject variableInfo = new JSONObject();
                DynamicObject variable = BusinessDataServiceHelper.loadSingleFromCache((Object)dy.getLong("variable.id"), (String)"fidm_disc_variable");
                variableInfo.fluentPut("variable.number", (Object)variable.getString("number")).fluentPut("variable.scope", (Object)variable.getString("scope"));
                variables.add((Object)variableInfo);
            }
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createJsonFile(String jsonString, String fileName) throws IOException {
        try (ByteArrayInputStream inStream = null;){
            inStream = new ByteArrayInputStream(jsonString.getBytes(Charset.forName("UTF-8")));
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            DownFileUtil.authorizedDownLoadFileUrl4Far((String)url, (String)"far_analysis_list", (String)"44ETG5XKVRY9");
            String string = url;
            return string;
        }
    }

    private String getFileName(String filename) {
        String fileName = filename;
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()) + ".json";
        return fileName;
    }
}

