/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.design;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.dto.DatasetCheckExpParam;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.far.enums.TemplateImportObjectEnum;
import kd.epm.far.common.common.FiBcmErrorCode;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisSingleF7ServiceHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisVariableHelper;
import org.apache.commons.io.IOUtils;

public class AnalysisDesignImportPlugin
extends AbstractBaseDMFormPlugin
implements UploadListener {
    private static final String BTNOK = "btnok";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String CACHEKEY_FILE_TYPE = "file_type";
    private static final String CACHEKEY_FILE_URL = "file_url";
    private DynamicObject currentModel;
    private DynamicObject template;
    private DynamicObject defaultChapter;
    private DatasetDimService fidmDimService = new DatasetDimService();
    private List<DynamicObject> variableList;
    private Map<String, Object> variableNumToDefault;
    private List<DynamicObject> logDyList;
    private List<DynamicObject> singleDatasetDyList;
    private List<DynamicObject> multiValueDatasetDyList;
    private List<DynamicObject> datasetDyList;
    private List<DynamicObject> itemDyList;
    private List<DynamicObject> datasetToVariable;
    private Map<String, DynamicObject> datasetNumToNewDataset;
    private Map<String, DynamicObject> datasetNumToNewSingleDS;

    @Override
    public void initialize() {
        super.initialize();
        Long modelId = (Long)this.getFormCustomParam("dmmodelid");
        this.currentModel = DatasetDataReader.getModel((Long)modelId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK);
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        attach.addUploadListener((UploadListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        if (StringUtils.isNotEmpty((String)key) && key.equals(BTNOK)) {
            Long modelId = (Long)this.getFormCustomParam("dmmodelid");
            this.currentModel = DatasetDataReader.getModel((Long)modelId);
            String number = (String)this.getModel().getValue("number");
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            ResultInfo resultInfo = FarNumberRule.checkChapterNumber((String)number);
            if (!resultInfo.isSuccess().booleanValue()) {
                this.getView().showErrorNotification(resultInfo.getMessage());
                return;
            }
            if (StringUtils.isBlank((String)number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisDesignImportPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            if (Objects.isNull(name) || name.isEmpty() || name.getLocaleValue().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisDesignImportPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject sameNumberTemplate = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id", (QFilter[])new QFBuilder("number", "=", (Object)number).add("model", "=", (Object)this.currentModel.getLong("id")).toArray());
            if (Objects.nonNull(sameNumberTemplate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"AnalysisDesignImportPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String file_url = this.getPageCache().get(CACHEKEY_FILE_URL);
                if (file_url == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e\u3002", (String)"AnalysisDesignImportPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                String[] reqParams = new URL(file_url).getQuery().split("&");
                HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                InputStream inputStream = content.getInputStream();
                this.logDyList = Lists.newArrayListWithCapacity((int)10);
                this.singleDatasetDyList = Lists.newArrayListWithCapacity((int)10);
                this.multiValueDatasetDyList = Lists.newArrayListWithCapacity((int)10);
                this.datasetDyList = Lists.newArrayListWithCapacity((int)10);
                this.datasetToVariable = Lists.newArrayListWithCapacity((int)10);
                this.itemDyList = Lists.newArrayListWithCapacity((int)10);
                try {
                    String jsonString = this.getStringFromInputStream(inputStream);
                    jsonString = (String)ObjectSerialUtil.deSerializedBytes((String)jsonString);
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
                    this.initBoardInfo();
                    this.importChapterVariable(jsonObject);
                    this.importBoardDataset(jsonObject);
                    this.importItemModule(jsonObject);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bfb\u53d6\u5f02\u5e38\uff0c\u6587\u4ef6\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AnalysisDesignImportPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                finally {
                    this.writeDetailImportLog();
                }
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
                throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.importFailed"), new Object[]{e.getMessage()});
            }
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    this.saveToDB();
                    this.writeDetailImportLog();
                }
                catch (Exception e) {
                    txHandle.markRollback();
                }
            }
            this.returnDataToParent("okkk");
            this.getView().close();
        }
    }

    private void saveToDB() {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.template});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.defaultChapter});
        SaveServiceHelper.save((DynamicObject[])this.variableList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])this.datasetDyList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])this.singleDatasetDyList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])this.multiValueDatasetDyList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])this.datasetToVariable.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])this.itemDyList.toArray(new DynamicObject[0]));
    }

    private void initBoardInfo() {
        this.template = BusinessDataServiceHelper.newDynamicObject((String)"fidm_template");
        long templateId = GlobalIdUtil.genGlobalLongId();
        this.template.set("id", (Object)templateId);
        this.template.set("number", this.getModel().getValue("number"));
        this.template.set("name", this.getModel().getValue("name"));
        this.template.set("templatecatalog", this.getFormCustomParam("templateCatalogId"));
        this.template.set("model", (Object)this.currentModel);
        this.template.set("status", (Object)"0");
        this.template.set("creator", (Object)RequestContext.get().getCurrUserId());
        this.defaultChapter = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chapter");
        long chapterId = GlobalIdUtil.genGlobalLongId();
        this.defaultChapter.set("id", (Object)chapterId);
        this.defaultChapter.set("model", (Object)this.currentModel);
        this.defaultChapter.set("template", (Object)this.template.getLong("id"));
        this.defaultChapter.set("number", (Object)"DefaultChapter");
        this.defaultChapter.set("name", (Object)"DefaultChapter");
    }

    private void importChapterVariable(JSONObject jsonObject) {
        JSONArray variableArray = jsonObject.getJSONArray("chapterVariable");
        this.variableNumToDefault = Maps.newHashMapWithExpectedSize((int)variableArray.size());
        this.variableList = Lists.newArrayListWithCapacity((int)variableArray.size());
        long[] variableLongs = DBServiceHelper.genLongIds((String)"fidm_disc_variable", (int)variableArray.size());
        for (int i = 0; i < variableArray.size(); ++i) {
            Object o = variableArray.get(i);
            DynamicObject old = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)"fidm_disc_variable", (String)o.toString());
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject variable = (DynamicObject)cloneUtils.clone((IDataEntityBase)old);
            try {
                this.checkVariableValid(variable);
            }
            catch (Exception e) {
                this.addDetailImportLog(TemplateImportObjectEnum.CHAPTER_VARIABLE, variable.getString("number"), variable.getString("name"), e.getMessage(), false);
                continue;
            }
            this.variableList.add(variable);
            this.variableNumToDefault.put(variable.getString("number"), variable.get("defaultvalue"));
            variable.set("id", (Object)variableLongs[i]);
            variable.set("model", (Object)this.currentModel);
            variable.set("chapterid", (Object)this.defaultChapter.getLong("id"));
            DynamicObjectCollection enums = variable.getDynamicObjectCollection("entryentity");
            if (!Objects.nonNull(enums) || enums.size() == 0) continue;
            long[] enumsId = DBServiceHelper.genLongIds((String)"fidm_disc_variable.entryentity", (int)enums.size());
            for (int j = 0; j < enums.size(); ++j) {
                DynamicObject enumItem = (DynamicObject)cloneUtils.clone((IDataEntityBase)enums.get(j));
                enumItem.set("id", (Object)enumsId[j]);
                enumItem.setParent((Object)variable);
            }
        }
    }

    private void checkVariableValid(DynamicObject variable) {
        String valueType = variable.getString("valuetype");
        if (DmVariableTypeEnum.ENUM.getIndex().equals(valueType) && Objects.equals("epm_model", this.currentModel.getDynamicObject("model").getDataEntityType().getName())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u524d\u9884\u7b97\u4f53\u7cfb\u4e0d\u652f\u6301\u679a\u4e3e\u7c7b\u578b\u53d8\u91cf\u3002", (String)"AnalysisDesignImportPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void importBoardDataset(JSONObject jsonObject) {
        JSONObject boardDataset = jsonObject.getJSONObject("boardDataset");
        JSONArray singleDataset = boardDataset.getJSONArray("singleDataset");
        JSONArray multiRowDataset = boardDataset.getJSONArray("multiRowDataset");
        JSONArray multiValueDataset = boardDataset.getJSONArray("multiValueDataset");
        JSONObject getDatasetBindSourceModel = boardDataset.getJSONObject("getDatasetBindSourceModel");
        this.datasetNumToNewDataset = Maps.newHashMapWithExpectedSize((int)(singleDataset.size() + multiRowDataset.size()));
        this.datasetNumToNewSingleDS = Maps.newHashMapWithExpectedSize((int)singleDataset.size());
        this.importSingleDataset(singleDataset, getDatasetBindSourceModel, false);
        this.importSingleDataset(multiRowDataset, getDatasetBindSourceModel, true);
        this.importMultiValueDataset(multiValueDataset);
    }

    private void importMultiValueDataset(JSONArray multiRowDataset) {
        long[] datasetLongs = DBServiceHelper.genLongIds((String)"fidm_dataset", (int)multiRowDataset.size());
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (int i = 0; i < multiRowDataset.size(); ++i) {
            JSONArray oneMultiRowDataset = (JSONArray)multiRowDataset.get(i);
            if (oneMultiRowDataset.size() == 0) continue;
            DynamicObject oneMultiDataset = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)"fidm_dataset_multivalue", (String)oneMultiRowDataset.get(0).toString());
            DynamicObject datasetOld = oneMultiDataset.getDynamicObject("dataset");
            DynamicObject datasetNew = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset");
            datasetNew.set("id", (Object)datasetLongs[i]);
            datasetNew.set("chapterid", (Object)this.defaultChapter.getLong("id"));
            datasetNew.set("discmodel", (Object)this.currentModel);
            datasetNew.set("status", (Object)"1");
            datasetNew.set("number", (Object)datasetOld.getString("number"));
            datasetNew.set("name", (Object)datasetOld.getString("name"));
            datasetNew.set("type", (Object)"3");
            datasetNew.set("creator", (Object)RequestContext.get().getCurrUserId());
            datasetNew.set("scope", (Object)"2");
            try {
                DatasetServiceHelper.checkDatasetNumberWithGB((String)datasetOld.getString("number"), (long)this.currentModel.getLong("id"), (long)0L);
                long[] multiRowLongs = DBServiceHelper.genLongIds((String)"fidm_dataset_multivalue", (int)oneMultiRowDataset.size());
                cloneUtils = new CloneUtils(true, true);
                for (int j = 0; j < oneMultiRowDataset.size(); ++j) {
                    DynamicObject multiRowOld = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)"fidm_dataset_multivalue", (String)oneMultiRowDataset.get(j).toString());
                    DynamicObject multiRowNew = (DynamicObject)cloneUtils.clone((IDataEntityBase)multiRowOld);
                    multiRowNew.set("id", (Object)multiRowLongs[j]);
                    multiRowNew.set("dataset", (Object)datasetNew);
                    multiRowNew.set("desq", (Object)(j + 1));
                    String formulatype = multiRowNew.getString("formulatype");
                    String formulatext = multiRowNew.getString("formulatext");
                    if ("1".equals(formulatype)) {
                        DynamicObject singleDS = this.datasetNumToNewSingleDS.get(formulatext);
                        if (Objects.nonNull(singleDS)) {
                            multiRowNew.set("single", (Object)singleDS.getLong("dataset.id"));
                        } else {
                            multiRowNew.set("single", (Object)this.getSingleDataSet(formulatext).getLong("id"));
                        }
                    }
                    this.multiValueDatasetDyList.add(multiRowNew);
                }
            }
            catch (Exception e) {
                this.addDetailImportLog(TemplateImportObjectEnum.CHAPTER_DATASET, datasetOld.getString("number"), datasetOld.getString("name"), e.getMessage(), false);
                continue;
            }
            this.datasetNumToNewDataset.put(datasetNew.getString("number"), datasetNew);
            this.datasetDyList.add(datasetNew);
        }
    }

    private void importSingleDataset(JSONArray singleDataset, JSONObject getDatasetBindSourceModel, boolean isMultiRow) {
        long[] singleLongs = DBServiceHelper.genLongIds((String)"fidm_dataset_single", (int)singleDataset.size());
        long[] datasetLongs = DBServiceHelper.genLongIds((String)"fidm_dataset", (int)singleDataset.size());
        CloneUtils cloneUtils = new CloneUtils(true, true);
        for (int i = 0; i < singleDataset.size(); ++i) {
            Object o = singleDataset.get(i);
            DynamicObject singleOld = (DynamicObject)ObjectSerialUtil.deSerializedToDynaObj((String)"fidm_dataset_single", (String)o.toString());
            DynamicObject single = (DynamicObject)cloneUtils.clone((IDataEntityBase)singleOld);
            DynamicObject datasetOld = single.getDynamicObject("dataset");
            DynamicObject dataset = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset");
            try {
                DatasetServiceHelper.checkDatasetNumberWithGB((String)datasetOld.getString("number"), (long)this.currentModel.getLong("id"), (long)0L);
                this.checkDatasetSingleValid(single, getDatasetBindSourceModel);
            }
            catch (Exception e) {
                this.addDetailImportLog(TemplateImportObjectEnum.CHAPTER_DATASET, datasetOld.getString("number"), datasetOld.getString("name"), e.getMessage(), false);
                continue;
            }
            single.set("id", (Object)singleLongs[i]);
            dataset.set("id", (Object)datasetLongs[i]);
            dataset.set("chapterid", (Object)this.defaultChapter.getLong("id"));
            dataset.set("discmodel", (Object)this.currentModel);
            dataset.set("status", (Object)"1");
            dataset.set("number", (Object)datasetOld.getString("number"));
            dataset.set("name", (Object)datasetOld.getString("name"));
            dataset.set("type", (Object)datasetOld.getString("type"));
            dataset.set("creator", (Object)RequestContext.get().getCurrUserId());
            dataset.set("scope", (Object)"2");
            single.set("dataset", (Object)dataset);
            DatasetDto datasetDto = new DatasetDto();
            datasetDto.setScope("2");
            datasetDto.setExpression(single.getString("expression"));
            datasetDto.setDiscmodelId(Long.valueOf(this.currentModel.getLong("id")));
            datasetDto.setChapterId(Long.valueOf(this.defaultChapter.getLong("id")));
            datasetDto.setType(dataset.getString("type"));
            DynamicObjectCollection variableCollection = new DynamicObjectCollection();
            variableCollection.addAll(this.variableList);
            List datasetVar = DatasetServiceHelper.addDatasetVar((DatasetDto)datasetDto, (long)dataset.getLong("id"), (DynamicObjectCollection)variableCollection);
            if (Objects.nonNull(datasetVar)) {
                this.datasetToVariable.addAll(datasetVar);
            }
            this.datasetNumToNewDataset.put(datasetOld.getString("number"), dataset);
            if (!isMultiRow) {
                this.datasetNumToNewSingleDS.put(datasetOld.getString("number"), single);
            }
            this.datasetDyList.add(dataset);
            this.singleDatasetDyList.add(single);
        }
    }

    private void checkDatasetSingleValid(DynamicObject single, JSONObject getDatasetBindSourceModel) {
        ModelInfo dmModel = this.getDMModel();
        if (DisModelTypeEnum.EB.getType().equals(dmModel.getModelType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e3a\u9884\u7b97\u4f53\u7cfb\uff0c\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u6765\u6e90\u4f53\u7cfb\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u9884\u7b97\u6570\u636e\u96c6\u3002", (String)"AnalysisDesignImportPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dataset = single.getDynamicObject("dataset");
        String dataSrcType = single.getString("datasrctype");
        long sourceModelId = this.currentModel.getLong("id");
        String modelSrcType = this.currentModel.getString("modeltype");
        JSONObject modelInfo = getDatasetBindSourceModel.getJSONObject(dataset.getString("number"));
        DynamicObject sourceModel = this.currentModel;
        if (!DataSrcTypeEnum.CURRENT_MODEL.getType().equals(dataSrcType)) {
            String modelNumber = modelInfo.getString("modelNumber");
            String modelType = modelInfo.getString("modelType");
            sourceModel = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_model", (String)"id,number,name,modeltype,model,status,apptype", (QFilter[])new QFBuilder("number", "=", (Object)modelNumber).add("apptype", "in", (Object)new String[]{"2", "3"}).toArray());
            sourceModelId = sourceModel.getLong("id");
            modelSrcType = sourceModel.getString("modeltype");
            String modelSourceType = sourceModel.getString("modeltype");
            if (!Objects.equals(modelSourceType, modelType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5bfc\u51fa\u65f6\u6765\u6e90\u4f53\u7cfb\u7c7b\u578b\u4e0e\u5bfc\u5165\u65f6\u6765\u6e90\u4f53\u7cfb\u7c7b\u578b\u4e0d\u7b26\u3002", (String)"AnalysisDesignImportPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        single.set("datasrcid", (Object)sourceModel.getLong("id"));
        single.set("datasrcnumber", (Object)sourceModel.getString("number"));
        if (Objects.nonNull(modelInfo) && StringUtils.isNotEmpty((String)modelInfo.getString("extendsModelNumber")) && (DataSrcTypeEnum.MERGE_MODEL.getType().equals(modelSrcType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(modelSrcType))) {
            List tuples = this.fidmDimService.getExtendsModel(dataSrcType, Long.valueOf(sourceModelId));
            Optional<Tuple> any = tuples.stream().filter(t -> Objects.equals(t.p1, modelInfo.getString("extendsModelNumber"))).findAny();
            if (!any.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u9009\u62e9\u7684\u62d3\u5c55\u7ef4\u4e0d\u5b58\u5728\u4e8e\u5bfc\u5165\u65f6\u6765\u6e90\u4f53\u7cfb\u3002", (String)"AnalysisDesignImportPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            single.set("extendsmodelid", (Object)Long.valueOf((String)any.get().p3));
            any.ifPresent(stringStringStringTuple -> single.set("extendsmodelid", (Object)Long.valueOf((String)stringStringStringTuple.p3)));
        }
        DatasetCheckExpParam param = new DatasetCheckExpParam();
        param.setExpression(single.getString("expression")).setModelId(Long.valueOf(this.currentModel.getLong("id"))).setDataSrcType(single.getString("datasrctype")).setDataSrcId(Long.valueOf(sourceModel.getLong("id"))).setShowTips(true).setModelNumber(sourceModel.getString("number")).setChapterId(Long.valueOf(this.defaultChapter.getLong("id")));
        DatasetExpressionHelper.getReplacedVar((String)param.getExpression(), (Long)this.currentModel.getLong("id"), this.variableNumToDefault, (boolean)true, (boolean)true, null);
    }

    private void importItemModule(JSONObject jsonObject) {
        JSONObject item;
        int i;
        JSONObject itemInfo = jsonObject.getJSONObject("itemInfo");
        JSONObject pageConfig = itemInfo.getJSONObject("pageConfig");
        JSONObject queryConfig = itemInfo.getJSONObject("queryConfig");
        JSONArray itemList = itemInfo.getJSONArray("itemList");
        long[] moduleIds = DBServiceHelper.genLongIds((String)"fidm_modulerepository", (int)(itemList.size() + 2));
        pageConfig.put("id", (Object)String.valueOf(moduleIds[itemList.size()]));
        queryConfig.put("id", (Object)String.valueOf(moduleIds[itemList.size() + 1]));
        List<Map<String, Object>> dimList = AnalysisSingleF7ServiceHelper.getDimList(this.currentModel.getLong("id"), this.currentModel.getLong("id"));
        List<Map<String, String>> gbVarList = AnalysisVariableHelper.getGlobalVariableList(this.currentModel.getLong("id"));
        Map gbVarNumToMap = gbVarList.stream().collect(Collectors.toMap(map -> (String)map.get("number"), Function.identity(), (key1, key2) -> key2));
        Map dimNumToDimList = dimList.stream().collect(Collectors.toMap(a -> a.get("number").toString(), Function.identity()));
        JSONArray dimListInQueryConfig = queryConfig.getJSONArray("dimList");
        JSONArray newDimListInQueryConfig = new JSONArray(dimListInQueryConfig.size());
        for (Object o : dimListInQueryConfig) {
            JSONObject dimInfo = (JSONObject)o;
            if (Objects.equals("1", dimInfo.get((Object)"isDim"))) {
                String dimNumber = dimInfo.getString("number");
                if (!dimNumToDimList.containsKey(dimNumber)) continue;
                newDimListInQueryConfig.add(dimNumToDimList.get(dimNumber));
                continue;
            }
            if (Objects.equals("1", dimInfo.get((Object)"vartype"))) {
                Map gbVar = (Map)gbVarNumToMap.get(dimInfo.getString("number"));
                if (!Objects.nonNull(gbVar)) continue;
                if (!DmVariableTypeEnum.ENUM.getIndex().equals(dimInfo.getString("valuetype")) && Objects.equals(dimInfo.getString("valuetype"), gbVar.get("valuetype"))) {
                    gbVar.put("defaultvalue", dimInfo.getString("defaultvalue"));
                }
                JSONObject object = JSONObject.parseObject((String)JSON.toJSONString((Object)gbVar));
                object.put("valuetype", (Object)Integer.parseInt(object.getString("valuetype")));
                newDimListInQueryConfig.add((Object)object);
                continue;
            }
            newDimListInQueryConfig.add((Object)dimInfo);
        }
        queryConfig.put("dimList", (Object)newDimListInQueryConfig);
        DynamicObjectCollection chapterModules = this.defaultChapter.getDynamicObjectCollection("entryentity");
        chapterModules.clear();
        AnalysisServiceHelper.saveToModule(new ArrayList<Long>(), chapterModules, this.itemDyList, queryConfig);
        AnalysisServiceHelper.saveToModule(new ArrayList<Long>(), chapterModules, this.itemDyList, pageConfig);
        HashMap oldModuleIdToNewId = Maps.newHashMapWithExpectedSize((int)itemList.size());
        for (i = 0; i < itemList.size(); ++i) {
            item = (JSONObject)itemList.get(i);
            String newId = String.valueOf(moduleIds[i]);
            oldModuleIdToNewId.put(item.getString("id"), newId);
            item.put("id", (Object)newId);
            item.remove((Object)"copyfrom");
            JSONObject emptyDataset = new JSONObject();
            emptyDataset.put("id", null);
            emptyDataset.put("name", (Object)"");
            emptyDataset.put("detail", (Object)new JSONArray());
            emptyDataset.put("var", (Object)new JSONArray());
            emptyDataset.put("filter", (Object)new JSONArray());
            JSONObject request = new JSONObject();
            emptyDataset.put("request", (Object)request);
            request.put("legendNumber", (Object)"");
            request.put("displayValueNumber", (Object)"");
            request.put("legendDetailNumber", (Object)"");
            request.put("sortSelectX", (Object)"");
            request.put("sortSelectY", (Object)"");
            try {
                this.checkItemDataset(item);
                continue;
            }
            catch (Exception e) {
                item.put("dataset", (Object)emptyDataset.clone());
                this.addDetailImportLog(TemplateImportObjectEnum.CHAPTER_MODULE, item.getString("name"), item.getString("name"), e.getMessage(), false);
            }
        }
        for (i = 0; i < itemList.size(); ++i) {
            Object ids;
            item = (JSONObject)itemList.get(i);
            String pid = item.getString("pid");
            if (!"0".equals(pid)) {
                item.put("pid", oldModuleIdToNewId.get(pid));
            }
            if (Objects.nonNull(ids = JSONPath.eval((Object)item, (String)"$.c.config.compLinkage.ids")) && ids instanceof JSONArray && !((JSONArray)ids).isEmpty()) {
                JSONArray idsArray = (JSONArray)ids;
                System.out.println("ids: " + idsArray);
                JSONArray newIds = new JSONArray(idsArray.size());
                for (Object oo : idsArray) {
                    String oldId = (String)oo;
                    if (!oldModuleIdToNewId.containsKey(oldId)) continue;
                    newIds.add(oldModuleIdToNewId.get(oldId));
                }
                JSONPath.set((Object)item, (String)"$.c.config.compLinkage.ids", (Object)newIds);
            }
            AnalysisServiceHelper.saveToModule(new ArrayList<Long>(), chapterModules, this.itemDyList, item);
        }
    }

    private void checkItemDataset(JSONObject item) {
        JSONObject dataset = item.getJSONObject("dataset");
        if (Objects.nonNull(dataset) && !dataset.isEmpty()) {
            String datasetNum = dataset.getString("number");
            DynamicObject datasetDy = this.datasetNumToNewDataset.get(datasetNum);
            if (Objects.isNull(datasetDy)) {
                datasetDy = this.getDataSet(datasetNum);
            }
            if (Objects.isNull(datasetDy)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\u96c6\u3002", (String)"AnalysisDesignImportPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (!Objects.equals(datasetDy.getString("type"), dataset.getString("type"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7ec4\u4ef6\u7684\u6570\u636e\u96c6\u7c7b\u578b\u4e0e\u5f53\u524d\u4f53\u7cfb\u4e2d\u5bf9\u5e94\u7f16\u7801\u7684\u6570\u636e\u96c6\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"AnalysisDesignImportPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            dataset.put("id", (Object)String.valueOf(datasetDy.getLong("id")));
        }
    }

    public DynamicObject getSingleDataSet(String formulaText) {
        QFilter qFilter = new QFilter("dataset.discmodel", "=", (Object)this.currentModel.getLong("id"));
        qFilter.and("dataset.scope", "=", (Object)"1");
        qFilter.and("dataset.type", "=", (Object)"1");
        qFilter.and("dataset.number", "=", (Object)formulaText);
        DynamicObject singleDS = QueryServiceHelper.queryOne((String)"fidm_dataset_single", (String)"id,datasrcid,datasrctype,dataset.status", (QFilter[])qFilter.toArray());
        if (Objects.isNull(singleDS)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\"%s\"\u6570\u636e\u96c6\uff0c\u6e05\u7a7a\u7ec4\u4ef6\u5df2\u9009\u6570\u636e\u96c6\u3002", (String)"AnalysisDesignImportPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]), formulaText));
        }
        return singleDS;
    }

    public DynamicObject getDataSet(String datasetNumber) {
        QFilter qFilter = new QFilter("discmodel", "=", (Object)this.currentModel.getLong("id"));
        qFilter.and("scope", "=", (Object)"1");
        qFilter.and("number", "=", (Object)datasetNumber);
        DynamicObject dataSet = QueryServiceHelper.queryOne((String)"fidm_dataset", (String)"id,type", (QFilter[])qFilter.toArray());
        if (Objects.isNull(dataSet)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\"%s\"\u6570\u636e\u96c6\uff0c\u6e05\u7a7a\u7ec4\u4ef6\u5df2\u9009\u6570\u636e\u96c6\u3002", (String)"AnalysisDesignImportPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetNumber));
        }
        return dataSet;
    }

    private void addDetailImportLog(TemplateImportObjectEnum importObjectEnum, String objectNum, String objectName, String result, boolean isSuccess) {
        DynamicObject importLog = BusinessDataServiceHelper.newDynamicObject((String)"far_analysis_importlog");
        importLog.set("model", (Object)this.currentModel);
        importLog.set("templatenumber", this.getValue("number"));
        importLog.set("templatename", this.getValue("name"));
        importLog.set("importobeject", (Object)importObjectEnum.getType());
        importLog.set("objectnumber", (Object)objectNum);
        importLog.set("objectname", (Object)objectName);
        importLog.set("result", (Object)result);
        importLog.set("modifier", (Object)RequestContext.get().getCurrUserId());
        importLog.set("modifydate", (Object)new Date());
        this.logDyList.add(importLog);
    }

    private void writeDetailImportLog() {
        SaveServiceHelper.save((DynamicObject[])this.logDyList.toArray(new DynamicObject[0]));
    }

    private String getStringFromInputStream(InputStream inputStream) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            log.error("io error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38\u3002", (String)"AnalysisDesignImportPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return writer.toString();
    }

    public void afterUpload(UploadEvent evt) {
        for (Object url : evt.getUrls()) {
            this.getPageCache().put(CACHEKEY_FILE_URL, (String)((Map)url).get("url"));
            this.getPageCache().put(CACHEKEY_FILE_TYPE, (String)((Map)url).get("type"));
        }
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().remove(CACHEKEY_FILE_URL);
        this.getPageCache().remove(CACHEKEY_FILE_TYPE);
    }
}

