/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.moudle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.ComeFromEnum;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;

public class ModuleReportityBakPlugin
extends AbstractBaseDMFormPlugin {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ModuleReportityBakPlugin.class);
    public static final String ParamItemListJsonData = "itemListJsonData";
    public static final String ParamItemJsonData = "itemJsonData";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String CATALOG = "catalog";
    private static final String PERMCLASS = "permclass";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String btn_save = "btnok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_save);
        BasedataEdit catalog = (BasedataEdit)this.getControl(CATALOG);
        catalog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERMCLASS)), (Object)this.getView().getFormShowParameter().getCustomParam("modelId"), (String)"fidmmodel", (String)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String itemJsonData = (String)this.getView().getFormShowParameter().getCustomParam(ParamItemJsonData);
        String name = "";
        if (!StringUtils.isEmpty((CharSequence)itemJsonData)) {
            JSONObject jsonObject = JSON.parseObject((String)itemJsonData);
            Object itemObject = jsonObject.get((Object)"item");
            if (itemObject instanceof JSONArray) {
                JSONArray itemArray = (JSONArray)itemObject;
                for (int i = 0; i < itemArray.size(); ++i) {
                    JSONObject jo = itemArray.getJSONObject(i);
                    String pid = jo.getString("pid");
                    if (!"0".equals(pid)) continue;
                    name = jo.getString(NAME);
                    break;
                }
            } else {
                name = ((JSONObject)itemObject).getString(NAME);
            }
            if (!StringUtils.isEmpty((CharSequence)name)) {
                this.getModel().setValue(NAME, (Object)name);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "catalog": {
                this.setCatalogQfilter(evt);
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (btn_save.equals(key)) {
            this.saveModuleToReportity();
        }
    }

    private void saveModuleToReportity() {
        String itemJsonData;
        JSONObject jsonObject;
        Object itemObject;
        String number = this.getModel().getValue(NUMBER).toString();
        String name = this.getModel().getValue(NAME).toString();
        Object catalog = this.getModel().getValue(CATALOG);
        Object description = this.getModel().getValue(DESCRIPTION);
        Number permclass = 0;
        if (this.getModel().getValue(PERMCLASS) != null) {
            permclass = ((DynamicObject)this.getModel().getValue(PERMCLASS)).getLong("id");
        }
        if ((itemObject = (jsonObject = JSON.parseObject((String)(itemJsonData = (String)this.getView().getFormShowParameter().getCustomParam(ParamItemJsonData)))).get((Object)"item")) instanceof JSONArray) {
            JSONArray itemArray = (JSONArray)itemObject;
            JSONObject joParent = new JSONObject();
            for (Object item : itemArray) {
                JSONObject itemJo = (JSONObject)item;
                if ("0".equals(itemJo.get((Object)"pid"))) {
                    joParent = itemJo;
                    continue;
                }
                this.checkOrSaveItem(itemArray, itemJo, number, name, catalog, description, permclass);
            }
            this.checkOrSaveItem(itemArray, joParent, number, name, catalog, description, permclass);
        } else if (itemObject instanceof JSONObject) {
            this.checkOrSaveItem(itemObject, (JSONObject)itemObject, number, name, catalog, description, permclass);
        } else {
            log.error("An unexpected type occurred:" + itemObject.getClass().getName());
        }
    }

    private void checkOrSaveItem(Object itemJson, JSONObject itemObject, String number, String name, Object catalog, Object description, Object permclass) {
        String dataSetScope;
        DynamicObject dataSetObject;
        Long dataSetId = AnalysisServiceHelper.getDatasetId(itemObject);
        if (Objects.nonNull(dataSetId) && 0L != dataSetId && Objects.nonNull(dataSetObject = DatasetServiceHelper.getDataSetById((Long)dataSetId)) && "2".equals(dataSetScope = dataSetObject.getString("scope"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5168\u5c40\u6570\u636e\u96c6\u7ec4\u4ef6\u53ef\u53e6\u5b58\u3002", (String)"ModuleReportityBakPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"0".equals(itemObject.getString("pid"))) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleReportityBakPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.isModuleNumberVilidate(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"ModuleReportityBakPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean exsistMoudleNumber = ModuleServiceHelper.isExsistMoudleNumber((Long)((Long)this.getView().getFormShowParameter().getCustomParam("modelId")), (String)number, (String)this.getBizAppId());
        if (exsistMoudleNumber) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"ModuleReportityBakPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleReportityBakPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (name.length() > 50) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"ModuleReportityBakPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!Objects.nonNull(catalog)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5e93\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleReportityBakPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!Objects.nonNull(itemJson)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7ec4\u4ef6\u3002", (String)"ModuleReportityBakPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(12);
        params.put(NUMBER, number);
        params.put(NAME, name);
        params.put(CATALOG, ((DynamicObject)catalog).getLong("id"));
        params.put(PERMCLASS, permclass);
        params.put(DESCRIPTION, description);
        params.put(TYPE, itemObject.get((Object)TYPE));
        params.put("datasetId", dataSetId);
        params.put("propertiesStr", JSON.toJSONString((Object)itemJson));
        Long id = this.saveModuleToRepositoryList((Long)this.getView().getFormShowParameter().getCustomParam("modelId"), params, this.getBizAppId(), ComeFromEnum.FAR);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ModuleReportityBakPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
        this.returnDataToParent(id);
        this.getView().close();
    }

    private Long saveModuleToRepositoryList(Long modelId, Map<String, Object> params, String bizAppid, ComeFromEnum comefrom) {
        DynamicObject module = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
        module.set("model", (Object)modelId);
        module.set(NUMBER, params.get(NUMBER));
        module.set(NAME, params.get(NAME));
        module.set(DESCRIPTION, params.get(DESCRIPTION));
        module.set("template", (Object)LongUtil.toLong((Object)params.get("templateId")));
        module.set(CATALOG, (Object)LongUtil.toLong((Object)params.get(CATALOG)));
        module.set("modifier", (Object)RequestContext.get().getCurrUserId());
        module.set("creator", (Object)RequestContext.get().getCurrUserId());
        module.set("scope", (Object)AppCatalogTypeEnum.getCatalogByAppId((String)bizAppid).getType());
        module.set("status", (Object)"1");
        String type = ModuleServiceHelper.getModuleTypeByNumber((String)String.valueOf(params.get(TYPE)), (String)bizAppid);
        module.set(TYPE, (Object)type);
        module.set("applytype", (Object)ModuleServiceHelper.getModuleApplyType((String)type));
        module.set("comefrom", (Object)comefrom.getType());
        module.set("datasetid", (Object)LongUtil.toLong((Object)params.get("datasetId")));
        if (LongUtil.toLong((Object)params.get(PERMCLASS)) > 0L) {
            module.set(PERMCLASS, (Object)LongUtil.toLong((Object)params.get(PERMCLASS)));
        }
        module.set("properties", params.get("propertiesStr"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{module});
        PermClassEntityHelper.saveDiscPermClass((DynamicObject)module, (String)"fidmmodel", (String)bizAppid);
        return Objects.nonNull(module.getLong("id")) ? Long.valueOf(module.getLong("id")) : null;
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("modelId"));
        qFilter.and("catalogtype", "=", (Object)"1");
        this.addModuleCataLogPermFilter(qFilter);
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)1);
        qFilters.add(qFilter);
        listShowParameter.getTreeFilterParameter().setQFilters((List)qFilters);
    }

    private boolean isModuleNumberVilidate(String number) {
        Matcher matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9.]+$").matcher(number);
        return matcherNumber.matches() && !number.contains("..") && !number.startsWith(".") && !number.startsWith("-");
    }

    private void addModuleCataLogPermFilter(QFilter catalogBuilder) {
        HashSet noPermsCataLog = new HashSet(16);
        noPermsCataLog.addAll(PermClassEntityHelper.getDiscPermissionMap((String)"fidm_modulecatalog", (Long)((Long)this.getView().getFormShowParameter().getCustomParam("modelId")), (Long)this.getUserId(), (String)this.getBizAppId()).get((Object)"1"));
        if (noPermsCataLog.size() != 0) {
            catalogBuilder.and(new QFilter("id", "not in", noPermsCataLog));
        }
    }
}

