/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.myanalysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassCache;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;

public class AbstractAnalysisTreePlugin
extends AbstractBaseDMListPlugin {
    protected static final String FAR_ANALYSIS_CATALOG = "catalog";
    protected static final String FAR_MYANALYSIS_BASEDATA = "far_myanalysis";
    protected static final String MODEL = "model";
    protected static final String TREENODEPERM = "treenodeperm";
    protected static final String FIDMMODEL = "fidmmodel";
    protected static final String READONLY = "readOnlyList";
    protected static final String FI_BCM_FORM_PLUGIN = "epm-far-formplugin";
    protected static final String FAR_ANALYSIS_CATALOG_BASEDATA = "far_myanalysiscatalog";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String PARENT = "parent";
    private static final String PARENTID = "parentid";
    private static final String SEQUENCE = "sequence";
    private static final String TREE_LIST = "treelist";
    private static final String FOCUS_NODEID = "focusnodeid";
    private static final String CATCALOGTYPE = "catcalogType";
    private static final String BTN_UP = "btn_up";
    private static final String BTN_DOWN = "btn_down";
    private static final String BTN_ADDNEW = "btn_addnew";
    private static final String BTN_MODIFY = "btn_modify";
    private static final String BTN_DELETE = "btn_delete";
    private static final String DELETECATALOG_COMFIRM = "deletecatalog_comfirm";
    protected Set<String> noControlButtons = new HashSet<String>(Arrays.asList("btn_addnew", "btn_modify", "btn_delete", "btn_up", "btn_down"));

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refrushTree();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addListeners();
    }

    @Override
    public String getModelSign() {
        return "modelbd";
    }

    protected void addListeners() {
        this.addClickListeners(BTN_ADDNEW, BTN_DELETE, BTN_MODIFY, BTN_UP, BTN_DOWN);
        TreeView tview = (TreeView)this.getControl(FAR_ANALYSIS_CATALOG);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                AbstractAnalysisTreePlugin.this.getPageCache().put(AbstractAnalysisTreePlugin.FOCUS_NODEID, evt.getNodeId().toString());
                AbstractAnalysisTreePlugin.this.getPageCache().put(AbstractAnalysisTreePlugin.PARENT, evt.getParentNodeId().toString());
                AbstractAnalysisTreePlugin.this.cacheTreeNodePerm(evt.getNodeId().toString());
                AbstractAnalysisTreePlugin.this.refreshBillList();
            }
        });
    }

    protected void cacheTreeNodePerm(String treeNodeId) {
        if (!StringUtils.isEmpty((CharSequence)treeNodeId)) {
            boolean isNodeOnlyRead = this.isNodeReadOnly(treeNodeId);
            this.getPageCache().put(TREENODEPERM, String.valueOf(isNodeOnlyRead));
        } else {
            this.getPageCache().put(TREENODEPERM, "noperm");
        }
    }

    protected boolean isNodeReadOnly(String nodeId) {
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_LIST), List.class);
        Iterator iterator = treeList.iterator();
        String parentNodeId = "";
        HashMap<String, String> node = new HashMap<String, String>(4);
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            if (!((String)next.get(ID)).equals(nodeId)) continue;
            parentNodeId = (String)next.get(PARENTID);
            node.putAll(next);
            break;
        }
        ArrayList<Long> readOnlyIds = new ArrayList<Long>(16);
        if (this.getPageCache().get(READONLY) == null) {
            readOnlyIds.addAll(this.getReadOnlyCataLogIds(FAR_ANALYSIS_CATALOG_BASEDATA, this.getModelId(), String.valueOf(this.getUserId())));
            this.getPageCache().put(READONLY, SerializationUtils.toJsonString(readOnlyIds));
        } else {
            readOnlyIds.addAll((Collection)SerializationUtils.fromJsonString((String)this.getPageCache().get(READONLY), List.class));
        }
        if (readOnlyIds.contains(LongUtil.toLong((Object)nodeId))) {
            return true;
        }
        return this.hasOnlyReadParentNode(treeList, node, readOnlyIds);
    }

    protected boolean isNodeReadOnly(Set<String> nodeIds) {
        List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_LIST), List.class);
        ArrayList<Long> readOnlyIds = new ArrayList<Long>(16);
        if (this.getPageCache().get(READONLY) == null) {
            readOnlyIds.addAll(this.getReadOnlyCataLogIds(FAR_ANALYSIS_CATALOG_BASEDATA, this.getModelId(), String.valueOf(this.getUserId())));
            this.getPageCache().put(READONLY, SerializationUtils.toJsonString(readOnlyIds));
        } else {
            readOnlyIds.addAll((Collection)SerializationUtils.fromJsonString((String)this.getPageCache().get(READONLY), List.class));
        }
        for (Map next : treeList) {
            if (!nodeIds.contains(next.get(ID))) continue;
            if (readOnlyIds.contains(LongUtil.toLong(next.get(ID)))) {
                return true;
            }
            if (!this.hasOnlyReadParentNode(treeList, next, readOnlyIds)) continue;
            return true;
        }
        return false;
    }

    private List<Long> getReadOnlyCataLogIds(String entityName, Long modelId, String userId) {
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)entityName, (Long)modelId, (Long)LongUtil.toLong((Object)userId), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"2"));
        return readOnlyPerms;
    }

    private boolean hasOnlyReadParentNode(List<Map<String, String>> treeList, Map<String, String> node, List<Long> readOnlyIds) {
        for (Map<String, String> next : treeList) {
            if (!node.get(PARENTID).equals(next.get(ID))) continue;
            if (readOnlyIds.contains(LongUtil.toLong((Object)next.get(ID)))) {
                return true;
            }
            return this.hasOnlyReadParentNode(treeList, next, readOnlyIds);
        }
        return false;
    }

    protected void initTree() {
        TreeNode catalog = new TreeNode();
        String nodeId = this.getPageCache().get(FOCUS_NODEID);
        String algoKey = this.getClass().getName();
        String modelID = this.getPageCache().get("dmmodelid");
        String entityName = this.getCatalogEntryEntity();
        String selectFields = this.getSelectFields();
        QFilter[] filters = null;
        QFilter fmodelid = new QFilter(MODEL, "=", (Object)this.getModelId());
        QFilter ftype = this.getCatalogTypeQFilter();
        filters = new QFilter[]{fmodelid, ftype};
        String orderBys = SEQUENCE;
        String headid = "";
        String headName = "";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)entityName, (String)modelID);
        List<Long> noPerms = this.getNoPermIds(FAR_ANALYSIS_CATALOG_BASEDATA, this.getModelId(), RequestContext.get().getUserId());
        ArrayList treeList = new ArrayList(16);
        this.getPageCache().remove(FOCUS_NODEID);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                if (noPerms.contains(task.getLong(ID))) continue;
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put(ID, task.get(ID).toString());
                memberMap.put(NUMBER, (String)task.get(NUMBER));
                memberMap.put(NAME, (String)task.get(NAME));
                memberMap.put(PARENTID, task.get(PARENT).toString());
                memberMap.put("type", FAR_ANALYSIS_CATALOG);
                treeList.add(memberMap);
                if (!"0".equals(task.get(PARENT).toString())) continue;
                headid = task.get(ID).toString();
                headName = this.getRootName();
                catalog.setId(headid);
                catalog.setIcon("kdfont kdfont-wenjianjia");
                this.getPageCache().put(FOCUS_NODEID, headid);
                this.getPageCache().put("headnodeid", headid);
            }
        }
        catalog.setParentid("");
        catalog.setText(headName);
        this.getPageCache().put(TREE_LIST, SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNodeDm((TreeNode)catalog, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)catalog);
        if (StringUtils.isEmpty((CharSequence)catalog.getId())) {
            return;
        }
        TreeView tree = (TreeView)this.getControl(FAR_ANALYSIS_CATALOG);
        tree.addNode(catalog);
        TreeNode fo = this.findFocusNodeById(nodeId, catalog);
        if (fo == null) {
            fo = catalog;
        } else {
            this.getPageCache().put(FOCUS_NODEID, fo.getId());
        }
        tree.focusNode(fo);
    }

    private List<Long> getNoPermIds(String entityName, Long modelId, String userId) {
        ArrayList<Long> noPerms = new ArrayList<Long>();
        if (this.isFIDM()) {
            noPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)entityName, (Long)modelId, (Long)LongUtil.toLong((Object)userId), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1"));
        } else {
            noPerms.addAll(PermClassCache.getPermissionMap((IPageCache)this.getPageCache(), (String)DataTypeEnum.NO.getIndex()));
        }
        return noPerms;
    }

    protected String getRootName() {
        return ResManager.loadKDString((String)"\u6211\u7684\u5206\u6790", (String)"MyAnalysisListPlugin_11", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]);
    }

    private TreeNode findFocusNodeById(String id, TreeNode tree) {
        if (StringUtils.isEmpty((CharSequence)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = this.findFocusNodeById(id, c);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    protected List<String> queryAllChildNodeList(String nodeid, List<Map<String, String>> treeList, List<String> allnodelist) {
        for (Map<String, String> m : treeList) {
            if (!m.get(PARENTID).equals(nodeid)) continue;
            allnodelist.add(m.get(ID));
            this.queryAllChildNodeList(m.get(ID), treeList, allnodelist);
        }
        return allnodelist;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.validator()) {
            return;
        }
        String nodeId = this.getPageCache().get(FOCUS_NODEID);
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6587\u4ef6\u5939\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractAnalysisTreePlugin_0", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String isNodeOnlyRead = this.getPageCache().get(TREENODEPERM);
        if (this.noControlButtons.contains(c.getKey().toLowerCase(Locale.ENGLISH)) && StringUtils.equals((CharSequence)"true", (CharSequence)isNodeOnlyRead)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6587\u4ef6\u5939\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"AbstractAnalysisTreePlugin_1", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_addnew": {
                this.newCatalog(nodeId, true);
                break;
            }
            case "btn_delete": {
                if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u6587\u4ef6\u5939\u4e0d\u80fd\u5220\u9664\u3002", (String)"AbstractAnalysisTreePlugin_2", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u5220\u6587\u4ef6\u5939\u4e0b\u7684\u6587\u4ef6\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u5176\u76f4\u63a5\u4e0a\u7ea7\u6587\u4ef6\u5939\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"AbstractAnalysisTreePlugin_3", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETECATALOG_COMFIRM, (IFormPlugin)this));
                break;
            }
            case "btn_modify": {
                this.newCatalog(nodeId, false);
                break;
            }
            case "btn_up": 
            case "btn_down": {
                this.downAndUpMember(c.getKey().toLowerCase(Locale.ENGLISH));
                break;
            }
        }
    }

    protected void downAndUpMember(String key) {
        TreeView treeView = (TreeView)this.getView().getControl(FAR_ANALYSIS_CATALOG);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getSelectedNodeId();
        if (selectNodeIds == null || selectNodeIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6587\u4ef6\u5939\u3002", (String)"AbstractAnalysisTreePlugin_4", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String selectedNodeId = (String)selectNodeIds.get(selectNodeIds.size() - 1);
        try {
            if (BTN_UP.equals(key)) {
                this.checkCatalogSeq(selectedNodeId);
                this.moveCatalogUp(selectedNodeId, this.getCatalogEntryEntity());
            } else if (BTN_DOWN.equals(key)) {
                this.checkCatalogSeq(selectedNodeId);
                this.moveCatalogDown(selectedNodeId, this.getCatalogEntryEntity());
            }
        }
        catch (Exception e) {
            DynamicObject dyTree = BusinessDataReader.loadSingle((Object)Long.parseLong(selectedNodeId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getCatalogEntryEntity()));
            OperationName operationName = BTN_UP.equals(key) ? OperationName.CATALOG_MOVE_UP : OperationName.CATALOG_MOVE_DOWN;
            this.writeOpLog(OperationResult.FAILURE, operationName, dyTree);
            throw e;
        }
    }

    protected void checkCatalogSeq(String selectNodeId) {
        String parentId = this.queryParentId(selectNodeId, this.getCatalogEntryEntity());
        this.dealChildSeq(parentId);
    }

    protected void moveCatalogUp(String id, String formId) {
        DynamicObject dyTree = BusinessDataServiceHelper.newDynamicObject((String)formId);
        DynamicObject dyTree2 = BusinessDataServiceHelper.newDynamicObject((String)formId);
        dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        if (seq == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u5939\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractAnalysisTreePlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter qf1 = new QFilter(SEQUENCE, "<", (Object)dyTree.getInt(SEQUENCE));
        String parentId = this.queryParentId(id, formId);
        QFilter filter = new QFilter(PARENT, "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{qf1, filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence desc", (int)1);
        if (seq != 0) {
            if (dcs != null && dcs.size() > 0) {
                dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get(ID), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
                int seq2 = dyTree2.getInt(SEQUENCE);
                dyTree2.set(SEQUENCE, (Object)seq);
                dyTree.set(SEQUENCE, (Object)seq2);
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                ((TreeView)this.getControl(FAR_ANALYSIS_CATALOG)).deleteAllNodes();
                this.initTree();
                TreeNode node = new TreeNode(parentId, id, dyTree.getString(NAME));
                ((TreeView)this.getControl(FAR_ANALYSIS_CATALOG)).focusNode(node);
                this.writeOpLog(OperationResult.SUCCESS, OperationName.CATALOG_MOVE_UP, dyTree);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u5939\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractAnalysisTreePlugin_5", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
    }

    protected String queryParentId(String id, String entityId) {
        QFilter[] filters = new QFilter[]{new QFilter(ID, "=", (Object)LongUtil.toLong((Object)id))};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityId, (String)PARENT, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getString(PARENT);
        }
        return "";
    }

    protected void dealChildSeq(String parentId) {
        QFilter parent = new QFilter(PARENT, "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)this.getCatalogEntryEntity(), (String)"id,sequence", (QFilter[])filters, (String)"longnumber");
        if (dcs != null && dcs.size() > 0) {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(16);
            ArrayList<Long> arrayList = new ArrayList<Long>(16);
            for (DynamicObject dy : dcs) {
                Long id = dy.getLong(ID);
                arrayList.add(id);
                map.put(id, dy.getInt(SEQUENCE));
            }
            if (map.values().contains(0)) {
                DynamicObject dyCatelog = BusinessDataServiceHelper.newDynamicObject((String)this.getCatalogEntryEntity());
                Object[] dyDealSeq = (DynamicObject[])BusinessDataReader.load((Object[])arrayList.toArray(), (IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()));
                for (int i = 0; i < dyDealSeq.length; ++i) {
                    dyDealSeq[i].set(SEQUENCE, (Object)(i + 1));
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyCatelog.getDynamicObjectType().getName()), (Object[])dyDealSeq);
            }
        }
    }

    protected int getDSeq(long id, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter(ID, "=", (Object)id)};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)SEQUENCE, (QFilter[])filters, (String)SEQUENCE);
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getInt(SEQUENCE);
        }
        return 1;
    }

    protected void moveCatalogDown(String id, String formId) {
        DynamicObject dyTree = BusinessDataServiceHelper.newDynamicObject((String)formId);
        DynamicObject dyTree2 = BusinessDataServiceHelper.newDynamicObject((String)formId);
        dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        QFilter qf1 = new QFilter(SEQUENCE, ">", (Object)dyTree.getInt(SEQUENCE));
        String parentId = this.queryParentId(id, formId);
        QFilter filter = new QFilter(PARENT, "=", (Object)LongUtil.toLong((Object)parentId));
        QFilter[] filters = new QFilter[]{qf1, filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence asc", (int)1);
        if (seq != 0) {
            if (dcs != null && dcs.size() > 0) {
                dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get(ID), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyTree.getDynamicObjectType().getName()));
                int seq2 = dyTree2.getInt(SEQUENCE);
                dyTree2.set(SEQUENCE, (Object)seq);
                dyTree.set(SEQUENCE, (Object)seq2);
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                ((TreeView)this.getControl(FAR_ANALYSIS_CATALOG)).deleteAllNodes();
                this.initTree();
                TreeNode node = new TreeNode(parentId, id, dyTree.getString(NAME));
                ((TreeView)this.getControl(FAR_ANALYSIS_CATALOG)).focusNode(node);
                this.writeOpLog(OperationResult.SUCCESS, OperationName.CATALOG_MOVE_DOWN, dyTree);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u5939\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbstractAnalysisTreePlugin_6", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
    }

    protected void newCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get("dmmodelid"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, FAR_MYANALYSIS_BASEDATA);
        if (isAddNew) {
            long id = Long.parseLong(nodeId);
            params.put(PARENT, id);
            params.put(CATCALOGTYPE, this.getCatalogType());
            params.put("type", "add");
            this.showForm(this.getCatalogEntryEntity(), params, closeCallBack, ShowType.Modal, 0L);
        } else {
            long id = Long.parseLong(nodeId);
            params.put(CATCALOGTYPE, this.getCatalogType());
            params.put(PARENT, this.getPageCache().get(PARENT));
            params.put("type", "edit");
            this.showForm(this.getCatalogEntryEntity(), params, closeCallBack, ShowType.Modal, id);
        }
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        params.put("entity", this.getCatalogEntryEntity());
        param.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u5939\u521b\u5efa", (String)"AbstractAnalysisTreePlugin_7", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void refrushTree() {
        TreeView Tree = (TreeView)this.getControl(FAR_ANALYSIS_CATALOG);
        Tree.deleteAllNodes();
        this.initTree();
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String modelId = this.getPageCache().get("dmmodelid");
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals(DELETECATALOG_COMFIRM)) {
            ArrayList dynList = Lists.newArrayListWithCapacity((int)5);
            try {
                PlatUtil.executeWithTXNew(tx -> {
                    DynamicObject[] oo;
                    TreeView tree = (TreeView)this.getControl(FAR_ANALYSIS_CATALOG);
                    Map map = tree.getTreeState().getFocusNode();
                    String nodeId = (String)map.get(ID);
                    String parentId = (String)map.get(PARENTID);
                    List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_LIST), List.class);
                    ArrayList<String> list = new ArrayList<String>(16);
                    this.queryAllChildNodeList(nodeId, treeList, list);
                    list.add(nodeId);
                    List longList = LongUtil.toLongList(list);
                    dynList.addAll(this.getTemplateCatalogByIds(longList, FAR_ANALYSIS_CATALOG_BASEDATA));
                    for (DynamicObject dd : oo = (DynamicObject[])this.queryTemplateByCatalogIds(longList)) {
                        dd.set(FAR_ANALYSIS_CATALOG, (Object)parentId);
                    }
                    SaveServiceHelper.save((DynamicObject[])oo);
                    List ids = list.stream().map(a -> Long.parseLong(a)).collect(Collectors.toList());
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getCatalogEntryEntity()), (Object[])list.toArray());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractAnalysisTreePlugin_8", (String)FI_BCM_FORM_PLUGIN, (Object[])new Object[0]));
                    String formId = this.getView().getFormShowParameter().getFormId();
                });
                this.batchWriteOpLog(OperationResult.SUCCESS, OperationName.CATALOG_DELETE, dynList);
            }
            catch (Exception e) {
                this.batchWriteOpLog(OperationResult.FAILURE, OperationName.CATALOG_DELETE, dynList);
                throw e;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "far_myanalysis": {
                ArrayList ids;
                ArrayList arrayList = ids = closedCallBackEvent.getReturnData() == null ? null : (ArrayList)closedCallBackEvent.getReturnData();
                if (ids == null || ids.size() <= 0) break;
                this.refrushTree();
                String nodeid = ((Long)ids.get(0)).toString();
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_LIST), List.class);
                for (Map m : treeList) {
                    if (!nodeid.equals(m.get(ID))) continue;
                    TreeNode node = new TreeNode((String)m.get(PARENTID), (String)m.get(ID), (String)m.get(NAME));
                    ((TreeView)this.getControl(FAR_ANALYSIS_CATALOG)).focusNode(node);
                    this.getPageCache().put(FOCUS_NODEID, nodeid);
                    this.getPageCache().put(PARENT, (String)m.get(PARENTID));
                }
                this.refreshBillList();
                break;
            }
        }
    }

    private Object[] queryTemplateByCatalogIds(List<Long> pks) {
        QFilter filter1 = new QFilter(FAR_ANALYSIS_CATALOG, "in", pks);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getEntryEntity(), (String)ID, (QFilter[])new QFilter[]{filter1});
        ArrayList<Long> ids = new ArrayList<Long>(dcs.size());
        for (DynamicObject dd : dcs) {
            ids.add(dd.getLong(ID));
        }
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntryEntity()));
    }

    protected String getEntryEntity() {
        return FAR_MYANALYSIS_BASEDATA;
    }

    protected String getCatalogType() {
        return "";
    }

    protected String getCatalogEntryEntity() {
        return "";
    }

    protected void controlButtonEnable(Boolean status) {
        this.getView().setEnable(status, new String[]{"tbldel"});
    }

    protected void refreshBillList() {
    }

    protected QFilter getCatalogTypeQFilter() {
        return null;
    }

    protected String getSelectFields() {
        return "id,name,number,parent,catalogtype";
    }

    private void writeOpLog(OperationResult result, OperationName opName, DynamicObject template) {
        String templateNumber = template != null ? template.getString(NUMBER) : "";
        super.writeOpLog(OperationCategory.MYANALYSIS, opName, result, FAR_MYANALYSIS_BASEDATA, templateNumber);
    }

    private void batchWriteOpLog(OperationResult result, OperationName opName, List<DynamicObject> dynList) {
        super.batchWriteOpLog(OperationCategory.MYANALYSIS, opName, result, FAR_MYANALYSIS_BASEDATA, dynList, new String[0]);
    }
}

