/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.myanalysis;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;

public class MyAnalysisBaseInfoPlugin
extends AbstractBaseFormPlugin {
    private static final String btn_save = "btnok";
    private static final String analysis_id = "analysis_id";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String ANALYSISPERM = "analysisperm";
    private static final String CATALOG = "catalog";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_save);
        BasedataEdit permclass = (BasedataEdit)this.getControl(PERMCLASS);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(CATALOG);
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPage();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (btn_save.equals(key) && StringUtils.isEmpty((CharSequence)this.checkReportPerm())) {
            Object name = this.getModel().getValue("name");
            if (StringUtils.isEmpty((CharSequence)((String)name))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MyAnalysisBaseInfoPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            Object catalog = this.getModel().getValue(CATALOG);
            if (catalog == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MyAnalysisBaseInfoPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            this.saveAnalysisInfor();
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (key.equals(CATALOG)) {
            this.setCatalogQfilter(evt);
        }
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("model", "=", (Object)this.getDMModelId());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qFilter);
        fsp.getListFilterParameter().getQFilters().add(qFilter);
        fsp.getTreeFilterParameter().setQFilters(qFilters);
    }

    private void saveAnalysisInfor() {
        String name = this.getModel().getValue("name").toString();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            Long analysisId = this.getAnalysisId();
            try {
                DynamicObject analysis = BusinessDataServiceHelper.loadSingle((Object)analysisId, (String)"far_myanalysis", (String)"name,catalog,permclass");
                analysis.set("name", (Object)name);
                Object catalog = this.getModel().getValue(CATALOG);
                analysis.set(CATALOG, catalog);
                analysis.set(PERMCLASS, this.getModel().getValue(PERMCLASS));
                SaveServiceHelper.save((IDataEntityType)analysis.getDynamicObjectType(), (Object[])new Object[]{analysis});
                this.savePermClass();
                this.returnDataToParent(analysisId);
                this.getView().close();
                this.writeOpLog(OperationResult.SUCCESS);
            }
            catch (Exception e) {
                this.writeOpLog(OperationResult.FAILURE);
                log.error((Throwable)e);
            }
        }
    }

    private void initPage() {
        Long analysisId = this.getAnalysisId();
        DynamicObject analysis = BusinessDataServiceHelper.loadSingle((Object)analysisId, (String)"far_myanalysis", (String)"name,catalog,number");
        long catalogId = analysis.getLong("catalog.id");
        String name = analysis.getString("name");
        String number = analysis.getString("number");
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue("name", (Object)name);
        this.getModel().setValue(CATALOG, (Object)catalogId);
        this.setPermClass();
    }

    private void setPermClass() {
        QFBuilder permClassEntityFilter = new QFBuilder();
        permClassEntityFilter.add(new QFilter(FIDMMODEL, "=", (Object)this.getDMModelId()));
        permClassEntityFilter.add(new QFilter("entityid", "=", (Object)this.getAnalysisId()));
        permClassEntityFilter.add(new QFilter("entityname", "=", (Object)"far_myanalysis"));
        permClassEntityFilter.add(new QFilter("authclass.app", "=", (Object)this.getBizAppId()));
        String selectField = PERMCLASS;
        DynamicObject permClassEntity = QueryServiceHelper.queryOne((String)"bcm_permclass_entity", (String)selectField, (QFilter[])permClassEntityFilter.toArray());
        if (permClassEntity != null) {
            Long permClassId = permClassEntity.getLong(PERMCLASS);
            this.getModel().setValue(PERMCLASS, (Object)permClassId);
        }
    }

    private void savePermClass() {
        PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)"far_myanalysis", (Long)this.getAnalysisId(), (Object)this.getDMModelId(), (OperationStatus)OperationStatus.EDIT, (String)FIDMMODEL, (String)this.getBizAppId());
    }

    public Long getAnalysisId() {
        Long analysisId = (Long)this.getFormCustomParam(analysis_id);
        return analysisId;
    }

    @Override
    public Long getDMModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
    }

    protected String checkReportPerm() {
        String perm = (String)this.getView().getFormShowParameter().getCustomParam(ANALYSISPERM);
        String msg = "";
        if ("2".equals(perm)) {
            msg = "readonly";
        }
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u6211\u7684\u5206\u6790\u201d\u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"MyAnalysisBaseInfoPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return msg;
    }

    private void writeOpLog(OperationResult result) {
        ModelInfo model = new ModelStrategyEx(this.getDMModelId()).getModel().getModelInfo();
        Object number = this.getModel().getValue("number");
        String catalogNumber = number != null ? number.toString() : "";
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.MYANALYSIS).buildOpName(OperationName.EDIT_BASEINFO).buildFormNumber("far_myanalysis").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getNumber(), catalogNumber}).buildOpResult(result);
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
    }
}

