/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.myanalysis;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;

public class MyAnalysisCatalogPlugin
extends AbstractBasePlugIn {
    private static final String MODEL = "model";
    private static final String PARENT = "parent";
    private static final String SEQUENCE = "sequence";
    private static final String ENTITY_NAME = "far_myanalysiscatalog";
    private static final String FIDMMODEL = "fidmmodel";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)LongUtil.toLong((Object)this.getModelId()), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
    }

    public void afterLoadData(EventObject e) {
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)this.getModelId());
        this.getModel().setDataChanged(false);
        Object parentNode = this.getModel().getValue(PARENT);
        if (Objects.isNull(parentNode)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object objModel = map.get(MODEL);
        Object objParent = map.get(PARENT);
        this.getModel().setValue(MODEL, objModel);
        this.getModel().setValue(PARENT, objParent);
        int seq = this.getCurNodeSequence(map.get(MODEL).toString(), map.get(PARENT).toString());
        this.getModel().setValue(SEQUENCE, (Object)seq);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            Object number = this.getModel().getValue("number");
            if (!this.isValidNumber((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"MyAnalysisListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("status", (Object)"C");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        List ids = e.getOperationResult().getSuccessPkIds();
        Object number = this.getModel().getValue("number");
        Object name = this.getModel().getValue("name");
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        OperationName opName = OperationName.UNSUPPORTED;
        if ("add".equals(type)) {
            opName = OperationName.CATALOG_CREATE;
        } else if ("edit".equals(type)) {
            opName = OperationName.CATALOG_EDIT;
        }
        try {
            if (e.getSource() instanceof Save) {
                if (isSuccess) {
                    PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)this.getCatalogEntity(), (Long)LongUtil.toLong(ids.get(0)), (Object)LongUtil.toLong((Object)this.getModelId()), (OperationStatus)status, (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
                    this.getView().returnDataToParent((Object)ids);
                    this.getView().close();
                    this.writeOpLog(OperationResult.SUCCESS, opName);
                } else {
                    this.writeOpLog(OperationResult.SUCCESS, opName);
                }
            }
        }
        catch (Exception exception) {
            this.writeOpLog(OperationResult.FAILURE, opName);
            throw exception;
        }
    }

    private int getCurNodeSequence(String modelId, String parentId) {
        QFilter model = new QFilter(MODEL, "=", (Object)Long.valueOf(modelId));
        QFilter parent = new QFilter(PARENT, "=", (Object)Long.valueOf(parentId));
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getCatalogEntity(), (String)SEQUENCE, (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString(SEQUENCE);
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    private String getCatalogEntity() {
        return ENTITY_NAME;
    }

    private Object getModelId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map.get(MODEL);
    }

    private boolean isAdd() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        return map.get("type") != null && map.get("type").toString().equals("add");
    }

    private boolean isValidNumber(String number) {
        Matcher matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9._]+$").matcher(number);
        return matcherNumber.matches() && !number.contains("..") && !number.startsWith(".") && !number.startsWith("-");
    }

    private void writeOpLog(OperationResult result, OperationName opName) {
        Long modelId = Long.parseLong((String)this.getModelId());
        ModelInfo model = new ModelStrategyEx(modelId).getModel().getModelInfo();
        Object number = this.getModel().getValue("number");
        String catalogNumber = number != null ? number.toString() : "";
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.MYANALYSIS).buildOpName(opName).buildFormNumber("far_myanalysis").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getNumber(), catalogNumber}).buildOpResult(result);
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
    }
}

