/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.myanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Delete;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.far.utils.MyAnalysisService;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.faranalysis.myanalysis.AbstractAnalysisTreePlugin;

public class MyAnalysisListPlugin
extends AbstractAnalysisTreePlugin
implements ListRowClickListener {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String FOCUS_NODE_ID = "focusnodeid";
    private static final String TREE_CHECK_BOX = "treecheckbox";
    private static final String ENTITY_NAME = "far_myanalysis";
    private static final String CATALOG_ENTITY_NAME = "far_myanalysiscatalog";
    private static final String CTL_MODEL = "modelbd";
    private static final String ANALYSISPERM = "analysisperm";
    private static final String ANALYSIS_BASEINFO_CLOSED = "analysis_baseinfo_closed";

    @Override
    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.addBeforePackageDataListener(this::setCatalogText);
        billList.addHyperClickListener(this::hyperLinkClick);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    @Override
    protected String getRootName() {
        return ResManager.loadKDString((String)"\u6211\u7684\u5206\u6790", (String)"MyAnalysisListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected QFilter getCatalogTypeQFilter() {
        return null;
    }

    @Override
    protected String getSelectFields() {
        return "id,name,number,parent";
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        ModelInfo model = this.getDiscModel();
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        super.afterCreateNewData(e);
        Long modelId = this.getUserSelect();
        if (modelId == null || modelId == 0L) {
            return;
        }
        this.getModel().setValue(this.getModelSign(), (Object)modelId);
        this.getPageCache().put("dmmodelid", modelId.toString());
        this.addCatalogRoot(modelId);
        this.refreshBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        String key = e.getProperty().getName();
        if (key.equals(TREE_CHECK_BOX)) {
            this.refreshBillList();
        } else if (key.equals(CTL_MODEL)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue == null) {
                return;
            }
            if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
                return;
            }
            this.addCatalogRoot(newValue.getLong("id"));
            TreeView tree = (TreeView)this.getControl("catalog");
            tree.deleteAllNodes();
            this.initTree();
            this.refreshBillList();
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() > 0) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            String myAnalysisSelectField = "id,catalog";
            QFBuilder moduleFilter = new QFBuilder();
            moduleFilter.add("id", "in", (Object)selectNodeIds);
            DynamicObject[] modules = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)myAnalysisSelectField, (QFilter[])moduleFilter.toArray());
            HashSet<String> cataLogIds = new HashSet<String>(modules.length);
            for (DynamicObject module : modules) {
                String cataLogId = module.getString("catalog.id");
                cataLogIds.add(cataLogId);
            }
            boolean isCatalogOnlyRead = this.isNodeReadOnly(cataLogIds);
            if (isCatalogOnlyRead) {
                this.controlButtonEnable(Boolean.FALSE);
            } else {
                ArrayList readOnlyPerms = new ArrayList();
                readOnlyPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)ENTITY_NAME, (Long)this.getModelId(), (Long)this.getUserId(), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"2"));
                this.controlButtonEnable(Boolean.TRUE);
                for (DynamicObject module : modules) {
                    Long moduleId = module.getLong("id");
                    if (!readOnlyPerms.contains(moduleId)) continue;
                    this.controlButtonEnable(Boolean.FALSE);
                    break;
                }
            }
        } else if (billList.getSelectedRows().size() != 0 && StringUtils.equals((CharSequence)"true", (CharSequence)this.getPageCache().get("treenodeperm"))) {
            this.controlButtonEnable(Boolean.FALSE);
        } else if (billList.getSelectedRows().size() == 0) {
            this.controlButtonEnable(Boolean.TRUE);
        }
    }

    private void addCatalogRoot(Long dmModelId) {
        boolean exists = MyAnalysisService.createMyAnalysisCatalogRoot((Long)dmModelId);
        if (!exists) {
            this.refrushTree();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete) {
            if (this.checkExistData()) {
                args.setCancel(true);
                return;
            }
            if (this.cancelDeleteOperation()) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Delete) {
            String jsonString = this.getView().getPageCache().get("deletedRows");
            TypeReference<List<Object[]>> typeReference = new TypeReference<List<Object[]>>(){};
            List deletedRows = (List)JSON.parseObject((String)jsonString, (TypeReference)typeReference, (Feature[])new Feature[0]);
            if (args.getOperationResult().isSuccess()) {
                this.batchWriteOpLog(OperationResult.SUCCESS, deletedRows);
            } else {
                this.batchWriteOpLog(OperationResult.FAILURE, deletedRows);
            }
        }
    }

    private boolean cancelDeleteOperation() {
        DynamicObject[] collection;
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        Object[] selectedIds = billList.getSelectedRows().getPrimaryKeyValues();
        if (selectedIds.length != (collection = BusinessDataServiceHelper.load((Object[])selectedIds, (DynamicObjectType)billList.getEntityType())).length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u884c\u4e2d\u6709\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"MyAnalysisListPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        ArrayList formatParams = Lists.newArrayListWithCapacity((int)collection.length);
        for (DynamicObject dynamicObject : collection) {
            formatParams.add(new Object[]{dynamicObject.getString("number"), dynamicObject.getString("name")});
        }
        this.getView().getPageCache().put("deletedRows", JSON.toJSONString((Object)formatParams));
        return false;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_preview": {
                break;
            }
            case "bar_refresh": {
                this.refreshBillList();
                this.refrushTree();
                break;
            }
            case "btn_addmyanalysis": {
                break;
            }
            case "tblrefresh": {
                this.refreshPermCache();
                this.refrushTree();
                this.refreshBillList();
                break;
            }
            case "btn_baseinfor": {
                if (this.checkExistData()) {
                    return;
                }
                this.openBaseInfo();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (ANALYSIS_BASEINFO_CLOSED.equals(actionId) && Objects.nonNull(returnData)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MyAnalysisListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    public void openBaseInfo() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"MyAnalysisListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u591a\u9009\u3002", (String)"MyAnalysisListPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ANALYSIS_BASEINFO_CLOSED));
        fsp.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"MyAnalysisListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        fsp.setFormId("far_myanalysis_baseinfo");
        fsp.setCustomParam("modelId", (Object)this.getModelId());
        fsp.setCustomParam(ANALYSISPERM, (Object)this.getPageCache().get(ANALYSISPERM));
        Long rportId = (Long)billList.getSelectedRows().get(0).getPrimaryKeyValue();
        fsp.setCustomParam("analysis_id", (Object)rportId);
        this.getView().showForm(fsp);
    }

    private boolean checkExistData() {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"MyAnalysisListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)ENTITY_NAME);
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ThemeAnalysisListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void hyperLinkClick(HyperLinkClickEvent arg) {
        if (this.checkExistData()) {
            return;
        }
        if (arg.getFieldName().equals("number")) {
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)arg).getCurrentRow();
            Long myAnalysisId = (Long)currentRow.getPrimaryKeyValue();
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = mainPageView != null ? myAnalysisId + "far_myanalysisview" + mainPageView.getPageId() : myAnalysisId + "far_myanalysisviewJustForTest";
            if (mainPageView == null || mainPageView.getView(pageId) == null) {
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                DynamicObject templateDy = BusinessDataServiceHelper.loadSingleFromCache((Object)myAnalysisId, (String)ENTITY_NAME, (String)"id, name, number");
                customParams.put("myAnalysisId", templateDy.get("id"));
                customParams.put("number", templateDy.getString("number"));
                customParams.put("fileName", templateDy.getString("name"));
                customParams.put("appId", this.getBizAppId());
                customParams.put("dmmodelid", this.getDMModelId());
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("far_myanalysisview");
                formShowParameter.setCustomParams(customParams);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCaption(templateDy.getString("name"));
                formShowParameter.setPageId(pageId);
                if (parentView != null) {
                    parentView.showForm(formShowParameter);
                    this.getView().sendFormAction(parentView);
                }
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    @Override
    public String getBizEntityNumber() {
        return ENTITY_NAME;
    }

    @Override
    protected String getEntryEntity() {
        return ENTITY_NAME;
    }

    @Override
    protected void refreshBillList() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        billList.clearSelection();
        billList.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = new QFilter("model", "=", (Object)this.getDiscModelId());
        this.getCatalogQFilter(filter);
        this.addPermClassFilter(filter);
        e.setCustomQFilters(Collections.singletonList(filter));
        e.setOrderBy("sequence asc,number asc");
    }

    private void addPermClassFilter(QFilter filter) {
        HashSet noPermId = new HashSet(16);
        noPermId.addAll(PermClassEntityHelper.getDiscPermissionMap((String)this.getEntryEntity(), (Long)this.getModelId(), (Long)this.getUserId(), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1"));
        filter.and(new QFilter("id", "not in", noPermId));
    }

    private void getCatalogQFilter(QFilter filter) {
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (nodeId != null) {
            QFilter qFilter1 = new QFilter("catalog", "=", (Object)LongUtil.toLong((Object)nodeId));
            boolean isallchild = Boolean.parseBoolean(this.getModel().getValue(TREE_CHECK_BOX).toString());
            if (isallchild) {
                List treeList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("treelist"), List.class);
                ArrayList<String> list = new ArrayList<String>(16);
                this.queryAllChildNodeList(nodeId, treeList, list);
                if (list.size() > 0) {
                    qFilter1.or("catalog", "in", (Object)LongUtil.toLongList(list));
                }
            }
            filter.and(qFilter1);
        }
    }

    private void setCatalogText(BeforePackageDataEvent e) {
        String catalogText = ResManager.loadKDString((String)"\u6211\u7684\u5206\u6790", (String)"MyAnalysisListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]);
        for (DynamicObject object : e.getPageData()) {
            if (!object.getDataEntityType().getProperties().contains((Object)"catalog") || !"root".equalsIgnoreCase(object.getString("catalog.name"))) continue;
            object.set("catalog.name", (Object)catalogText);
        }
    }

    @Override
    public void checkPerm(String opkey) {
        if ((opkey.equals("btn_addnew") || opkey.equals("btn_modify") || opkey.equals("btn_delete") || opkey.equals("btn_up") || opkey.equals("btn_down")) && StringUtils.equals((CharSequence)this.getPageCache().get("treenodeperm"), (CharSequence)"true")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u5206\u7c7b\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"MyAnalysisListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        super.checkPerm(opkey);
    }

    @Override
    protected String getCatalogEntryEntity() {
        return CATALOG_ENTITY_NAME;
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
    }

    private void refreshPermCache() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"tbldel"});
        this.getPageCache().remove(ANALYSISPERM);
        this.getPageCache().remove("treenodeperm");
    }

    private void batchWriteOpLog(OperationResult result, List<Object[]> formatParamsList) {
        super.batchWriteOpLogOrigin(OperationCategory.MYANALYSIS, OperationName.DELETE, result, ENTITY_NAME, formatParamsList);
    }
}

