/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.myanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.far.model.ParamData;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisPublishLogServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MyAnalysisPlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage,
BeforeF7SelectListener {
    private static final String ID = "id";
    private static final String FAR_NO_PERM = "1";
    private static final String MODEL = "model";
    private static final String CATALOG = "catalog";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String BTN_SAVE = "btn_save";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(CATALOG);
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERMCLASS)), (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getBizAppId());
        this.addClickListeners(BTN_SAVE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long dmModelId = this.getDmModelId();
        this.getModel().setValue(MODEL, (Object)dmModelId);
        String eventArgs = (String)this.getView().getFormShowParameter().getCustomParam("viewdata");
        JSONArray transferDimList = JSON.parseObject((String)eventArgs).getJSONObject("queryConfig").getJSONArray("dimList");
        if (Objects.nonNull(transferDimList) && transferDimList.size() > 0) {
            List<ParamData> dimList = AnalysisCommonOperateHelper.getDimList(eventArgs);
            AnalysisCommonOperateHelper.createDynamicControl(dimList, this.getView(), (IFormPlugin)this, this.getPageCache());
            AnalysisCommonOperateHelper.setDefaultValue(dimList, this.getView(), this.getModel(), "");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultparamflex"});
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        Element c;
        if (this.getPage(this.getView()) != null && Objects.nonNull(c = this.getPage(this.getView()).findElementBySign(e.getKey()))) {
            Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam("dmmodelid");
            AnalysisCommonOperateHelper.getControl(e, c, dmModelId, this.getView(), this.getModel(), this.getPageCache(), this, (ClickListener)this, null);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (key.equals(CATALOG)) {
            this.setCatalogQfilter(beforeF7SelectEvent);
        } else {
            Control scenarioControl = this.getView().getControl(DimTypesEnum.SCENARIO.getNumber().toLowerCase());
            String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
            if (DimTypesEnum.PERIOD.getNumber().equalsIgnoreCase(dimKey) && Objects.nonNull(scenarioControl) && this.getModel().getValue(DimTypesEnum.SCENARIO.getNumber().toLowerCase(Locale.ENGLISH)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"AnalysisSingleF7ServiceHelper_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam("dmmodelid");
            AnalysisCommonOperateHelper.addF7Filter(beforeF7SelectEvent, this.getModel(), this.getPageCache(), this.getView(), dimKey, dmModelId);
        }
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getDmModelId());
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)1);
        List list = PermClassEntityHelper.getFARPermissionMap((String)"far_myanalysiscatalog", (Long)this.getDmModelId(), (Long)this.getUserId()).get((Object)FAR_NO_PERM);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            qFilter.and(new QFilter(ID, "not in", (Object)list));
        }
        qFilters.add(qFilter);
        fsp.getListFilterParameter().getQFilters().add(qFilter);
        fsp.getTreeFilterParameter().setQFilters((List)qFilters);
    }

    public Long getDmModelId() {
        Long modelId = null;
        Object temp = this.getFormCustomParam("dmmodelid");
        modelId = temp instanceof Integer ? Long.valueOf(((Integer)temp).intValue()) : (Long)temp;
        return modelId;
    }

    private boolean validateNumber() {
        int count;
        Long modelId;
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((String)number)) {
            String showMsg = ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MyAnalysisPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(showMsg);
            return false;
        }
        String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        String showMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"MyAnalysisPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), number);
        if (!matcher.matches()) {
            this.getView().showTipNotification(showMsg);
            return false;
        }
        if (number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            this.getView().showTipNotification(showMsg);
            return false;
        }
        Long pkId = null;
        if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
            pkId = (Long)((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        }
        QFilter filter = new QFilter(MODEL, "=", (Object)(Objects.nonNull(modelId = Long.valueOf(((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID))) ? modelId : 0L));
        filter.and("number", "=", (Object)number);
        if (Objects.nonNull(pkId)) {
            filter.and(ID, "!=", (Object)pkId);
        }
        if ((count = QueryServiceHelper.queryOne((String)"far_myanalysis", (String)"count(id) num", (QFilter[])new QFilter[]{filter}).getInt("num")) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"MyAnalysisPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_SAVE.equals(key)) {
            if (!this.validateNumber()) {
                return;
            }
            boolean isSuccess = false;
            long id = 0L;
            try (TXHandle tx = TX.required();){
                try {
                    DynamicObject newMyAnalysis = BusinessDataServiceHelper.newDynamicObject((String)"far_myanalysis");
                    newMyAnalysis.set("number", this.getModel().getValue("number"));
                    newMyAnalysis.set("name", this.getModel().getValue("name"));
                    newMyAnalysis.set("description", this.getModel().getValue("description"));
                    newMyAnalysis.set(CATALOG, this.getModel().getValue(CATALOG));
                    newMyAnalysis.set("viewdata", this.getView().getFormShowParameter().getCustomParam("viewdata"));
                    newMyAnalysis.set(MODEL, this.getModel().getValue(MODEL));
                    newMyAnalysis.set("status", this.getModel().getValue("status"));
                    newMyAnalysis.set("enable", this.getModel().getValue("enable"));
                    newMyAnalysis.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
                    newMyAnalysis.set("createtime", (Object)TimeServiceHelper.now());
                    newMyAnalysis.set("creator", (Object)RequestContext.get().getCurrUserId());
                    newMyAnalysis.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    newMyAnalysis.set("modifytime", (Object)TimeServiceHelper.now());
                    newMyAnalysis.set(PERMCLASS, this.getModel().getValue(PERMCLASS));
                    ArrayList logs = Lists.newArrayListWithExpectedSize((int)1);
                    Long templateID = (Long)this.getView().getFormShowParameter().getCustomParam("templateID");
                    DynamicObject dy = (DynamicObject)this.getModel().getValue(CATALOG);
                    String path = Objects.nonNull(dy) ? dy.getLocaleString("name").getLocaleValue() : "";
                    DynamicObject dylog = AnalysisPublishLogServiceHelper.newAnalysisPublishLog(templateID, this.getModel().getValue("name").toString(), path, FAR_NO_PERM);
                    logs.add(dylog);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newMyAnalysis});
                    AnalysisPublishLogServiceHelper.batchInsertAnalysisPublishLog(logs);
                    PermClassEntityHelper.saveDiscPermClass((DynamicObject)newMyAnalysis, (String)FIDMMODEL, (String)this.getBizAppId());
                    id = newMyAnalysis.getLong(ID);
                    isSuccess = true;
                    this.writeOpLog(OperationResult.SUCCESS);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                    this.writeOpLog(OperationResult.FAILURE);
                    tx.markRollback();
                }
            }
            if (isSuccess) {
                this.returnDataToParent(id);
                this.getView().close();
            }
        }
    }

    private void writeOpLog(OperationResult result) {
        Long templateID = (Long)this.getView().getFormShowParameter().getCustomParam("templateID");
        DynamicObject template = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)templateID)});
        String templateNumber = template != null ? template.getString("number") : "";
        String publishNumber = this.getValue("number") != null ? (String)this.getValue("number") : "";
        Object[] params = new Object[]{templateNumber, publishNumber};
        super.writeOpLog(OperationCategory.ANALYSIS_DESIGN, OperationName.PUBLISH_MYANALYSIS, result, "far_analysisdesign", params);
    }
}

