/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.myanalysis;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.util.StringUtils;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.faranalysis.AbstractAnalysisPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;

public class MyAnalysisViewPlugin
extends AbstractAnalysisPlugin
implements BeforeF7SelectListener {
    private static final String KEY_MYANALYSISID = "KEY_MYANALYSISID";
    private static final String CTL_TOOLBAR_AP = "toolbarap";
    private static final String FLEXPANELAPQUERY = "flexpanelapquery";
    private static final String BTN_PREVIEW = "btn_preview";
    private static final String BTN_ALLSCREEN = "btn_allscreen";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_CLOSE = "btn_close";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(CTL_TOOLBAR_AP);
        this.addClickListeners(BTN_PREVIEW, BTN_ALLSCREEN, BTN_REFRESH, BTN_CLOSE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initMyAnalysisId();
        this.changeView(true);
        this.dataInit();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_preview": {
                if (this.checkExistMyAnalysisData()) {
                    return;
                }
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_PREVIEW));
                break;
            }
            case "btn_refresh": {
                this.dataInit();
                break;
            }
            case "btn_allscreen": {
                this.allScreen();
                break;
            }
        }
    }

    private boolean checkExistMyAnalysisData() {
        boolean isExistThemeData = AnalysisServiceHelper.isExistMyAnalysisData(this.getDmModelId(), this.getMyAnalysisId());
        if (!isExistThemeData) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u89c8\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AnalysisPreviewPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void dataInit() {
        if (this.checkExistMyAnalysisData()) {
            return;
        }
        try {
            String previewResultStr = AnalysisServiceHelper.getDataInitByMyAnlysis(this.getDmModelId(), this.getSourceModelId(), this.getMyAnalysisId());
            if (!StringUtils.isEmpty((String)previewResultStr)) {
                this.previewCallBack(ObjectSerialUtil.toByteSerialized((Object)previewResultStr));
            }
        }
        catch (Exception ex) {
            this.dataError(ex);
        }
    }

    private void allScreen() {
        this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_FULLSCREEN));
    }

    @Override
    public void customEvent(CustomEventArgs evt) {
        super.customEvent(evt);
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        try {
            AnalysisDesignConstants.CallBackType callBackType = AnalysisDesignConstants.CallBackType.valueOf(eventName);
            this.putCallBackType(callBackType, eventArgs);
            if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_DOSEARCH.toString())) {
                String myAnalysisId = this.getPageCache().get(KEY_MYANALYSISID);
                AnalysisServiceHelper.updateDynamicObject(eventArgs, myAnalysisId, "far_myanalysis");
                this.doSearch(eventArgs);
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return;
        }
    }

    @Override
    public Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("dmmodelid");
        return modelId;
    }

    private void initMyAnalysisId() {
        Long id = (Long)this.getFormCustomParam("myAnalysisId");
        this.getPageCache().put(KEY_MYANALYSISID, Objects.nonNull(id) ? id.toString() : "0");
    }

    private Long getMyAnalysisId() {
        Long templateId = null;
        String templateIdTemp = this.getPageCache().get(KEY_MYANALYSISID);
        templateId = StringUtils.isNotEmpty((String)templateIdTemp) && !Objects.equals("0", templateIdTemp) ? Long.valueOf(templateIdTemp) : (Long)this.getFormCustomParam(KEY_MYANALYSISID);
        return templateId;
    }

    @Override
    protected boolean dimMemberReturn(Object returnData) {
        if (!super.dimMemberReturn(returnData)) {
            return false;
        }
        JSONObject jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_DIM_F7);
        if (Objects.nonNull(jsonObject)) {
            String dimKey = jsonObject.getJSONObject("dim").getString("shortNumber");
            HashMap<String, Object> memberMap = new HashMap<String, Object>(3);
            memberMap.put("id", ((DynamicObject)returnData).getString("id"));
            memberMap.put("name", ((DynamicObject)returnData).getString("name"));
            memberMap.put("number", ((DynamicObject)returnData).getString("number"));
            AnalysisServiceHelper.saveMyAnlysisDefaultParam(this.getDmModelId(), this.getMyAnalysisId(), dimKey, memberMap);
        }
        return true;
    }

    private void changeView(boolean designView) {
        this.getView().setVisible(Boolean.valueOf(designView), new String[]{BTN_PREVIEW, BTN_ALLSCREEN, BTN_REFRESH});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAPQUERY});
    }
}

