/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.perm.permclass.PermClassCache;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.MainPage;
import kd.epm.far.formplugin.common.usermemory.UserMemoryUtil;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.pivot.IPivot;
import kd.epm.far.formplugin.faranalysis.pivot.dto.DataFormula;
import kd.epm.far.formplugin.faranalysis.pivot.uitls.PivotServiceHelper;

public abstract class AbsPivotPlugin
extends AbstractBaseDMFormPlugin
implements IPivot,
TreeNodeClickListener,
MainPage {
    public static final String APPID = "far";
    public static final String MODEL = "model";
    public static final String DISCMODEL = "discmodel";
    protected static final String CTL_TOOLBAR_AP = "toolbarap";
    protected static final String CTL_CUSTOMCONTROLAP = "customcontrolap";
    public static final String DATASET_BASEDATA = "dataset_basedata";
    public static final String POP_DATASET = "popdataset";
    protected static final String BTN_SAVE = "btn_save";
    protected static final String BTN_SAVENEW = "btn_savenew";
    protected static final String BTN_SAVEAS_CM = "btn_saveas_cm";
    protected static final String BTN_NEWSCHEME = "btn_newscheme";
    public static final String BTN_MOVE = "btn_move";
    public static final String BTN_CLEAR = "btn_clear";
    public static final String BTN_INFO = "btn_info";
    public static final String BTN_DEL = "btn_del";
    public static final String SCHEME = "scheme";
    public static final String DataSetDto_Key = "DataSetDto";
    public static final String MODELID = "modelId";
    public static final String DATASETID = "datasetId";
    public static final String SCHEMEID = "schemeId";
    public static final String CACHE_MODEL = "cache_model";
    protected static final String FAR_PIVOT_CATALOG = "catalog";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String NUMBER = "number";
    protected static final String PARENT = "parent";
    protected static final String PARENTID = "parentid";
    protected static final String SEQUENCE = "sequence";
    protected static final String TREE_LIST = "treelist";
    protected static final String FOCUS_NODEID = "focusnodeid";
    protected static final String TREEROOT = "TREEROOT";
    protected static final String TREENODEPERM = "treenodeperm";
    protected static final String CATCALOGTYPE = "catcalogType";
    protected static final String CATALOGNODE_CALLBACK = "CATALOGNODE_CALLBACK";
    protected static final String POPDATASET_CALLBACK = "POPDATASET_CALLBACK";
    protected static final String EDITINFOR_CALLBACK = "EDITINFOR_CALLBACK";
    protected static final String MOVE_CALLBACK = "MOVE_CALLBACK";
    protected static final String TREECLICK_CATALOG_EVT = "TREECLICK_CATALOG_EVT";
    protected static final String BTN_UP = "btn_up";
    protected static final String BTN_DOWN = "btn_down";
    protected static final String BTN_ADDNEW = "btn_addnew";
    protected static final String BTN_MODIFY = "btn_modify";
    protected static final String BTN_DELETE = "btn_delete";
    protected static final String BTN_NEWPOP = "btn_newpop";
    protected static final String BTN_NEWPOP1 = "btn_newpop1";
    protected static final String BTN_EDITPOP = "btn_editpop";
    protected static final String BTN_DELPOP = "btn_delpop";
    protected static final String BTN_REFRESHLIST = "btn_refreshlist";
    protected static final String BTN_OPENPARAM = "btn_openparam";
    protected static final String BTN_COLLAPSEPARAM = "btn_collapseparam";
    protected static final String BTN_PREVIEW = "btn_preview";
    protected static final String BTN_UPDATE = "btn_update";
    protected static final String DELETECATALOG_COMFIRM = "deletecatalog_comfirm";
    protected Map<String, Integer> catalogList = Maps.newLinkedHashMapWithExpectedSize((int)12);
    public static final String ALL_DIM_MAP_CACHE = "allDimMap";
    protected static final String DIMF7MAP = "dimf7map";
    protected static final String DIMENSION_NUMBER_MAP_CACHE = "dimension_number_map_cache";
    protected static final String ONLY_READNODES = "ONLY_READNODES";
    public static final String CHANGESCHEME = "CHANGESCHEME";
    public static final String CHANGEDATASET_OPERATE = "CHANGEDATASET_OPERATE";
    public static final String MODEL_TYPE = "model_type";
    public static final String CLEAR_DATASET = "clear_dataset";
    protected Set<String> noControlButtons = new HashSet<String>(Arrays.asList("btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down", "btn_newpop", "btn_newpop1", "btn_delpop", "btn_editpop"));
    protected Set<String> paramsButtons = new HashSet<String>(Arrays.asList("btn_openparam", "btn_collapseparam", "btn_preview", "btn_update"));
    protected Set<String> popButtons = new HashSet<String>(Arrays.asList("btn_newpop", "btn_delpop", "btn_editpop"));

    @Override
    public void initialize() {
        this.resetAppId();
        super.initialize();
        this.addClickListeners();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tview = (TreeView)this.getControl(FAR_PIVOT_CATALOG);
        tview.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initModelHandler();
        super.afterCreateNewData(e);
        this.initModel();
        this.initNode();
        this.handlerView();
        this.resetStatus(true);
        this.collapseParamFlex(false);
        this.resetPopDataSetStatus(true);
        this.refreshTreeView();
        this.evtPageInit();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (!this.checkModel()) {
            return;
        }
        String nodeId = this.getPageCache().get(FOCUS_NODEID);
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6587\u4ef6\u5939\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractAnalysisTreePlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.noControlButtons.contains(c.getKey().toLowerCase(Locale.ENGLISH)) && this.checkOnlyRead(nodeId, true)) {
            return;
        }
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btn_refreshlist": {
                this.refreshTreeView();
                break;
            }
            case "btn_addnew": {
                this.newCatalog(nodeId, true);
                break;
            }
            case "btn_delete": {
                if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AbsPivotPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u5206\u6790\u65b9\u6848\u5206\u7c7b\u5417\uff1f", (String)"PivotSchemeListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETECATALOG_COMFIRM));
                break;
            }
            case "btn_modify": {
                if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"AbsPivotPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.newCatalog(nodeId, false);
                break;
            }
            case "btn_up": 
            case "btn_down": {
                this.downAndUpMember(nodeId, c.getKey().toLowerCase(Locale.ENGLISH));
                break;
            }
            case "btn_newpop": 
            case "btn_newpop1": {
                this.openPopConfirm();
                break;
            }
            case "btn_editpop": {
                this.openPop(false);
                break;
            }
            case "btn_delpop": {
                this.delPopConfirm();
                break;
            }
        }
    }

    @Override
    public String getModelSign() {
        return MODEL;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.cacheTreeNode(evt);
        this.getView().getPageCache().remove(TREECLICK_CATALOG_EVT);
        TreeView t = (TreeView)evt.getSource();
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_MODIFY, BTN_DELETE, BTN_UP, BTN_DOWN});
        Map focusNode = t.getTreeState().getFocusNode();
        if (Objects.nonNull(focusNode) && Objects.nonNull(focusNode.get(PARENTID)) && (StringUtils.equals((CharSequence)"0", (CharSequence)focusNode.get(PARENTID).toString()) || StringUtils.equals((CharSequence)"", (CharSequence)focusNode.get(PARENTID).toString()))) {
            this.changeModelAndStatus();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (DELETECATALOG_COMFIRM.equals(callBackId)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.deleteCatalogNode();
            }
        } else if (BTN_NEWPOP.equals(callBackId) || BTN_NEWPOP1.equals(callBackId)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.openPop(true);
            }
        } else if (BTN_DELPOP.equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.delPivotPop();
            this.resetStatus(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_MODIFY, BTN_DELETE, BTN_UP, BTN_DOWN});
            this.treeClickNodeScheme(this.getCurSchemeId().toString());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (Objects.nonNull(returnData)) {
            switch (actionId) {
                case "CATALOGNODE_CALLBACK": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractAnalysisPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    this.refreshTreeView();
                    break;
                }
                case "POPDATASET_CALLBACK": {
                    this.savePopDto((DatasetDto)SerializationUtils.fromJsonString((String)returnData.toString(), DatasetDto.class));
                    this.getView().getPageCache().put(CLEAR_DATASET, "1");
                    this.getModel().setValue(DATASET_BASEDATA, null);
                    this.treeClickNodeScheme(this.getCurSchemeId().toString());
                    break;
                }
            }
        }
    }

    @Override
    public void checkPerm(String opkey, String entityId) {
        if (this.isCM()) {
            return;
        }
        super.checkPerm(opkey, entityId);
    }

    private void initModel() {
        Long modelId = this.getPivotModelId();
        this.getModel().setValue(MODEL, (Object)modelId);
        this.getPageCache().put("dmmodelid", String.valueOf(modelId));
        this.cacheModelMemory(modelId);
    }

    public boolean onlyAnalysis() {
        return false;
    }

    public void handlerView() {
        if (this.isCM()) {
            if (this.onlyAnalysis()) {
                this.getView().setEnable(Boolean.valueOf(!this.onlyAnalysis()), new String[]{MODEL});
                this.getView().setVisible(Boolean.valueOf(!this.onlyAnalysis()), new String[]{"flexpanelap1"});
                this.getView().setVisible(Boolean.valueOf(!this.onlyAnalysis()), new String[]{SCHEME});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEWSCHEME, BTN_SAVE, BTN_INFO, BTN_MOVE, BTN_DEL, BTN_SAVEAS_CM});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVEAS_CM});
            }
            this.getView().setVisible(Boolean.valueOf(this.onlyAnalysis()), new String[]{"btn_refresh"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SAVEAS_CM});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_refresh"});
        }
    }

    public void treeClickNodeScheme(String schemeId) {
    }

    @Override
    public AbstractFormPlugin getPivotPlugin() {
        return this;
    }

    @Override
    public String getModelTypeSign() {
        return MODEL_TYPE;
    }

    @Override
    public ApplicationTypeEnum getAppType() {
        String bizAppId = this.getBizAppId();
        return StringUtils.isEmpty((CharSequence)bizAppId) ? ApplicationTypeEnum.FAR : ApplicationTypeEnum.getEnumByNumber((String)bizAppId);
    }

    protected Long getPivotModelId() {
        Long modelId = this.getDMModelId();
        if (this.isCM() && this.onlyAnalysis()) {
            modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODELID);
        }
        return modelId;
    }

    protected void cacheModelMemory(Long modelId) {
        if (Objects.nonNull(modelId) && modelId != 0L) {
            ApplicationTypeEnum applicationType = this.getApplicationType();
            String appSign = applicationType.getOIndex();
            UserMemoryUtil.saveUserMemory(this.getUserId(), modelId, appSign);
        }
    }

    private void initNode() {
        long modelId = this.getCurModelId();
        if (modelId == 0L) {
            return;
        }
        PivotServiceHelper.addCatalogRoot(modelId, this.getModelEntity());
        if (this.isCM()) {
            PivotServiceHelper.addImprovisation(modelId);
        }
    }

    public void initPivotData() {
    }

    private void initTree() {
        if (!this.checkModel()) {
            return;
        }
        long modelId = this.getCurModelId();
        this.initNode();
        TreeNode catalog = new TreeNode();
        String nodeId = this.getPageCache().get(FOCUS_NODEID);
        String algoKey = this.getClass().getName();
        String selectFields = this.getSelectFields();
        QFilter fmodelId = new QFilter(MODEL, "=", (Object)modelId).and(MODEL_TYPE, "=", (Object)this.getModelEntity());
        QFilter[] filters = new QFilter[]{fmodelId};
        String orderBys = SEQUENCE;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)"far_pivotcatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        PermClassCache.cachePermission((IPageCache)this.getPageCache(), (String)"far_pivotcatalog", (String)String.valueOf(modelId));
        this.cacheAllOnlyReadNodes();
        List<Long> noPerms = this.getNoPermIds("far_pivotcatalog", modelId, RequestContext.get().getUserId());
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(16);
        this.getPageCache().remove(FOCUS_NODEID);
        this.loadTreeNode(modelId, dcs, noPerms, treeList);
        String headid = this.initRootNode(catalog);
        this.getPageCache().put(TREE_LIST, SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNodeDm((TreeNode)catalog, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)catalog);
        if (StringUtils.isEmpty((CharSequence)catalog.getId())) {
            return;
        }
        TreeView tree = (TreeView)this.getControl(FAR_PIVOT_CATALOG);
        tree.addNode(catalog);
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)catalog));
        TreeNode fo = this.findFocusNodeById(nodeId, catalog);
        if (fo == null) {
            fo = catalog;
        } else {
            this.getPageCache().put(FOCUS_NODEID, fo.getId());
        }
        tree.focusNode(fo);
    }

    private void loadTreeNode(long modelId, DynamicObjectCollection dcs, List<Long> noPerms, List<Map<String, String>> treeList) {
        HashSet<Long> ids = new HashSet<Long>(12);
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                if (noPerms.contains(task.getLong(ID))) continue;
                ids.add(task.getLong(ID));
                this.buildTreeNodeList(treeList, task, true);
            }
        }
        QFilter qFilter = new QFilter(MODEL, "=", (Object)modelId);
        qFilter.and(FAR_PIVOT_CATALOG, "in", ids).and(MODEL_TYPE, "=", (Object)this.getModelEntity());
        Collection schemes = BusinessDataServiceHelper.loadFromCache((String)"far_pivot_scheme", (String)"id,number,name,catalog", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc").values();
        List<Long> noPermScheme = this.getNoPermIds("far_pivot_scheme", modelId, RequestContext.get().getUserId());
        if (!schemes.isEmpty()) {
            for (DynamicObject scheme : schemes) {
                if (noPermScheme.contains(scheme.getLong(ID))) continue;
                this.buildTreeNodeList(treeList, scheme, false);
            }
        }
    }

    private String initRootNode(TreeNode catalog) {
        String headid = "0";
        String headName = ResManager.loadKDString((String)"\u6570\u636e\u5206\u6790\u65b9\u6848", (String)"AbsPivotPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]);
        catalog.setId(headid);
        catalog.setIcon("kdfont kdfont-wenjianjia");
        this.getPageCache().put(FOCUS_NODEID, headid);
        this.getPageCache().put("headnodeid", headid);
        catalog.setParentid("");
        catalog.setType("default");
        catalog.setText(headName);
        return headid;
    }

    private void buildTreeNodeList(List<Map<String, String>> treeList, DynamicObject dc, boolean isCatalog) {
        HashMap<String, String> memberMap = new HashMap<String, String>(12);
        memberMap.put(ID, dc.getString(ID));
        memberMap.put(NUMBER, dc.getString(NUMBER));
        if (isCatalog) {
            memberMap.put(NAME, dc.getString(NAME));
            memberMap.put(PARENTID, dc.getString(PARENT));
            memberMap.put("type", FAR_PIVOT_CATALOG);
        } else {
            memberMap.put(NAME, dc.getLocaleString(NAME).getLocaleValue());
            memberMap.put(PARENTID, ((DynamicObject)dc.get(FAR_PIVOT_CATALOG)).getString(ID));
            memberMap.put("icon", "kdfont kdfont-qingfenxibaobiao");
            memberMap.put("type", SCHEME);
        }
        treeList.add(memberMap);
    }

    public void refreshTreeView() {
        TreeView Tree = (TreeView)this.getControl(FAR_PIVOT_CATALOG);
        Tree.deleteAllNodes();
        this.initTree();
    }

    public void callBackPreviewPivotData(List<Map> result) {
    }

    public void refreshF7Panel() {
    }

    public void evtPageInit() {
        this.evtToPivotTable(null, AnalysisDesignConstants.PropsDataType.PIVOT_PAGE_INIT);
    }

    protected void evtToPivotTable(Map<String, Object> params, AnalysisDesignConstants.PropsDataType evtName) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)evtName);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        dataObj.put("i18n", AnalysisServiceHelper.getI18n());
        if (Objects.nonNull(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                dataObj.put(key, value);
            }
        }
        this.SendToVue(dataObj);
    }

    protected void SendToVue(Object data) {
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        custom.setData(data);
    }

    protected void addClickListeners() {
        this.addClickListeners(BTN_ADDNEW, BTN_DELETE, BTN_MODIFY, BTN_UP, BTN_DOWN, BTN_OPENPARAM, BTN_COLLAPSEPARAM, BTN_PREVIEW, BTN_UPDATE, BTN_NEWPOP, BTN_NEWPOP1, BTN_EDITPOP, BTN_DELPOP, BTN_REFRESHLIST);
    }

    protected void newCatalog(String nodeId, boolean isAddNew) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(MODEL, this.getPageCache().get("dmmodelid"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CATALOGNODE_CALLBACK);
        if (isAddNew) {
            params.put(PARENT, "0");
            params.put("type", "add");
            this.showForm("far_pivotcatalog", params, closeCallBack, ShowType.Modal, 0L);
        } else {
            long id = Long.parseLong(nodeId);
            params.put(PARENT, "0");
            params.put("type", "edit");
            this.showForm("far_pivotcatalog", params, closeCallBack, ShowType.Modal, id);
        }
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, long id) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        params.put("entity", "far_pivotcatalog");
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        }
        if (params.size() > 0) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    protected String getSelectFields() {
        return "id,name,number,parent";
    }

    private TreeNode findFocusNodeById(String id, TreeNode tree) {
        if (StringUtils.isEmpty((CharSequence)id) || tree == null) {
            return null;
        }
        if (id.equals(tree.getId())) {
            return tree;
        }
        if (tree.getChildren() != null) {
            for (TreeNode c : tree.getChildren()) {
                TreeNode fc = this.findFocusNodeById(id, c);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    public List<Long> getNoPermIds(String entityName, Long modelId, String userId) {
        ArrayList noPermIds = Lists.newArrayList();
        noPermIds.addAll(PermClassEntityHelper.getDiscPermissionMap((String)entityName, (Long)modelId, (Long)LongUtil.toLong((Object)userId), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1"));
        return noPermIds;
    }

    protected void cacheAllOnlyReadNodes() {
        ArrayList noPermIds = Lists.newArrayList();
        List<Long> onlyReadCatalogIds = this.getOnlyReadIds("far_pivotcatalog", this.getCurModelId(), RequestContext.get().getUserId());
        List<Long> onlyReadSchemeIds = this.getOnlyReadIds("far_pivot_scheme", this.getCurModelId(), RequestContext.get().getUserId());
        noPermIds.addAll(onlyReadCatalogIds);
        noPermIds.addAll(onlyReadSchemeIds);
        this.getView().getPageCache().put(ONLY_READNODES, this.toByteSerialized(noPermIds));
    }

    protected boolean checkOnlyRead(String id, boolean displayTip) {
        List noPermIds;
        String permS = this.getView().getPageCache().get(ONLY_READNODES);
        if (StringUtils.isNotEmpty((CharSequence)permS) && (noPermIds = (List)this.deSerializedBytes(permS)).contains(Long.parseLong(id))) {
            if (displayTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"AbsPivotPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    public List<Long> getOnlyReadIds(String entityName, Long modelId, String userId) {
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)entityName, (Long)modelId, (Long)LongUtil.toLong((Object)userId), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"2"));
        return readOnlyPerms;
    }

    protected void resetAppId() {
        this.getView().getFormShowParameter().setAppId(this.getBizAppId());
    }

    public boolean checkModel() {
        if (Objects.isNull(this.getModel().getValue(MODEL))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean checkDataSet(boolean showTip) {
        if (Objects.isNull(this.getModel().getValue(DATASET_BASEDATA)) && (Objects.isNull(this.getModel().getValue(POP_DATASET)) || StringUtils.isEmpty((CharSequence)this.getModel().getValue(POP_DATASET).toString()))) {
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6216\u65b0\u589e\u6570\u636e\u96c6\u3002", (String)"PivotViewPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public boolean checkPopDataSet(boolean showTip) {
        if (Objects.isNull(this.getModel().getValue(POP_DATASET)) || StringUtils.isEmpty((CharSequence)this.getModel().getValue(POP_DATASET).toString())) {
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6216\u65b0\u589e\u6570\u636e\u96c6\u3002", (String)"PivotViewPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public boolean checkScheme(boolean showTip) {
        if (Objects.isNull(this.getModel().getValue(SCHEME))) {
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u65b9\u6848\u3002", (String)"PivotViewPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public void checkDimsMap(Object allStr) {
        if (Objects.isNull(allStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u4f53\u7cfb\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"DataSetPreviewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    protected void downAndUpMember(String nodeId, String key) {
        if (nodeId.equals(this.getPageCache().get("headnodeid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"AbsPivotPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(FAR_PIVOT_CATALOG);
        TreeView.TreeState treeState = treeView.getTreeState();
        List selectNodeIds = treeState.getSelectedNodeId();
        if (selectNodeIds == null || selectNodeIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u5206\u6790\u5206\u7c7b\u3002", (String)"AbsPivotPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectedNodeId = (String)selectNodeIds.get(selectNodeIds.size() - 1);
        if (BTN_UP.equals(key)) {
            this.moveCatalogUp(selectedNodeId, "far_pivotcatalog");
        } else if (BTN_DOWN.equals(key)) {
            this.moveCatalogDown(selectedNodeId, "far_pivotcatalog");
        }
    }

    protected void moveCatalogUp(String id, String formId) {
        DynamicObject dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        if (seq == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbsPivotPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            String parentId = "0";
            QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getCurModelId());
            qFilter.and(PARENT, "=", (Object)0L).and(SEQUENCE, "<", (Object)dyTree.getInt(SEQUENCE));
            QFilter[] filters = new QFilter[]{qFilter};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence desc", (int)1);
            if (dcs != null && dcs.size() > 0) {
                AnalysisOpLogParam logParam = this.getSingleLogParam(dyTree);
                logParam.buildOpName(OperationName.CATALOG_MOVE_UP);
                try {
                    DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get(ID), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                    int seq2 = dyTree2.getInt(SEQUENCE);
                    dyTree2.set(SEQUENCE, (Object)seq);
                    dyTree.set(SEQUENCE, (Object)seq2);
                    SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                    ((TreeView)this.getControl(FAR_PIVOT_CATALOG)).deleteAllNodes();
                    this.initTree();
                    TreeNode node = new TreeNode(parentId, id, dyTree.getString(NAME));
                    ((TreeView)this.getControl(FAR_PIVOT_CATALOG)).focusNode(node);
                    logParam.buildOpResult(OperationResult.SUCCESS);
                }
                catch (Exception e) {
                    logParam.buildOpResult(OperationResult.FAILURE);
                    throw e;
                }
                finally {
                    AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbsPivotPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void moveCatalogDown(String id, String formId) {
        DynamicObject dyTree = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
        int seq = this.getDSeq(Long.parseLong(id), formId);
        String parentId = "0";
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getCurModelId());
        qFilter.and(PARENT, "=", (Object)0L).and(SEQUENCE, ">", (Object)dyTree.getInt(SEQUENCE));
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)"id,sequence", (QFilter[])filters, (String)"sequence asc", (int)1);
        if (dcs != null && dcs.size() > 0) {
            AnalysisOpLogParam logParam = this.getSingleLogParam(dyTree);
            try {
                logParam.buildOpName(OperationName.CATALOG_MOVE_DOWN);
                DynamicObject dyTree2 = BusinessDataReader.loadSingle((Object)((DynamicObject)dcs.get(0)).get(ID), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId));
                int seq2 = dyTree2.getInt(SEQUENCE);
                dyTree2.set(SEQUENCE, (Object)seq);
                dyTree.set(SEQUENCE, (Object)seq2);
                SaveServiceHelper.save((IDataEntityType)dyTree.getDataEntityType(), (Object[])new Object[]{dyTree, dyTree2});
                ((TreeView)this.getControl(FAR_PIVOT_CATALOG)).deleteAllNodes();
                this.initTree();
                TreeNode node = new TreeNode(parentId, id, dyTree.getString(NAME));
                ((TreeView)this.getControl(FAR_PIVOT_CATALOG)).focusNode(node);
                logParam.buildOpResult(OperationResult.SUCCESS);
            }
            catch (Exception e) {
                logParam.buildOpResult(OperationResult.FAILURE);
                throw e;
            }
            finally {
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbsPivotPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    protected int getDSeq(long id, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter(ID, "=", (Object)id)};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)formId, (String)SEQUENCE, (QFilter[])filters, (String)SEQUENCE);
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getInt(SEQUENCE);
        }
        return 1;
    }

    private void deleteCatalogNode() {
        AnalysisOpLogParam logParam = null;
        try {
            if (this.isOk()) {
                Map<String, Object> focusNode = this.getCurTreeNode();
                String catalogId = focusNode.get(ID).toString();
                DynamicObject dyTree = BusinessDataReader.loadSingle((Object)LongUtil.toLong((Object)catalogId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"far_pivotcatalog"));
                logParam = this.getSingleLogParam(dyTree);
                logParam.buildOpName(OperationName.DELETE_SCHEME_CATALOG);
                int delete = DeleteServiceHelper.delete((String)"far_pivotcatalog", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)Long.parseLong(catalogId))});
                if (delete > 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractTemplateTreePlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    this.refreshTreeView();
                    logParam.buildOpResult(OperationResult.SUCCESS);
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"AbsPivotPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    logParam.buildOpResult(OperationResult.FAILURE);
                }
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
        }
        catch (Exception e) {
            if (Objects.nonNull(logParam)) {
                logParam.buildOpResult(OperationResult.FAILURE);
                AnalysisOpLogHelper.writeOperationLog(logParam);
            }
            throw e;
        }
    }

    private boolean isOk() {
        Map<String, Object> focusNode = this.getCurTreeNode();
        if (Objects.isNull(focusNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7c7b\u8282\u70b9\u3002", (String)"AbsPivotPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        String catalogId = focusNode.get(ID).toString();
        if (catalogId.equals(this.getPageCache().get("headnodeid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AbsPivotPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"far_pivotcatalog", (String)NUMBER);
        if (Objects.nonNull(dy) && StringUtils.equals((CharSequence)dy.getString(NUMBER), (CharSequence)"default")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u6790\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AbsPivotPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        long modelId = this.getModelId();
        QFilter filter = new QFilter(MODEL, "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        int count = QueryServiceHelper.queryOne((String)"far_pivotcatalog", (String)"count(id) num", (QFilter[])new QFilter[]{filter}).getInt("num");
        if (count == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u5206\u7c7b\u3002", (String)"AbsPivotPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean catalog = QueryServiceHelper.exists((String)"far_pivot_scheme", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId).and(FAR_PIVOT_CATALOG, "=", (Object)Long.parseLong(catalogId))});
        if (catalog) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7c7b\u4e0b\u5b58\u5728\u65b9\u6848\uff0c\u65e0\u6cd5\u5220\u9664\u5f53\u524d\u5206\u7c7b\u8282\u70b9\u3002", (String)"AbsPivotPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void treeClickCatalog() {
        this.resetStatus(true);
        this.clearDatasetAndScheme();
        this.collapseParamFlex(false);
    }

    protected void resetStatus(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"load"});
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{BTN_NEWSCHEME});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{BTN_SAVE, BTN_INFO, BTN_MOVE, BTN_CLEAR, BTN_DEL});
        this.getView().setVisible(Boolean.valueOf(this.isCM() && this.onlyAnalysis() ? false : !flag), new String[]{"paramsflex"});
        this.getView().setVisible(Boolean.valueOf(this.isCM() ? false : !flag), new String[]{DATASET_BASEDATA});
        this.handlerView();
    }

    protected void clearDatasetAndScheme() {
        this.getModel().setValue(DATASET_BASEDATA, null);
        this.getModel().setValue(SCHEME, null);
    }

    public void collapseParamFlex(boolean visiable) {
        this.getView().setVisible(Boolean.valueOf(this.onlyAnalysis() ? false : visiable), new String[]{"paramflex"});
        this.getView().setVisible(Boolean.valueOf(this.onlyAnalysis() ? false : visiable), new String[]{BTN_COLLAPSEPARAM});
        this.getView().setVisible(Boolean.valueOf(this.onlyAnalysis() ? false : !visiable), new String[]{BTN_OPENPARAM});
    }

    protected Map<String, Object> getCurTreeNode() {
        TreeView tview = (TreeView)this.getControl(FAR_PIVOT_CATALOG);
        String nodeId = this.getPageCache().get(FOCUS_NODEID);
        String treeRoot = this.getPageCache().get(TREEROOT);
        if (StringUtils.isEmpty((CharSequence)treeRoot) || StringUtils.isEmpty((CharSequence)nodeId)) {
            return null;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeNode focusNodeById = this.findFocusNodeById(nodeId, root);
        if (focusNodeById != null) {
            tview.focusNode(focusNodeById);
        }
        return tview.getTreeState().getFocusNode();
    }

    public boolean isSchemeNode() {
        Map<String, Object> curTreeNode = this.getCurTreeNode();
        return Objects.nonNull(curTreeNode) && Objects.nonNull(curTreeNode.get(PARENTID)) && StringUtils.isNotEmpty((CharSequence)curTreeNode.get(PARENTID).toString()) && !StringUtils.equals((CharSequence)"0", (CharSequence)curTreeNode.get(PARENTID).toString());
    }

    public Long getCurModelId() {
        return Objects.nonNull(this.getModel().getValue(MODEL)) ? ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID) : 0L;
    }

    public Long getCurDataSetId() {
        return Objects.nonNull(this.getModel().getValue(DATASET_BASEDATA)) ? ((DynamicObject)this.getModel().getValue(DATASET_BASEDATA)).getLong(ID) : 0L;
    }

    public Long getCurSchemeId() {
        return Objects.nonNull(this.getModel().getValue(SCHEME)) ? ((DynamicObject)this.getModel().getValue(SCHEME)).getLong(ID) : 0L;
    }

    public Long getCatalogParentId() {
        Map<String, Object> curTreeNode = this.getCurTreeNode();
        Long catalogId = 0L;
        if (Objects.nonNull(curTreeNode)) {
            String id = curTreeNode.get(ID).toString();
            if (StringUtils.equals((CharSequence)"0", (CharSequence)id)) {
                List treeList;
                String treeListStr = this.getPageCache().get(TREE_LIST);
                if (StringUtils.isNotEmpty((CharSequence)treeListStr) && !(treeList = (List)SerializationUtils.fromJsonString((String)treeListStr, List.class)).isEmpty()) {
                    Map node = (Map)treeList.get(0);
                    catalogId = Long.parseLong(node.get(ID).toString());
                }
            } else {
                catalogId = StringUtils.equals((CharSequence)"0", (CharSequence)curTreeNode.get(PARENTID).toString()) ? Long.valueOf(Long.parseLong(curTreeNode.get(ID).toString())) : Long.valueOf(Long.parseLong(curTreeNode.get(PARENTID).toString()));
            }
        }
        return catalogId;
    }

    protected void cacheTreeNode(TreeNodeEvent evt) {
        this.getPageCache().put(FOCUS_NODEID, evt.getNodeId().toString());
        this.getPageCache().put(PARENT, evt.getParentNodeId().toString());
    }

    protected void changeModelAndStatus() {
        this.getPageCache().put(TREECLICK_CATALOG_EVT, "1");
        this.resetStatus(true);
        this.clearDatasetAndScheme();
        this.collapseParamFlex(false);
        this.evtPageInit();
    }

    public void updateFormalTips(String tipStr) {
        Label formalTip = (Label)this.getView().getControl("formal");
        Tips tips = new Tips();
        tips.setContent(StringUtils.isNotEmpty((CharSequence)tipStr) ? new LocaleString(tipStr) : new LocaleString(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u96c6\u6682\u4e0d\u652f\u6301\u663e\u793a\u516c\u5f0f\u3002", (String)"AbsPivotPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0])));
        tips.setType("text");
        formalTip.addTips(tips);
        this.getView().updateView();
    }

    public void loadDataSetModel(Long schemeId) {
        this.getModel().setValue(POP_DATASET, null);
        if (this.isCM() && this.onlyAnalysis()) {
            this.getModel().setValue(POP_DATASET, (Object)ResManager.loadKDString((String)"\u5373\u5e2d\u5206\u6790", (String)"PivotServiceHelper_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject dy = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"number,name,dataset,dataparams", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)schemeId)});
            if (dy != null) {
                this.getModel().setValue(DATASET_BASEDATA, dy.getLong("dataset") == 0L ? null : dy.get("dataset"));
                DataFormula dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class);
                if (dataparams != null && dataparams.getDatasetDto() != null) {
                    String name = dataparams.getDatasetDto().getNameStr();
                    this.getModel().setValue(POP_DATASET, (Object)(StringUtils.isEmpty((CharSequence)name) ? dy.getString(NAME) : name));
                }
            }
        }
    }

    public void resetPopDataSetStatus(boolean flag) {
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{BTN_NEWPOP});
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{BTN_DELPOP, BTN_EDITPOP});
        this.resetDataSetVisible();
    }

    public void resetDataSetVisible() {
        if (this.isFAR()) {
            Object pop = this.getModel().getValue(POP_DATASET);
            boolean hasPop = pop != null && !StringUtils.isEmpty((CharSequence)pop.toString());
            this.getView().setVisible(Boolean.valueOf(hasPop), new String[]{POP_DATASET});
            this.getView().setVisible(Boolean.valueOf(!hasPop), new String[]{DATASET_BASEDATA, BTN_NEWPOP1});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DATASET_BASEDATA, BTN_NEWPOP1});
        }
    }

    public void openPopConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_NEWPOP);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u65b0\u589e\u5f39\u51fa\u5f0f\u6570\u636e\u96c6\u540e\u4f1a\u8986\u76d6\u5168\u5c40\u6570\u636e\u96c6\uff0c\u5220\u9664\u540e\u624d\u53ef\u4ee5\u91cd\u65b0\u9009\u62e9\u5168\u5c40\u6570\u636e\u96c6\u3002", (String)"AbsPivotPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void delPopConfirm() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_DELPOP);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u65b9\u6848\u5f39\u51fa\u5f0f\u6570\u636e\u96c6\u540e\u65e0\u6cd5\u627e\u56de\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u6570\u636e\u96c6\u5417\uff1f", (String)"AbsPivotPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void openPop(boolean isAddNew) {
        DataFormula dataparams;
        DynamicObject dy;
        if (!isAddNew && !this.checkPopDataSet(true)) {
            return;
        }
        if (!(isAddNew || (dy = BusinessDataServiceHelper.loadSingle((String)"far_pivot_scheme", (String)"dataparams", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.getCurSchemeId())})) == null || (dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class)) != null && dataparams.isAllowEdit())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5f39\u51fa\u5f0f\u6570\u636e\u96c6\u7f16\u8f91\u3002", (String)"AbsPivotPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkModel() && this.checkScheme(true)) {
            FormShowParameter pivotPopForm = PivotServiceHelper.getPivotPopForm(this.getCurModelId(), this.getCurSchemeId(), this.isFAR());
            pivotPopForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, POPDATASET_CALLBACK));
            this.getView().showForm(pivotPopForm);
        }
    }

    public void delPivotPop() {
        if (this.checkModel() && this.checkScheme(true) && this.checkPopDataSet(true)) {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"far_pivot_scheme", (String)"pivotfields,congfigfields,dataparams", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.getCurSchemeId())});
            if (dy == null) {
                return;
            }
            dy.set("dataparams", null);
            dy.set("pivotfields", null);
            dy.set("congfigfields", null);
            SaveServiceHelper.save((IDataEntityType)dy.getDataEntityType(), (Object[])new Object[]{dy});
        }
    }

    public void savePopDto(DatasetDto dto) {
        if (dto == null) {
            return;
        }
        if (!this.checkModel() && !this.checkScheme(true)) {
            return;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"far_pivot_scheme", (String)"pivotfields,congfigfields,dataset,dims,dataparams", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)this.getCurSchemeId())});
        if (dy != null) {
            DataFormula dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class);
            if (dataparams != null) {
                dataparams.setDatasetDto(dto);
            } else {
                dataparams = new DataFormula();
                dataparams.setAllowEdit(true);
                dataparams.setDatasetDto(dto);
            }
            dy.set("dataparams", (Object)JSONObject.toJSONString((Object)dataparams));
            dy.set("dataset", null);
            dy.set("dims", null);
            dy.set("pivotfields", null);
            dy.set("congfigfields", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        }
        this.getView().getPageCache().remove("dimsMember");
    }

    private AnalysisOpLogParam getSingleLogParam(DynamicObject catalog) {
        String numberField = ApplicationTypeEnum.FAR.getAppnum().equals(this.getView().getFormShowParameter().getAppId()) ? NUMBER : "shownumber";
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        String schemeNumber = catalog.getString(NUMBER);
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.PIVOT_TABLE).buildFormNumber("far_pivotcatalog").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString(numberField), schemeNumber});
    }
}

