/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;

public class PivotSchemeListPlugin
extends AbstractBaseDMListPlugin
implements HyperLinkClickListener {
    public static final String MODEL = "model";
    private static final String MODELID = "modelId";
    private static final String DATASETID = "datasetId";
    private static final String SCHEMEID = "schemeId";
    private static final String DATASET = "dataset";
    public static final String BILLLISTAP = "billlistap";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_DELETE = "btn_delete";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_CANCEL, BTN_OK, BTN_DELETE);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
        this.refreshBillList();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_CANCEL.equals(key)) {
            this.getView().close();
        }
        if (BTN_OK.equals(key)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ArrayList ids = new ArrayList(10);
            billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
            if (!ids.isEmpty()) {
                this.getView().returnDataToParent(ids.get(0));
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"PivotSchemeListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        if (BTN_DELETE.equals(key)) {
            this.showDeleteConfirm();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (BTN_DELETE.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteScheme();
            this.refreshBillList();
        }
    }

    private void initData() {
        Object modelId = this.getView().getFormShowParameter().getCustomParam(MODELID);
        Object dataSetId = this.getView().getFormShowParameter().getCustomParam(DATASETID);
        Object schemeId = this.getView().getFormShowParameter().getCustomParam(SCHEMEID);
        this.getPageCache().put("dmmodelid", Objects.isNull(modelId) ? null : modelId.toString());
        this.getPageCache().put(DATASETID, Objects.isNull(dataSetId) ? null : dataSetId.toString());
        this.getPageCache().put(SCHEMEID, Objects.isNull(schemeId) ? null : schemeId.toString());
    }

    private void showDeleteConfirm() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_DELETE);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u65b9\u6848\u5417\uff1f", (String)"PivotSchemeListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"PivotSchemeListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void deleteScheme() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ArrayList ids = new ArrayList(10);
        billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
        String schemeId = this.getPageCache().get(SCHEMEID);
        if (Objects.nonNull(schemeId) && schemeId.equals(ids.get(0).toString())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u4f7f\u7528\u65b9\u6848\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PivotSchemeListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ids.isEmpty()) {
            DeleteServiceHelper.delete((String)"far_pivot_scheme", (QFilter[])new QFilter("id", "in", ids).toArray());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PivotSchemeListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Object pkId = list.getFocusRowPkId();
        this.getView().returnDataToParent(pkId);
        this.getView().close();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(this.setBillListFilter());
        billList.setFilterParameter(fp);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter setBillListFilter() {
        if (this.getPageCache().get("dmmodelid") == null) {
            return new QFilter(MODEL, "=", (Object)-1);
        }
        Long modelId = Long.valueOf(this.getPageCache().get("dmmodelid"));
        QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
        Long dataSetId = Objects.isNull(this.getPageCache().get(DATASETID)) ? Long.valueOf(-1L) : Long.valueOf(this.getPageCache().get(DATASETID));
        filter.and(DATASET, "=", (Object)dataSetId);
        return filter;
    }
}

