/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.faranalysis.pivot.IPivot;
import kd.epm.far.formplugin.faranalysis.pivot.dto.DataFormula;
import kd.epm.far.formplugin.faranalysis.pivot.uitls.PivotServiceHelper;

public class PivotTableSchemePlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener,
IPivot {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(PivotTableSchemePlugin.class);
    private static final String BTN_OK = "btn_ok";
    private static final String MODELID = "modelId";
    protected static final String PARENTID = "parentid";
    private static final String DATASETID = "datasetId";
    private static final String MODEL = "model";
    private static final String DATASET = "dataset";
    private static final String SAVE = "save";
    private static final String OPERATE_TYPE = "OPERATE_TYPE";
    private static final String ADD_NEW = "ADD_NEW";
    public static final String POP_DATASET = "popdataset";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String ENTITY_PIVOT_SCHEME = "far_pivot_scheme";
    public static final String SCHEMEID = "schemeId";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
        BasedataEdit catalog = (BasedataEdit)this.getControl("catalog");
        catalog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Object modelId = this.getView().getFormShowParameter().getCustomParam(MODELID);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)(Objects.nonNull(modelId) ? modelId : LongUtil.toLong((Object)this.getModelId())), (String)(ApplicationTypeEnum.CM == this.getAppType() ? MODEL : FIDMMODEL), (String)this.getView().getFormShowParameter().getAppId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object modelId = this.getView().getFormShowParameter().getCustomParam(MODELID);
        PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)(Objects.nonNull(modelId) ? modelId : LongUtil.toLong((Object)this.getModelId())));
        this.getModel().setDataChanged(false);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != null && OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initModelHandler();
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != null && OperationStatus.EDIT.equals((Object)status)) {
            return;
        }
        Object parentId = this.getView().getFormShowParameter().getCustomParam(PARENTID);
        this.getModel().setValue("catalog", parentId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && SAVE.equals(operateKey = ((FormOperate)args.getSource()).getOperateKey())) {
            Object schemeId;
            Object catalog = this.getModel().getValue("catalog");
            if (catalog == null || !QueryServiceHelper.exists((String)"far_pivotcatalog", (Object)((DynamicObject)catalog).getLong("id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"PivotTableSchemePlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (status != null && OperationStatus.EDIT.equals((Object)status)) {
                return;
            }
            Object modelId = this.getView().getFormShowParameter().getCustomParam(MODELID);
            Object dataSetId = this.getView().getFormShowParameter().getCustomParam(DATASETID);
            if (!this.checkFormValida()) {
                args.setCancel(true);
                return;
            }
            this.getModel().setValue(MODEL, modelId);
            this.getModel().setValue(DATASET, dataSetId);
            boolean isNew = (Boolean)this.getView().getFormShowParameter().getCustomParam(OPERATE_TYPE);
            if (!isNew && Objects.nonNull(schemeId = this.getView().getFormShowParameter().getCustomParam(SCHEMEID))) {
                DataFormula dataFormula = PivotServiceHelper.getDataFormula(Long.parseLong(schemeId.toString()));
                this.getModel().setValue("dataparams", (Object)(dataFormula == null ? null : JSONObject.toJSONString((Object)dataFormula)));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        AnalysisOpLogParam logParam = this.getSingleLogParam();
        boolean isSaveAs = Objects.nonNull(this.getView().getFormShowParameter().getCustomParam(SCHEMEID));
        boolean isBaseInfoEdit = Objects.nonNull(this.getView().getFormShowParameter().getCustomParam(DATASETID));
        OperationName opName = isSaveAs ? OperationName.SCHEME_SAVE_AS : (isBaseInfoEdit ? OperationName.SCHEME_EDIT : OperationName.CREATE_SCHEME);
        logParam.buildOpName(opName);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (isSuccess) {
            List ids = e.getOperationResult().getSuccessPkIds();
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (!ids.isEmpty()) {
                Object schemeId;
                Object modelId = this.getView().getFormShowParameter().getCustomParam(MODELID);
                PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)ENTITY_PIVOT_SCHEME, (Long)LongUtil.toLong(ids.get(0)), (Object)LongUtil.toLong((Object)modelId), (OperationStatus)status, (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
                this.getView().returnDataToParent(ids.get(0));
                if (isSaveAs && (schemeId = this.getView().getFormShowParameter().getCustomParam(SCHEMEID)) != null) {
                    DynamicObject[] resDo;
                    QFilter[] qFilters = new QFilter[]{new QFilter("pivotschemeid", "=", (Object)Long.valueOf(schemeId.toString()))};
                    for (DynamicObject a : resDo = BusinessDataServiceHelper.load((String)"far_pivotstylecondi", (String)"name,scopes,styles,headers,celltype,headertype,pivotschemeid,index,isenabled", (QFilter[])qFilters)) {
                        DynamicObject newDo = BusinessDataServiceHelper.newDynamicObject((String)"far_pivotstylecondi");
                        newDo.set("creatorid_id", (Object)RequestContext.get().getCurrUserId());
                        newDo.set("name", (Object)a.getString("name"));
                        newDo.set("scopes", (Object)a.getString("scopes"));
                        newDo.set("styles", (Object)a.getString("styles"));
                        newDo.set("headers", (Object)a.getString("headers"));
                        newDo.set("celltype", (Object)a.getString("celltype"));
                        newDo.set("headertype", (Object)a.getString("headertype"));
                        newDo.set("pivotschemeid", ids.get(0));
                        newDo.set("index", (Object)a.getString("index"));
                        newDo.set("isenabled", (Object)a.getString("isenabled"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDo});
                    }
                }
            }
            this.getView().close();
            logParam.buildOpResult(OperationResult.SUCCESS);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PivotViewPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            logParam.buildOpResult(OperationResult.FAILURE);
        }
        if (logParam.getOpName() == OperationName.SCHEME_SAVE_AS) {
            return;
        }
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        super.beforeF7Select(evt);
        switch (key = evt.getProperty().getName()) {
            case "catalog": {
                this.setCatalogQfilter(evt);
                break;
            }
        }
    }

    @Override
    public AbstractFormPlugin getPivotPlugin() {
        return this;
    }

    @Override
    public String getModelTypeSign() {
        return "model_type";
    }

    @Override
    public ApplicationTypeEnum getAppType() {
        String bizAppId = this.getBizAppId();
        return StringUtils.isEmpty((CharSequence)bizAppId) ? ApplicationTypeEnum.FAR : ApplicationTypeEnum.getEnumByNumber((String)bizAppId);
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter(MODEL, "=", this.getView().getFormShowParameter().getCustomParam(MODELID));
        qFilter.and("model_type", "=", (Object)this.getModelEntity());
        this.addCataLogPermFilter(qFilter);
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)1);
        qFilters.add(qFilter);
        listShowParameter.getTreeFilterParameter().setQFilters((List)qFilters);
    }

    public boolean checkFormValida() {
        Object number = this.getModel().getValue("number");
        if (!this.isValidNumber(number.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"MyAnalysisListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isNew = (Boolean)this.getView().getFormShowParameter().getCustomParam(OPERATE_TYPE);
        Object modelId = this.getView().getFormShowParameter().getCustomParam(MODELID);
        Object dataSetId = this.getView().getFormShowParameter().getCustomParam(DATASETID);
        if (Objects.isNull(modelId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!isNew) {
            boolean hasPop = (Boolean)this.getView().getFormShowParameter().getCustomParam(POP_DATASET);
            if (this.isFAR() && Objects.isNull(dataSetId) && !hasPop) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"PivotSchemeListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (QueryServiceHelper.exists((String)ENTITY_PIVOT_SCHEME, (QFilter[])new QFilter[]{new QFilter(MODEL, "=", modelId).and("number", "=", (Object)number.toString())})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\u3002", (String)"PivotTableSchemePlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean savePivotScheme(Object pkId, Object pivotParams, Object pivotConfig, Long datasetId, String dims, String dataSetDtoStr) {
        try {
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)ENTITY_PIVOT_SCHEME);
            if (Objects.isNull(dy)) {
                return false;
            }
            dy.set("pivotfields", pivotParams);
            dy.set("congfigfields", pivotConfig);
            dy.set(DATASET, (Object)datasetId);
            dy.set("dims", (Object)dims);
            dy.set("dataparams", (Object)dataSetDtoStr);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            return true;
        }
        catch (KDException e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    private boolean isValidNumber(String number) {
        Matcher matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9._]+$").matcher(number);
        return matcherNumber.matches() && !number.contains("..") && !number.startsWith(".") && !number.startsWith("-");
    }

    private void addCataLogPermFilter(QFilter catalogBuilder) {
        HashSet noPermsCataLog = new HashSet(12);
        noPermsCataLog.addAll(PermClassEntityHelper.getDiscPermissionMap((String)"far_pivotcatalog", (Long)((Long)this.getView().getFormShowParameter().getCustomParam(MODELID)), (Long)this.getUserId(), (String)this.getBizAppId()).get((Object)"1"));
        if (noPermsCataLog.size() != 0) {
            catalogBuilder.and(new QFilter("id", "not in", noPermsCataLog));
        }
    }

    private AnalysisOpLogParam getSingleLogParam() {
        String selectedField;
        String numberField;
        String entity;
        if (ApplicationTypeEnum.FAR.getAppnum().equals(this.getView().getFormShowParameter().getAppId())) {
            entity = "fidm_model";
            numberField = "number";
            selectedField = "id,number,name";
        } else {
            entity = "bcm_model";
            numberField = "shownumber";
            selectedField = "id,shownumber,name";
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)entity, (String)selectedField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        String schemeNumber = (String)this.getModel().getValue("number");
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.PIVOT_TABLE).buildFormNumber(ENTITY_PIVOT_SCHEME).buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString(numberField), schemeNumber});
    }
}

