/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dynamic.CommandParam;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.pivot.AbsPivotPlugin;
import kd.epm.far.formplugin.faranalysis.pivot.dto.ColsField;
import kd.epm.far.formplugin.faranalysis.pivot.dto.DataFormula;
import kd.epm.far.formplugin.faranalysis.pivot.dto.PivotModel;
import kd.epm.far.formplugin.faranalysis.pivot.dto.PivotStyleCondi;
import kd.epm.far.formplugin.faranalysis.pivot.uitls.PivotServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class PivotViewPlugin
extends AbsPivotPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String VAR_PANEL = "varpanel";
    private static final String DIM_PANEL = "dimpanel";
    protected static final String DIMENSION_NUMBER_MAP_CACHE = "dimension_number_map_cache";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_SELECT = "btn_select";
    private static final String BTN_RESETPARAMS = "btn_resetparams";
    private static final String BTN_RESET = "btn_reset";
    private static final String OPERATE_TYPE = "OPERATE_TYPE";
    private static final String CALL_BACK_PIVOT_SCHEME_LIST = "CALL_BACK_PIVOT_SCHEME_LIST";
    private static final String DATASET_PREVIEW_PIVOT_CLOSE = "dataset_preview_pivot_close";
    private static final String CALL_BACK_PIVOT_SCHEME = "CALL_BACK_PIVOT_SCHEME";
    private static final String CALL_BACK_ADDNEW_PIVOT_SCHEME = "CALL_BACK_ADDNEW_PIVOT_SCHEME";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BasedataEdit datasetBaseData = (BasedataEdit)this.getControl("dataset_basedata");
        datasetBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        datasetBaseData.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.resetAppId();
        super.afterCreateNewData(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("model".equals(propertyName)) {
            this.changeModel(e);
        } else if ("dataset_basedata".equals(propertyName)) {
            if (!this.isEffective()) {
                return;
            }
            this.getView().getPageCache().remove(DIMENSION_NUMBER_MAP_CACHE);
            this.getPageCache().put("CHANGEDATASET_OPERATE", "1");
            this.openDataSetConfig();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_newscheme": {
                this.openAddPivotScheme(true);
                break;
            }
            case "btn_save": {
                this.itemClickSave();
                break;
            }
            case "btn_savenew": 
            case "btn_saveas_cm": {
                this.openAddPivotScheme(false);
                break;
            }
            case "btn_select": {
                this.openSchemeList();
                break;
            }
            case "btn_resetparams": {
                break;
            }
            case "btn_refresh": {
                this.itemClickUpdate();
                break;
            }
            case "btn_clear": {
                this.evtClear();
                break;
            }
            case "btn_info": {
                this.openSchemeEdit();
                break;
            }
            case "btn_del": {
                this.showDelConfirm();
                break;
            }
            case "btn_move": {
                this.openMoveView();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (!(this.paramsButtons.contains(key) && this.checkModel() && this.checkScheme(true) && this.checkDataSet(true))) {
            return;
        }
        switch (key) {
            case "btn_openparam": {
                this.collapseParamFlex(true);
                break;
            }
            case "btn_collapseparam": {
                this.collapseParamFlex(false);
                break;
            }
            case "btn_preview": {
                this.preViewDataSetTable();
                break;
            }
            case "btn_update": {
                this.evtUpdateData();
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_PIVOT_SAVE.toString())) {
            this.saveScheme(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_PIVOT_STYLE_CONDI_SAVE.toString())) {
            this.saveCondiStyle(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_PIVOT_STYLE_CONDI_QUERY_ALL.toString())) {
            this.pivotStyleCondiQuery();
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_PIVOT_STYLE_CONDI_DELETE.toString())) {
            this.deleteCondiStyle(eventArgs);
        } else if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_PIVOT_STYLE_CONDI_MODIFY.toString())) {
            this.modifyCondiStyle(eventArgs);
        }
    }

    public void modifyCondiStyle(String eventArgs) {
        boolean res;
        JSONObject joEventArgs = JSONObject.parseObject((String)eventArgs);
        JSONArray jaData = joEventArgs.getJSONArray("data");
        JSONArray jaIds = joEventArgs.getJSONArray("ids");
        JSONArray longIdsArray = new JSONArray();
        for (int i = 0; i < jaIds.size(); ++i) {
            long idLong = Long.parseLong(jaIds.getString(i));
            longIdsArray.add((Object)idLong);
        }
        try {
            DynamicObject[] dys;
            for (DynamicObject dy : dys = BusinessDataServiceHelper.load((Object[])longIdsArray.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"far_pivotstylecondi"))) {
                for (Object objData : jaData) {
                    JSONObject joData = (JSONObject)objData;
                    if (joData.getLong("id").longValue() != dy.getLong("id")) continue;
                    Object propValue = new Object();
                    if (joData.getString("propType").equalsIgnoreCase("Long")) {
                        propValue = Long.valueOf(joData.getString("propValue"));
                    } else if (joData.getString("propType").equalsIgnoreCase("Int")) {
                        propValue = Integer.valueOf(joData.getString("propValue"));
                    }
                    dy.set(joData.getString("propName"), propValue);
                }
            }
            SaveServiceHelper.save((DynamicObject[])dys);
            res = true;
        }
        catch (Exception e) {
            res = false;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("isSuccess", res);
        this.evtToPivotTable(resMap, AnalysisDesignConstants.PropsDataType.DATA_PIVOT_STYLE_CONDI_MODIFY);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (Objects.nonNull(returnData)) {
            switch (actionId) {
                case "CALL_BACK_PIVOT_SCHEME": {
                    this.refreshTreeView();
                    this.evtPivotSave(returnData.toString());
                    break;
                }
                case "CALL_BACK_ADDNEW_PIVOT_SCHEME": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u6210\u529f\u3002", (String)"PivotViewPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    this.refreshTreeView();
                    this.treeClickCatalog();
                    break;
                }
                case "EDITINFOR_CALLBACK": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u6210\u529f\u3002", (String)"PivotViewPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    this.refreshTreeView();
                    this.getView().updateView("scheme");
                    break;
                }
                case "MOVE_CALLBACK": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u79fb\u52a8\u6210\u529f\u3002", (String)"PivotViewPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    this.refreshTreeView();
                    this.getView().updateView("scheme");
                    break;
                }
            }
        } else if (DATASET_PREVIEW_PIVOT_CLOSE.equals(actionId) && StringUtils.equals((CharSequence)"evtRefresh", (CharSequence)this.getPageCache().get(OPERATE_TYPE))) {
            this.getPageCache().remove(OPERATE_TYPE);
            return;
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = evt.getProperty().getName();
        if (!StringUtils.equals((CharSequence)"model", (CharSequence)key) && !this.checkModel()) {
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"dataset_basedata", (CharSequence)key)) {
            this.refreshDataSetList(evt);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        TreeView t = (TreeView)evt.getSource();
        Map focusNode = t.getTreeState().getFocusNode();
        if (Objects.nonNull(focusNode) && Objects.nonNull(focusNode.get("parentid")) && !StringUtils.equals((CharSequence)"", (CharSequence)focusNode.get("parentid").toString()) && !StringUtils.equals((CharSequence)"0", (CharSequence)focusNode.get("parentid").toString())) {
            this.resetStatus(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_modify", "btn_delete", "btn_up", "btn_down"});
            String schemeId = focusNode.get("id").toString();
            try {
                this.treeClickNodeScheme(schemeId);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("btn_delete".equals(callBackId)) {
            if (evt.getResult() == MessageBoxResult.No) {
                return;
            }
            AnalysisOpLogParam logParam = this.getSingleLogParam();
            logParam.buildOpName(OperationName.DELETE_SCHEME);
            try {
                PivotServiceHelper.deleteScheme(this.getCurSchemeId(), this.getView());
                DeleteServiceHelper.delete((String)"far_pivotstylecondi", (QFilter[])new QFilter("pivotschemeid", "in", (Object)this.getCurSchemeId()).toArray());
                this.refreshTreeView();
                this.getPageCache().put("TREECLICK_CATALOG_EVT", "1");
                this.treeClickCatalog();
                TreeView tv = (TreeView)this.getControl("catalog");
                tv.treeNodeClick("", "0");
                this.evtPageInit();
                logParam.buildOpResult(OperationResult.SUCCESS);
            }
            catch (Exception e) {
                logParam.buildOpResult(OperationResult.FAILURE);
                throw e;
            }
            finally {
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
        }
    }

    @Override
    public boolean onlyAnalysis() {
        Object onlyAnalysis = this.getView().getFormShowParameter().getCustomParam("onlyAnalysis");
        return Objects.nonNull(onlyAnalysis) && Boolean.parseBoolean(onlyAnalysis.toString());
    }

    public void itemClickUpdate() {
        if (!(this.checkModel() && this.checkScheme(true) && this.checkDataSet(true))) {
            return;
        }
        this.evtUpdateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerView() {
        super.handlerView();
        if (this.isCM()) {
            SplitContainer splitcontainerap = (SplitContainer)this.getControl("splitcontainerap");
            if (this.onlyAnalysis()) {
                splitcontainerap.hidePanel(SplitDirection.left, true);
                Long schemeId = null;
                try {
                    DynamicObject dy = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"id", (QFilter[])new QFilter[]{PivotServiceHelper.getImprovisationQFilter(this.getCurModelId())});
                    schemeId = dy.getLong("id");
                    this.getModel().setValue("scheme", (Object)schemeId);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                }
                finally {
                    this.getModel().setValue("scheme", schemeId);
                }
            } else {
                splitcontainerap.hidePanel(SplitDirection.left, false);
            }
        }
    }

    @Override
    public void evtPageInit() {
        if (this.onlyAnalysis()) {
            this.treeClickNodeScheme(this.getCurSchemeId().toString());
            return;
        }
        super.evtPageInit();
    }

    private void itemClickSave() {
        if (this.checkModel() && this.checkDataSet(true) && this.checkScheme(true)) {
            Map<String, Object> curTreeNode = this.getCurTreeNode();
            if (Objects.nonNull(curTreeNode) && this.checkOnlyRead(curTreeNode.get("id").toString(), true)) {
                return;
            }
            this.sendMsgToF7Panel();
            this.evtPivotSave(String.valueOf(this.getCurSchemeId()));
        }
    }

    private void openAddPivotScheme(Boolean isNewScheme) {
        if (!this.checkModel()) {
            return;
        }
        Map<String, Object> curTreeNode = this.getCurTreeNode();
        if (Objects.nonNull(curTreeNode) && this.checkOnlyRead(curTreeNode.get("id").toString(), true)) {
            return;
        }
        if (!isNewScheme.booleanValue()) {
            this.sendMsgToF7Panel();
        }
        if (isNewScheme.booleanValue() || this.checkDataSet(isNewScheme == false)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setParentPageId(this.getView().getPageId());
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setFormId("far_pivot_scheme");
            fsp.setCustomParam(OPERATE_TYPE, (Object)isNewScheme);
            fsp.setCustomParam("modelId", (Object)this.getCurModelId());
            fsp.setCustomParam("parentid", (Object)this.getCatalogParentId());
            fsp.setCustomParam("popdataset", (Object)this.checkPopDataSet(false));
            fsp.setCustomParam("schemeId", isNewScheme != false ? null : this.getCurSchemeId().toString());
            fsp.setCustomParam("datasetId", (Object)(Objects.isNull(this.getModel().getValue("dataset_basedata")) ? null : this.getCurDataSetId()));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isNewScheme != false ? CALL_BACK_ADDNEW_PIVOT_SCHEME : CALL_BACK_PIVOT_SCHEME));
            this.getView().showForm(fsp);
        }
    }

    private void openSchemeList() {
        if (this.checkModel() && this.checkDataSet(true)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setParentPageId(this.getView().getPageId());
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setFormId("far_pivotscheme_list");
            fsp.setCustomParam("modelId", (Object)((DynamicObject)this.getModel().getValue("model")).getLong("id"));
            fsp.setCustomParam("datasetId", (Object)((DynamicObject)this.getModel().getValue("dataset_basedata")).getLong("id"));
            fsp.setCustomParam("schemeId", Objects.isNull(this.getModel().getValue("scheme")) ? null : Long.valueOf(((DynamicObject)this.getModel().getValue("scheme")).getLong("id")));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_PIVOT_SCHEME_LIST));
            this.getView().showForm(fsp);
        }
    }

    private void openSchemeEdit() {
        if (!this.checkScheme(true)) {
            return;
        }
        Map<String, Object> curTreeNode = this.getCurTreeNode();
        if (Objects.nonNull(curTreeNode) && this.checkOnlyRead(curTreeNode.get("id").toString(), true)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("modelId", this.getCurModelId());
        params.put("datasetId", this.getCurDataSetId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "EDITINFOR_CALLBACK");
        long pkId = ((DynamicObject)this.getModel().getValue("scheme")).getLong("id");
        PivotServiceHelper.editScheme(pkId, this.getView(), params, closeCallBack);
    }

    private void openMoveView() {
        if (this.checkModel() && this.checkScheme(true)) {
            Map<String, Object> curTreeNode = this.getCurTreeNode();
            if (Objects.nonNull(curTreeNode) && this.checkOnlyRead(curTreeNode.get("id").toString(), true)) {
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setParentPageId(this.getView().getPageId());
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setFormId("far_template_move");
            String treeListStr = this.getPageCache().get("treelist");
            if (StringUtils.isNotEmpty((CharSequence)treeListStr)) {
                List treeList = (List)SerializationUtils.fromJsonString((String)treeListStr, List.class);
                List newTreeList = treeList.stream().filter(v -> "catalog".equals(v.get("type"))).collect(Collectors.toList());
                fsp.setCustomParam("treelist", newTreeList);
            }
            fsp.setCustomParam("modelId", (Object)this.getCurModelId());
            fsp.setCustomParam("schemeId", (Object)this.getCurSchemeId());
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "MOVE_CALLBACK"));
            this.getView().showForm(fsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCmDataSetConfig() {
        this.collapseParamFlex(false);
        if (this.checkModel()) {
            String formalTipsStr;
            Object result;
            Map<String, List<Map<String, String>>> cmDimMap;
            block13: {
                cmDimMap = this.getCmDimMap();
                result = null;
                formalTipsStr = null;
                try {
                    if (this.checkDataSet(false)) {
                        this.resetPopDataSetStatus(false);
                        DatasetDto dto = null;
                        if (this.onlyAnalysis()) {
                            DataFormula dataFormula = this.buildDataFormula(null);
                            dto = dataFormula.getDatasetDto();
                        } else {
                            dto = PivotServiceHelper.getDataSetDto(this.getCurSchemeId(), 0L);
                        }
                        if (this.onlyAnalysis() || PivotServiceHelper.checkFillAllParams(dto, cmDimMap)) {
                            result = PivotServiceHelper.getEnhanceRes(dto, cmDimMap, this.isFAR());
                            PivotServiceHelper.handleDtoParamException(dto);
                            DatasetUtil.buildDetails((DatasetDto)dto);
                            formalTipsStr = dto.getDetails();
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8865\u5168\u6570\u636e\u96c6\u53c2\u6570\u3002", (String)"PivotViewPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
                        }
                        break block13;
                    }
                    this.resetPopDataSetStatus(true);
                }
                catch (Exception e) {
                    try {
                        this.getView().showErrorNotification(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        this.getView().getPageCache().put("DisF7Set", this.toByteSerialized(cmDimMap));
                        if (!this.onlyAnalysis()) {
                            this.collapseParamFlex(true);
                            this.refreshF7Panel();
                        }
                        this.callBackPreviewPivotData(Objects.isNull(result) ? new ArrayList(12) : (List)result);
                        this.updateFormalTips(formalTipsStr);
                        throw throwable;
                    }
                    this.getView().getPageCache().put("DisF7Set", this.toByteSerialized(cmDimMap));
                    if (!this.onlyAnalysis()) {
                        this.collapseParamFlex(true);
                        this.refreshF7Panel();
                    }
                    this.callBackPreviewPivotData(Objects.isNull(result) ? new ArrayList(12) : (List)result);
                    this.updateFormalTips(formalTipsStr);
                }
            }
            this.getView().getPageCache().put("DisF7Set", this.toByteSerialized(cmDimMap));
            if (!this.onlyAnalysis()) {
                this.collapseParamFlex(true);
                this.refreshF7Panel();
            }
            this.callBackPreviewPivotData(Objects.isNull(result) ? new ArrayList(12) : (List)result);
            this.updateFormalTips(formalTipsStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDataSetConfig() {
        this.collapseParamFlex(false);
        if (this.checkModel()) {
            String formalTipsStr = "";
            if (this.checkDataSet(true)) {
                long modelId = this.getCurModelId();
                long dataSetId = this.getCurDataSetId();
                DatasetDto dataSetDto = PivotServiceHelper.getDataSetDto(this.getCurSchemeId(), dataSetId);
                this.cacheModelId();
                this.getView().getPageCache().remove("allDimMap");
                Map<String, Map<String, String>> allDimMap = PivotServiceHelper.getDimMap(this.getView(), dataSetDto);
                this.checkDimsMap(allDimMap);
                this.getView().getPageCache().put("allDimMap", SerializationUtils.serializeToBase64(allDimMap));
                Map<String, List<Map<String, String>>> dataParams = new HashMap<String, List<Map<String, String>>>(12);
                try {
                    Map<String, Boolean> f7Dims = PivotServiceHelper.getF7Dims(dataSetDto.getExpression());
                    if (f7Dims != null && !f7Dims.isEmpty()) {
                        this.collapseParamFlex(true);
                        dataParams = PivotServiceHelper.getFarDefaultDimValue(modelId, dataSetId, this.getCurSchemeId(), allDimMap);
                    } else {
                        this.collapseParamFlex(false);
                    }
                    this.getView().getPageCache().put("DisF7Set", this.toByteSerialized(dataParams));
                    if (PivotServiceHelper.checkFillAllParams(dataSetDto, dataParams)) {
                        Object result = PivotServiceHelper.getEnhanceRes(dataSetDto, dataParams, this.isFAR());
                        DatasetUtil.buildDetails((DatasetDto)dataSetDto);
                        formalTipsStr = dataSetDto.getDetails();
                        this.callBackPreviewPivotData((List)result);
                    }
                    this.callBackPreviewPivotData(new ArrayList<Map>(12));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8865\u5168\u6570\u636e\u96c6\u53c2\u6570\u3002", (String)"PivotViewPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().updateView("dataset_basedata");
                    this.getView().showErrorNotification(e.getMessage());
                    this.callBackPreviewPivotData(new ArrayList<Map>(12));
                }
                finally {
                    this.refreshF7Panel();
                    this.updateFormalTips(formalTipsStr);
                }
            } else {
                this.callBackPreviewPivotData(new ArrayList<Map>(12));
            }
        }
        if (Objects.isNull(this.getPageCache().get("CHANGEDATASET_OPERATE")) && Objects.isNull(this.getPageCache().get("CHANGESCHEME")) && !this.isSchemeNode()) {
            this.getModel().setValue("scheme", null);
        }
        this.getPageCache().remove("CHANGESCHEME");
        this.getPageCache().remove("CHANGEDATASET_OPERATE");
    }

    private void showDelConfirm() {
        if (!this.isSchemeNode() || !this.checkScheme(true)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b9\u6848\u3002", (String)"PivotSchemeListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> curTreeNode = this.getCurTreeNode();
        if (Objects.nonNull(curTreeNode) && this.checkOnlyRead(curTreeNode.get("id").toString(), true)) {
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_delete");
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u65b9\u6848\u5417\uff1f", (String)"PivotSchemeListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    @Override
    public void callBackPreviewPivotData(List<Map> result) {
        this.evtDataInit(result);
    }

    private void changeModel(PropertyChangedArgs e) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (newValue == null) {
            return;
        }
        if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
            return;
        }
        this.getPageCache().put("KEY_MODEL_ID", this.getDMModelId().toString());
        this.getPageCache().put("dmmodelid", newValue.getString("id"));
        this.getPageCache().remove("focusnodeid");
        this.refreshTreeView();
        this.changeModelAndStatus();
        this.cacheModelMemory(newValue.getLong("id"));
    }

    @Override
    public void treeClickNodeScheme(String schemeId) {
        this.updateFormalTips(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u516c\u5f0f\u3002", (String)"PivotViewPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        boolean exists = QueryServiceHelper.exists((String)"far_pivot_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)schemeId))});
        if (exists) {
            this.getPageCache().put("CHANGESCHEME", "1");
            this.getModel().setValue("scheme", (Object)LongUtil.toLong((Object)schemeId));
            this.loadDataSetModel(LongUtil.toLong((Object)schemeId));
            Object pop = this.getModel().getValue("popdataset");
            this.resetPopDataSetStatus(pop == null || StringUtils.isEmpty((CharSequence)pop.toString()));
            if (this.isCM()) {
                this.openCmDataSetConfig();
            } else {
                this.openDataSetConfig();
            }
        }
    }

    private void evtDataInit(List<Map> data) {
        this.evtTreeClick(data);
    }

    public void evtUpdateData() {
        this.sendMsgToF7Panel();
        Object dataSetRes = this.getDataSetRes(false);
        if (Objects.isNull(dataSetRes)) {
            return;
        }
        PivotModel pivotModel = this.getPivotModel((List)dataSetRes);
        Map<String, Object> params = this.buildPivotModel(pivotModel);
        String dataSetId = String.valueOf(this.getCurDataSetId());
        if (this.checkPopDataSet(false)) {
            dataSetId = "1";
        }
        params.put("hasDataSet", this.isFAR() ? dataSetId : Long.valueOf(-1L));
        AnalysisOpLogParam logParam = this.getSingleLogParam();
        logParam.buildOpName(OperationName.SCHEME_REFRESH);
        try {
            this.evtToPivotTable(params, AnalysisDesignConstants.PropsDataType.PIVOT_UPDATE);
            logParam.buildOpResult(OperationResult.SUCCESS);
        }
        catch (Exception e) {
            logParam.buildOpResult(OperationResult.FAILURE);
            throw e;
        }
        finally {
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u65b0\u3002", (String)"PivotViewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
    }

    public void evtTreeClick(List<Map> data) {
        if (!this.checkModel()) {
            return;
        }
        PivotModel pivotModel = null;
        pivotModel = !this.checkDataSet(false) ? new PivotModel(String.valueOf(this.getCurSchemeId()), null, null) : this.getPivotModel(data);
        Map<String, Object> params = this.buildPivotModel(pivotModel);
        String dataSetId = String.valueOf(this.getCurDataSetId());
        if (this.checkPopDataSet(false)) {
            dataSetId = "1";
        }
        params.put("hasDataSet", this.isFAR() ? dataSetId : Long.valueOf(-1L));
        AnalysisDesignConstants.PropsDataType dataType = AnalysisDesignConstants.PropsDataType.PIVOT_TREECLICK_SCHEME;
        if (Objects.nonNull(this.getPageCache().get("CHANGEDATASET_OPERATE"))) {
            dataType = AnalysisDesignConstants.PropsDataType.PIVOT_CHANGE_DATASET;
        }
        this.evtToPivotTable(params, dataType);
    }

    public PivotModel getPivotModel(List<Map> data) {
        long modelId = this.getCurModelId();
        long dataSetId = this.getCurDataSetId();
        DataFormula dataFormula = null;
        try {
            if (this.isCM()) {
                HashMap<String, List<Map<String, String>>> dimMembers = new HashMap(12);
                String dimsMember = this.getView().getPageCache().get("dimsMember");
                if (StringUtils.isNotEmpty((CharSequence)dimsMember)) {
                    dimMembers = (Map)this.deSerializedBytes(dimsMember);
                }
                dataFormula = this.buildDataFormula(dimMembers.isEmpty() ? null : dimMembers);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        List<ColsField> meta = this.isFAR() ? PivotServiceHelper.getColsFields(PivotServiceHelper.getDataSetDto(this.getCurSchemeId(), dataSetId)) : (dataFormula == null ? PivotServiceHelper.getColsFields(data != null ? data : new ArrayList<Map>(2)) : PivotServiceHelper.getColsFields(dataFormula.getDatasetDto()));
        PivotModel pivotModel = new PivotModel(meta, data);
        if (Objects.nonNull(this.getModel().getValue("scheme"))) {
            Long schemeId = this.getCurSchemeId();
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)schemeId), (String)"far_pivot_scheme", (String)"pivotfields,congfigfields");
            pivotModel.setId(String.valueOf(schemeId));
            pivotModel.setFields(JSONObject.parseObject((String)scheme.getString("pivotfields")));
            pivotModel.setConfig(JSONObject.parseObject((String)scheme.getString("congfigfields")));
        }
        return pivotModel;
    }

    public void evtChangeScheme(String schemeId) {
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)schemeId), (String)"far_pivot_scheme", (String)"pivotfields,congfigfields,dataset");
        if (Objects.nonNull(dy)) {
            String curDatasetId = String.valueOf(this.getCurDataSetId());
            if (!StringUtils.equals((CharSequence)curDatasetId, (CharSequence)dy.getString("dataset"))) {
                if (this.isSchemeNode()) {
                    this.getPageCache().put("CHANGESCHEME", "1");
                }
                this.getModel().setValue("dataset_basedata", dy.get("dataset"));
                this.openDataSetConfig();
            }
            this.getModel().setValue("scheme", (Object)LongUtil.toLong((Object)schemeId));
        }
    }

    public void evtPivotSave(String schemeId) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("schemeId", schemeId);
        this.evtToPivotTable(params, AnalysisDesignConstants.PropsDataType.DATA_PIVOTSCHEME_SAVE);
    }

    public void evtRefresh() {
        if (!this.checkModel() || !this.checkDataSet(true)) {
            return;
        }
        this.getPageCache().put(OPERATE_TYPE, "evtRefresh");
        this.openDataSetConfig();
    }

    public void evtClear() {
        if (!(this.checkScheme(true) && this.checkModel() && this.checkDataSet(true))) {
            return;
        }
        AnalysisOpLogParam logParam = this.getSingleLogParam();
        logParam.buildOpName(OperationName.SCHEME_CLEAR);
        try {
            this.evtToPivotTable(Collections.emptyMap(), AnalysisDesignConstants.PropsDataType.DATA_PIVOTVIEW_CLEAR);
            logParam.buildOpResult(OperationResult.SUCCESS);
        }
        catch (Exception e) {
            logParam.buildOpResult(OperationResult.FAILURE);
            throw e;
        }
        finally {
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u6e05\u7a7a\u3002", (String)"PivotViewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
    }

    public Map<String, Object> buildPivotModel(PivotModel pivotModel) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put(pivotModel.getClass().getSimpleName(), pivotModel);
        return params;
    }

    public Map<String, Object> buildReturnObject(Object object) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put(object.getClass().getSimpleName(), object);
        return params;
    }

    public void deleteCondiStyle(String eventArgs) {
        boolean res;
        JSONObject joEventArgs = JSONObject.parseObject((String)eventArgs);
        JSONArray jaData = joEventArgs.getJSONArray("data");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Object o : jaData.toArray()) {
            ids.add(Long.parseLong((String)o));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids)};
        try {
            DeleteServiceHelper.delete((String)"far_pivotstylecondi", (QFilter[])qFilters);
            res = true;
        }
        catch (Exception e) {
            res = false;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("isSuccess", res);
        this.evtToPivotTable(resMap, AnalysisDesignConstants.PropsDataType.DATA_PIVOT_STYLE_CONDI_DELETE);
    }

    public void saveCondiStyle(String eventArgs) {
        Object[] o;
        JSONObject joEventArgs = JSONObject.parseObject((String)eventArgs);
        String openTarget = joEventArgs.getString("openTarget");
        JSONObject joData = joEventArgs.getJSONObject("data");
        String id = joData.getString("id");
        String name = joData.getString("name");
        String scopes = joData.getString("scopes");
        String styles = joData.getString("styles");
        String headers = joData.getString("headers");
        String typeCell = joData.getString("typeCell");
        String typeHeader = joData.getString("typeHeader");
        String index = joData.getString("index");
        String enabled = joData.getString("enabled");
        long schemeId = this.getCurSchemeId();
        DynamicObject obj = new DynamicObject();
        if ("add".equals(openTarget)) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"far_pivotstylecondi");
            obj.set("creatorid_id", (Object)RequestContext.get().getCurrUserId());
        } else if ("edit".equals(openTarget)) {
            obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"far_pivotstylecondi");
        }
        obj.set("name", (Object)name);
        obj.set("scopes", (Object)scopes);
        obj.set("styles", (Object)styles);
        obj.set("headers", (Object)headers);
        obj.set("celltype", (Object)typeCell);
        obj.set("headertype", (Object)typeHeader);
        obj.set("pivotschemeid", (Object)schemeId);
        obj.set("index", (Object)index);
        obj.set("isenabled", (Object)enabled);
        Map<String, Object> stringObjectMap = null;
        try {
            o = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
        catch (Exception e) {
            o = null;
        }
        if (o != null && o.length > 0) {
            DynamicObject dynamicObject = (DynamicObject)o[0];
            Date createTimeDate = (Date)dynamicObject.get("createtime");
            Date modifyTimeDate = (Date)dynamicObject.get("modifytime");
            SimpleDateFormat dateFormat = new SimpleDateFormat(TimeServiceHelper.getDateTimeFormatString());
            String createTimmStr = dateFormat.format(createTimeDate);
            String modifyTimeStr = dateFormat.format(modifyTimeDate);
            long createUserId = dynamicObject.getLong("creatorid_id");
            long modifyUserId = dynamicObject.getLong("modifierid_id");
            String createUserName = "";
            String modifyUserName = "";
            if (createUserId != 0L) {
                Map createUserInfoByID = UserServiceHelper.getUserInfoByID((long)createUserId);
                createUserName = String.valueOf(createUserInfoByID.get("name"));
            }
            if (createUserId != 0L) {
                Map modifyUserInfoByID = UserServiceHelper.getUserInfoByID((long)modifyUserId);
                modifyUserName = String.valueOf(modifyUserInfoByID.get("name"));
            }
            PivotStyleCondi pivotStyleCondi = new PivotStyleCondi();
            pivotStyleCondi.setId(dynamicObject.get("id").toString());
            pivotStyleCondi.setPivotSchemeId(dynamicObject.get("pivotschemeid").toString());
            pivotStyleCondi.setName(dynamicObject.get("name").toString());
            pivotStyleCondi.setScopes(dynamicObject.get("scopes").toString());
            pivotStyleCondi.setStyles(dynamicObject.get("styles").toString());
            pivotStyleCondi.setHeaders(dynamicObject.get("headers").toString());
            pivotStyleCondi.setTypeCell(dynamicObject.get("celltype").toString());
            pivotStyleCondi.setTypeHeader(dynamicObject.get("headertype").toString());
            pivotStyleCondi.setIndex(dynamicObject.get("index").toString());
            pivotStyleCondi.setEnabled(dynamicObject.get("isenabled").toString());
            pivotStyleCondi.setCreateUser(createUserName);
            pivotStyleCondi.setCreateTime(createTimmStr);
            pivotStyleCondi.setModifyUser(modifyUserName);
            pivotStyleCondi.setModifyTime(modifyTimeStr);
            stringObjectMap = this.buildReturnObject(pivotStyleCondi);
        }
        this.evtToPivotTable(stringObjectMap, AnalysisDesignConstants.PropsDataType.DATA_PIVOT_STYLE_CONDI_QUERY_ONE);
    }

    private PivotStyleCondi buildStyleCondi(DynamicObject dynamicObject) {
        Date createTimeDate = (Date)dynamicObject.get("createtime");
        Date modifyTimeDate = (Date)dynamicObject.get("modifytime");
        SimpleDateFormat dateFormat = new SimpleDateFormat(TimeServiceHelper.getDateTimeFormatString());
        String createTimmStr = dateFormat.format(createTimeDate);
        String modifyTimeStr = dateFormat.format(modifyTimeDate);
        long createUserId = dynamicObject.getLong("creatorid_id");
        long modifyUserId = dynamicObject.getLong("modifierid_id");
        Map createUserInfoByID = UserServiceHelper.getUserInfoByID((long)createUserId);
        String createUserName = String.valueOf(createUserInfoByID.get("name"));
        Map modifyUserInfoByID = UserServiceHelper.getUserInfoByID((long)modifyUserId);
        String modifyUserName = String.valueOf(modifyUserInfoByID.get("name"));
        PivotStyleCondi pivotStyleCondi = new PivotStyleCondi();
        pivotStyleCondi.setId(dynamicObject.get("id").toString());
        pivotStyleCondi.setPivotSchemeId(dynamicObject.get("pivotschemeid").toString());
        pivotStyleCondi.setName(dynamicObject.get("name").toString());
        pivotStyleCondi.setScopes(dynamicObject.get("scopes").toString());
        pivotStyleCondi.setStyles(dynamicObject.get("styles").toString());
        pivotStyleCondi.setHeaders(dynamicObject.get("headers").toString());
        pivotStyleCondi.setTypeCell(dynamicObject.get("celltype").toString());
        pivotStyleCondi.setTypeHeader(dynamicObject.get("headertype").toString());
        pivotStyleCondi.setIndex(dynamicObject.get("index").toString());
        pivotStyleCondi.setEnabled(dynamicObject.get("isenabled").toString());
        pivotStyleCondi.setCreateUser(createUserName);
        pivotStyleCondi.setCreateTime(createTimmStr);
        pivotStyleCondi.setModifyUser(modifyUserName);
        pivotStyleCondi.setModifyTime(modifyTimeStr);
        return pivotStyleCondi;
    }

    public void pivotStyleCondiQuery() {
        QFilter[] filters = new QFilter[]{new QFilter("pivotschemeid", "=", (Object)this.getCurSchemeId())};
        Collection values = BusinessDataServiceHelper.loadFromCache((String)"far_pivotstylecondi", (QFilter[])filters).values();
        ArrayList<PivotStyleCondi> pivotStyleCondiList = new ArrayList<PivotStyleCondi>(10);
        for (DynamicObject dynamicObject : values) {
            pivotStyleCondiList.add(this.buildStyleCondi(dynamicObject));
        }
        HashMap<String, Object> pivotStyleCondiListMap = new HashMap<String, Object>();
        pivotStyleCondiListMap.put("pivotStyleCondiList", pivotStyleCondiList);
        this.evtToPivotTable(pivotStyleCondiListMap, AnalysisDesignConstants.PropsDataType.DATA_PIVOT_STYLE_CONDI_QUERY_ALL);
    }

    public boolean saveScheme(String eventArgs) {
        if (Objects.nonNull(eventArgs)) {
            AnalysisOpLogParam logParam;
            PivotModel pivotModel = (PivotModel)JSONObject.parseObject((String)JSONObject.parseObject((String)eventArgs).getJSONObject(PivotModel.class.getSimpleName()).toJSONString(), PivotModel.class);
            if (Objects.isNull(pivotModel) || Objects.isNull(pivotModel.getId()) || !QueryServiceHelper.exists((String)"far_pivot_scheme", (Object)LongUtil.toLong((Object)pivotModel.getId()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u900f\u89c6\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"PivotViewPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean saveFlag = this.saveDtoScheme(pivotModel, JSONObject.toJSONString((Object)pivotModel.getFields()), JSONObject.toJSONString((Object)pivotModel.getConfig()));
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)pivotModel.getId()))});
            AnalysisOpLogParam analysisOpLogParam = logParam = Objects.isNull(scheme) ? this.getSingleLogParam() : this.getSingleLogParam(scheme);
            if (saveFlag) {
                logParam.buildOpResult(OperationResult.SUCCESS);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u6210\u529f\u3002", (String)"PivotViewPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                logParam.buildOpResult(OperationResult.FAILURE);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PivotViewPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (Objects.equals(pivotModel.getId(), ((DynamicObject)this.getModel().getValue("scheme")).getString("id"))) {
                logParam.buildOpName(OperationName.SCHEME_SAVE);
            } else {
                logParam.buildOpName(OperationName.SCHEME_SAVE_AS);
            }
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            return saveFlag;
        }
        return false;
    }

    public boolean saveDtoScheme(PivotModel pivotModel, Object pivotParams, Object pivotConfig) {
        DynamicObject dy;
        HashMap<String, List<Map<String, String>>> dimMembers = new HashMap(12);
        String dimsMember = this.getView().getPageCache().get("dimsMember");
        if (StringUtils.isNotEmpty((CharSequence)dimsMember)) {
            dimMembers = (Map)this.deSerializedBytes(dimsMember);
        }
        if ((dy = BusinessDataServiceHelper.loadSingle((Object)pivotModel.getId(), (String)"far_pivot_scheme")) != null) {
            dy.set("pivotfields", pivotParams);
            dy.set("congfigfields", pivotConfig);
            if (this.isCM()) {
                DataFormula dataFormula = this.onlyAnalysis() ? this.buildDataFormula(null) : this.buildDataFormula(dimMembers);
                dy.set("dataset", null);
                dy.set("dims", null);
                dy.set("dataparams", (Object)JSONObject.toJSONString((Object)dataFormula));
            } else if (this.getCurDataSetId() == 0L && this.checkPopDataSet(false)) {
                DataFormula dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class);
                dataparams.setDimParams(dimMembers);
                dy.set("dataset", null);
                dy.set("dims", null);
                dy.set("dataparams", (Object)JSONObject.toJSONString((Object)dataparams));
            } else {
                dy.set("dataset", (Object)this.getCurDataSetId());
                dy.set("dims", (Object)JSONObject.toJSONString(dimMembers));
                dy.set("dataparams", null);
            }
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void refreshDataSetList(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = this.getDataSetFilter(this.getDMModelId());
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        listFilterParameter.setFilter(filter);
        listFilterParameter.setOrderBy("createtime desc");
    }

    public QFilter getDataSetFilter(Long modelId) {
        QFilter filter = new QFilter("discmodel", "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        QFilter filter_1 = new QFilter("scope", "=", (Object)"1");
        filter.and("type", "=", (Object)"2");
        DatasetServiceHelper.addDataSetF7Filter((QFilter)filter_1, (Long)modelId, (Long)RequestContext.get().getCurrUserId(), (String)ApplicationTypeEnum.FAR.getAppnum());
        return filter.and(filter_1);
    }

    private void treeClickCurScheme(String schemeId) {
        if (StringUtils.isEmpty((CharSequence)schemeId)) {
            return;
        }
        DynamicObject dy = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"catalog", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(schemeId))});
        if (Objects.nonNull(dy)) {
            TreeView t = (TreeView)this.getControl("catalog");
            t.treeNodeClick(dy.getString("catalog"), schemeId);
        }
    }

    private void preViewDataSetTable() {
        this.sendMsgToF7Panel();
        this.getDataSetRes(true);
    }

    private Object getDataSetRes(boolean isShowTable) {
        HashMap<String, List<Map<String, String>>> dimMembers = new HashMap(12);
        String dimsMember = this.getView().getPageCache().get("dimsMember");
        if (StringUtils.isNotEmpty((CharSequence)dimsMember)) {
            dimMembers = (Map)this.deSerializedBytes(dimsMember);
        }
        Object res = null;
        String formalTipsStr = null;
        DatasetDto datasetDto = null;
        if (this.isCM()) {
            if (this.onlyAnalysis()) {
                datasetDto = this.buildDataFormula(null).getDatasetDto();
            } else {
                DataFormula dataFormula = this.buildDataFormula(dimMembers);
                datasetDto = dataFormula.getDatasetDto();
            }
        } else {
            datasetDto = PivotServiceHelper.getDataSetDto(this.getCurSchemeId(), this.getCurDataSetId());
            Map<String, Boolean> f7Dims = PivotServiceHelper.getF7Dims(datasetDto.getExpression());
            if (!f7Dims.isEmpty() && (dimMembers == null || dimMembers.isEmpty())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u6210\u5458\u5b58\u5728\u5f02\u5e38\u3002", (String)"PivotViewPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        if (datasetDto == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u516c\u5f0f\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"PivotViewPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (this.onlyAnalysis()) {
            dimMembers = this.getCmDimMap();
        }
        if (this.onlyAnalysis() || PivotServiceHelper.checkFillAllParams(datasetDto, dimMembers)) {
            res = PivotServiceHelper.getEnhanceRes(datasetDto, dimMembers, this.isFAR());
            PivotServiceHelper.handleDtoParamException(datasetDto);
            DatasetUtil.buildDetails((DatasetDto)datasetDto);
            formalTipsStr = datasetDto.getDetails();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8865\u5168\u6570\u636e\u96c6\u53c2\u6570\u3002", (String)"PivotViewPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.updateFormalTips(formalTipsStr);
        if (isShowTable) {
            PivotServiceHelper.showTableView(res, this.getView(), String.valueOf(this.getCurModelId()), String.valueOf(this.getCurDataSetId()));
        }
        return res;
    }

    private DataFormula buildDataFormula(Map<String, List<Map<String, String>>> params) {
        DataFormula dataFormula = null;
        if (this.onlyAnalysis()) {
            Map customParams = (Map)this.getShowCustomParams();
            if (Objects.nonNull(params) && !params.isEmpty()) {
                customParams.put("dimMap", params);
            }
            dataFormula = new DataFormula((Map)customParams.get("dimMap"), PivotServiceHelper.createDataSetDto(customParams, this.onlyAnalysis()));
        } else {
            dataFormula = (DataFormula)this.getShowCustomParams();
            DatasetDto datasetDto = dataFormula.getDatasetDto();
            if (Objects.nonNull(params) && !params.isEmpty()) {
                Map<String, List<Map<String, String>>> allParams = params;
                if (!dataFormula.isAllowEdit()) {
                    allParams = dataFormula.getDimParams().entrySet().stream().filter(entry -> ((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
                    allParams.putAll(params);
                    String formulaStr = DatasetUtil.buildExpression(allParams, null, (boolean)false);
                    datasetDto.setExpression(formulaStr);
                    datasetDto.setTempExpression(formulaStr);
                }
                dataFormula.setDimParams(allParams);
            }
        }
        return dataFormula;
    }

    @Override
    public void refreshF7Panel() {
        if (!(this.checkModel() && this.checkDataSet(true) && this.checkScheme(true))) {
            this.collapseParamFlex(false);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(12);
        params.put("modelId", this.getCurModelId());
        params.put("datasetId", this.getCurDataSetId());
        params.put("scheme", this.getCurSchemeId());
        params.put("DataSetDto", PivotServiceHelper.getDataSetDto(this.getCurSchemeId(), this.getCurDataSetId()));
        if (this.isCM()) {
            HashMap dimMap = this.getCmDimMap();
            params.put("defaultMembers", Objects.isNull(dimMap) ? Maps.newHashMapWithExpectedSize((int)12) : dimMap);
        }
        PivotServiceHelper.showF7Panel(this.getView(), params);
    }

    @Override
    public void dealMsg(CommandParam com) {
        List<Object> param;
        String operation = com.getOperation();
        if (StringUtils.equals((CharSequence)"getF7Member", (CharSequence)operation) && CollectionUtils.isNotEmpty(param = com.getParam())) {
            Map dims = (Map)param.get(0);
            this.getView().getPageCache().put("dimsMember", this.toByteSerialized(dims));
        }
    }

    private void sendMsgToF7Panel() {
        CommandParam commandParam = new CommandParam("far_pivot", "far_pivot_f7", "getF7Member", new Object[0]);
        this.sendMsg(this.getView(), commandParam);
    }

    private boolean isEffective() {
        if (Objects.nonNull(this.getPageCache().get("CHANGESCHEME"))) {
            return false;
        }
        if (Objects.nonNull(this.getPageCache().get("TREECLICK_CATALOG_EVT"))) {
            this.getPageCache().remove("TREECLICK_CATALOG_EVT");
            return false;
        }
        if (Objects.nonNull(this.getView().getPageCache().get("clear_dataset"))) {
            this.getView().getPageCache().remove("clear_dataset");
            return false;
        }
        return true;
    }

    private boolean cacheModelId() {
        String cacheModel = this.getView().getPageCache().get("cache_model");
        if (StringUtils.equals((CharSequence)cacheModel, (CharSequence)String.valueOf(this.getCurModelId()))) {
            return false;
        }
        this.getView().getPageCache().put("cache_model", String.valueOf(this.getCurModelId()));
        return true;
    }

    private Map<String, List<Map<String, String>>> getCmDimMap() {
        Object params = this.getShowCustomParams();
        Map<String, List<Map<String, String>>> dimMap = new HashMap<String, List<Map<String, String>>>(12);
        if (params instanceof Map) {
            Map tempDimMap = (Map)((Map)params).get("dimMap");
            dimMap = this.keyTransferUpper(tempDimMap);
        } else if (params instanceof DataFormula) {
            Map<String, List<Map<String, String>>> tempDimMap = ((DataFormula)params).getDimParams();
            dimMap = this.keyTransferUpper(tempDimMap);
        }
        return dimMap;
    }

    private Map<String, List<Map<String, String>>> keyTransferUpper(Map<String, List<Map<String, String>>> objectMap) {
        if (Objects.isNull(objectMap)) {
            return null;
        }
        return objectMap.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), Map.Entry::getValue));
    }

    private Object getShowCustomParams() {
        if (this.onlyAnalysis()) {
            return this.getView().getFormShowParameter().getCustomParams();
        }
        DynamicObject dy = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"number,name,dataparams", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getCurSchemeId())});
        DataFormula dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class);
        return Objects.isNull(dataparams) ? new DataFormula() : dataparams;
    }

    private List<Map<String, String>> mockGetDim(String dimStr) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        JSONArray jsonArray = JSONArray.parseArray((String)dimStr);
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            list.add((Map<String, String>)jsonObject.toJavaObject(Map.class));
        }
        return list;
    }

    private AnalysisOpLogParam getSingleLogParam() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        return this.getSingleLogParam(scheme);
    }

    private AnalysisOpLogParam getSingleLogParam(DynamicObject scheme) {
        String selectedField;
        String numberField;
        String entity;
        if (ApplicationTypeEnum.FAR.getAppnum().equals(this.getView().getFormShowParameter().getAppId())) {
            entity = "fidm_model";
            numberField = "number";
            selectedField = "id,number,name";
        } else {
            entity = "bcm_model";
            numberField = "shownumber";
            selectedField = "id,shownumber,name";
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)entity, (String)selectedField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        String schemeNumber = scheme.getString("number");
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.PIVOT_TABLE).buildFormNumber("far_pivot_scheme").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString(numberField), schemeNumber});
    }
}

