/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot.dto;

import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;

public class PivotModelStrategyEx {
    public static ModelStrategyEx getPivotModelStrategyEx(Long dmModelId, boolean isFarApp) {
        PivotModelStrategyEx.checkAppStatus(isFarApp);
        if (isFarApp) {
            return new ModelStrategyEx(dmModelId);
        }
        return new ModelStrategyEx(dmModelId, DisModelTypeEnum.CM.getType());
    }

    public static ModelStrategyEx getPivotModelStrategyEx(DatasetDto dataSetDto) {
        if (Objects.isNull(dataSetDto)) {
            throw new KDBizException("dataSetDto is null");
        }
        if (Objects.isNull(dataSetDto.getDataSrcId()) || dataSetDto.getDataSrcId() == 0L) {
            throw new KDBizException("dataSrcId is valida");
        }
        DisModelTypeEnum modelTypeEnum = DisModelTypeEnum.getModelType((String)dataSetDto.getDataSrcType(), (Long)dataSetDto.getDataSrcId());
        return new ModelStrategyEx(dataSetDto.getDataSrcId(), modelTypeEnum.getType());
    }

    public static void checkAppStatus(Object appType) {
        if (Objects.isNull(appType)) {
            throw new KDBizException("AppType is null");
        }
    }
}

