/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot.uitls;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.f7.BasedataEditSingleMemberF7BCM;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.f7.base.BasedataEditMultiMemberFIDM;
import kd.epm.far.business.common.f7.base.BasedataEditSingleMemberFIDM;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.adapter.DimMemberAdapter;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.CommandParam;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.dynamic.SubPage;
import kd.epm.far.formplugin.faranalysis.pivot.dto.DataFormula;
import kd.epm.far.formplugin.faranalysis.pivot.dto.PivotModelStrategyEx;
import kd.epm.far.formplugin.faranalysis.pivot.uitls.F7DimHelper;
import kd.epm.far.formplugin.faranalysis.pivot.uitls.PivotServiceHelper;

public class PivotF7Plugin
extends AbstractBaseDMFormPlugin
implements DynamicPage,
SubPage {
    private static final String MODELID = "modelId";
    private static final String DATASETID = "datasetId";
    private static final String SHORTNUMBERLIST = "shortNumberList";
    private static final String DEFAULTMEMBERS = "defaultMembers";
    protected static final String SCHEME = "scheme";
    private static final String MODEL = "model";
    private static final String DATASET = "dataset";
    protected static final String ALL_DIM_MAP_CACHE = "allDimMap";
    protected static final String DIMF7MAP = "dimf7map";
    private static final String DIM_PANEL = "f7panel";
    private static final String DataSetDto = "DataSetDto";
    private static final String DIMMEMBERSSTR = "DimMembersStr";
    private static final String MUL_PREFIX = "Mul_";
    private static final String SGL_PREFIX = "Sgl_";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.makeUpF7Area();
        this.initSelectedMembers();
        this.builderF7Member();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Control c = this.getView().getControl(e.getProperty().getName());
        if (Objects.isNull(c)) {
            return;
        }
        if (c instanceof BasedataEditSingleMemberF7BCM || c instanceof BasedataEditSingleMemberFIDM) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (Objects.isNull(newValue)) {
                this.getModel().setValue(key, (Object)oldValue);
            }
        } else if (c instanceof BasedataEditMultiMemberFIDM) {
            DynamicObjectCollection newValue = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            DynamicObjectCollection oldValue = (DynamicObjectCollection)e.getChangeSet()[0].getOldValue();
            if (Objects.isNull(newValue) || newValue.isEmpty()) {
                this.getModel().setValue(key, (Object)oldValue);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = evt.getProperty().getName();
        Map<String, Long> f7DimMap = this.getAllF7Map();
        if (f7DimMap == null || f7DimMap.isEmpty()) {
            return;
        }
        Long dimId = f7DimMap.get(key);
        Long farModelId = this.getCurModelId();
        DatasetDto dataSetDto = this.getDataSetDto();
        if (dataSetDto != null && dataSetDto.getDataSrcId() != null && dataSetDto.getDataSrcId() != 0L) {
            farModelId = dataSetDto.getDataSrcId();
        }
        if (dimId == null || farModelId == null || farModelId == 0L) {
            return;
        }
        QFilter qFilter = new QFilter(MODEL, "=", (Object)farModelId);
        qFilter.and("dimension", "=", (Object)dimId);
        ((IF7Operator)evt.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        if (DmDimMemberEntityEnum.BCM_YEAR.getNumber().equalsIgnoreCase(key)) {
            filterList.add(new QFilter("number", "not in", Arrays.asList("LastYear", "CurrentYear", "Year", "AllYear")));
        } else if (DmDimMemberEntityEnum.BCM_PERIOD.getNumber().equalsIgnoreCase(key)) {
            filterList.add(new QFilter("number", "not in", Arrays.asList("LastPeriod", "CurrentPeriod")));
        }
        evt.setCustomQFilters(filterList);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (this.getPage(this.getView()) != null) {
            boolean isEb;
            Element element = this.getPage(this.getView()).findElementBySign(e.getKey());
            if (element == null) {
                return;
            }
            Map<String, Long> f7DimMap = this.getAllF7Map();
            if (f7DimMap == null || f7DimMap.isEmpty()) {
                return;
            }
            Long dimId = f7DimMap.get(e.getKey());
            if (dimId == null) {
                return;
            }
            DatasetDto dataSetDto = this.getDataSetDto();
            if (dataSetDto == null) {
                return;
            }
            DisModelTypeEnum modelTypeEnum = DisModelTypeEnum.getModelType((String)dataSetDto.getDataSrcType(), (Long)dataSetDto.getDataSrcId());
            ModelStrategyEx modelStrategyEx = PivotModelStrategyEx.getPivotModelStrategyEx(dataSetDto);
            List allDim = modelStrategyEx.getDim().getDimList(false);
            DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)allDim, (Long)dimId);
            boolean bl = this.isCM() ? false : (isEb = DisModelTypeEnum.EB == modelTypeEnum);
            if (element instanceof MultiBaseEditElement) {
                List<DimMemberInfo> selecteds = this.getCurDimSelectedByShortNum(dimensionInfo.getShortNumber());
                MulBasedataEdit mulF7 = modelStrategyEx.getDimensionF7().openComMutilF7(this.getView(), selecteds, dimensionInfo, isEb ? (dataSetDto != null ? dataSetDto.getEbDataset() : "default") : null, (BeforeF7SelectListener)this, MUL_PREFIX + e.getKey(), this.getPluginName(), true);
                e.setControl((Control)mulF7);
            } else if (element instanceof BaseEditElement) {
                BasedataEdit singleMemberF7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, e.getKey(), null, false, isEb ? (dataSetDto != null ? dataSetDto.getEbDataset() : "default") : "");
                e.setControl((Control)singleMemberF7);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (Objects.isNull(actionId) || Objects.isNull(returnData)) {
            return;
        }
        if (actionId.startsWith(MUL_PREFIX)) {
            this.buildMulReturnData(returnData, actionId);
        }
    }

    public void buildMulReturnData(Object returnData, String actionId) {
        Map<String, List<Map<String, String>>> dimMembers;
        Object[] ids = null;
        ArrayList selectedMs = new ArrayList(12);
        String shortNum = this.getShortNumByF7Key(actionId.replace(MUL_PREFIX, ""));
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rDSelectedRows = (ListSelectedRowCollection)returnData;
            ids = rDSelectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList()).toArray();
            for (ListSelectedRow row : rDSelectedRows) {
                Map dataMap = row.getDataMap();
                if (dataMap == null) continue;
                HashMap<String, String> member = new HashMap<String, String>(12);
                member.put("id", String.valueOf(dataMap.getOrDefault("id", "0")));
                member.put("number", String.valueOf(dataMap.getOrDefault("number", "")));
                member.put("name", String.valueOf(dataMap.getOrDefault("name", "")));
                member.put("range", String.valueOf(dataMap.getOrDefault("scope", "10")));
                selectedMs.add(member);
            }
        } else {
            DynamicObjectCollection memberList = (DynamicObjectCollection)returnData;
            ids = memberList.stream().map(v -> v.getLong(4)).collect(Collectors.toList()).toArray();
            for (DynamicObject dy : memberList) {
                HashMap<String, String> member = new HashMap<String, String>(12);
                member.put("id", dy.getString("mid1"));
                member.put("number", dy.getString("mnum1"));
                member.put("name", dy.getString("mname1"));
                member.put("range", dy.getString("filltypevalue1"));
                selectedMs.add(member);
            }
        }
        if ((dimMembers = this.getDimPageCacheMembers()) == null) {
            dimMembers = new HashMap<String, List<Map<String, String>>>(12);
        }
        dimMembers.put(shortNum, selectedMs);
        this.getView().getPageCache().put(DIMMEMBERSSTR, SerializationUtils.toJsonString(dimMembers));
        this.getModel().setValue(actionId.replace(MUL_PREFIX, ""), (Object)ids);
        this.getView().updateView(actionId.replace(MUL_PREFIX, "").toLowerCase());
        this.getView().updateView();
    }

    private List<DimMemberInfo> getCurDimSelectedByShortNum(String shortNum) {
        ArrayList<DimMemberInfo> dimMemberInfos = new ArrayList<DimMemberInfo>(12);
        List<Map<String, String>> cacheSelectedByShortNum = this.getCacheSelectedByShortNum(shortNum);
        if (cacheSelectedByShortNum == null) {
            return dimMemberInfos;
        }
        for (Map<String, String> stringMap : cacheSelectedByShortNum) {
            DimMemberInfo dimMemberInfo = new DimMemberInfo();
            dimMemberInfo.setId(Long.valueOf(Long.parseLong(stringMap.getOrDefault("id", "0"))));
            dimMemberInfo.setName(stringMap.getOrDefault("name", ""));
            dimMemberInfo.setNumber((String)stringMap.getOrDefault("number", null));
            try {
                dimMemberInfo.setRange(Integer.parseInt(stringMap.getOrDefault("range", "10")));
            }
            catch (Exception e) {
                dimMemberInfo.setRange(10);
            }
            dimMemberInfos.add(dimMemberInfo);
        }
        return dimMemberInfos;
    }

    private List<Map<String, String>> getCacheSelectedByShortNum(String shortNum) {
        Map<String, List<Map<String, String>>> dimPageCacheMembers = this.getDimPageCacheMembers();
        if (dimPageCacheMembers == null) {
            dimPageCacheMembers = this.isFAR() ? PivotServiceHelper.getFarDefaultDimValue(this.getCurModelId(), this.getDatasetId(), this.getSchemeId(), this.getAllDimMap()) : this.getDefaultMembers();
        }
        return dimPageCacheMembers.get(shortNum);
    }

    private Map<String, List<Map<String, String>>> getDimPageCacheMembers() {
        String dimMembersStr = this.getView().getPageCache().get(DIMMEMBERSSTR);
        Map dimMembers = null;
        if (StringUtils.isNotEmpty((CharSequence)dimMembersStr)) {
            dimMembers = (Map)SerializationUtils.fromJsonString((String)dimMembersStr, Map.class);
        }
        return dimMembers;
    }

    private void initSelectedMembers() {
        Map<String, List<Map<String, String>>> dimPageCacheMembers = this.isFAR() ? PivotServiceHelper.getFarDefaultDimValue(this.getCurModelId(), this.getDatasetId(), this.getSchemeId(), this.getAllDimMap()) : this.getDefaultMembers();
        this.getView().getPageCache().put(DIMMEMBERSSTR, SerializationUtils.toJsonString(dimPageCacheMembers));
    }

    private String getShortNumByNum(String num) {
        String disF7Set = this.getView().getPageCache().get("DisF7Set");
        Map dims = (Map)ObjectSerialUtil.deSerializedBytes((String)disF7Set);
        return (String)dims.get(num);
    }

    private String getShortNumByF7Key(String f7key) {
        Map<String, Long> f7DimMap = this.getAllF7Map();
        if (f7DimMap == null || f7DimMap.isEmpty()) {
            return null;
        }
        Long dimId = f7DimMap.get(f7key);
        if (dimId == null) {
            return null;
        }
        DatasetDto dataSetDto = this.getDataSetDto();
        if (dataSetDto == null) {
            return null;
        }
        DimensionInfo dimensionInfo = this.getDimensionInfo(dimId);
        return dimensionInfo != null ? dimensionInfo.getShortNumber() : null;
    }

    private DimensionInfo getDimensionInfo(Long dimId) {
        DatasetDto dataSetDto = this.getDataSetDto();
        if (dataSetDto == null) {
            return null;
        }
        ModelStrategyEx modelStrategyEx = PivotModelStrategyEx.getPivotModelStrategyEx(dataSetDto);
        List allDim = modelStrategyEx.getDim().getDimList(false);
        DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)allDim, (Long)dimId);
        return dimensionInfo;
    }

    private Long getCurModelId() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(MODELID);
        return modelId;
    }

    private List<String> getShortNumberList() {
        return (List)this.getView().getFormShowParameter().getCustomParam(SHORTNUMBERLIST);
    }

    private boolean checkDatasetDto(boolean isShowTip) {
        DatasetDto dataSetDto = this.getDataSetDto();
        if (dataSetDto == null) {
            if (isShowTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6216\u65b0\u589e\u6570\u636e\u96c6\u3002", (String)"PivotViewPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private DatasetDto getDataSetDto() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(DataSetDto);
        if (customParam != null) {
            return (DatasetDto)SerializationUtils.fromJsonString((String)customParam.toString(), DatasetDto.class);
        }
        return null;
    }

    private Map<String, List<Map<String, String>>> getDefaultMembers() {
        return (Map)this.getView().getFormShowParameter().getCustomParam(DEFAULTMEMBERS);
    }

    private Map<String, Long> getAllF7Map() {
        String str = this.getView().getPageCache().get(DIMF7MAP);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        return (Map)this.deSerializedBytes(str);
    }

    private Long getDatasetId() {
        Long dataSetId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(DATASETID).toString());
        return dataSetId;
    }

    private Long getSchemeId() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam(SCHEME);
        return schemeId;
    }

    private boolean isJXSchemeExtendAnalysis() {
        if (!this.isCM() || this.getSchemeId() == 0L) {
            return false;
        }
        DynamicObject dy = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"dataparams", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getSchemeId())});
        if (dy == null || StringUtils.isEmpty((CharSequence)dy.getString("dataparams"))) {
            return false;
        }
        DataFormula dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class);
        DatasetDto datasetDto = dataparams.getDatasetDto();
        if (Objects.isNull(datasetDto.getExtendsModelNumber())) {
            return false;
        }
        return dataparams != null && !dataparams.isAllowEdit();
    }

    private void makeUpF7Area() {
        Area dimPanel = new Area(DIM_PANEL);
        Page page = new Page();
        DatasetDto dataSetDto = this.getDataSetDto();
        if (dataSetDto == null || !this.checkDatasetDto(false)) {
            return;
        }
        Map<String, Map<String, String>> allDimMap = PivotServiceHelper.getDimMap(this.getView(), dataSetDto);
        if (allDimMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u4f53\u7cfb\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"DataSetPreviewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.getView().getPageCache().put(ALL_DIM_MAP_CACHE, SerializationUtils.serializeToBase64(allDimMap));
        Map<String, Boolean> f7Dims = PivotServiceHelper.getF7Dims(dataSetDto.getExpression());
        if (this.isCM() && this.isJXSchemeExtendAnalysis()) {
            f7Dims = F7DimHelper.getCMF7Config();
        }
        List<String> shortNumberList = f7Dims.keySet().stream().collect(Collectors.toList());
        List<String> sortedShortNumber = this.sortShortNumber(shortNumberList);
        PivotServiceHelper.buildDimPanel(dimPanel, sortedShortNumber, f7Dims, this.getView(), dataSetDto);
        page.addArea(dimPanel);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private Map<String, List<Map<String, String>>> getMembers() {
        HashMap<String, List<Map<String, String>>> dimMembers = new HashMap<String, List<Map<String, String>>>(12);
        String disF7Set = this.getView().getPageCache().get("DisF7Set");
        if (StringUtils.isNotEmpty((CharSequence)disF7Set)) {
            Map dims = (Map)ObjectSerialUtil.deSerializedBytes((String)disF7Set);
            for (Map.Entry entry : dims.entrySet()) {
                String dim = (String)entry.getKey();
                String shortNumber = (String)entry.getValue();
                ArrayList<Map<Object, Object>> maps = new ArrayList<Map<Object, Object>>(12);
                if (Objects.isNull(this.getModel().getValue(dim)) || this.getModel().getValue(dim) instanceof MulBasedataDynamicObjectCollection && ((MulBasedataDynamicObjectCollection)this.getModel().getValue(dim)).isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8865\u5168\u6570\u636e\u96c6\u53c2\u6570\u3002", (String)"PivotViewPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                Object dyn = this.getModel().getValue(dim);
                if (Objects.isNull(dyn)) continue;
                Control c = this.getView().getControl(dim.toLowerCase());
                if (c == null) {
                    throw new KDBizException("F7 key is null");
                }
                if (c instanceof BasedataEditSingleMemberF7BCM || c instanceof BasedataEditSingleMemberFIDM) {
                    String memberValue = ((DynamicObject)dyn).getString("number");
                    String id = ((DynamicObject)dyn).getString("id");
                    String name = ((DynamicObject)dyn).getString("name");
                    HashMap<String, String> dimM = new HashMap<String, String>(4);
                    dimM.put("id", id);
                    dimM.put("name", name);
                    dimM.put("number", memberValue);
                    dimM.put("range", "10");
                    maps.add(dimM);
                } else if (c instanceof BasedataEditMultiMemberFIDM) {
                    List<Map<String, String>> selected = this.getCacheSelectedByShortNum(shortNumber);
                    if (selected == null || selected.isEmpty()) {
                        DynamicObjectCollection collection = (DynamicObjectCollection)dyn;
                        collection.stream().forEach(v -> {
                            String memberValue = v.getString("fbasedataid.number");
                            String id = v.getString("fbasedataid.id");
                            String name = v.getString("fbasedataid.name");
                            HashMap<String, String> dimM = new HashMap<String, String>(4);
                            dimM.put("id", id);
                            dimM.put("name", name);
                            dimM.put("number", memberValue);
                            dimM.put("range", "10");
                            maps.add(dimM);
                        });
                    } else {
                        maps.addAll(selected);
                    }
                }
                dimMembers.put(shortNumber, maps);
            }
        }
        return dimMembers;
    }

    private void builderF7Member() {
        if (!this.checkDatasetDto(false)) {
            return;
        }
        String disF7Set = this.getView().getPageCache().get("DisF7Set");
        if (StringUtils.isEmpty((CharSequence)disF7Set)) {
            return;
        }
        Map<String, Map<String, String>> allDimMap = this.getAllDimMap();
        Map<String, List<Map<String, String>>> defaultMultiMembers = this.isFAR() ? PivotServiceHelper.getFarDefaultDimValue(this.getCurModelId(), this.getDatasetId(), this.getSchemeId(), allDimMap) : this.getDefaultMembers();
        Map dims = (Map)ObjectSerialUtil.deSerializedBytes((String)disF7Set);
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        DatasetDto datasetDto = this.getDataSetDto();
        String dataSrc = Objects.isNull(datasetDto) ? "-1" : datasetDto.getDataSrcType();
        Long srcId = Objects.isNull(datasetDto) ? Long.valueOf(0L) : datasetDto.getDataSrcId();
        DisModelTypeEnum modelTypeEnum = DisModelTypeEnum.getModelType((String)dataSrc, (Long)srcId);
        Map<String, String> upperNumToRealNum = PivotServiceHelper.getRealDimShortNumber(this.getCurModelId(), modelTypeEnum.getType());
        if (defaultMultiMembers != null && !defaultMultiMembers.isEmpty()) {
            for (Map.Entry entry : dims.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Map<String, String> map1 = allDimMap.get(value);
                String number = map1.get("number");
                if (!(defaultMultiMembers.get(value) != null && !defaultMultiMembers.get(value).isEmpty() || defaultMultiMembers.get(value = upperNumToRealNum.get(value)) != null && !defaultMultiMembers.get(value).isEmpty())) continue;
                List<DimMemberInfo> dimMemberInfos = this.buildDimMembers(number, defaultMultiMembers.get(value));
                Control c = this.getView().getControl(key.toLowerCase());
                if (c == null) {
                    throw new KDBizException("F7 key is null");
                }
                if (c instanceof BasedataEditSingleMemberF7BCM || c instanceof BasedataEditSingleMemberFIDM) {
                    DimMemberInfo dimMemberInfo = dimMemberInfos.size() > 0 ? dimMemberInfos.get(0) : null;
                    if (!Objects.nonNull(dimMemberInfo) || !props.containsKey((Object)key.toLowerCase())) continue;
                    this.getModel().setValue(key.toLowerCase(), (Object)dimMemberInfo.getId());
                    this.getView().updateView(key.toLowerCase());
                    continue;
                }
                if (!(c instanceof BasedataEditMultiMemberFIDM)) continue;
                Object[] ids = dimMemberInfos.stream().map(v -> v.getId()).collect(Collectors.toList()).toArray();
                this.getModel().setValue(key.toLowerCase(), (Object)ids);
                this.getView().updateView(key.toLowerCase());
            }
        }
    }

    private Map<String, Map<String, String>> getAllDimMap() {
        String allStr = this.getView().getPageCache().get(ALL_DIM_MAP_CACHE);
        if (StringUtils.isEmpty((CharSequence)allStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u4f53\u7cfb\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"DataSetPreviewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        Map allDimMap = (Map)SerializationUtils.deSerializeFromBase64((String)allStr);
        return allDimMap;
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if (StringUtils.equals((CharSequence)"getF7Member", (CharSequence)operation)) {
            if (!this.checkDatasetDto(false)) {
                return;
            }
            Map<String, List<Map<String, String>>> members = this.getMembers();
            if (Objects.isNull(members)) {
                return;
            }
            this.sendMsgToMain(members);
        }
    }

    private void sendMsgToMain(Object params) {
        String receiver = this.isCM() ? "bcm_far_pivot" : "far_pivot";
        CommandParam commandParam = new CommandParam("far_pivot_f7", receiver, "getF7Member", params);
        this.sendMsg(this.getView(), commandParam);
    }

    private List<String> sortShortNumber(List<String> sourceList) {
        if (Objects.isNull(sourceList) || sourceList.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> newSoure = sourceList.stream().map(v -> v.toUpperCase(Locale.ENGLISH)).collect(Collectors.toList());
        try {
            DatasetDto dataSetDto = this.getDataSetDto();
            if (dataSetDto == null) {
                return new ArrayList<String>();
            }
            DisModelTypeEnum modelTypeEnum = DisModelTypeEnum.getModelType((String)dataSetDto.getDataSrcType(), (Long)dataSetDto.getDataSrcId());
            ModelStrategyEx modelStrategyEx = PivotModelStrategyEx.getPivotModelStrategyEx(dataSetDto);
            List allDims = modelStrategyEx.getDim().getDimList().stream().map(v -> v.getShortNumber().toUpperCase(Locale.ENGLISH)).collect(Collectors.toList());
            ArrayList fixedSort = Lists.newArrayList((Object[])new String[]{"S", "FY", "P", "C", "E", "BP", "AT"});
            if (this.isCM() && this.isJXSchemeExtendAnalysis()) {
                return fixedSort;
            }
            if (this.isFAR() && DisModelTypeEnum.EB.getType().equals(modelTypeEnum.getType())) {
                return allDims.stream().filter(v -> newSoure.contains(v)).collect(Collectors.toList());
            }
            allDims.removeAll(fixedSort);
            fixedSort.addAll(allDims);
            return fixedSort.stream().filter(v -> newSoure.contains(v)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return newSoure;
        }
    }

    private List<DimMemberInfo> buildDimMembers(String dimNumber, List<Map<String, String>> members) {
        ArrayList<DimMemberInfo> dimMemberInfos = new ArrayList<DimMemberInfo>(members.size());
        DimMemberAdapter dimMemberHelper = PivotModelStrategyEx.getPivotModelStrategyEx(this.getDataSetDto()).getDimMember();
        for (Map<String, String> member : members) {
            String number = member.get("number");
            DimMemberInfo mv = dimMemberHelper.findMemberByNumber(dimNumber, number);
            if (mv == null) continue;
            dimMemberInfos.add(mv);
        }
        return dimMemberInfos;
    }
}

