/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot.uitls;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;

public class PivotMovePlugin
extends AbstractBaseFormPlugin {
    protected static final String TREE_LIST = "treelist";
    protected static final String FOCUS_NODEID = "focusnodeid";
    public static final String SCHEMEID = "schemeId";
    protected static final String ROWLIST = "rowlist";
    protected static final String FOCUS = "focus";
    protected static final String TREEROOT = "treeroot";
    protected static final String TEMPLATECATALOG = "templatecatalog";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("bar_add", "bar_cancel", "searchbefore", "searchnext");
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    PivotMovePlugin.this.searchMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
                } else {
                    PivotMovePlugin.this.getPageCache().put(PivotMovePlugin.ROWLIST, null);
                    PivotMovePlugin.this.getView().showTipNotification(MessageConstant.getName_NOINPUT());
                }
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode catalog = new TreeNode();
        List treeList = (List)this.getView().getFormShowParameter().getCustomParam(TREE_LIST);
        this.getPageCache().remove(FOCUS_NODEID);
        String headid = this.initRootNode(catalog);
        this.getPageCache().put(TREE_LIST, SerializationUtils.toJsonString((Object)treeList));
        BCMTreeUtils.setEntryNodeDm((TreeNode)catalog, (List)treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)catalog);
        if (StringUtils.isEmpty((CharSequence)catalog.getId())) {
            return;
        }
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        tree.addNode(catalog);
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)catalog));
    }

    public String initRootNode(TreeNode catalog) {
        String headid = "0";
        String headName = ResManager.loadKDString((String)"\u6570\u636e\u5206\u6790\u65b9\u6848", (String)"AbsPivotPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]);
        catalog.setId(headid);
        catalog.setIcon("kdfont kdfont-wenjianjia");
        this.getPageCache().put(FOCUS_NODEID, headid);
        this.getPageCache().put("headnodeid", headid);
        catalog.setParentid("");
        catalog.setType("default");
        catalog.setText(headName);
        return headid;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            TreeNode old;
            String rowcache = this.getPageCache().get(ROWLIST);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"DiscTemplateCatalogSelectPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode[] rowList = (TreeNode[])SerializationUtils.fromJsonString((String)rowcache, TreeNode[].class);
            int rowCount = Integer.parseInt(this.getPageCache().get(FOCUS));
            if ("searchbefore".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DiscTemplateCatalogSelectPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else {
                if (rowList.length - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DiscTemplateCatalogSelectPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            this.getPageCache().put(FOCUS, String.valueOf(rowCount));
            TreeNode focusNode = rowList[rowCount];
            TreeView treeView = (TreeView)this.getControl(TEMPLATECATALOG);
            String oldnode = this.getPageCache().get("oldnode");
            TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
            if (old != null) {
                old.setColor("");
                treeView.updateNode(old);
            }
            treeView.updateNode(focusNode);
            treeView.focusNode(focusNode);
            this.getPageCache().put("oldnode", SerializationUtils.serializeToBase64((Object)focusNode));
        } else if ("bar_add".equals(key) && this.isValida()) {
            this.moveTemplate();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private boolean isValida() {
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        Map map = tree.getTreeState().getFocusNode();
        if (Objects.isNull(map)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u5206\u7c7b\u3002", (String)"PivotViewPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        String newNodeId = (String)map.get("id");
        if (!QueryServiceHelper.exists((String)"far_pivotcatalog", (Object)LongUtil.toLong((Object)newNodeId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"PivotTableSchemePlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.equals((CharSequence)newNodeId, (CharSequence)"0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u76f4\u63a5\u4e0b\u7ea7\u6682\u4e0d\u652f\u6301\u5206\u6790\u65b9\u6848\u3002", (String)"AbsPivotPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (Objects.isNull(modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        List noIds = PermClassEntityHelper.getDiscPermissionMap((String)"far_pivotcatalog", (Long)((Long)modelId), (Long)LongUtil.toLong((Object)RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1");
        List onlysIds = PermClassEntityHelper.getDiscPermissionMap((String)"far_pivotcatalog", (Long)((Long)modelId), (Long)LongUtil.toLong((Object)RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"2");
        noIds.addAll(onlysIds);
        if (noIds.contains(LongUtil.toLong((Object)newNodeId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5206\u7c7b\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"AbsPivotPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void moveTemplate() {
        TreeView tree = (TreeView)this.getControl(TEMPLATECATALOG);
        Map map = tree.getTreeState().getFocusNode();
        String newNodeId = (String)map.get("id");
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam(SCHEMEID);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"far_pivot_scheme");
        if (Objects.nonNull(dy)) {
            dy.set("catalog", (Object)newNodeId);
            AnalysisOpLogParam logParam = this.getSingleLogParam(dy);
            logParam.buildOpName(OperationName.SCHEME_MOVE);
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
                logParam.buildOpResult(OperationResult.SUCCESS);
            }
            catch (Exception e) {
                logParam.buildOpResult(OperationResult.FAILURE);
                throw e;
            }
            finally {
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
        }
        this.getView().returnDataToParent((Object)newNodeId);
        this.getView().close();
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(TEMPLATECATALOG);
        List<TreeNode> treeNodes = new ArrayList<TreeNode>();
        treeNodes = this.getTreeNodeListByText(root, treeNodes, text);
        List<TreeNode> alltreeNodes = new ArrayList<TreeNode>();
        alltreeNodes = this.getTreeNodeListByText(root, alltreeNodes, "");
        for (TreeNode treeNode : alltreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(alltreeNodes);
        if (!treeNodes.isEmpty()) {
            this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
            TreeNode asd = treeNodes.get(0);
            this.getPageCache().put(FOCUS, "0");
            mTree.updateNode(asd);
            mTree.focusNode(asd);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"DiscTemplateCatalogSelectPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private List<TreeNode> getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
        return treeNodes;
    }

    private AnalysisOpLogParam getSingleLogParam(DynamicObject scheme) {
        String selectedField;
        String numberField;
        String entity;
        Object modelId = this.getView().getFormShowParameter().getCustomParam("modelId");
        if (ApplicationTypeEnum.FAR.getAppnum().equals(this.getView().getFormShowParameter().getAppId())) {
            entity = "fidm_model";
            numberField = "number";
            selectedField = "id,number,name";
        } else {
            entity = "bcm_model";
            numberField = "shownumber";
            selectedField = "id,shownumber,name";
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)entity, (String)selectedField, (QFilter[])new QFilter[]{new QFilter("id", "=", modelId)});
        String schemeNumber = scheme.getString("number");
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.PIVOT_TABLE).buildFormNumber("far_pivotcatalog").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString(numberField), schemeNumber});
    }
}

