/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.pivot.uitls;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.dataset.PreviewDataSet;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.enums.FidmDataTypeEnum;
import kd.epm.far.business.common.helper.ElementHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.adapter.DimMemberAdapter;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.eb.EBDataReader;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.business.far.enums.ModelSourceEnum;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.faranalysis.pivot.dto.ColsField;
import kd.epm.far.formplugin.faranalysis.pivot.dto.DataFormula;
import kd.epm.far.formplugin.faranalysis.pivot.dto.PivotModelStrategyEx;
import kd.epm.far.formplugin.faranalysis.pivot.uitls.F7DimHelper;
import org.apache.commons.lang.RandomStringUtils;

public class PivotServiceHelper {
    private static final String ALL_DIM_MAP_CACHE = "allDimMap";
    private static final String DIMF7MAP = "dimf7map";
    protected static final String DIMENSION_NUMBER_MAP_CACHE = "dimension_number_map_cache";
    private static final String DISF7SET = "DisF7Set";

    public static List<Map> getPivotData(Long datasetId, Map<String, String> dimDefaultMembers) {
        return (List)new PreviewDataSet(datasetId, dimDefaultMembers).getResult();
    }

    public static List<ColsField> getColsFields(DatasetDto datasetDto) {
        List columnList = DatasetUtil.getColumnsByExpression((DatasetDto)datasetDto, (boolean)false);
        return PivotServiceHelper.buildColsFields(columnList);
    }

    private static List<ColsField> buildColsFields(List<Map<String, Object>> columnList) {
        ArrayList<ColsField> colsFields = new ArrayList<ColsField>();
        ArrayList valCols = new ArrayList();
        columnList.forEach(m -> {
            boolean isValue = false;
            if (FidmDataTypeEnum.DM.getType().equals(m.get("type")) || FidmDataTypeEnum.LEM.getType().equals(m.get("type")) || FidmDataTypeEnum.REM.getType().equals(m.get("type"))) {
                isValue = true;
            }
            ColsField colsField = new ColsField(String.valueOf(m.get("number")), String.valueOf(m.get("name")), isValue);
            if (isValue) {
                valCols.add(colsField);
            } else {
                colsFields.add(colsField);
            }
        });
        colsFields.addAll(valCols);
        return colsFields;
    }

    public static List<ColsField> getColsFields(Object data) {
        List da = (List)data;
        ArrayList<ColsField> list = new ArrayList<ColsField>(12);
        if (da.isEmpty()) {
            return list;
        }
        Map map = (Map)da.get(0);
        for (Map.Entry entry : map.entrySet()) {
            list.add(new ColsField((String)entry.getKey(), (String)entry.getKey(), entry.getValue() instanceof BigDecimal));
        }
        return list;
    }

    public static boolean hasVariable(Long modelId, Long dataSetId) {
        Map result = DatasetServiceHelper.getVarAndDimVars((long)modelId, (long)dataSetId, (long)0L, (boolean)true);
        List variableList = (List)result.get("variableList");
        List shortNumberList = (List)result.get("shortNumberList");
        return !shortNumberList.isEmpty() || !variableList.isEmpty();
    }

    public static boolean hasDimsVariable(Long modelId, Long dataSetId) {
        Map res = DatasetServiceHelper.getVarAndDimVars((long)modelId, (long)dataSetId, (long)0L, (boolean)true);
        List shortNumberList = (List)res.get("shortNumberList");
        return !shortNumberList.isEmpty();
    }

    public static boolean addCatalogRoot(Long dmModelId, String modelType) {
        QFilter mqFilter = new QFilter("model", "=", (Object)dmModelId);
        mqFilter.and("number", "=", (Object)"default").and("model_type", "=", (Object)modelType);
        boolean exists = QueryServiceHelper.exists((String)"far_pivotcatalog", (QFilter[])new QFilter[]{mqFilter});
        if (!exists) {
            DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)"far_pivotcatalog");
            catalog.set("model", (Object)dmModelId);
            catalog.set("model_type", (Object)modelType);
            catalog.set("number", (Object)"default");
            catalog.set("longnumber", (Object)"default");
            catalog.set("name", (Object)ResManager.getLocaleString((String)"\u9ed8\u8ba4\u5206\u6790\u5206\u7c7b", (String)"PivotServiceHelper_2", (String)"epm-far-formplugin"));
            catalog.set("isleaf", (Object)Boolean.TRUE);
            catalog.set("status", (Object)"C");
            catalog.set("enable", (Object)"1");
            SaveServiceHelper.save((IDataEntityType)catalog.getDynamicObjectType(), (Object[])new Object[]{catalog});
        }
        return true;
    }

    public static boolean addImprovisation(Long modelId) {
        boolean exists = QueryServiceHelper.exists((String)"far_pivot_scheme", (QFilter[])new QFilter[]{PivotServiceHelper.getImprovisationQFilter(modelId)});
        if (!exists) {
            DynamicObject sch = BusinessDataServiceHelper.newDynamicObject((String)"far_pivot_scheme");
            sch.set("model", (Object)modelId);
            sch.set("model_type", (Object)"bcm_model");
            sch.set("number", (Object)"improvisation-analysis");
            sch.set("name", (Object)ResManager.loadKDString((String)"\u5373\u5e2d\u5206\u6790", (String)"PivotServiceHelper_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            sch.set("catalog", (Object)0L);
            SaveServiceHelper.save((IDataEntityType)sch.getDynamicObjectType(), (Object[])new Object[]{sch});
        }
        return true;
    }

    public static QFilter getImprovisationQFilter(Long modelId) {
        QFilter mqFilter = new QFilter("model", "=", (Object)modelId);
        mqFilter.and("number", "=", (Object)"improvisation-analysis").and("catalog", "=", (Object)0L).and("model_type", "=", (Object)"bcm_model");
        return mqFilter;
    }

    public static void buildDimPanel(Area dimPanel, List<String> shortNumberList, Map<String, Boolean> f7DimsType, IFormView view, DatasetDto dto) {
        if (shortNumberList == null || shortNumberList.isEmpty()) {
            return;
        }
        Map<String, Map<String, String>> allDimMap = PivotServiceHelper.getDimMap(view, dto);
        if (allDimMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u4f53\u7cfb\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"DataSetPreviewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        view.getPageCache().put(ALL_DIM_MAP_CACHE, SerializationUtils.serializeToBase64(allDimMap));
        HashMap<String, String> elements = new HashMap<String, String>(12);
        for (String shortNumber : shortNumberList) {
            PivotServiceHelper.addBaseEditElement(dimPanel, shortNumber, f7DimsType, allDimMap);
            Map<String, String> dimMap = allDimMap.get(shortNumber);
            if (!Objects.nonNull(dimMap)) continue;
            elements.put(dimMap.get("number").toLowerCase(Locale.ENGLISH), shortNumber);
        }
        if (shortNumberList.isEmpty()) {
            view.getPageCache().remove(DISF7SET);
        } else {
            view.getPageCache().put(DISF7SET, ObjectSerialUtil.toByteSerialized(elements));
        }
    }

    private static void addBaseEditElement(Area dimPanel, String shortNumber, Map<String, Boolean> f7DimsType, Map<String, Map<String, String>> allDimMap) {
        Map<String, String> dimMap = allDimMap.get(shortNumber);
        if (dimMap == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"DataSetPreviewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]), shortNumber));
        }
        Element baseEditElement = PivotServiceHelper.createSingleBaseEditElement(dimMap.get("name"), dimMap.get("number").toLowerCase(Locale.ENGLISH), dimMap.get("membermodel"));
        if (f7DimsType.get(shortNumber).booleanValue()) {
            baseEditElement = PivotServiceHelper.createMultiBaseEditElement(dimMap.get("name"), dimMap.get("number").toLowerCase(Locale.ENGLISH), dimMap.get("membermodel"));
        }
        dimPanel.addElement(baseEditElement);
    }

    public static Element createMultiBaseEditElement(String name, String sign, String entity) {
        MultiBaseEditElement baseEdit = new MultiBaseEditElement(name, sign, entity);
        baseEdit.setFuzzySearch(false);
        baseEdit.setBtnFontClass("kdfont kdfont-zidingyi");
        ElementHelper.buildPivotF7Style((Element)baseEdit);
        baseEdit.setWidth(new LocaleString("12.5%"));
        return baseEdit;
    }

    private static Element createSingleBaseEditElement(String name, String sign, String entity) {
        BaseEditElement baseEdit = new BaseEditElement(name, sign, entity);
        ElementHelper.buildPivotF7Style((Element)baseEdit);
        baseEdit.setWidth(new LocaleString("12.5%"));
        return baseEdit;
    }

    public static Map<String, Map<String, String>> getDimMap(IFormView view, DatasetDto dto) {
        String s = view.getPageCache().get(ALL_DIM_MAP_CACHE);
        if (s != null) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)s);
        }
        ModelStrategyEx modelStrategyEx = PivotModelStrategyEx.getPivotModelStrategyEx(dto);
        String dimEntity = modelStrategyEx.getDim().getDimEntity();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)dimEntity, (String)"id,shortnumber,number,name,membermodel,issysdimension", (QFilter[])new QFilter("model", "=", (Object)dto.getDataSrcId()).toArray(), (String)"dseq");
        HashMap<String, Map<String, String>> allDimMap = new HashMap<String, Map<String, String>>(32);
        HashMap<String, Long> dimF7Map = new HashMap<String, Long>(32);
        for (DynamicObject dyn : dyns) {
            String dimensionId = dyn.getString("id");
            String shortNumber = dyn.getString("shortnumber").toUpperCase(Locale.ENGLISH);
            String dimNumber = dyn.getString("number");
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            dimMap.put("id", dimensionId);
            dimMap.put("name", dyn.getString("name"));
            dimMap.put("shortnumber", shortNumber);
            dimMap.put("number", dimNumber);
            dimMap.put("membermodel", DmDimMemberEntityEnum.getNewEntityNum((String)dyn.getString("membermodel")));
            allDimMap.put(shortNumber, dimMap);
            dimF7Map.put(dimNumber.toLowerCase(Locale.ENGLISH), Long.parseLong(dimensionId));
        }
        view.getPageCache().put(DIMF7MAP, SerializationUtils.serializeToBase64(dimF7Map));
        return allDimMap;
    }

    public static void showTableView(Object result, IFormView view, String modelId, String dataset) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        String formId = "fidm_preview_multi_line";
        fsp.setFormId(formId);
        fsp.setParentPageId(view.getPageId());
        fsp.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u9884\u89c8", (String)"PivotServiceHelper_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam("dmmodelid", (Object)modelId);
        if (result instanceof Exception || Objects.isNull(result)) {
            return;
        }
        fsp.setCustomParam("result", (Object)ObjectSerialUtil.toByteSerialized((Object)result));
        fsp.setCustomParam("datasetId", Objects.isNull(dataset) || StringUtils.equals((CharSequence)"0", (CharSequence)dataset) ? null : Long.valueOf(Long.parseLong(dataset)));
        fsp.setCustomParam("type", (Object)DataSetTypeEnum.MULTIPLE_ROW.getType());
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("540px");
        inlineStyleCss.setWidth("960px");
        fsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        view.showForm(fsp);
    }

    public static void showF7Panel(IFormView view, Map<String, Object> params) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("dimpanel");
        String formId = "far_pivot_f7";
        fsp.setFormId(formId);
        fsp.setPageId(PivotServiceHelper.getPageIdAndCache(view.getPageCache(), formId));
        fsp.setParentPageId(view.getPageId());
        fsp.setCustomParams(params);
        view.showForm(fsp);
    }

    private static String getPageIdAndCache(IPageCache pageCache, String formId) {
        String pageId = formId + RandomStringUtils.randomAlphanumeric((int)10);
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
        return pageId;
    }

    public static void editScheme(Long id, IFormView view, Map<String, Object> params, CloseCallBack closeCallBack) {
        BaseShowParameter info = new BaseShowParameter();
        info.getOpenStyle().setShowType(ShowType.Modal);
        info.setFormId("far_pivot_scheme");
        params.put("entity", "far_pivot_scheme");
        info.setCustomParams(params);
        info.setPkId((Object)id);
        info.setStatus(OperationStatus.EDIT);
        if (closeCallBack != null) {
            info.setCloseCallBack(closeCallBack);
        }
        view.showForm((FormShowParameter)info);
    }

    public static void deleteScheme(Long pkId, IFormView view) {
        DeleteServiceHelper.delete((String)"far_pivot_scheme", (QFilter[])new QFilter("id", "=", (Object)pkId).toArray());
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PivotSchemeListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
    }

    public static Map<String, List<Map<String, String>>> getFarDefaultDimValue(Long modelId, Long datasetId, Long SchemeId, Map<String, Map<String, String>> allDimMap) {
        if (datasetId != null && datasetId != 0L) {
            return PivotServiceHelper.getDefaultMembers(modelId, datasetId, SchemeId, allDimMap);
        }
        return PivotServiceHelper.getPopDefaultMembers(modelId, SchemeId, allDimMap);
    }

    public static Map<String, List<Map<String, String>>> getDefaultMembers(Long modelId, Long datasetId, Long SchemeId, Map<String, Map<String, String>> allDimMap) {
        Map dimMap;
        String dims;
        if (Objects.isNull(SchemeId) || SchemeId == 0L) {
            return new HashMap<String, List<Map<String, String>>>();
        }
        DatasetDto dto = DatasetUtil.getSingleDataSetDto((Long)datasetId);
        if (dto == null) {
            return new HashMap<String, List<Map<String, String>>>();
        }
        Long farModelId = modelId;
        if (dto.getDiscmodelId() != null && dto.getDiscmodelId() != 0L) {
            farModelId = dto.getDiscmodelId();
        }
        Map<String, Boolean> f7Dims = PivotServiceHelper.getF7Dims(dto.getExpression());
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)SchemeId, (String)"far_pivot_scheme", (String)"dims");
        HashMap<String, List<Map<String, String>>> dbMs = new HashMap<String, List<Map<String, String>>>(12);
        if (Objects.nonNull(dy) && StringUtils.isNotEmpty((CharSequence)(dims = dy.getString("dims"))) && !(dimMap = (Map)JSONObject.parseObject((String)dims, Map.class)).isEmpty()) {
            Object o = dimMap.values().stream().findFirst().get();
            if (o instanceof List) {
                Map newData = (Map)JSONObject.parseObject((String)dims, Map.class);
                dbMs.putAll(newData);
            } else if (o instanceof String) {
                Map newData = (Map)JSONObject.parseObject((String)dims, Map.class);
                dbMs.putAll(PivotServiceHelper.convertDimsParamsToCm(newData));
            }
        }
        return PivotServiceHelper.buildFarDefaultDimValue(farModelId, allDimMap, f7Dims, dbMs, dto);
    }

    public static Map<String, List<Map<String, String>>> getPopDefaultMembers(Long modelId, Long SchemeId, Map<String, Map<String, String>> allDimMap) {
        DataFormula dataparams;
        if (Objects.isNull(SchemeId) || SchemeId == 0L) {
            return new HashMap<String, List<Map<String, String>>>(12);
        }
        Map<String, Boolean> f7Dims = new HashMap<String, Boolean>(12);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)SchemeId, (String)"far_pivot_scheme", (String)"dataparams");
        Map<String, List<Map<String, String>>> dbMs = new HashMap<String, List<Map<String, String>>>(12);
        DatasetDto dto = null;
        Long farModelId = modelId;
        if (dy != null && (dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class)) != null && dataparams.getDatasetDto() != null) {
            dto = dataparams.getDatasetDto();
            if (dto.getDiscmodelId() != null && dto.getDiscmodelId() != 0L) {
                farModelId = dto.getDiscmodelId();
            }
            f7Dims = PivotServiceHelper.getF7Dims(dto.getExpression());
            dbMs = dataparams.getDimParams();
        }
        if (dbMs == null) {
            dbMs = new HashMap(12);
        }
        if (dto == null) {
            return new HashMap<String, List<Map<String, String>>>();
        }
        return PivotServiceHelper.buildFarDefaultDimValue(farModelId, allDimMap, f7Dims, dbMs, dto);
    }

    private static Map<String, List<Map<String, String>>> buildFarDefaultDimValue(Long modelId, Map<String, Map<String, String>> allDimMap, Map<String, Boolean> dimVarMaps, Map<String, List<Map<String, String>>> dbMs, DatasetDto dto) {
        HashMap<String, List<Map<String, String>>> members = new HashMap<String, List<Map<String, String>>>(12);
        Long farModelId = modelId;
        if (dto.getDiscmodelId() != null && dto.getDiscmodelId() != 0L) {
            farModelId = dto.getDiscmodelId();
        }
        List dimOrVar = dimVarMaps.keySet().stream().collect(Collectors.toList());
        String ebDataset = dto == null || dto.getEbDataset() == null ? "" : dto.getEbDataset();
        Map<String, List<Map<String, String>>> defaultMs = PivotServiceHelper.getCurModelMembers(farModelId, ebDataset, dimVarMaps);
        DimMemberAdapter dimMemberSrcHelper = PivotModelStrategyEx.getPivotModelStrategyEx(dto).getDimMember();
        dimOrVar.stream().forEach(v -> {
            String dimNum;
            List m = (List)dbMs.get(v);
            Map dim = (Map)allDimMap.get(v);
            String string = dimNum = dim != null ? (String)dim.get("number") : null;
            if (Objects.isNull(m) || m.isEmpty()) {
                PivotServiceHelper.buildUserDefaultDims(members, (List)defaultMs.get(v), dimNum, v, dimMemberSrcHelper);
            } else {
                ArrayList<Map> dbM = new ArrayList<Map>(m.size());
                for (Map em : m) {
                    DimMemberInfo mSrcVo;
                    if (dimMemberSrcHelper == null || !Objects.nonNull(mSrcVo = dimMemberSrcHelper.findMemberByNumber(dimNum, (String)em.get("number"), false))) continue;
                    em.put("id", String.valueOf(mSrcVo.getId()));
                    dbM.add(em);
                }
                members.put((String)v, (List<Map<String, String>>)dbM);
                if (dbM.isEmpty()) {
                    PivotServiceHelper.buildUserDefaultDims(members, (List)defaultMs.get(v), dimNum, v, dimMemberSrcHelper);
                }
            }
        });
        return members;
    }

    private static void buildUserDefaultDims(Map<String, List<Map<String, String>>> members, List<Map<String, String>> defaultNumbers, String dimNum, String shortNumber, DimMemberAdapter dimMemberSrcHelper) {
        ArrayList<Map<String, String>> newData = new ArrayList<Map<String, String>>(4);
        if (defaultNumbers != null && !defaultNumbers.isEmpty()) {
            for (Map<String, String> dM : defaultNumbers) {
                String number = dM.get("number");
                DimMemberInfo mSrcVo = dimMemberSrcHelper.findMemberByNumber(dimNum, number, false);
                if (!Objects.nonNull(mSrcVo)) continue;
                newData.add(dM);
            }
        }
        members.put(shortNumber, newData);
    }

    public static Map<String, List<Map<String, String>>> getCurModelMembers(Long modelId, String ebDataSet, Map<String, Boolean> dimVarMaps) {
        HashMap<String, List<Map<String, String>>> members = new HashMap<String, List<Map<String, String>>>(12);
        DynamicObject model = DatasetDataReader.getModel((Long)modelId);
        String modelType = model.getString("modeltype");
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType((String)modelType);
        Map<String, String> realDimMap = PivotServiceHelper.getRealDimShortNumber(modelId);
        if (dimVarMaps != null && !dimVarMaps.isEmpty()) {
            for (Map.Entry<String, Boolean> entry : dimVarMaps.entrySet()) {
                String key = entry.getKey();
                Boolean value = entry.getValue();
                String dim = realDimMap.get(key.trim().toUpperCase(Locale.ENGLISH));
                ArrayList<Map<String, String>> ms = new ArrayList<Map<String, String>>(12);
                if (dim != null) {
                    DimDefaultValueVo dfV = DimDefaultValueHelper.getDefaultValue((String)realDimMap.get(key.trim().toUpperCase(Locale.ENGLISH)), (Long)modelId, (DisModelTypeEnum)enumByType, (String)ebDataSet);
                    if (value.booleanValue()) {
                        for (DimMemberInfo memberInfo : dfV.getDefaultCurs()) {
                            ms.add(PivotServiceHelper.buildMs(memberInfo.getId() == null ? "0" : memberInfo.getId().toString(), memberInfo.getNumber(), memberInfo.getRange() == 0 ? "10" : String.valueOf(memberInfo.getRange())));
                        }
                    } else {
                        String defaultValue = dfV.getDefaultValue();
                        ms.add(PivotServiceHelper.buildMs("0", defaultValue, "10"));
                    }
                }
                members.put(key, ms);
            }
        }
        return members;
    }

    private static Map<String, String> buildMs(String id, String number, String range) {
        HashMap<String, String> de = new HashMap<String, String>(3);
        de.put("id", id);
        de.put("number", number);
        de.put("range", range);
        return de;
    }

    public static Map<String, String> getRealDimShortNumber(Long modelId) {
        return new ModelStrategyEx(modelId).getDim().getDimList().stream().collect(Collectors.toMap(dim -> dim.getShortNumber().trim().toUpperCase(Locale.ENGLISH), DimensionInfo::getShortNumber));
    }

    public static Map<String, String> getRealDimShortNumber(Long modelId, String dataSrcType) {
        return new ModelStrategyEx(modelId, dataSrcType).getDim().getDimList().stream().collect(Collectors.toMap(dim -> dim.getShortNumber().trim().toUpperCase(Locale.ENGLISH), DimensionInfo::getShortNumber));
    }

    public static Map<String, Boolean> getF7Dims(String expression) {
        HashMap<String, Boolean> keys = new HashMap<String, Boolean>(12);
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return keys;
        }
        Arrays.stream(expression.split(",")).filter(v -> v.contains(".$Cur") || v.contains(".$Curs")).collect(Collectors.toList()).forEach(v -> {
            String[] split = v.split("\\.");
            if (split.length == 2) {
                keys.put(split[0].toUpperCase(Locale.ENGLISH), split[1].contains("Curs"));
            }
        });
        return keys;
    }

    public static DatasetDto createDataSetDto(Map<String, Object> params, boolean isOnlyAnalysis) {
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        datasetDataVo.setParam(Objects.nonNull(params.get("filter")) && StringUtils.isNotEmpty((CharSequence)params.get("filter").toString()) ? params.get("filter").toString() : null);
        if (Objects.nonNull(params.get("dproMap"))) {
            List propertyList = (List)params.get("dproMap");
            ArrayList propertyVoList = Lists.newArrayListWithCapacity((int)propertyList.size());
            for (Object propertyInfo : propertyList) {
                DatasetPropertyVo propertyVo = new DatasetPropertyVo();
                propertyVo.setType(Integer.valueOf(3));
                if (((String)propertyInfo.get("number")).contains(":")) {
                    String[] numbers = ((String)propertyInfo.get("number")).split(":");
                    propertyVo.setNumber(numbers[0]);
                    propertyVo.setPropertyNumber(numbers[1]);
                    String[] names = ((String)propertyInfo.get("name")).split(":");
                    propertyVo.setName(names[1]);
                } else {
                    propertyVo.setNumber((String)propertyInfo.get("number"));
                    propertyVo.setName((String)propertyInfo.get("name"));
                }
                propertyVo.setSource((String)propertyInfo.get("source"));
                propertyVoList.add(propertyVo);
            }
            datasetDataVo.setColumns((List)propertyVoList);
        }
        Object type = params.get("type");
        if (isOnlyAnalysis && Objects.nonNull(params.get("fmoney")) && Objects.equals("2", type)) {
            List fmoneyList = (List)params.get("fmoney");
            ArrayList propertyVoList = Lists.newArrayListWithCapacity((int)fmoneyList.size());
            for (String fmoney : fmoneyList) {
                DatasetPropertyVo propertyVo = new DatasetPropertyVo();
                propertyVo.setType(Integer.valueOf(1));
                propertyVo.setSource("extend");
                propertyVo.setNumber(fmoney);
                propertyVo.setFilters((List)Lists.newArrayListWithCapacity((int)0));
                propertyVoList.add(propertyVo);
            }
            datasetDataVo.setColumns((List)propertyVoList);
        }
        String dimMapExpression = F7DimHelper.getCMExExpression();
        if (isOnlyAnalysis) {
            HashMap allCurs = new HashMap();
            Map dimMap = (Map)params.get("dimMap");
            if (Objects.equals("1", type)) {
                Set curs = dimMap.keySet();
                allCurs.put("curs", curs);
            } else {
                Map<String, Boolean> defaultCmDims = F7DimHelper.getCMF7Config();
                HashSet curs = Sets.newHashSetWithExpectedSize((int)dimMap.size());
                HashSet cur = Sets.newHashSetWithExpectedSize((int)dimMap.size());
                for (Map.Entry entry : dimMap.entrySet()) {
                    Boolean isCreateF7 = defaultCmDims.get(entry.getKey());
                    if (Objects.isNull(isCreateF7)) continue;
                    if (Objects.equals(isCreateF7, Boolean.TRUE)) {
                        curs.add(entry.getKey());
                        continue;
                    }
                    cur.add(entry.getKey());
                }
                allCurs.put("curs", curs);
                allCurs.put("cur", cur);
            }
            dimMapExpression = DatasetUtil.buildExpression((Map)((Map)params.get("dimMap")), allCurs, (boolean)false);
        }
        String jsonString = JSON.toJSONString((Object)params.get("fmoney"));
        String fmoney = Arrays.stream(jsonString.replaceAll("[\"\\[\\]\\\\]", "").split(",")).map(String::trim).collect(Collectors.joining(","));
        DatasetDto datasetDto = new DatasetDto();
        datasetDto.setDiscmodelId((Long)params.get("modelId"));
        datasetDto.setDataSrcId((Long)params.get("modelId"));
        datasetDto.setExtendsModelId((Long)params.get("extendsModelId"));
        datasetDto.setExtendsModelNumber((String)params.get("extendsModelNumber"));
        if (Objects.nonNull(params.get("excludeDynaData"))) {
            datasetDto.setExcludeDynaData((Boolean)params.get("excludeDynaData") != false ? "1" : "0");
        }
        if (Objects.nonNull(params.get("excludeNullData"))) {
            datasetDto.setExcludeNullData((Boolean)params.get("excludeNullData") != false ? "1" : "0");
        }
        datasetDto.setType("2");
        datasetDto.setDataSrcType(ModelSourceEnum.CM.getType());
        datasetDto.setExpression(dimMapExpression);
        datasetDto.setTempExpression(dimMapExpression);
        datasetDto.setValue(fmoney);
        datasetDto.setData(JSON.toJSONString((Object)datasetDataVo));
        datasetDto.setHasSourceOrg(Objects.equals("2", type));
        datasetDto.setCm(true);
        return datasetDto;
    }

    public static Map<String, String> convertDimsParamsToFar(Map<String, List<Map<String, String>>> dimMembers) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(dimMembers.size());
        for (Map.Entry<String, List<Map<String, String>>> entry : dimMembers.entrySet()) {
            List<Map<String, String>> value = entry.getValue();
            if (value instanceof List) {
                List<Map<String, String>> dimMemberLists = value;
                if (dimMemberLists.isEmpty()) continue;
                paramsMap.put(entry.getKey(), dimMemberLists.get(0).get("number"));
                continue;
            }
            if (!(value instanceof String)) continue;
            paramsMap.put(entry.getKey(), entry.getValue().toString());
        }
        return paramsMap;
    }

    public static Map<String, List<Map<String, String>>> convertDimsParamsToCm(Map<String, String> dimMembers) {
        HashMap<String, List<Map<String, String>>> paramsMap = new HashMap<String, List<Map<String, String>>>(dimMembers.size());
        for (Map.Entry<String, String> entry : dimMembers.entrySet()) {
            HashMap<String, String> member = new HashMap<String, String>(1);
            member.put("number", entry.getValue());
            member.put("range", "10");
            paramsMap.put(entry.getKey(), Lists.newArrayList((Object[])new Map[]{member}));
        }
        return paramsMap;
    }

    public static DatasetDto getDataSetDto(Long schemeId, Long dataSetId) {
        DatasetDto dto = null;
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"far_pivot_scheme", (String)"dataparams", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        if (dy != null) {
            DataFormula dataparams;
            if (dataSetId != 0L) {
                dto = DatasetUtil.getSingleDataSetDto((Long)dataSetId);
            }
            if ((dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class)) != null && dataparams.getDatasetDto() != null) {
                dto = dataparams.getDatasetDto();
                DatasetUtil.addDtoProperty((DatasetDto)dto);
            }
        }
        return dto;
    }

    public static DataFormula getDataFormula(Long schemeId) {
        DataFormula dfl = null;
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"far_pivot_scheme", (String)"dataparams", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        if (dy != null) {
            dfl = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class);
        }
        return dfl;
    }

    public static Object getEnhanceRes(DatasetDto dto, Map<String, List<Map<String, String>>> params, boolean isFar) {
        if (dto == null) {
            return new ArrayList(12);
        }
        Map<String, Set<String>> fetchDataParams = PivotServiceHelper.buildFetchDataParams(params, isFar);
        String modelShowNumber = PivotServiceHelper.getModelShowNumber(dto, isFar);
        String tmpEx = dto.getExpression();
        if (StringUtils.isNotEmpty((CharSequence)modelShowNumber)) {
            tmpEx = DatasetUtil.replaceExpressionDimVar((String)modelShowNumber, (String)dto.getExpression(), fetchDataParams);
        }
        dto.setExpression(tmpEx);
        dto.setTempExpression(tmpEx);
        Object result = DatasetUtil.getResultByPreview((DatasetDto)dto, (boolean)Boolean.FALSE);
        return result == null ? new ArrayList(12) : result;
    }

    public static FormShowParameter getPivotPopForm(Long modelId, Long schemeId, boolean isFar) {
        DatasetDto dto = PivotServiceHelper.getDataSetDto(schemeId, 0L);
        OperationStatus status = OperationStatus.EDIT;
        status = OperationStatus.ADDNEW;
        if (dto == null) {
            status = OperationStatus.ADDNEW;
            dto = new DatasetDto();
            dto.setType(DataSetTypeEnum.MULTIPLE_ROW.getType());
            dto.setDataSrcId(modelId);
            dto.setDataSrcType(DataSrcTypeEnum.MERGE_MODEL.getType());
            dto.setDiscmodelId(modelId);
            dto.setChapterId(schemeId);
            dto.setSave(false);
            if (isFar) {
                ModelStrategyEx modelStrategyEx = PivotModelStrategyEx.getPivotModelStrategyEx(modelId, isFar);
                String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
                if (ModelSourceEnum.EB.getType().equals(modelType)) {
                    dto.setDataSrcType(DataSrcTypeEnum.EB_MODEL.getType());
                } else if (ModelSourceEnum.RPT.getType().equals(modelType)) {
                    dto.setDataSrcType(DataSrcTypeEnum.RPT_MODEL.getType());
                }
            } else {
                dto.setCm(true);
            }
        }
        FormShowParameter popFormShow = DatasetUtil.getPopFormShow((DatasetDto)dto, (boolean)false);
        return popFormShow;
    }

    public static void saveDto(Long schemeId) {
        DataFormula dataparams;
        DynamicObject dy = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"dataparams", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        if (dy == null || (dataparams = (DataFormula)JSONObject.parseObject((String)dy.getString("dataparams"), DataFormula.class)) != null) {
            // empty if block
        }
    }

    public static Map<String, Set<String>> buildFetchDataParams(Map<String, List<Map<String, String>>> params, boolean isFar) {
        HashMap<String, Set<String>> newParams = new HashMap<String, Set<String>>(12);
        if (params != null) {
            for (Map.Entry<String, List<Map<String, String>>> entry : params.entrySet()) {
                String key = entry.getKey();
                HashSet<String> innerParams = new HashSet<String>(entry.getValue().size());
                List<Map<String, String>> value = entry.getValue();
                for (Map<String, String> member : value) {
                    String number = member.get("number");
                    String range = member.get("range");
                    String rangeNumber = "";
                    rangeNumber = !StringUtils.isEmpty((CharSequence)range) && range.matches("^\\d+$") ? RangeEnum.getRangeByVal((int)Integer.parseInt(range)).getNumber() : range;
                    innerParams.add(number + (StringUtils.isEmpty((CharSequence)range) ? "" : "." + rangeNumber));
                }
                newParams.put(key, innerParams);
            }
        }
        return newParams;
    }

    public static String getModelShowNumber(DatasetDto dto, boolean isFar) {
        String number = "";
        if (dto == null) {
            return number;
        }
        Long srcId = dto.getDataSrcId();
        if (isFar) {
            ModelStrategyEx modelStrategyEx = PivotModelStrategyEx.getPivotModelStrategyEx(dto);
            if (modelStrategyEx != null) {
                DisModelTypeEnum modelTypeEnum = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
                String modelType = modelTypeEnum.getType();
                if (DisModelTypeEnum.EB.getType().equals(modelType)) {
                    DynamicObject model = EBDataReader.getModel((Long)srcId);
                    number = model.getString("shownumber");
                } else if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
                    DynamicObject model = BCMDataReader.getModel((Long)srcId);
                    number = model.getString("shownumber");
                }
            }
        } else {
            DynamicObject model = BCMDataReader.getModel((Long)srcId);
            number = model.getString("shownumber");
        }
        return number;
    }

    public static boolean checkFillAllParams(DatasetDto dto, Map<String, List<Map<String, String>>> fillParams) {
        boolean isFullParams = true;
        Map<String, Boolean> f7Dims = PivotServiceHelper.getF7Dims(dto.getExpression());
        if (f7Dims != null && !f7Dims.isEmpty()) {
            if (fillParams != null && !fillParams.isEmpty()) {
                for (Map.Entry<String, Boolean> entry : f7Dims.entrySet()) {
                    String key = entry.getKey();
                    if (fillParams.get(key) != null && !fillParams.get(key).isEmpty()) continue;
                    isFullParams = false;
                    break;
                }
            } else {
                isFullParams = false;
            }
        }
        return isFullParams;
    }

    public static DatasetDto handleDtoParamException(DatasetDto dto) {
        DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        if (datasetDataVo != null) {
            try {
                datasetDataVo.getSerializedParam();
            }
            catch (Exception e) {
                datasetDataVo.setParam(null);
                dto.setData(JSONObject.toJSONString((Object)datasetDataVo));
            }
        }
        return dto;
    }
}

