/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.themeanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.far.model.ParamData;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisPublishLogServiceHelper;

public class ThemeAnalysisBoardPlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage,
BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String THEMEANALYSIS = "themeanalysis";
    private static final String VIEWDATA = "viewdata";
    private static final String BTN_SAVE = "btn_save";

    private static QFilter addNoPermAnalysisPackage(Long modelId, Long userId) {
        HashSet noPermsDataSet = new HashSet(16);
        noPermsDataSet.addAll(PermClassEntityHelper.getDiscPermissionMap((String)"far_themeanalysis", (Long)modelId, (Long)userId, (String)ApplicationTypeEnum.FAR.getAppnum()).get((Object)"1"));
        QFilter qFilter = new QFilter("id", "not in", noPermsDataSet);
        return qFilter;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl(THEMEANALYSIS);
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(BTN_SAVE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long dmModelId = this.getDmModelId();
        this.getModel().setValue(MODEL, (Object)dmModelId);
        String eventArgs = (String)this.getView().getFormShowParameter().getCustomParam(VIEWDATA);
        this.getModel().setValue(VIEWDATA, (Object)eventArgs);
        JSONArray transferDimList = JSON.parseObject((String)eventArgs).getJSONObject("queryConfig").getJSONArray("dimList");
        if (Objects.nonNull(transferDimList) && transferDimList.size() > 0) {
            List<ParamData> dimList = AnalysisCommonOperateHelper.getDimList(eventArgs);
            AnalysisCommonOperateHelper.createDynamicControl(dimList, this.getView(), (IFormPlugin)this, this.getPageCache());
            AnalysisCommonOperateHelper.setDefaultValue(dimList, this.getView(), this.getModel(), "");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultparamflex"});
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        Element c;
        if (this.getPage(this.getView()) != null && Objects.nonNull(c = this.getPage(this.getView()).findElementBySign(e.getKey()))) {
            Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam("dmmodelid");
            AnalysisCommonOperateHelper.getControl(e, c, dmModelId, this.getView(), this.getModel(), this.getPageCache(), this, (ClickListener)this, null);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (key.equals(THEMEANALYSIS)) {
            this.setCatalogQfilter(evt);
        } else {
            Control scenarioControl = this.getView().getControl(DimTypesEnum.SCENARIO.getNumber().toLowerCase());
            String dimKey = ((BasedataEdit)evt.getSource()).getKey();
            if (DimTypesEnum.PERIOD.getNumber().equalsIgnoreCase(dimKey) && Objects.nonNull(scenarioControl) && this.getModel().getValue(DimTypesEnum.SCENARIO.getNumber().toLowerCase(Locale.ENGLISH)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f\u3002", (String)"AnalysisSingleF7ServiceHelper_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            Long dmModelId = (Long)this.getView().getFormShowParameter().getCustomParam("dmmodelid");
            AnalysisCommonOperateHelper.addF7Filter(evt, this.getModel(), this.getPageCache(), this.getView(), dimKey, dmModelId);
        }
    }

    private void setCatalogQfilter(BeforeF7SelectEvent evt) {
        ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
        fsp.setCaption(ResManager.loadKDString((String)"\u4e3b\u9898\u5206\u6790\u5217\u8868", (String)"ThemeAnalysisListPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
        QFilter qFilter = new QFilter(MODEL, "=", (Object)this.getDmModelId());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilter.and(ThemeAnalysisBoardPlugin.addNoPermAnalysisPackage(this.getDmModelId(), this.getUserId()));
        qFilters.add(qFilter);
        fsp.getListFilterParameter().getQFilters().add(qFilter);
        fsp.getTreeFilterParameter().setQFilters(qFilters);
    }

    public Long getDmModelId() {
        Long modelId = null;
        Object temp = this.getFormCustomParam("dmmodelid");
        modelId = temp instanceof Integer ? Long.valueOf(((Integer)temp).intValue()) : (Long)temp;
        return modelId;
    }

    private boolean validateNumber() {
        int count;
        Long modelId;
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((String)number)) {
            String showMsg = ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThemeAnalysisBoardPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(showMsg);
            return false;
        }
        String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        String showMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ThemeAnalysisBoardPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), number);
        if (!matcher.matches()) {
            this.getView().showTipNotification(showMsg);
            return false;
        }
        if (number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            this.getView().showTipNotification(showMsg);
            return false;
        }
        Long pkId = null;
        if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
            pkId = (Long)((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        }
        QFilter filter = new QFilter(MODEL, "=", (Object)(Objects.nonNull(modelId = Long.valueOf(((DynamicObject)this.getModel().getValue(MODEL)).getLong("id"))) ? modelId : 0L));
        filter.and("number", "=", (Object)number);
        if (Objects.nonNull(pkId)) {
            filter.and("id", "!=", (Object)pkId);
        }
        if ((count = QueryServiceHelper.queryOne((String)"far_themeanalysisboard", (String)"count(id) num", (QFilter[])new QFilter[]{filter}).getInt("num")) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"ThemeAnalysisBoardPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_SAVE.equals(key)) {
            if (!this.validateNumber()) {
                return;
            }
            Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
            QFilter filter = new QFilter(MODEL, "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
            filter.and(THEMEANALYSIS, "=", (Object)((DynamicObject)this.getModel().getValue(THEMEANALYSIS)).getLong("id"));
            int sequence = QueryServiceHelper.queryOne((String)"far_themeanalysisboard", (String)"max(sequence) num", (QFilter[])new QFilter[]{filter}).getInt("num");
            boolean isSuccess = false;
            long id = 0L;
            try (TXHandle tx = TX.required();){
                try {
                    DynamicObject newMyAnalysis = BusinessDataServiceHelper.newDynamicObject((String)"far_themeanalysisboard");
                    newMyAnalysis.set("number", this.getModel().getValue("number"));
                    newMyAnalysis.set("name", this.getModel().getValue("name"));
                    newMyAnalysis.set("description", this.getModel().getValue("description"));
                    newMyAnalysis.set(THEMEANALYSIS, this.getModel().getValue(THEMEANALYSIS));
                    newMyAnalysis.set(VIEWDATA, this.getView().getFormShowParameter().getCustomParam(VIEWDATA));
                    newMyAnalysis.set(MODEL, this.getModel().getValue(MODEL));
                    newMyAnalysis.set("status", this.getModel().getValue("status"));
                    newMyAnalysis.set("enable", this.getModel().getValue("enable"));
                    newMyAnalysis.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
                    newMyAnalysis.set("createtime", (Object)TimeServiceHelper.now());
                    newMyAnalysis.set("creator", (Object)RequestContext.get().getCurrUserId());
                    newMyAnalysis.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    newMyAnalysis.set("modifytime", (Object)TimeServiceHelper.now());
                    newMyAnalysis.set("sequence", (Object)(sequence + 1));
                    ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
                    Long templateID = (Long)this.getView().getFormShowParameter().getCustomParam("templateID");
                    DynamicObject dy = (DynamicObject)this.getModel().getValue(THEMEANALYSIS);
                    String path = Objects.nonNull(dy) ? dy.getLocaleString("name").getLocaleValue() : "";
                    DynamicObject dylog = AnalysisPublishLogServiceHelper.newAnalysisPublishLog(templateID, this.getModel().getValue("name").toString(), path, "2");
                    logs.add(dylog);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newMyAnalysis});
                    AnalysisPublishLogServiceHelper.batchInsertAnalysisPublishLog(logs);
                    id = newMyAnalysis.getLong("id");
                    isSuccess = true;
                    this.writeOpLog(OperationResult.SUCCESS);
                }
                catch (Exception e) {
                    this.writeOpLog(OperationResult.FAILURE);
                    this.getView().showErrorNotification(e.getMessage());
                    tx.markRollback();
                }
            }
            if (isSuccess) {
                this.returnDataToParent(id);
                this.getView().close();
            }
        }
    }

    private void writeOpLog(OperationResult result) {
        Long templateID = (Long)this.getView().getFormShowParameter().getCustomParam("templateID");
        DynamicObject template = QueryServiceHelper.queryOne((String)"fidm_tmplcatalog", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateID)});
        String templateNumber = template != null ? template.getString("number") : "";
        String publishNumber = this.getValue("number") != null ? (String)this.getValue("number") : "";
        Object[] params = new Object[]{templateNumber, publishNumber};
        super.writeOpLog(OperationCategory.ANALYSIS_DESIGN, OperationName.PUBLISH_THEMEANALYSIS, result, "far_analysisdesign", params);
    }
}

