/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.themeanalysis;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.formplugin.faranalysis.AbstractAnalysisPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;

public class ThemeAnalysisLayoutPlugin
extends AbstractAnalysisPlugin
implements BeforeF7SelectListener {
    private static final String KEY_THEMEANALYSISID = "KEY_THEMEANALYSISID";
    private static final String CTL_TOOLBAR_AP = "toolbarap";
    private static final String FLEXPANELAPQUERY = "flexpanelapquery";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_CLOSE = "btn_close";
    private static final String BTN_BASEINFO = "btn_baseinfo";
    private static final String OPERATION = "operation";
    private static final String ADDNEW = "addnew";
    private static final String EDIT = "edit";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(CTL_TOOLBAR_AP);
        this.addClickListeners(BTN_SAVE, BTN_REFRESH, BTN_BASEINFO, BTN_CLOSE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initThemeAnalysisId();
        this.changeView(true);
        this.dataInit();
        String msg = this.checkAnalysisPerm();
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                if (this.checkExistThemeData()) {
                    return;
                }
                String msg = this.checkAnalysisPerm();
                if (!StringUtils.isEmpty((CharSequence)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_THEME_SAVE));
                break;
            }
            case "btn_refresh": {
                this.dataInit();
                break;
            }
            case "btn_baseinfo": {
                if (this.checkExistThemeData()) {
                    return;
                }
                this.openThemeAnalysis(this.getThemeAnalysisId().toString());
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "far_themeanalysis": {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ThemeAnalysisListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "far_themeanalysis": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ThemeAnalysisListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void dataInit() {
        if (this.checkExistThemeData()) {
            return;
        }
        try {
            Map<String, Object> themeResult = AnalysisServiceHelper.getDataEditByThemeAnalysis(this.getDmModelId(), this.getThemeAnalysisId());
            this.SendToVue(AnalysisDesignHelper.themeInitResult(true, themeResult.get("pageConfig"), themeResult.get("i18n"), themeResult.get("theme")));
        }
        catch (Exception ex) {
            this.dataError(ex);
        }
    }

    private boolean checkExistThemeData() {
        boolean isExistThemeData = AnalysisServiceHelper.isExistThemeData(this.getDmModelId(), this.getThemeAnalysisId());
        if (!isExistThemeData) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u89c8\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AnalysisPreviewPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void openThemeAnalysis(String id) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "far_themeanalysis");
        openParameter.put("pkId", id);
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCustomParam("dmmodelid", (Object)this.getDmModelId());
        formShowParameter.setCustomParam("perm", this.getView().getFormShowParameter().getCustomParam("perm"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (id == null) {
            formShowParameter.setCustomParam(OPERATION, (Object)ADDNEW);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e3b\u9898\u65b0\u589e", (String)"ThemeAnalysisListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            formShowParameter.setCustomParam(OPERATION, (Object)EDIT);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e3b\u9898\u7f16\u8f91", (String)"ThemeAnalysisListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "far_themeanalysis"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    public Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("dmmodelid");
        return modelId;
    }

    private void initThemeAnalysisId() {
        Long id = (Long)this.getFormCustomParam("themeAnalysisId");
        this.getPageCache().put(KEY_THEMEANALYSISID, Objects.nonNull(id) ? id.toString() : "0");
    }

    private Long getThemeAnalysisId() {
        Long templateId = null;
        String templateIdTemp = this.getPageCache().get(KEY_THEMEANALYSISID);
        templateId = StringUtils.isNotEmpty((CharSequence)templateIdTemp) && !Objects.equals("0", templateIdTemp) ? Long.valueOf(templateIdTemp) : (Long)this.getFormCustomParam(KEY_THEMEANALYSISID);
        return templateId;
    }

    private void changeView(boolean designView) {
        this.getView().setVisible(Boolean.valueOf(designView), new String[]{BTN_SAVE, BTN_REFRESH});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAPQUERY});
    }

    @Override
    protected void evThemeSave(String eventArgs) {
        DynamicObject templateDy = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getThemeAnalysisId(), (String)"far_themeanalysis", (String)"id, name, number");
        try {
            if (AnalysisServiceHelper.themeSave(this.getDmModelId(), this.getThemeAnalysisId(), eventArgs)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ThemeAnalysisLayoutPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.writeOpLog(OperationResult.SUCCESS, templateDy);
            } else {
                this.writeOpLog(OperationResult.FAILURE, templateDy);
            }
        }
        catch (KDBizException kdEx) {
            this.writeOpLog(OperationResult.FAILURE, templateDy);
            log.error((Throwable)kdEx);
            this.getView().showErrorNotification(kdEx.getMessage());
        }
    }

    private String checkAnalysisPerm() {
        String perm = (String)this.getView().getFormShowParameter().getCustomParam("perm");
        String msg = "";
        if ("2".equals(perm)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u201c\u4e3b\u9898\u5206\u6790\u201d\u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"ThemeAnalysisLayoutPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    private void writeOpLog(OperationResult result, DynamicObject dyn) {
        String number = dyn != null ? dyn.getString("number") : "";
        super.writeOpLog(OperationCategory.THEMEANLYSIS, OperationName.EDIT, result, "far_themeanalysis", number);
    }
}

