/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.themeanalysis;

import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.faranalysis.themeanalysis.ThemeAnalysisServiceHelper;

public class ThemeAnalysisListPlugin
extends AbstractBaseDMListPlugin
implements HyperLinkClickListener {
    public static final String disc_model = "model";
    public static final String BILLLISTAP = "billlistap";
    public static final String callbackid_del_confirm = "callbackid_del_confirm";
    public static final String SEARCH_LIST_TEMP = "search_list_temp";
    public static final String BTN_COPY = "btn_copy";
    public static final String BTN_EDIT = "btn_edit";
    public static final String BTN_EDIT_ITEM = "btn_edit_item";
    public static final String BTN_ADDNEW = "btn_addnew";
    public static final String BTN_DELETE = "btn_delete";
    public static final String BTN_REFRESH = "btn_refresh";
    public static final String BTN_PREVIEW = "btn_preview";
    public static final String OPERATION = "operation";
    public static final String ADDNEW = "addnew";
    public static final String EDIT = "edit";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String ANISISPERM = "anisisperm";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addListRowClickListener((ListRowClickListener)this);
        this.addClickListeners(BTN_PREVIEW, BTN_COPY, BTN_EDIT);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    ThemeAnalysisListPlugin.this.getPageCache().put(ThemeAnalysisListPlugin.SEARCH_LIST_TEMP, event.getText());
                } else {
                    ThemeAnalysisListPlugin.this.getPageCache().remove(ThemeAnalysisListPlugin.SEARCH_LIST_TEMP);
                }
                ThemeAnalysisListPlugin.this.refreshBill();
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getUserSelect();
        if (modelId != null && modelId != 0L) {
            this.getModel().setValue(disc_model, (Object)modelId);
            this.getPageCache().put("dmmodelid", modelId.toString());
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setDefaultView("cardview");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        this.refreshBill();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Object pkId = list.getFocusRowPkId();
        this.openThemeAnalysisView(pkId.toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "callbackid_del_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.actionDeleteResult();
                break;
            }
            case "CopyTheme_Comfirm": {
                Object[] selectedIds;
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) || (selectedIds = this.getSelectedIds()) == null || selectedIds.length <= 0) break;
                BillList billList = (BillList)this.getControl("billlistap");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("modelId", this.getDMModelId());
                params.put("themeId", selectedIds[0]);
                this.openFormPage("far_theme_copy", ResManager.loadKDString((String)"\u7f16\u7801\u540d\u79f0\u7ef4\u62a4", (String)"AnalysisDesignListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), params);
                break;
            }
        }
    }

    private void actionDeleteResult() {
        String msg = "";
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)2);
        for (ListSelectedRow row : billList.getSelectedRows()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"far_themeanalysis");
            if (dynamicObject == null) {
                msg = String.format(ResManager.loadKDString((String)"%s\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ThemeAnalysisListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), row.getName());
                this.getView().showTipNotification(msg);
                continue;
            }
            msg = this.checkActionDelete(dynamicObject.getLong("id"));
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                continue;
            }
            ids.add(dynamicObject.getLong("id"));
        }
        if (ids.size() > 0) {
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DeleteServiceHelper.delete((String)"far_themeanalysis", (QFilter[])filter.toArray());
            msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"ThemeAnalysisListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]), ids.size());
            this.getView().showSuccessNotification(msg);
        }
        this.refreshBill();
    }

    private String checkActionDelete(Long copyFromId) {
        String fcardid;
        DynamicObject pageCardConfigCollection;
        String msg = "";
        DynamicObject copyFrom = QueryServiceHelper.queryOne((String)"far_themeanalysis", (String)"id,number,status,name", (QFilter[])new QFilter("id", "=", (Object)copyFromId).toArray());
        if (copyFrom == null) {
            return msg;
        }
        String copyFromName = copyFrom.getString("name");
        DynamicObject moduleandcardFrom = QueryServiceHelper.queryOne((String)"far_moduleandcard", (String)"card", (QFilter[])new QFilter("thematicanalysis", "=", (Object)copyFromId).toArray());
        if (moduleandcardFrom != null && (pageCardConfigCollection = QueryServiceHelper.queryOne((String)"bos_mainpagecardconfig", (String)"cardid", (QFilter[])new QFilter("cardid", "=", (Object)Long.parseLong(fcardid = moduleandcardFrom.getString("card"))).toArray())) != null) {
            msg = String.format(ResManager.loadKDString((String)"\u9996\u9875\u7ec4\u4ef6\u5361\u7247\u5173\u7cfb\u201d\u7684\u5b57\u6bb5\u201c\u4e3b\u9898\u5206\u6790\u201d\u5f15\u7528\u4e86\u4e3b\u9898\u5206\u6790\u3010%s\u3011\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"ThemeAnalysisListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]), copyFromName);
            return msg;
        }
        return msg;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        Long modelId = this.getDMModelId();
        if (modelId == null || modelId.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btn_addnew": {
                this.openThemeAnalysis(null);
                break;
            }
            case "btn_delete": {
                this.actionDelete();
                break;
            }
            case "btn_refresh": {
                this.refreshBill();
                break;
            }
            case "btn_copy": {
                this.copyNewThemeAnalysis();
                break;
            }
            case "btn_edit_item": {
                this.actionLayout();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Long modelId = this.getDMModelId();
        if (modelId == null || modelId.equals(0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_copy": {
                if (this.checkExistThemeData()) {
                    return;
                }
                this.copyNewThemeAnalysis();
                break;
            }
            case "btn_preview": {
                if (this.checkExistThemeData()) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                Object pkId = billList.getFocusRowPkId();
                if (pkId == null) {
                    pkId = 0L;
                }
                this.openThemeAnalysisView(pkId.toString());
                break;
            }
            case "btn_edit": {
                if (this.checkExistThemeData()) {
                    return;
                }
                this.actionLayout();
                break;
            }
        }
    }

    private boolean checkExistThemeData() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"MyAnalysisListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u591a\u9009\u3002", (String)"MyAnalysisListPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"far_themeanalysis");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ThemeAnalysisListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "far_themeanalysis": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ThemeAnalysisListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.refreshBill();
                break;
            }
            case "far_theme_copy": {
                if (!Objects.nonNull(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"AnalysisDesignListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.refreshBill();
                break;
            }
        }
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ThemeAnalysisListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"far_themeanalysis");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ThemeAnalysisListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u5220\u9664\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u4e3b\u9898\u5206\u6790\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ThemeAnalysisListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name")), MessageBoxOptions.YesNo, new ConfirmCallBackListener(callbackid_del_confirm, (IFormPlugin)this));
    }

    private void actionLayout() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u7f16\u8f91\u7684\u6570\u636e\u3002", (String)"ThemeAnalysisListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue(), (String)"far_themeanalysis");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"ThemeAnalysisListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openThemeAnalysisLayout(dynamicObject.getString("id"));
    }

    private void refreshBill() {
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter fp = new FilterParameter();
        fp.setFilter(this.setBillListFilter());
        billList.setFilterParameter(fp);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter setBillListFilter() {
        if (this.getPageCache().get("dmmodelid") == null) {
            return new QFilter(disc_model, "=", (Object)-1);
        }
        Long modelId = Long.valueOf(this.getPageCache().get("dmmodelid"));
        QFilter filter = new QFilter(disc_model, "=", (Object)modelId);
        if (this.getPageCache().get(SEARCH_LIST_TEMP) != null) {
            String searchStr = this.getPageCache().get(SEARCH_LIST_TEMP);
            QFilter filter1 = new QFilter("number", "like", (Object)("%" + searchStr + "%"));
            filter1.or("name", "like", (Object)("%" + searchStr + "%"));
            filter.and(filter1);
        }
        List<Long> noPermIds = this.getNoPermIds(modelId);
        filter.and("id", "not in", noPermIds);
        return filter;
    }

    private void openThemeAnalysis(String id) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "far_themeanalysis");
        openParameter.put("pkId", id);
        if (this.getPageCache().get("dmmodelid") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165\u4f53\u7cfb\u7ba1\u7406\u9875\u9762\u8bbe\u7f6e\u5f53\u524d\u4f53\u7cfb\u3002", (String)"ThemeAnalysisListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setCustomParam("dmmodelid", (Object)this.getPageCache().get("dmmodelid"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (id == null) {
            formShowParameter.setCustomParam(OPERATION, (Object)ADDNEW);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e3b\u9898\u65b0\u589e", (String)"ThemeAnalysisListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            formShowParameter.setCustomParam(OPERATION, (Object)EDIT);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e3b\u9898\u7f16\u8f91", (String)"ThemeAnalysisListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "far_themeanalysis"));
        this.getView().showForm(formShowParameter);
    }

    private void openThemeAnalysisView(String themeAnalysisId) {
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = mainPageView != null ? String.valueOf(themeAnalysisId) + "far_themeanalysisview" + mainPageView.getPageId() : String.valueOf(themeAnalysisId) + "far_themeanalysisview0000000000000000";
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)themeAnalysisId), (String)"far_themeanalysis", (String)"id, name, number");
            customParams.put("themeAnalysisId", templateDy.get("id"));
            customParams.put("number", templateDy.getString("number"));
            customParams.put("fileName", templateDy.getString("name"));
            customParams.put("appId", this.getBizAppId());
            customParams.put("dmmodelid", this.getDMModelId());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("far_themeanalysisview");
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCaption(templateDy.getString("name"));
            formShowParameter.setPageId(pageId);
            if (parentView != null) {
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private void openThemeAnalysisLayout(String themeAnalysisId) {
        String pageId;
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        if (Objects.isNull(mainPageView)) {
            SecureRandom random = new SecureRandom();
            pageId = String.valueOf(themeAnalysisId) + "far_themeanalysislayout" + random.nextDouble() + random.nextDouble();
        } else {
            pageId = String.valueOf(themeAnalysisId) + "far_themeanalysislayout" + mainPageView.getPageId();
        }
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)themeAnalysisId), (String)"far_themeanalysis", (String)"id, name, number");
            String caption = String.format(ResManager.loadKDString((String)"%s-\u5e03\u5c40", (String)"ThemeAnalysisListPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]), templateDy.getString("name"));
            customParams.put("themeAnalysisId", templateDy.get("id"));
            customParams.put("number", templateDy.getString("number"));
            customParams.put("fileName", templateDy.getString("name"));
            customParams.put("appId", this.getBizAppId());
            customParams.put("perm", this.getPageCache().get(ANISISPERM));
            customParams.put("dmmodelid", this.getDMModelId());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("far_themeanalysislayout");
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCaption(caption);
            formShowParameter.setPageId(pageId);
            if (parentView != null) {
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (disc_model.equals(keyName) && e.getChangeSet()[0].getNewValue() != null) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                this.getPageCache().put("dmmodelid", newValue.getString("id"));
            }
            this.refreshBill();
        }
    }

    private void copyNewThemeAnalysis() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection dys = billList.getSelectedRows();
        ListSelectedRow selectedRow = dys.isEmpty() ? null : dys.get(0);
        Object[] primaryKeyValues = dys.getPrimaryKeyValues();
        if (primaryKeyValues.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u9009\u4e2d\u9762\u677f\u540e\u8fdb\u884c\u590d\u5236\u64cd\u4f5c\u3002", (String)"ThemeAnalysisListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ThemeAnalysisServiceHelper.isExistNumberThemeAnalysis(this.getDMModelId(), dys.get(0).getNumber())) {
            String tips = String.format(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\u3002\u590d\u5236\u540e\u7684\u4e3b\u9898\u5206\u6790\u7f16\u7801\u4e0e\u201c%1$s\u201d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u201c%2$s\u201d\u7f16\u7801\u540e\u518d\u6267\u884c\u590d\u5236\u3002", (String)"ThemeAnalysisListPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]), dys.get(0).getNumber() + "_copy", dys.get(0).getNumber() + "_copy");
            this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CopyTheme_Comfirm", (IFormPlugin)this));
            return;
        }
        try {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)billList.getEntityType());
            List<DynamicObject> dyList = Arrays.asList(dynamicObjects);
            if ((dys.get(0).getNumber() + "_copy").length() > 30 || (dys.get(0).getName() + "_copy").length() > 50) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u8d85\u8fc7\u957f\u5ea6\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\u3002", (String)"AnalysisDesignListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CopyTheme_Comfirm", (IFormPlugin)this));
                return;
            }
            ThemeAnalysisServiceHelper.copyThemeAnalysisToNew(dyList, null, null);
            this.writeOpLog(OperationResult.SUCCESS, OperationName.COPY, selectedRow);
        }
        catch (Exception e) {
            this.writeOpLog(OperationResult.FAILURE, OperationName.COPY, selectedRow);
            throw e;
        }
        billList.refresh();
    }

    private void openFormPage(String formId, String caption, Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(params);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(caption);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private Object[] getSelectedIds() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"AnalysisDesignListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return null;
        }
        return billList.getSelectedRows().getPrimaryKeyValues();
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.getSelectedRows().size() > 0) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            Long selectNodeId = 0L;
            if (selectNodeIds != null) {
                selectNodeId = LongUtil.toLong((Object)selectNodeIds[0]);
            }
            String perm = PermClassEntityHelper.getSingleDiscPermission((String)"far_themeanalysis", (Long)selectNodeId, (Long)this.getDMModelId(), (Long)this.getUserId(), (String)"fidmmodel", (String)this.getBizAppId());
            this.getPageCache().put(ANISISPERM, perm);
            if (StringUtils.equals((CharSequence)"2", (CharSequence)perm)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_DELETE, BTN_COPY});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_DELETE, BTN_COPY});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_DELETE, BTN_COPY});
        }
    }

    private List<Long> getNoPermIds(Long modelId) {
        ArrayList<Long> noPerms = new ArrayList<Long>();
        noPerms.addAll(PermClassEntityHelper.getDiscPermissionMap((String)"far_themeanalysis", (Long)modelId, (Long)this.getUserId(), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1"));
        return noPerms;
    }

    private void writeOpLog(OperationResult result, OperationName opName, ListSelectedRow selectedRow) {
        String number = selectedRow != null ? selectedRow.getNumber() : "";
        super.writeOpLog(OperationCategory.THEMEANLYSIS, opName, result, "far_themeanalysis", number);
    }
}

