/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.themeanalysis;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisPublishLogServiceHelper;

public class ThemeAnalysisPlugin
extends AbstractBaseDMFormPlugin
implements BeforeF7SelectListener,
IBillPlugin {
    public static final String OPERATION = "operation";
    public static final String ADDNEW = "addnew";
    public static final String EDIT = "edit";
    private static final String MODEL = "model";
    private static final String PERMCLASS = "permclass";
    private static final String FIDMMODEL = "fidmmodel";
    private static final String BTN_SAVE = "btn_save";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_PARAM_EDIT = "btn_param_edit";
    private static final String BOARD_LIST = "board_list";
    private static final String PARAM_CACHE = "param_cache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl(PERMCLASS)), (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getBizAppId());
        this.addClickListeners(BTN_SAVE);
        this.addItemClickListeners(ADVCONTOOLBARAP);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long dmModelId = this.getDmModelId();
        this.getModel().setValue(MODEL, (Object)dmModelId);
    }

    public void afterBindData(EventObject e) {
        if (Objects.isNull(this.getValue("id")) || "0".equals(this.getValue("id").toString())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"analysismanageflex"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"analysismanageflex"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_ADD.equals(key)) {
            this.addBoard();
        }
    }

    private Map<String, String> getParamMap() {
        String paramStr = this.getPageCache().get(PARAM_CACHE);
        if (StringUtils.isEmpty((CharSequence)paramStr)) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
    }

    private void checkSelectedRow(int[] selectRows) {
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u770b\u677f\u3002", (String)"ThemeAnalysisPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (selectRows.length != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"ThemeAnalysisPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_SAVE.equals(key)) {
            String msg = this.checkAnalysisPerm();
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            if (Objects.isNull(this.getValue("id")) || "0".equals(this.getValue("id").toString())) {
                this.addData();
            } else {
                this.editData();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "fidm_template": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (!Objects.nonNull(selectedRows)) break;
                ArrayList<Long> selectedValues = new ArrayList<Long>(2);
                for (ListSelectedRow row : selectedRows) {
                    selectedValues.add(LongUtil.toLong((Object)row.getPrimaryKeyValue()));
                }
                this.addRows(selectedValues);
                break;
            }
        }
    }

    private void addRows(List<Long> selectedValues) {
        String selectFields = "id,name,number";
        QFilter fmodelid = new QFilter(MODEL, "=", (Object)this.getDmModelId());
        QFilter fid = new QFilter("id", "in", selectedValues);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"fidm_template", (String)selectFields, (QFilter[])new QFilter[]{fmodelid, fid}, (String)"sequence");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("boardid", new Object[0]);
        vs.addField("boardname", new Object[0]);
        vs.addField("boardnumber", new Object[0]);
        for (DynamicObject item : dcs) {
            vs.addRow(new Object[]{item.getLong("id"), item.getString("name"), item.getString("number")});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(BOARD_LIST, vs);
        this.getModel().endInit();
        this.getView().updateView(BOARD_LIST);
    }

    public Long getDmModelId() {
        Long modelId = null;
        Object temp = this.getFormCustomParam("dmmodelid");
        if (Objects.nonNull(temp)) {
            modelId = LongUtil.toLong((Object)temp.toString());
        }
        return modelId;
    }

    public void addBoard() {
        String selectFields = "id";
        QFilter fmodelid = new QFilter(MODEL, "=", (Object)this.getDmModelId());
        QFilter ftype = DiscTemplateCatalogTypeEnum.getCatalogTypeQfByAppId((String)this.getBizAppId());
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"fidm_tmplcatalog", (String)selectFields, (QFilter[])new QFilter[]{fmodelid, ftype}, (String)"sequence");
        ArrayList catelogIds = Lists.newArrayListWithExpectedSize((int)2);
        for (DynamicObject item : dcs) {
            catelogIds.add(item.getLong("id"));
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"fidm_template", (boolean)true);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fidm_template"));
        lsp.setHasRight(true);
        lsp.setCaption(ResManager.loadKDString((String)"\u5206\u6790\u8bbe\u8ba1", (String)"ThemeAnalysisPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        lsp.setFormId("bos_listf7");
        lsp.setBillFormId("fidm_template");
        lsp.setMultiSelect(true);
        List qFilters = lsp.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter(MODEL, "=", (Object)this.getDMModelId()));
        qFilters.add(new QFilter("status", "=", (Object)true));
        qFilters.add(new QFilter("templatecatalog", "in", (Object)catelogIds));
        lsp.setListFilterParameter(new ListFilterParameter(qFilters, (String)null));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private boolean validateNumber() {
        DynamicObject dynamicObject;
        Long id;
        int count;
        Long modelId;
        String number = (String)this.getValue("number");
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(number);
            String showMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ThemeAnalysisPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), number);
            if (!matcher.matches()) {
                this.getView().showErrorNotification(showMsg);
                return false;
            }
            if (number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
                this.getView().showErrorNotification(showMsg);
                return false;
            }
        }
        Long pkId = null;
        if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
            pkId = LongUtil.toLong((Object)((BillShowParameter)this.getView().getFormShowParameter()).getPkId());
        }
        QFilter filter = new QFilter(MODEL, "=", (Object)(Objects.nonNull(modelId = Long.valueOf(((DynamicObject)this.getModel().getValue(MODEL)).getLong("id"))) ? modelId : 0L));
        filter.and("number", "=", (Object)number);
        if (Objects.nonNull(pkId)) {
            filter.and("id", "!=", (Object)pkId);
        }
        if ((count = QueryServiceHelper.queryOne((String)"far_themeanalysis", (String)"count(id) num", (QFilter[])new QFilter[]{filter}).getInt("num")) > 0 && !EDIT.equals(this.getFormCustomParam(OPERATION))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"ThemeAnalysisPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        if (count > 0 && EDIT.equals(this.getFormCustomParam(OPERATION)) && !Objects.equals(pkId, id = Long.valueOf((dynamicObject = QueryServiceHelper.queryOne((String)"far_themeanalysis", (String)"id", (QFilter[])new QFilter[]{filter})).getLong("id")))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"ThemeAnalysisPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    private void editData() {
        if (!this.validateNumber()) {
            return;
        }
        long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        boolean isSuccess = false;
        long id = GlobalIdUtil.genGlobalLongId();
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject newMyAnalysis = null;
                if (Objects.isNull(this.getValue("id")) || "0".equals(this.getValue("id").toString())) {
                    newMyAnalysis = BusinessDataServiceHelper.newDynamicObject((String)"far_themeanalysis");
                    newMyAnalysis.set("id", (Object)id);
                    newMyAnalysis.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
                    newMyAnalysis.set(MODEL, this.getValue(MODEL));
                    newMyAnalysis.set("createtime", (Object)TimeServiceHelper.now());
                    newMyAnalysis.set("creator", (Object)RequestContext.get().getCurrUserId());
                    newMyAnalysis.set("status", this.getValue("status"));
                    newMyAnalysis.set("enable", this.getValue("enable"));
                } else {
                    id = LongUtil.toLong((Object)this.getValue("id"));
                    QFilter filter = new QFilter(MODEL, "=", (Object)modelId);
                    filter.and("id", "=", (Object)id);
                    String selctFields = "id,number,name,description,modifier,modifytime,permclass";
                    newMyAnalysis = BusinessDataServiceHelper.loadSingle((String)"far_themeanalysis", (String)selctFields, (QFilter[])new QFilter[]{filter});
                }
                DynamicObject permclass = (DynamicObject)this.getValue(PERMCLASS);
                newMyAnalysis.set(PERMCLASS, Objects.isNull(permclass) ? null : permclass.get("id"));
                newMyAnalysis.set("number", this.getValue("number"));
                newMyAnalysis.set("name", this.getValue("name"));
                newMyAnalysis.set("description", this.getValue("description"));
                newMyAnalysis.set("modifier", (Object)RequestContext.get().getCurrUserId());
                newMyAnalysis.set("modifytime", (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newMyAnalysis});
                PermClassEntityHelper.saveDiscPermClass((DynamicObject)this.getModel().getDataEntity(), (String)FIDMMODEL, (String)this.getBizAppId());
                isSuccess = true;
                this.writeOpLog(OperationResult.SUCCESS, OperationName.EDIT_BASEINFO);
            }
            catch (Exception e) {
                this.writeOpLog(OperationResult.FAILURE, OperationName.EDIT_BASEINFO);
                this.getView().showErrorNotification(e.getMessage());
                tx.markRollback();
            }
        }
        if (isSuccess) {
            this.getModel().setDataChanged(false);
            this.returnDataToParent(id);
            this.getView().close();
        }
    }

    private void addData() {
        if (!this.validateNumber()) {
            return;
        }
        long themeanalysisId = GlobalIdUtil.genGlobalLongId();
        Long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong("id");
        DynamicObjectCollection boardList = this.getModel().getEntryEntity(BOARD_LIST);
        ArrayList<DynamicObject> saveBoardList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
        Map<String, String> paramMap = this.getParamMap();
        if (Objects.nonNull(boardList)) {
            int sequence = 0;
            for (DynamicObject item : boardList) {
                ++sequence;
                Long chapterId = AnalysisServiceHelper.getDefaultChapterId(modelId, item.getLong("boardid"));
                if (!Objects.nonNull(chapterId)) continue;
                Map<String, Object> dataInit = AnalysisServiceHelper.getDataInit(modelId, modelId, chapterId, false);
                DynamicObject newBoard = BusinessDataServiceHelper.newDynamicObject((String)"far_themeanalysisboard");
                newBoard.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                newBoard.set("number", (Object)GlobalIdUtil.genGlobalLongId());
                newBoard.set("name", (Object)item.getString("boardname"));
                newBoard.set("description", (Object)"");
                newBoard.set("themeanalysis", (Object)themeanalysisId);
                newBoard.set("viewdata", (Object)SerializationUtils.toJsonString(dataInit));
                if (Objects.isNull(paramMap.get(item.getString("boardid")))) {
                    Map<String, Object> defaultparamData = AnalysisServiceHelper.getDefaultparamData(((JSONObject)dataInit.get("queryConfig")).getJSONArray("dimList"));
                    newBoard.set("defaultparam", (Object)SerializationUtils.toJsonString(defaultparamData));
                } else {
                    newBoard.set("defaultparam", (Object)paramMap.get(item.getString("boardid")));
                }
                newBoard.set(MODEL, this.getValue(MODEL));
                newBoard.set("status", (Object)"C");
                newBoard.set("enable", (Object)"1");
                newBoard.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
                newBoard.set("createtime", (Object)TimeServiceHelper.now());
                newBoard.set("creator", (Object)RequestContext.get().getCurrUserId());
                newBoard.set("modifier", (Object)RequestContext.get().getCurrUserId());
                newBoard.set("modifytime", (Object)TimeServiceHelper.now());
                newBoard.set("sequence", (Object)sequence);
                saveBoardList.add(newBoard);
                DynamicObject dylog = AnalysisPublishLogServiceHelper.newAnalysisPublishLog(item.getLong("boardid"), item.getString("boardname"), this.getValue("name").toString(), "2");
                logs.add(dylog);
            }
        }
        DynamicObject newAnalysis = BusinessDataServiceHelper.newDynamicObject((String)"far_themeanalysis");
        newAnalysis.set("id", (Object)themeanalysisId);
        newAnalysis.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
        newAnalysis.set(MODEL, this.getValue(MODEL));
        newAnalysis.set("createtime", (Object)TimeServiceHelper.now());
        newAnalysis.set("creator", (Object)RequestContext.get().getCurrUserId());
        newAnalysis.set("status", this.getValue("status"));
        newAnalysis.set("enable", this.getValue("enable"));
        newAnalysis.set("number", this.getValue("number"));
        newAnalysis.set("name", this.getValue("name"));
        newAnalysis.set("description", this.getValue("description"));
        newAnalysis.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newAnalysis.set("modifytime", (Object)TimeServiceHelper.now());
        newAnalysis.set(PERMCLASS, this.getModel().getValue(PERMCLASS));
        boolean isSuccess = false;
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAnalysis});
                if (saveBoardList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveBoardList.toArray(new DynamicObject[saveBoardList.size()]));
                }
                if (logs.size() > 0) {
                    AnalysisPublishLogServiceHelper.batchInsertAnalysisPublishLog(logs);
                }
                PermClassEntityHelper.saveDiscPermClass((DynamicObject)newAnalysis, (String)FIDMMODEL, (String)this.getBizAppId());
                isSuccess = true;
                this.writeOpLog(OperationResult.SUCCESS, OperationName.CREATE);
            }
            catch (Exception e) {
                this.writeOpLog(OperationResult.FAILURE, OperationName.CREATE);
                this.getView().showErrorNotification(e.getMessage());
                tx.markRollback();
            }
        }
        if (isSuccess) {
            this.getModel().setDataChanged(false);
            this.returnDataToParent(themeanalysisId);
            this.getView().close();
        }
    }

    public void afterLoadData(EventObject e) {
        Long dynId = this.getModel().getDataEntity().getLong("id");
        this.loadPermClass(dynId);
    }

    private void loadPermClass(Long dynId) {
        DynamicObject permClassEntity = PermClassEntityHelper.getDiscPermissionClassEntity((String)"far_themeanalysis", (Long)dynId, (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getBizAppId());
        if (permClassEntity != null) {
            Long permClassId = permClassEntity.getLong("permclass.id");
            this.getModel().setValue(PERMCLASS, (Object)permClassId);
        }
    }

    private String checkAnalysisPerm() {
        String perm = (String)this.getView().getFormShowParameter().getCustomParam("perm");
        String msg = "";
        if ("2".equals(perm)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u201c\u4e3b\u9898\u5206\u6790\u201d\u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"ThemeAnalysisLayoutPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    private void writeOpLog(OperationResult result, OperationName opName) {
        String templateNumber = this.getValue("number") != null ? this.getValue("number").toString() : "";
        super.writeOpLog(OperationCategory.THEMEANLYSIS, opName, result, "far_themeanalysis", templateNumber);
    }
}

