/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.themeanalysis;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class ThemeAnalysisServiceHelper {
    public static void copyThemeAnalysisToNew(List<DynamicObject> dyList, String number, String name) {
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> saveBoardList = new ArrayList<DynamicObject>(2);
        for (DynamicObject dynamicObject : dyList) {
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)dynamicObject);
            long analysisId = GlobalIdUtil.genGlobalLongId();
            clone.set("id", (Object)analysisId);
            clone.set("number", (Object)(Objects.nonNull(number) ? number : clone.getString("number") + "_copy"));
            clone.set("name", (Object)(Objects.nonNull(name) ? name : clone.getString("name") + "_copy"));
            clone.set("creator", (Object)RequestContext.get().getCurrUserId());
            clone.set("createtime", (Object)new Date());
            saveList.add(clone);
            QFilter boardfilter = new QFilter("model", "=", dynamicObject.get("model.id"));
            boardfilter.and("themeanalysis", "=", (Object)dynamicObject.getLong("id"));
            DynamicObjectCollection boardAnlysisList = QueryServiceHelper.query((String)"far_themeanalysisboard", (String)"name,viewdata,defaultparam,sequence", (QFilter[])new QFilter[]{boardfilter}, (String)"sequence");
            for (DynamicObject board : boardAnlysisList) {
                DynamicObject newBoard = BusinessDataServiceHelper.newDynamicObject((String)"far_themeanalysisboard");
                newBoard.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                newBoard.set("number", (Object)GlobalIdUtil.genGlobalLongId());
                newBoard.set("name", (Object)board.getString("name"));
                newBoard.set("themeanalysis", (Object)analysisId);
                newBoard.set("viewdata", (Object)board.getString("viewdata"));
                newBoard.set("defaultparam", (Object)board.getString("defaultparam"));
                newBoard.set("model", (Object)clone.getLong("model.id"));
                newBoard.set("status", (Object)"C");
                newBoard.set("enable", (Object)"1");
                newBoard.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
                newBoard.set("createtime", (Object)TimeServiceHelper.now());
                newBoard.set("creator", (Object)RequestContext.get().getCurrUserId());
                newBoard.set("modifier", (Object)RequestContext.get().getCurrUserId());
                newBoard.set("modifytime", (Object)TimeServiceHelper.now());
                newBoard.set("sequence", (Object)board.getInt("sequence"));
                saveBoardList.add(newBoard);
            }
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                if (saveBoardList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveBoardList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    public static boolean isExistNumberThemeAnalysis(Long modelId, String number) {
        return QueryServiceHelper.exists((String)"far_themeanalysis", (QFilter[])new QFilter("number", "=", (Object)(number + "_copy")).and(new QFilter("model", "=", (Object)modelId)).toArray());
    }
}

