/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.themeanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.faranalysis.AbstractAnalysisPlugin;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisServiceHelper;

public class ThemeAnalysisViewPlugin
extends AbstractAnalysisPlugin
implements BeforeF7SelectListener {
    private static final String KEY_THEMEANALYSISID = "KEY_THEMEANALYSISID";
    private static final String CTL_TOOLBAR_AP = "toolbarap";
    private static final String FLEXPANELAPQUERY = "flexpanelapquery";
    private static final String BTN_PREVIEW = "btn_preview";
    private static final String BTN_ALLSCREEN = "btn_allscreen";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_CLOSE = "btn_close";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(CTL_TOOLBAR_AP);
        this.addClickListeners(BTN_PREVIEW, BTN_ALLSCREEN, BTN_REFRESH, BTN_CLOSE);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initThemeAnalysisId();
        this.changeView(true);
        this.dataInit();
    }

    @Override
    public void customEvent(CustomEventArgs evt) {
        JSONObject jsonObject;
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_THEMATICANALYSIS.toString())) {
            Object newWindows = this.getView().getFormShowParameter().getCustomParam("newWindows");
            jsonObject = JSON.parseObject((String)eventArgs);
            String openStyle = jsonObject.getString("openStyle");
            if ("newWindows".equals(openStyle) && newWindows != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u7a97\u53e3\u4e0b\u6682\u4e0d\u652f\u6301\u591a\u6b21\u6570\u636e\u94fe\u63a5\u3002", (String)"AnalysisPreviewPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        super.customEvent(evt);
        try {
            AnalysisDesignConstants.CallBackType callBackType = AnalysisDesignConstants.CallBackType.valueOf(eventName);
            this.putCallBackType(callBackType, eventArgs);
            if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_ITEM_REFRESHANDSAVE.toString())) {
                jsonObject = JSON.parseObject((String)eventArgs);
                String themeAnalysisId = jsonObject.getString("selectId");
                AnalysisServiceHelper.updateDynamicObject(eventArgs, themeAnalysisId, "far_themeanalysisboard");
                this.evItemRefresh(eventArgs);
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            return;
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_preview": {
                this.checkExistThemeData();
                this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_PREVIEW));
                break;
            }
            case "btn_refresh": {
                this.checkExistThemeData();
                this.dataInit();
                break;
            }
            case "btn_allscreen": {
                this.allScreen();
                break;
            }
        }
    }

    private void dataInit() {
        try {
            Map<String, Object> themeResult = AnalysisServiceHelper.getDataEditByThemeAnalysis(this.getDmModelId(), this.getThemeAnalysisId());
            this.SendToVue(AnalysisDesignHelper.themeInitResult(false, themeResult.get("pageConfig"), themeResult.get("i18n"), themeResult.get("theme")));
        }
        catch (Exception ex) {
            this.dataError(ex);
        }
    }

    private void checkExistThemeData() {
        boolean isExistThemeData = AnalysisServiceHelper.isExistThemeData(this.getDmModelId(), this.getThemeAnalysisId());
        if (!isExistThemeData) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u89c8\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AnalysisPreviewPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void allScreen() {
        this.SendToVue(AnalysisDesignHelper.getPropsDataResult((Object)AnalysisDesignConstants.PropsDataType.DATA_FULLSCREEN));
    }

    @Override
    public Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("dmmodelid");
        return modelId;
    }

    private void initThemeAnalysisId() {
        Long id = (Long)this.getFormCustomParam("themeAnalysisId");
        this.getPageCache().put(KEY_THEMEANALYSISID, Objects.nonNull(id) ? id.toString() : "0");
    }

    private Long getThemeAnalysisId() {
        Long templateId = null;
        String templateIdTemp = this.getPageCache().get(KEY_THEMEANALYSISID);
        templateId = StringUtils.isNotEmpty((CharSequence)templateIdTemp) && !Objects.equals("0", templateIdTemp) ? Long.valueOf(templateIdTemp) : (Long)this.getFormCustomParam(KEY_THEMEANALYSISID);
        return templateId;
    }

    private void changeView(boolean designView) {
        this.getView().setVisible(Boolean.valueOf(designView), new String[]{BTN_PREVIEW, BTN_ALLSCREEN, BTN_REFRESH});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAPQUERY});
    }

    @Override
    protected boolean dimMemberReturn(Object returnData) {
        String pageId;
        if (!super.dimMemberReturn(returnData)) {
            return false;
        }
        JSONObject jsonObject = this.getCallBackType(AnalysisDesignConstants.CallBackType.EVENT_DIM_F7);
        if (Objects.nonNull(jsonObject) && !StringUtils.isEmpty((CharSequence)(pageId = jsonObject.getString("pageId")))) {
            String dimKey = jsonObject.getJSONObject("dim").getString("shortNumber");
            HashMap<String, Object> memberMap = new HashMap<String, Object>(3);
            memberMap.put("id", ((DynamicObject)returnData).getString("id"));
            memberMap.put("name", ((DynamicObject)returnData).getString("name"));
            memberMap.put("number", ((DynamicObject)returnData).getString("number"));
            AnalysisServiceHelper.saveThemeAnlysisDefaultParam(this.getDmModelId(), LongUtil.toLong((Object)pageId), dimKey, memberMap);
        }
        return true;
    }
}

