/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.uitls;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.ComboEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.control.TextEditElement;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.util.StringLengthUtil;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.business.far.enums.DynamicControlSourceEnum;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.business.far.model.Enums;
import kd.epm.far.business.far.model.MemberData;
import kd.epm.far.business.far.model.ParamData;
import kd.epm.far.business.far.model.QueryData;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignHelper;
import kd.epm.far.formplugin.faranalysis.AnalysisPreviewConfig;
import kd.epm.far.formplugin.faranalysis.AnalysisSingleF7ServiceHelper;
import kd.epm.far.formplugin.faranalysis.myanalysis.MyAnalysisPlugin;
import kd.epm.far.formplugin.faranalysis.themeanalysis.ThemeAnalysisBoardPlugin;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisVariableHelper;

public class AnalysisCommonOperateHelper {
    public static final String NUMBER = "number";
    public static final String DATASETID = "dataset.id";
    public static final String MODULEID = "module.id";
    private static final String DIMPANEL = "dimpanel";
    private static final String VARPANEL = "varpanel";
    private static final String LOCALVARPANEL = "localvarpanel";
    private static final Pair<String, String> DYNF7TYPE = Pair.onePair((Object)"DIMF7", (Object)"VARF7");
    private static final String DIMF7INFO = "dimf7info";
    private static final String PREVIEWDATA = "previewData";

    public static Style setCustomControlStyle(Integer index, String sourceName) {
        Style style = new Style();
        Margin margin = new Margin();
        if (index % 2 != 0) {
            if (sourceName.equals(DynamicControlSourceEnum.DESIGNANALYSIS.getSourceName())) {
                margin.setRight("60px");
            } else if (sourceName.equals(DynamicControlSourceEnum.MYANALYSIS.getSourceName()) || sourceName.equals(DynamicControlSourceEnum.THEMEANALYSIS.getSourceName())) {
                margin.setRight("80px");
            } else if (sourceName.equals(DynamicControlSourceEnum.MODULEANALYSIS.getSourceName())) {
                margin.setRight("40px");
            } else if (sourceName.equals(DynamicControlSourceEnum.DATASET.getSourceName())) {
                margin.setRight("10px");
            } else if (sourceName.equals(DynamicControlSourceEnum.DATASETDISPLAY.getSourceName())) {
                margin.setRight("50px");
            } else if (sourceName.equals(DynamicControlSourceEnum.DATASETINFO.getSourceName())) {
                margin.setRight("40px");
            } else {
                margin.setRight("60px");
            }
        } else if (sourceName.equals(DynamicControlSourceEnum.MODULEANALYSIS.getSourceName())) {
            margin.setRight("40px");
        } else if (sourceName.equals(DynamicControlSourceEnum.DATASET.getSourceName())) {
            margin.setRight("10px");
        } else if (sourceName.equals(DynamicControlSourceEnum.DATASETDISPLAY.getSourceName())) {
            margin.setRight("50px");
        } else if (sourceName.equals(DynamicControlSourceEnum.DATASETINFO.getSourceName())) {
            margin.setRight("40px");
        } else {
            margin.setRight("0px");
        }
        if (sourceName.equals(DynamicControlSourceEnum.DATASETDISPLAY.getSourceName())) {
            margin.setLeft("5px");
        } else {
            margin.setLeft("0px");
        }
        style.setMargin(margin);
        return style;
    }

    public static void copyTempalte(DynamicObject sourceTemplateDy, String newNumber, String newName, String appId) {
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                user.set("id", (Object)RequestContext.get().getCurrUserId());
                Date date = new Date();
                CloneUtils cloneUtils = new CloneUtils(true, true);
                DynamicObject newTemplate = (DynamicObject)cloneUtils.clone((IDataEntityBase)sourceTemplateDy);
                newTemplate.set(NUMBER, (Object)newNumber);
                newTemplate.set("name", (Object)newName);
                newTemplate.set("creator", (Object)user);
                newTemplate.set("createtime", (Object)date);
                newTemplate.set("modifier", (Object)user);
                newTemplate.set("modifytime", (Object)date);
                newTemplate.set("status", (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTemplate});
                long oldTemplateId = sourceTemplateDy.getLong("id");
                AnalysisCommonOperateHelper.copyChapter(cloneUtils, oldTemplateId, newTemplate, user, date);
                AnalysisCommonOperateHelper.writeOpLog(OperationResult.SUCCESS, sourceTemplateDy, appId);
            }
            catch (Exception e) {
                AnalysisCommonOperateHelper.writeOpLog(OperationResult.FAILURE, sourceTemplateDy, appId);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static void copyChapter(CloneUtils cloneUtils, long oldTemplateId, DynamicObject newTemplate, DynamicObject user, Date date) {
        DynamicObject[] oldChapters = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)oldTemplateId).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_chapter"));
        ArrayList<DynamicObject> newValues = new ArrayList<DynamicObject>(oldChapters.length);
        user.set("id", (Object)RequestContext.get().getCurrUserId());
        for (DynamicObject dy : oldChapters) {
            DynamicObject newChapter = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            long oldChapterId = dy.getLong("id");
            long newChapterId = GlobalIdUtil.genGlobalLongId();
            newChapter.set("id", (Object)newChapterId);
            newChapter.set("template", (Object)newTemplate);
            newChapter.set("creator", (Object)user);
            newChapter.set("createtime", (Object)date);
            newChapter.set("modifier", (Object)user);
            newChapter.set("modifytime", (Object)date);
            newChapter.set("commitstatus", (Object)"A");
            newValues.add(newChapter);
            Map<Long, DynamicObject> oldVarIdToNewVar = AnalysisCommonOperateHelper.copyVariable(cloneUtils, oldChapterId, newChapterId, user, date);
            AnalysisCommonOperateHelper.copyDataSet(cloneUtils, oldChapterId, newChapterId, user, date, oldVarIdToNewVar);
            AnalysisCommonOperateHelper.copyChapterModule(cloneUtils, oldChapterId, newChapter, user, date);
        }
        SaveServiceHelper.save((DynamicObject[])newValues.toArray(new DynamicObject[0]));
    }

    private static Map<Long, DynamicObject> copyVariable(CloneUtils cloneUtils, long oldChapterId, long newChapterId, DynamicObject user, Date date) {
        DynamicObject[] oldVariables = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id", (QFilter[])new QFilter("chapterid", "=", (Object)oldChapterId).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_disc_variable"));
        ArrayList<DynamicObject> newValues = new ArrayList<DynamicObject>(oldVariables.length);
        HashMap oldVarIdToNewVar = Maps.newHashMapWithExpectedSize((int)oldVariables.length);
        for (DynamicObject dy : oldVariables) {
            DynamicObject newVariable = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long oldId = dy.getLong("id");
            Long newId = GlobalIdUtil.genGlobalLongId();
            oldVarIdToNewVar.put(oldId, newVariable);
            newVariable.set("id", (Object)newId);
            newVariable.set("chapterid", (Object)newChapterId);
            newVariable.set("creator", (Object)user);
            newVariable.set("createdate", (Object)date);
            newVariable.set("modifier", (Object)user);
            newVariable.set("modifydate", (Object)date);
            newValues.add(newVariable);
        }
        SaveServiceHelper.save((DynamicObject[])newValues.toArray(new DynamicObject[0]));
        return oldVarIdToNewVar;
    }

    private static void copyDataSet(CloneUtils cloneUtils, long oldChapterId, long newChapterId, DynamicObject user, Date date, Map<Long, DynamicObject> oldVarIdToNewVar) {
        DynamicObject[] oldDataSets = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset", (String)"id", (QFilter[])new QFilter("chapterid", "=", (Object)oldChapterId).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset"));
        HashMap<Long, DynamicObject> oldDataSetId2new = new HashMap<Long, DynamicObject>(oldDataSets.length);
        for (DynamicObject dy : oldDataSets) {
            DynamicObject newDataSet = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSet.set("id", (Object)newId);
            newDataSet.set("chapterid", (Object)newChapterId);
            newDataSet.set("creator", (Object)user);
            newDataSet.set("createtime", (Object)date);
            newDataSet.set("modifier", (Object)user);
            newDataSet.set("modifytime", (Object)date);
            oldDataSetId2new.put(dy.getLong("id"), newDataSet);
        }
        SaveServiceHelper.save((DynamicObject[])oldDataSetId2new.values().toArray(new DynamicObject[0]));
        DynamicObject[] oldDataSetSingles = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset_single", (String)"id", (QFilter[])new QFilter("dataset", "in", oldDataSetId2new.keySet()).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset_single"));
        ArrayList<DynamicObject> newDataSetSingles = new ArrayList<DynamicObject>(oldDataSetSingles.length);
        for (DynamicObject dy : oldDataSetSingles) {
            DynamicObject newDataSetSingle = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSetSingle.set("id", (Object)newId);
            newDataSetSingle.set("dataset", oldDataSetId2new.get(dy.getLong(DATASETID)));
            newDataSetSingles.add(newDataSetSingle);
        }
        SaveServiceHelper.save((DynamicObject[])newDataSetSingles.toArray(new DynamicObject[0]));
        DynamicObject[] oldDataSetVars = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset_variable", (String)"id", (QFilter[])new QFilter("dataset", "in", oldDataSetId2new.keySet()).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset_variable"));
        ArrayList<DynamicObject> newDataSetVars = new ArrayList<DynamicObject>(oldDataSetSingles.length);
        for (DynamicObject dy : oldDataSetVars) {
            DynamicObject newDataSetVar = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSetVar.set("id", (Object)newId);
            newDataSetVar.set("dataset", oldDataSetId2new.get(dy.getLong(DATASETID)));
            if (oldVarIdToNewVar.containsKey(newDataSetVar.getLong("variable.id"))) {
                newDataSetVar.set("variable", (Object)oldVarIdToNewVar.get(newDataSetVar.getLong("variable.id")));
            }
            newDataSetVars.add(newDataSetVar);
        }
        SaveServiceHelper.save((DynamicObject[])newDataSetVars.toArray(new DynamicObject[0]));
        DynamicObject[] oldDataSetMultivalues = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_dataset_multivalue", (String)"id", (QFilter[])new QFilter("dataset", "in", oldDataSetId2new.keySet()).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_dataset_multivalue"));
        ArrayList<DynamicObject> newDataSetMultivalues = new ArrayList<DynamicObject>(oldDataSetSingles.length);
        for (DynamicObject dy : oldDataSetMultivalues) {
            DynamicObject newDataSetVar = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            Long newId = GlobalIdUtil.genGlobalLongId();
            newDataSetVar.set("id", (Object)newId);
            newDataSetVar.set("dataset", oldDataSetId2new.get(dy.getLong(DATASETID)));
            newDataSetMultivalues.add(newDataSetVar);
        }
        SaveServiceHelper.save((DynamicObject[])newDataSetMultivalues.toArray(new DynamicObject[0]));
    }

    private static void copyChapterModule(CloneUtils cloneUtils, long oldChapterId, DynamicObject newChapter, DynamicObject user, Date date) {
        DynamicObject oldChapter = BusinessDataServiceHelper.loadSingle((Object)oldChapterId, (String)"fidm_chapter");
        DynamicObjectCollection oldChapterModules = oldChapter.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newChapterModules = newChapter.getDynamicObjectCollection("entryentity");
        List moduleIds = oldChapterModules.stream().map(e -> e.getLong(MODULEID)).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
        if (moduleIds.size() > 0) {
            newChapterModules.clear();
            DynamicObject[] oldModuleList = BusinessDataServiceHelper.load((Object[])moduleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"));
            HashMap<String, String> idMap = new HashMap<String, String>(oldModuleList.length);
            ArrayList saveNewModules = Lists.newArrayListWithCapacity((int)oldModuleList.length);
            ArrayList newModuleInfo = Lists.newArrayListWithExpectedSize((int)oldModuleList.length);
            for (DynamicObject oldModule : oldModuleList) {
                JSONObject jsonObject;
                String itemId;
                DynamicObject newModule = (DynamicObject)cloneUtils.clone((IDataEntityBase)oldModule);
                Long newId = GlobalIdUtil.genGlobalLongId();
                newModule.set("id", (Object)newId);
                idMap.put(oldModule.get("id").toString(), newId.toString());
                newModule.set("creator", (Object)user);
                newModule.set("createtime", (Object)date);
                newModule.set("modifier", (Object)user);
                newModule.set("modifytime", (Object)date);
                String propertiesStr = newModule.getString("properties");
                if (StringUtils.isNotEmpty((String)propertiesStr) && !propertiesStr.equals("null") && StringUtils.isNotEmpty((String)(itemId = (jsonObject = JSON.parseObject((String)propertiesStr)).getString("id")))) {
                    String oldParentId = jsonObject.getString("pid");
                    Tuple itemIdInfo = Tuple.create((Object)newId, (Object)itemId, (Object)oldParentId);
                    newModuleInfo.add(itemIdInfo);
                    jsonObject.put("id", (Object)newId.toString());
                    newModule.set("properties", (Object)jsonObject.toJSONString());
                }
                saveNewModules.add(newModule);
                String moduleKey = "";
                DynamicObject oldChapterModule = oldChapterModules.stream().filter(x -> Objects.equals(x.getString(MODULEID), oldModule.getString("id"))).findAny().orElse(null);
                if (oldChapterModule != null) {
                    moduleKey = oldChapterModule.getString("key");
                }
                DynamicObject dyn = new DynamicObject(newChapterModules.getDynamicObjectType());
                dyn.set("module", (Object)newId);
                dyn.set("key", (Object)moduleKey);
                dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                newChapterModules.add((Object)dyn);
            }
            for (DynamicObject a : saveNewModules) {
                Object lineList;
                List resList;
                Object idsObj;
                JSONObject propJO = JSONObject.parseObject((String)a.getString("properties"));
                Object currTabId = AnalysisCommonOperateHelper.changeFieldByPath(propJO, "c.currTabId", "", true);
                if (currTabId != null) {
                    AnalysisCommonOperateHelper.changeFieldByPath(propJO, "c.currTabId", idMap.get(currTabId.toString()), false);
                }
                if ((idsObj = AnalysisCommonOperateHelper.changeFieldByPath(propJO, "c.config.compLinkage.ids", "", true)) instanceof List && (resList = (List)idsObj).size() != 0) {
                    ArrayList idList = new ArrayList(resList.size());
                    for (Object id : resList) {
                        idList.add(idMap.get(id.toString()));
                    }
                    AnalysisCommonOperateHelper.changeFieldByPath(propJO, "c.config.compLinkage.ids", idList, false);
                }
                if ((lineList = AnalysisCommonOperateHelper.changeFieldByPath(propJO, "c.lineList", "", true)) != null) {
                    AnalysisCommonOperateHelper.copyDupontLine(lineList, idMap);
                }
                a.set("properties", (Object)propJO);
            }
            if (saveNewModules.size() > 0 && newModuleInfo.size() > 0) {
                AnalysisCommonOperateHelper.changeParentRelation(newModuleInfo, saveNewModules);
            }
            SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
        }
    }

    public static void copyDupontLine(Object lineList, Map<String, String> idMap) {
        if (lineList == null || idMap.isEmpty()) {
            return;
        }
        for (Object item : (JSONArray)JSON.toJSON((Object)lineList)) {
            if (!(item instanceof JSONObject)) continue;
            JSONObject jsonObject = (JSONObject)item;
            String from = jsonObject.getString("from");
            String to = jsonObject.getString("to");
            if (from == null || to == null) {
                return;
            }
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcherFrom = pattern.matcher(from);
            Matcher matcherTo = pattern.matcher(to);
            String fromNumber = "";
            String toNumber = "";
            while (matcherFrom.find()) {
                fromNumber = matcherFrom.group();
            }
            while (matcherTo.find()) {
                toNumber = matcherTo.group();
            }
            jsonObject.put("from", (Object)from.replace(fromNumber, idMap.get(fromNumber)));
            jsonObject.put("to", (Object)to.replace(toNumber, idMap.get(toNumber)));
        }
    }

    public static Object changeFieldByPath(JSONObject jsonObject, String fieldPath, Object context, boolean isExist) {
        if (jsonObject == null || StringUtils.isEmpty((String)fieldPath)) {
            return null;
        }
        String[] pathSegments = fieldPath.split("\\.");
        JSONObject currentObject = jsonObject;
        for (int i = 0; i < pathSegments.length - 1; ++i) {
            String segment = pathSegments[i];
            if (!currentObject.containsKey((Object)segment) || !(currentObject.get((Object)segment) instanceof JSONObject)) {
                return null;
            }
            currentObject = currentObject.getJSONObject(segment);
        }
        String lastSegment = pathSegments[pathSegments.length - 1];
        if (currentObject.containsKey((Object)lastSegment)) {
            if (isExist) {
                return currentObject.get((Object)lastSegment);
            }
            return currentObject.put(lastSegment, context);
        }
        return null;
    }

    private static void changeParentRelation(List<Tuple<Long, String, String>> newModuleInfo, List<DynamicObject> saveNewModules) {
        HashMap newModuleParentInfo = Maps.newHashMapWithExpectedSize((int)10);
        newModuleInfo.stream().forEach(oldModuleId -> newModuleInfo.stream().forEach(oldModuleParent -> {
            if (oldModuleId.p3 != null && oldModuleParent.p2 != null && ((String)oldModuleId.p3).equals(oldModuleParent.p2)) {
                newModuleParentInfo.put(oldModuleId.p1, oldModuleParent.p1);
            }
        }));
        saveNewModules.forEach(saveNewModule -> {
            JSONObject jsonObject;
            Long itemId;
            String propertiesStr = saveNewModule.getString("properties");
            if (StringUtils.isNotEmpty((String)propertiesStr) && !propertiesStr.equals("null") && Objects.nonNull(itemId = (jsonObject = JSON.parseObject((String)propertiesStr)).getLong("id")) && newModuleParentInfo.containsKey(itemId)) {
                Long newModuleParentId = (Long)newModuleParentInfo.get(itemId);
                jsonObject.put("pid", (Object)String.valueOf(newModuleParentId));
                saveNewModule.set("properties", (Object)jsonObject.toJSONString());
            }
        });
    }

    public static List<ParamData> getDimList(String eventArgs) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List dimList = Collections.EMPTY_LIST;
        try {
            JSONObject queryConfig = JSON.parseObject((String)eventArgs).getJSONObject("queryConfig");
            QueryData queryData = (QueryData)objectMapper.readValue(queryConfig.toJSONString(), QueryData.class);
            dimList = queryData.getDimList();
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getMessage());
        }
        return dimList;
    }

    public static void createDynamicControl(List<ParamData> dimList, IFormView formView, IFormPlugin formPlugin, IPageCache pageCache) {
        Page page = new Page();
        Area F7DIMArea = new Area(DIMPANEL);
        Area localVarArea = new Area(LOCALVARPANEL);
        Area varArea = new Area(VARPANEL);
        AnalysisCommonOperateHelper.addDimensionPage(F7DIMArea, varArea, localVarArea, dimList, "", pageCache);
        if (F7DIMArea.getElementListList().size() > 0) {
            page.addArea(F7DIMArea);
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"dimflexpanel"});
        }
        if (varArea.getElementListList().size() > 0) {
            page.addArea(varArea);
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"varflexpanel"});
        }
        if (localVarArea.getElementListList().size() > 0) {
            page.addArea(localVarArea);
        } else {
            formView.setVisible(Boolean.FALSE, new String[]{"localvarflexpanel"});
        }
        if (F7DIMArea.getElementListList().size() > 0 || varArea.getElementListList().size() > 0 || localVarArea.getElementListList().size() > 0) {
            if (MyAnalysisPlugin.class.isAssignableFrom(formPlugin.getClass())) {
                ((MyAnalysisPlugin)formPlugin).setPage(formView, page);
            } else if (ThemeAnalysisBoardPlugin.class.isAssignableFrom(formPlugin.getClass())) {
                ((ThemeAnalysisBoardPlugin)formPlugin).setPage(formView, page);
            } else if (AnalysisPreviewConfig.class.isAssignableFrom(formPlugin.getClass())) {
                ((AnalysisPreviewConfig)formPlugin).setPage(formView, page);
            }
            page.updatePage(formView);
        }
    }

    private static void addDimensionPage(Area F7DIMArea, Area varArea, Area localVarArea, List<ParamData> dimList, String sourceName, IPageCache pageCache) {
        Integer dimIndex = 1;
        Integer varIndex = 1;
        Integer localVarIndex = 1;
        HashMap dimListInfo = Maps.newHashMapWithExpectedSize((int)7);
        for (ParamData paramData : dimList) {
            Number paramId;
            Object paramNumber;
            Integer n;
            Integer n2;
            String varType = paramData.getVartype();
            if (AnalysisCommonOperateHelper.isDimQueryConfig(paramData)) {
                AnalysisCommonOperateHelper.setF7BaseEditElement(F7DIMArea, (String)AnalysisCommonOperateHelper.DYNF7TYPE.p1, paramData, dimIndex, sourceName);
                n2 = dimIndex;
                n = dimIndex = Integer.valueOf(dimIndex + 1);
                paramNumber = paramData.getNumber();
                paramId = Long.valueOf(paramData.getId());
                dimListInfo.put(((String)paramNumber).toLowerCase(), paramId);
                continue;
            }
            if (AnalysisCommonOperateHelper.isF7VarQueryConfig(paramData)) {
                if (AnalysisVariableHelper.VariableType.GLOBAL.getType().equals(varType)) {
                    AnalysisCommonOperateHelper.setF7BaseEditElement(varArea, (String)AnalysisCommonOperateHelper.DYNF7TYPE.p2, paramData, varIndex, sourceName);
                    paramNumber = varIndex;
                    paramId = varIndex = Integer.valueOf(varIndex + 1);
                } else if (AnalysisVariableHelper.VariableType.CHAPTER.getType().equals(varType)) {
                    AnalysisCommonOperateHelper.setF7BaseEditElement(localVarArea, (String)AnalysisCommonOperateHelper.DYNF7TYPE.p2, paramData, localVarIndex, sourceName);
                    paramNumber = localVarIndex;
                    paramId = localVarIndex = Integer.valueOf(localVarIndex + 1);
                }
                Long dimId = Long.valueOf(paramData.getDimid());
                String paramNumber2 = paramData.getNumber();
                dimListInfo.put(paramNumber2.toLowerCase(), dimId);
                continue;
            }
            if (AnalysisCommonOperateHelper.isTextVarQueryConfig(paramData)) {
                if (AnalysisVariableHelper.VariableType.GLOBAL.getType().equals(varType)) {
                    AnalysisCommonOperateHelper.setTextEditElement(varArea, paramData, varIndex, sourceName);
                    n2 = varIndex;
                    n = varIndex = Integer.valueOf(varIndex + 1);
                    continue;
                }
                if (!AnalysisVariableHelper.VariableType.CHAPTER.getType().equals(varType)) continue;
                AnalysisCommonOperateHelper.setTextEditElement(localVarArea, paramData, localVarIndex, sourceName);
                n2 = localVarIndex;
                n = localVarIndex = Integer.valueOf(localVarIndex + 1);
                continue;
            }
            if (!AnalysisCommonOperateHelper.isEnumVarQueryConfig(paramData)) continue;
            if (AnalysisVariableHelper.VariableType.GLOBAL.getType().equals(varType)) {
                AnalysisCommonOperateHelper.setEnumEditElement(varArea, paramData, varIndex, sourceName);
                n2 = varIndex;
                n = varIndex = Integer.valueOf(varIndex + 1);
                continue;
            }
            if (!AnalysisVariableHelper.VariableType.CHAPTER.getType().equals(varType)) continue;
            AnalysisCommonOperateHelper.setEnumEditElement(localVarArea, paramData, localVarIndex, sourceName);
            n2 = localVarIndex;
            n = localVarIndex = Integer.valueOf(localVarIndex + 1);
        }
        if (F7DIMArea.getElementListList().size() > 0 || dimListInfo.size() > 0) {
            pageCache.put(DIMF7INFO, SerializationUtils.toJsonString((Object)dimListInfo));
        }
    }

    public static boolean isDimQueryConfig(ParamData paramData) {
        Integer valueType = paramData.getValuetype();
        String dimId = paramData.getDimid();
        if (Objects.isNull(dimId) && Objects.isNull(valueType)) {
            return true;
        }
        return VariableTypeEnum.DIM.getCode() == valueType.intValue() && Objects.isNull(dimId);
    }

    public static boolean isF7VarQueryConfig(ParamData paramData) {
        Integer valueType = paramData.getValuetype();
        String dimId = paramData.getDimid();
        return VariableTypeEnum.DIM.getCode() == valueType.intValue() && dimId != null;
    }

    public static boolean isEnumVarQueryConfig(ParamData paramData) {
        Integer valueType = paramData.getValuetype();
        return VariableTypeEnum.ENUM.getCode() == valueType.intValue();
    }

    public static boolean isTextVarQueryConfig(ParamData paramData) {
        Integer valueType = paramData.getValuetype();
        return VariableTypeEnum.TEXT.getCode() == valueType.intValue() || VariableTypeEnum.NUMBER.getCode() == valueType.intValue();
    }

    public static void setEnumEditElement(Area varArea, ParamData paramData, Integer index, String sourceName) {
        String varName = paramData.getName();
        String varNum = paramData.getNumber();
        List enums = paramData.getEnums();
        if (Objects.nonNull(enums)) {
            ArrayList enumInfos = Lists.newArrayListWithCapacity((int)enums.size());
            for (Enums enumInfo : enums) {
                String enumNumber = enumInfo.getNumber();
                enumInfos.add(enumNumber);
            }
            ComboEditElement comboEditElement = AnalysisDesignHelper.createComboEditElement(varName, varNum, index, enumInfos, sourceName);
            varArea.addElement((Element)comboEditElement);
        }
    }

    public static void setF7BaseEditElement(Area varArea, String F7Type, ParamData paramData, Integer index, String sourceName) {
        String dimNumber = paramData.getNumber();
        String dimName = StringLengthUtil.cropNameString((String)paramData.getName(), (int)20);
        String entityName = "";
        if (((String)AnalysisCommonOperateHelper.DYNF7TYPE.p1).equals(F7Type)) {
            entityName = paramData.getEntityName();
        } else if (((String)AnalysisCommonOperateHelper.DYNF7TYPE.p2).equals(F7Type)) {
            entityName = paramData.getDimentity();
        }
        BaseEditElement baseEdit = new BaseEditElement(dimName, dimNumber.toLowerCase(), entityName);
        AnalysisSingleF7ServiceHelper.BuildF7StyleForPreview((Element)baseEdit, index, sourceName);
        varArea.addElement((Element)baseEdit);
    }

    public static void setTextEditElement(Area varArea, ParamData paramData, Integer index, String sourceName) {
        String varName = StringLengthUtil.cropNameString((String)paramData.getName(), (int)20);
        String varNum = paramData.getNumber();
        TextEditElement textEditElement = AnalysisDesignHelper.createTextEditElement(varName, varNum, index, sourceName);
        varArea.addElement((Element)textEditElement);
    }

    public static void setDefaultValue(List<ParamData> dimList, IFormView formView, IDataModel dataMdoel, String previewSource) {
        Map<Object, Object> varAssignValue = Maps.newHashMapWithExpectedSize((int)1);
        if (DynamicControlSourceEnum.MODULEANALYSIS.getSourceName().equals(previewSource) || DynamicControlSourceEnum.ICONPARAMETERS.getSourceName().equals(previewSource)) {
            String eventArgs = (String)formView.getFormShowParameter().getCustomParam(PREVIEWDATA);
            varAssignValue = AnalysisCommonOperateHelper.getDataSetModifyValue(eventArgs, formView);
        }
        for (ParamData paramData : dimList) {
            String defaultValue;
            String paramNumber = paramData.getNumber();
            IDataEntityProperty paramProperty = dataMdoel.getProperty(paramNumber);
            if (!Objects.nonNull(paramProperty)) continue;
            if (AnalysisCommonOperateHelper.isDimQueryConfig(paramData)) {
                List memberIdList;
                List memberDataList;
                if (Objects.equals("1", paramData.getIsDim())) {
                    String memberId;
                    MemberData memberData2 = paramData.getMember();
                    if (!Objects.nonNull(memberData2) || !Objects.nonNull(memberId = memberData2.getId())) continue;
                    if (varAssignValue.containsKey(paramNumber)) {
                        formView.setEnable(Boolean.FALSE, new String[]{paramNumber.toLowerCase()});
                        dataMdoel.setValue(paramNumber, varAssignValue.get(paramNumber));
                        continue;
                    }
                    dataMdoel.setValue(paramNumber, (Object)memberId);
                    continue;
                }
                if (!Objects.equals("2", paramData.getIsDim()) || !Objects.nonNull(memberDataList = paramData.getMembers()) || (memberIdList = memberDataList.stream().map(memberData -> LongUtil.toLong((Object)memberData.getId())).collect(Collectors.toList())).isEmpty()) continue;
                if (varAssignValue.containsKey(paramNumber)) {
                    formView.setEnable(Boolean.FALSE, new String[]{paramNumber.toLowerCase()});
                    dataMdoel.setValue(paramNumber, (Object)memberIdList.toArray());
                    continue;
                }
                dataMdoel.setValue(paramNumber, (Object)memberIdList.toArray());
                continue;
            }
            if (AnalysisCommonOperateHelper.isF7VarQueryConfig(paramData) || AnalysisCommonOperateHelper.isTextVarQueryConfig(paramData)) {
                defaultValue = paramData.getDefaultvalue();
                if (!Objects.nonNull(defaultValue)) continue;
                if (varAssignValue.containsKey(paramNumber)) {
                    String modifyValueId = (String)varAssignValue.get(paramNumber);
                    formView.setEnable(Boolean.FALSE, new String[]{paramNumber.toLowerCase()});
                    if (modifyValueId.startsWith("$$EnableEdit$$:")) {
                        modifyValueId = modifyValueId.substring(15);
                        formView.setEnable(Boolean.TRUE, new String[]{paramNumber.toLowerCase()});
                    }
                    dataMdoel.setValue(paramNumber, (Object)modifyValueId);
                    continue;
                }
                dataMdoel.setValue(paramNumber, (Object)defaultValue);
                continue;
            }
            if (!AnalysisCommonOperateHelper.isEnumVarQueryConfig(paramData) || !Objects.nonNull(paramData.getEnums()) || !Objects.nonNull(defaultValue = paramData.getDefaultvalue())) continue;
            if (varAssignValue.containsKey(paramNumber)) {
                formView.setEnable(Boolean.FALSE, new String[]{paramNumber.toLowerCase()});
                dataMdoel.setValue(paramNumber, varAssignValue.get(paramNumber));
                continue;
            }
            dataMdoel.setValue(paramNumber, (Object)defaultValue);
        }
    }

    private static Map<String, String> getDataSetModifyValue(String eventArgs, IFormView formView) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray itemListInfo = jsonObject.getJSONArray("itemList");
        JSONObject itemList = null;
        if (Objects.nonNull(itemListInfo)) {
            itemList = (JSONObject)itemListInfo.get(0);
        }
        if (itemList == null) {
            itemList = jsonObject.getJSONObject("item");
        }
        JSONObject dataSet = itemList.getJSONObject("dataset");
        JSONArray dimParams = dataSet.getJSONArray("dimParams");
        JSONArray varParams = dataSet.getJSONArray("varParams");
        List variableList = (List)formView.getFormShowParameter().getCustomParam("variablelist");
        HashMap varAssignValue = Maps.newHashMapWithExpectedSize((int)variableList.size());
        if (Objects.nonNull(varParams) && varParams.size() > 0) {
            varParams.forEach(var -> {
                JSONObject varParam = (JSONObject)var;
                String valueType = varParam.getString("valuetype");
                String varNum = varParam.getString(NUMBER);
                if (VariableTypeEnum.DIM.getStringCode().equals(valueType)) {
                    String modifyValueId = varParam.getString("modifyvalueid");
                    if (Objects.nonNull(modifyValueId)) {
                        Object isRest = varParam.get((Object)"isRest");
                        if ("NO".equals(isRest)) {
                            varAssignValue.put(varNum, modifyValueId);
                        } else {
                            varAssignValue.put(varNum, "$$EnableEdit$$:" + modifyValueId);
                        }
                    }
                } else {
                    String modifyValue = varParam.getString("modifyvalue");
                    if (Objects.nonNull(modifyValue)) {
                        Object isRest = varParam.get((Object)"isRest");
                        if ("NO".equals(isRest)) {
                            varAssignValue.put(varNum, modifyValue);
                        } else {
                            varAssignValue.put(varNum, "$$EnableEdit$$:" + modifyValue);
                        }
                    }
                }
            });
        }
        if (Objects.nonNull(dimParams) && dimParams.size() > 0) {
            dimParams.forEach(dim -> {
                String modifyValueId;
                JSONObject dimParam = (JSONObject)dim;
                String NUMBER = dimParam.getString(NUMBER);
                JSONObject member = dimParam.getJSONObject("member");
                JSONArray members = dimParam.getJSONArray("members");
                if ((Objects.nonNull(member) && member.size() > 0 || Objects.nonNull(members) && members.size() > 0) && Objects.nonNull(modifyValueId = dimParam.getString("modifyvalueid")) && !modifyValueId.isEmpty()) {
                    varAssignValue.put(NUMBER, modifyValueId);
                }
            });
        }
        return varAssignValue;
    }

    public static void getControl(OnGetControlArgs e, Element c, Long dmModelId, IFormView formView, IDataModel dataMdoel, IPageCache pageCache, BeforeF7SelectListener F7Listener, ClickListener clickListener, Long datasetId) {
        if (c != null && (BaseEditElement.class.isAssignableFrom(c.getClass()) || MultiBaseEditElement.class.isAssignableFrom(c.getClass()))) {
            String f7KeyNum;
            String dimF7InfoCache = pageCache.get(DIMF7INFO);
            if (Objects.isNull(dimF7InfoCache)) {
                return;
            }
            Map f7DimInfo = (Map)SerializationUtils.fromJsonString((String)dimF7InfoCache, Map.class);
            Long dimensionId = (Long)f7DimInfo.get(f7KeyNum = e.getKey().toLowerCase());
            if (Objects.isNull(dimensionId)) {
                return;
            }
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
            DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(false), (Long)dimensionId);
            if (c instanceof BaseEditElement) {
                BasedataEdit f7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(formView, F7Listener, dimensionInfo, e.getKey(), null, false, "");
                f7.setDisplayProp("name");
                e.setControl((Control)f7);
            } else if (c instanceof MultiBaseEditElement) {
                DynamicObjectCollection selected = Objects.isNull(dataMdoel.getValue(e.getKey())) ? new DynamicObjectCollection() : (DynamicObjectCollection)dataMdoel.getValue(e.getKey());
                boolean isEb = DisModelTypeEnum.EB.getType().equals(modelStrategyEx.getModel().getModelInfo().getModelType());
                String ebDatset = null;
                DynamicObject dataSet = DatasetDataReader.getDataSet((Long)LongUtil.toLong((Object)datasetId));
                if (!Objects.equals(DataSetTypeEnum.MULTIPLE_VALUED.getType(), dataSet.getString("type"))) {
                    DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)LongUtil.toLong((Object)datasetId));
                    ebDatset = singleDS.getString("ebdataset");
                } else {
                    ebDatset = isEb ? "default" : null;
                }
                MulBasedataEdit mulF7 = modelStrategyEx.getDimensionF7().openComMutilF7(formView, selected, dimensionInfo, ebDatset, F7Listener, e.getKey(), null);
                e.setControl((Control)mulF7);
            }
        } else if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
            TextEdit edit = new TextEdit();
            edit.setKey(e.getKey());
            edit.setModel(dataMdoel);
            edit.setView(formView);
            edit.addClickListener(clickListener);
            e.setControl((Control)edit);
        } else if (c != null && ComboEditElement.class.isAssignableFrom(c.getClass())) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey(e.getKey());
            comboEdit.setModel(dataMdoel);
            comboEdit.setView(formView);
            e.setControl((Control)comboEdit);
        }
    }

    public static void addF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, IDataModel dataMdoel, IPageCache pageCache, IFormView formView, String dimKey, Long dmModelId) {
        Long dimId = 0L;
        Object o = dataMdoel.getValue(dimKey);
        DynamicObject dynamicObject = null;
        if (o instanceof DynamicObject) {
            dynamicObject = (DynamicObject)dataMdoel.getValue(dimKey);
        }
        if (Objects.nonNull(dynamicObject)) {
            dimId = (Long)dynamicObject.getDynamicObject("dimension").getPkValue();
        } else {
            String dimF7InfoCache = pageCache.get(DIMF7INFO);
            if (Objects.isNull(dimF7InfoCache)) {
                return;
            }
            Map f7DimInfo = (Map)SerializationUtils.fromJsonString((String)dimF7InfoCache, Map.class);
            dimId = (Long)f7DimInfo.get(dimKey);
        }
        DynamicObject dmmodel = BusinessDataServiceHelper.loadSingleFromCache((Object)dmModelId, (String)"fidm_model");
        Long modeId = dmmodel.getLong("model.id");
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        qFilter.and(new QFilter("dimension", "=", (Object)dimId));
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        String modeltype = dmmodel.getString("modeltype");
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType((String)modeltype);
        if (!Objects.equals(DisModelTypeEnum.EB, enumByType)) {
            AnalysisCommonOperateHelper.addBeforeF7SelectFilter(qFilter, dimKey, beforeF7SelectEvent, dimId, modeId);
        } else {
            ArrayList filterList = Lists.newArrayListWithCapacity((int)1);
            filterList.add(qFilter);
            beforeF7SelectEvent.setCustomQFilters((List)filterList);
        }
    }

    private static void addBeforeF7SelectFilter(QFilter qFilter, String dimKey, BeforeF7SelectEvent beforeF7SelectEvent, Long dimId, Long modeId) {
        ArrayList filterList = Lists.newArrayListWithCapacity((int)1);
        filterList.add(qFilter);
        if (DmDimMemberEntityEnum.BCM_YEAR.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter(NUMBER, "!=", (Object)"LastYear").and(new QFilter(NUMBER, "!=", (Object)"CurrentYear")));
        } else if (DmDimMemberEntityEnum.BCM_PERIOD.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter(NUMBER, "!=", (Object)"LastPeriod").and(new QFilter(NUMBER, "!=", (Object)"CurrentPeriod")));
        }
        List allDims = new ModelStrategyEx(modeId).getDim().getDimList();
        DimensionInfo dim = DimensionUtils.getDimById((List)allDims, (Long)dimId);
        if (dim == null) {
            return;
        }
        BcmPermService bcmPermService = new BcmPermService(modeId, dimId);
        QFilter permQFilter = bcmPermService.getPermQFilter("id");
        filterList.add(permQFilter);
        beforeF7SelectEvent.setCustomQFilters((List)filterList);
    }

    public static String urlAddTicket(String urlNoTicket) {
        if (StringUtils.isNotEmpty((String)urlNoTicket) && !urlNoTicket.contains("kd_cs_ticket")) {
            String sessionId = RequestContext.get().getGlobalSessionId();
            String csrfTokenValue = SessionManager.getCSRFTokenValue((String)sessionId);
            urlNoTicket = urlNoTicket + '&' + "kd_cs_ticket=" + csrfTokenValue;
        }
        return urlNoTicket;
    }

    private static void writeOpLog(OperationResult result, DynamicObject template, String appId) {
        DynamicObject model = template.getDynamicObject("model");
        if (Objects.isNull(model)) {
            return;
        }
        String templateNumber = template.getString(NUMBER);
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.ANALYSIS_DESIGN).buildOpName(OperationName.COPY).buildFormNumber("far_analysis_list").buildAppId(appId).buildFormatParams(new Object[]{model.getString(NUMBER), templateNumber}).buildOpResult(result);
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
    }
}

