/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.uitls;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AnalysisDesignVarsHelper {
    public static List<Map<String, Object>> buildCommonVarParams(List<Map<String, String>> sourceData, Long modelId) {
        ArrayList<Map<String, Object>> convertSourceData = new ArrayList<Map<String, Object>>(sourceData.size());
        for (Map<String, String> sourceDatum : sourceData) {
            HashMap<String, String> con = new HashMap<String, String>(sourceDatum.size());
            for (Map.Entry<String, String> entry : sourceDatum.entrySet()) {
                con.put(entry.getKey(), entry.getValue());
            }
            convertSourceData.add(con);
        }
        AnalysisDesignVarsHelper.buildVarEumParams(convertSourceData);
        AnalysisDesignVarsHelper.buildDimParams(convertSourceData, modelId);
        return convertSourceData;
    }

    public static List<Map<String, Object>> buildVarEumParams(List<Map<String, Object>> convertSourceData) {
        Set enumIds = convertSourceData.stream().filter(v -> "5".equals(v.get("valuetype"))).map(v -> Long.parseLong(v.get("id").toString())).collect(Collectors.toSet());
        Collection enumDy = BusinessDataServiceHelper.loadFromCache((Object[])enumIds.toArray(), (String)"fidm_disc_variable").values();
        HashMap m = Maps.newHashMapWithExpectedSize((int)enumDy.size());
        enumDy.stream().forEach(v -> {
            DynamicObjectCollection entryentity = v.getDynamicObjectCollection("entryentity");
            ArrayList<HashMap> list = new ArrayList<HashMap>(entryentity.size());
            for (DynamicObject dy : entryentity) {
                HashMap params = Maps.newHashMapWithExpectedSize((int)4);
                params.put("id", dy.getString("id"));
                params.put("number", dy.getString("enum_number"));
                params.put("name", dy.getString("enum_name"));
                params.put("isdefault", dy.getString("isdefault"));
                list.add(params);
            }
            String id = v.getString("id");
            m.put(id, list);
        });
        convertSourceData.stream().filter(v -> "5".equals(v.get("valuetype"))).forEach(v -> v.put("enums", m.get(v.get("id"))));
        return convertSourceData;
    }

    public static List<Map<String, Object>> buildDimParams(List<Map<String, Object>> convertSourceData, Long modelId) {
        Set dimIds = convertSourceData.stream().filter(v -> "4".equals(v.get("valuetype"))).map(v -> Long.parseLong(v.get("disc_dim").toString())).collect(Collectors.toSet());
        if (dimIds.size() > 0) {
            HashMap memberMap;
            List mapList = convertSourceData.stream().filter(v -> "4".equals(v.get("valuetype"))).collect(Collectors.toList());
            HashMap dimMaps = Maps.newHashMapWithExpectedSize((int)dimIds.size());
            HashMap m = new HashMap(12);
            for (Map map : mapList) {
                if (!StringUtils.equals((CharSequence)"4", (CharSequence)map.get("valuetype").toString())) continue;
                HashMap params = Maps.newHashMapWithExpectedSize((int)4);
                params.put("id", map.get("dimid") == null ? "" : map.get("dimid").toString());
                params.put("number", map.get("dimnumber") == null ? "" : map.get("dimnumber").toString());
                params.put("name", map.get("dimname") == null ? "" : map.get("dimname").toString());
                params.put("entityName", map.get("dimentity") == null ? "" : map.get("dimentity").toString());
                params.put("shortNumber", map.get("dimShortNumber") == null ? "" : map.get("dimShortNumber").toString());
                dimMaps.put(params.get("id"), JSONObject.toJSONString((Object)params));
                memberMap = Maps.newHashMapWithExpectedSize((int)4);
                memberMap.put("id", map.get("defaultvalue") == null ? "" : map.get("defaultvalue").toString());
                memberMap.put("number", map.get("membernum") == null ? "" : map.get("membernum").toString());
                memberMap.put("name", map.get("membername") == null ? "" : map.get("membername").toString());
                m.put(memberMap.get("id"), memberMap);
            }
            for (Map map : convertSourceData) {
                if (!StringUtils.equals((CharSequence)"4", (CharSequence)map.get("valuetype").toString()) || !StringUtils.isNotEmpty((CharSequence)map.get("disc_dim").toString())) continue;
                String defaultvalue = map.get("defaultvalue").toString();
                memberMap = (HashMap)m.get(defaultvalue);
                String discDim = (String)dimMaps.get(map.get("disc_dim"));
                JSONObject jB = JSONObject.parseObject((String)discDim);
                memberMap.put("dimNumber", jB.get((Object)"shortNumber").toString());
                jB.put("member", (Object)memberMap);
                map.put("vardim", jB);
            }
        }
        return convertSourceData;
    }
}

