/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.uitls;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AnalysisPublishLogServiceHelper {
    public static DynamicObject newAnalysisPublishLog(Long analysisTemplateId, String publishName, String publishPath, String publishType) {
        DynamicObject publishLog = BusinessDataServiceHelper.newDynamicObject((String)"far_analysispublish_log");
        publishLog.set("publishpath", (Object)publishPath);
        publishLog.set("publishname", (Object)publishName);
        publishLog.set("analysistemplateid", (Object)analysisTemplateId);
        publishLog.set("publishtype", (Object)publishType);
        publishLog.set("publisher", (Object)RequestContext.get().getCurrUserId());
        publishLog.set("publishdate", (Object)new Date());
        return publishLog;
    }

    public static void batchInsertAnalysisPublishLog(List<DynamicObject> logs) {
        if (logs.size() > 0) {
            DynamicObjectType objectType = logs.get(0).getDynamicObjectType();
            int batchSize = 999;
            if (logs.size() < batchSize) {
                BusinessDataWriter.save((IDataEntityType)objectType, (Object[])logs.toArray(new DynamicObject[0]));
            } else {
                ArrayList<DynamicObject> batch = new ArrayList<DynamicObject>(batchSize);
                for (DynamicObject log : logs) {
                    batch.add(log);
                    if (batch.size() < batchSize) continue;
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
                if (!batch.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)objectType, (Object[])batch.toArray(new DynamicObject[0]));
                    batch.clear();
                }
            }
        }
    }
}

