/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.faranalysis.uitls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.faranalysis.AnalysisSingleF7ServiceHelper;

public class AnalysisVariableHelper {
    public static final String DIMMEMBERTYPE = "dimmembertype";
    public static final String DISC_DIM = "disc_dim";
    public static final String VARIABLEFIELD = "id,name,number,scope,defaultvalue,valuetype,dimmembertype,disc_dim";

    public static DynamicObjectCollection getVariableDynamicObjectCollection(Collection varIds) {
        QFilter filter = new QFilter("id", "in", (Object)varIds);
        DynamicObjectCollection variableDynamicObjectCollection = QueryServiceHelper.query((String)"fidm_disc_variable", (String)VARIABLEFIELD, (QFilter[])new QFilter[]{filter});
        return variableDynamicObjectCollection;
    }

    public static List<Map<String, String>> getChapterVariableList(Long modelId, Long chapterId) {
        return AnalysisVariableHelper.getVariableList(modelId, VariableType.CHAPTER.getType(), chapterId);
    }

    public static List<Map<String, String>> getGlobalVariableList(Long modelId) {
        return AnalysisVariableHelper.getVariableList(modelId, VariableType.GLOBAL.getType(), null);
    }

    private static List<Map<String, String>> getVariableList(Long modelId, String scope, Long chapterId) {
        QFilter filter = new QFilter("model", "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        filter.and("scope", "=", (Object)scope);
        if (chapterId != null) {
            filter.and("chapterid", "=", (Object)chapterId);
        }
        DynamicObjectCollection gv_list = QueryServiceHelper.query((String)"fidm_disc_variable", (String)VARIABLEFIELD, (QFilter[])new QFilter[]{filter});
        List<Map<String, String>> treeList = AnalysisVariableHelper.setVarStructure(gv_list, modelId, scope);
        return treeList;
    }

    public static List<Map<String, String>> setVarStructure(DynamicObjectCollection gv_list, Long modelId, String scope) {
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(gv_list.size());
        for (DynamicObject chapter : gv_list) {
            String number = chapter.getString("number");
            String name = chapter.getString("name");
            String valueType = chapter.getString("valuetype");
            String defaultValue = chapter.getString("defaultvalue");
            HashMap<String, String> treeNode = new HashMap<String, String>();
            if (VariableTypeEnum.DIM.getCode() == Integer.parseInt(valueType)) {
                if (Objects.nonNull(chapter.get(DIMMEMBERTYPE)) && Objects.nonNull(chapter.get("defaultvalue"))) {
                    String entity = chapter.getString(DIMMEMBERTYPE);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)defaultValue), (String)entity, (String)"name,number");
                    if (Objects.nonNull(dynamicObject)) {
                        String memberNumber = dynamicObject.getString("number");
                        String memberName = dynamicObject.getLocaleString("name").getLocaleValue();
                        String dimId = chapter.getString(DISC_DIM);
                        List<Map<String, Object>> dimInfo = AnalysisSingleF7ServiceHelper.getVarDimList(modelId, Lists.newArrayList((Object[])new Long[]{Long.parseLong(dimId)}));
                        if (Objects.nonNull(dimInfo)) {
                            dimInfo.forEach(e -> {
                                String dimNumber = (String)e.get("number");
                                String dimName = (String)e.get("name");
                                String shortNumber = e.get("shortNumber").toString();
                                treeNode.put("dimnumber", dimNumber);
                                treeNode.put("dimname", dimName);
                                treeNode.put("dimShortNumber", shortNumber);
                            });
                        }
                        treeNode.put("dimid", dimId);
                        String dimEntity = chapter.getString(DIMMEMBERTYPE);
                        treeNode.put("dimentity", dimEntity);
                        treeNode.put("membernum", (String)treeNode.get("dimShortNumber") + "." + memberNumber);
                        treeNode.put("membername", memberName);
                    }
                }
            } else if (VariableTypeEnum.ENUM.getCode() == Integer.parseInt(valueType)) {
                Long variableId = chapter.getLong("id");
                DynamicObjectCollection enumCollection = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"entryentity.enum_number enumnum,entryentity.enum_name enumname,entryentity.isdefault isenumdefault", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)variableId)});
                StringJoiner stringJoiner = new StringJoiner(";");
                for (DynamicObject enumInfo : enumCollection) {
                    StringJoiner joiner = new StringJoiner("-");
                    String enumNumber = enumInfo.getString("enumnum");
                    joiner.add(enumNumber);
                    String enumName = enumInfo.getString("enumname");
                    joiner.add(enumName);
                    String isDefaultEnum = enumInfo.getString("isenumdefault");
                    joiner.add(isDefaultEnum);
                    stringJoiner.add(joiner.toString());
                }
                treeNode.put("enummembers", stringJoiner.toString());
            }
            treeNode.put("id", chapter.get("id").toString());
            treeNode.put("number", number);
            treeNode.put("name", name);
            treeNode.put("parentid", "0");
            treeNode.put("text", (String)treeNode.get("name"));
            treeNode.put("valuetype", valueType);
            treeNode.put("defaultvalue", defaultValue);
            treeNode.put(DISC_DIM, chapter.getString(DISC_DIM));
            treeNode.put("dimentity", chapter.getString(DIMMEMBERTYPE));
            if (VariableType.GLOBAL.getType().equals(scope) || VariableType.CHAPTER.getType().equals(scope)) {
                treeNode.put("vartype", scope);
            }
            treeList.add(treeNode);
        }
        return treeList;
    }

    public static enum VariableType {
        GLOBAL("1"),
        CHAPTER("2");

        private String type;

        private VariableType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

