/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.cache;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.cache.ICache;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public abstract class AbstractCache
implements ICache {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(AbstractCache.class);
    private final Cache<String, Object> _cache;

    public AbstractCache(Cache<String, Object> cache) {
        Objects.requireNonNull(cache);
        this._cache = cache;
    }

    @Override
    public <T> T getOrLoad(String key, GlobalCacheServiceHelper.ILoader<T> loader) {
        try {
            return (T)this._cache.get((Object)key, loader::load);
        }
        catch (ExecutionException e) {
            log.error(e);
            throw new RuntimeException(String.format("getOrLoad key[%s] fail!", key), e);
        }
    }

    @Override
    public void invalidateStartsWithKey(String key) {
        ArrayList cacheKeylst = new ArrayList();
        this._cache.asMap().keySet().forEach(cacheKey -> {
            if (cacheKey.startsWith(key)) {
                cacheKeylst.add(cacheKey);
            }
        });
        this._cache.invalidateAll(cacheKeylst);
    }

    @Override
    public void invalidateByKey(String key) {
        this._cache.invalidate((Object)key);
    }

    @Override
    public void invalidateAll() {
        this._cache.invalidateAll();
    }

    @Override
    public <T> T getIfPresent(String key) {
        return (T)this._cache.getIfPresent((Object)key);
    }

    @Override
    public void replaceCache(String key, Object v) {
        this._cache.put((Object)key, v);
    }

    @Override
    public void put(String key, Object v) {
        this._cache.put((Object)key, v);
    }

    @Override
    public void invalidateByKeys(String ... keys) {
        this._cache.invalidateAll(Arrays.asList(keys));
    }
}

