/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.cache;

import kd.epm.far.common.common.cache.ICache;
import kd.epm.far.common.common.cache.factory.CacheGenFactory;
import kd.epm.far.common.common.enums.CacheTypeEnum;

public class GlobalCacheServiceHelper {
    public static <T> T getOrLoadFromCommonCache(String key, ILoader<T> loader) {
        return CacheGenFactory.getCommonCache().getOrLoad(key, loader);
    }

    public static <T> T getOrLoadAboutDim(String modelNum, String key, ILoader<T> loader) {
        String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey(modelNum, key);
        return CacheGenFactory.getDimMemberCacheCache().getOrLoad(cacheKey, loader);
    }

    public static String packAboutDimCacheKey(String modelNum, String key) {
        return modelNum + "|" + key;
    }

    public static ICache getCache(CacheTypeEnum cacheType) {
        if (CacheTypeEnum.DimMemberCache == cacheType) {
            return CacheGenFactory.getDimMemberCacheCache();
        }
        if (CacheTypeEnum.TemplateModelReadCache == cacheType) {
            return CacheGenFactory.getTemplateModelReadCache();
        }
        if (CacheTypeEnum.CommonCache == cacheType) {
            return CacheGenFactory.getCommonCache();
        }
        if (CacheTypeEnum.TemporaryCache == cacheType) {
            return CacheGenFactory.getTemporaryCache();
        }
        if (CacheTypeEnum.BizStatusCache == cacheType) {
            return CacheGenFactory.getBizStatusCache();
        }
        throw new RuntimeException(String.format("not support cache type %s", cacheType == null ? "null" : cacheType.toString()));
    }

    public static ICache getDimMemberCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.DimMemberCache);
    }

    public static ICache getCommonCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.CommonCache);
    }

    public static interface ILoader<T> {
        public T load();
    }
}

