/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.cache.MemberReader;
import kd.epm.far.common.common.enums.DimEntityNumEnum;
import kd.epm.far.common.common.enums.StorageTypeEnum;
import kd.epm.far.common.common.util.ToStringHelper;

public class IDNumberTreeNode
implements Cloneable {
    public static final IDNumberTreeNode NotFoundTreeNode = new IDNumberTreeNode(-1L, "not found", "", -1, -1, null, null, false, null, -1L, "");
    private Long id;
    private String number;
    private Long copyFromId;
    private IDNumberTreeNode parent;
    private List<IDNumberTreeNode> shareNodes;
    private List<IDNumberTreeNode> children;
    private String aggOprt;
    private int dSeq;
    private int level;
    private Tuple<Long, String, String> dim;
    private StorageTypeEnum storageType;
    private boolean isLeaf;
    private Pair<Long, String> model;
    private String longNumber = "";
    private String currency;
    private Map<String, Object> properties = null;
    private Map<String, String> localeNames;
    private Long assoStoreMem;
    private Map<Integer, List<IDNumberTreeNode>> childType2AllChildren = new HashMap<Integer, List<IDNumberTreeNode>>(16);

    public IDNumberTreeNode(Long id, String number, String aggOprt, int dSeq, int level, Tuple<Long, String, String> dim, StorageTypeEnum storageType, boolean isLeaf, Pair<Long, String> model, Long copyFromId, String name) {
        this.id = id;
        this.number = number;
        this.copyFromId = copyFromId;
        this.aggOprt = aggOprt;
        this.dSeq = dSeq;
        this.level = level;
        this.dim = dim;
        this.storageType = storageType == StorageTypeEnum.UNSHARE ? null : storageType;
        this.isLeaf = isLeaf;
        this.model = model;
        this.initLocaleNames(name);
    }

    private void initLocaleNames(String name) {
        this.localeNames = new ConcurrentHashMap<String, String>(4);
        this.localeNames.put(RequestContext.get().getLang().name(), name);
    }

    public String getName() {
        String langName = RequestContext.get().getLang().name();
        if (this.dim == null || StringUtils.isEmpty((String)((String)this.dim.p3))) {
            return this.localeNames.get(langName);
        }
        if (!this.localeNames.containsKey(langName)) {
            DynamicObject entityNode = BusinessDataServiceHelper.loadSingle((String)((String)this.dim.p3), (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.id)});
            String localeName = entityNode != null && entityNode.getLocaleString("name").getLocaleValue() != null ? entityNode.getLocaleString("name").getLocaleValue() : this.localeNames.values().iterator().next();
            this.localeNames.put(langName, localeName);
        }
        return this.localeNames.get(langName);
    }

    public String getAggOprt() {
        return this.aggOprt;
    }

    public int getdSeq() {
        return this.dSeq;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDimNumber() {
        return (String)this.dim.p2;
    }

    public Long getDimId() {
        return (Long)this.dim.p1;
    }

    public StorageTypeEnum getStorageType() {
        return this.storageType == null ? StorageTypeEnum.UNSHARE : this.storageType;
    }

    public boolean isShare() {
        return StorageTypeEnum.isShare(this.getStorageType());
    }

    public Long getModelId() {
        return (Long)this.model.p1;
    }

    public String getModelNumber() {
        return (String)this.model.p2;
    }

    public void addChild(IDNumberTreeNode id) {
        if (this.children == null) {
            this.children = new ArrayList<IDNumberTreeNode>(16);
        }
        this.children.add(id);
    }

    public void addShareNode(IDNumberTreeNode shareNode) {
        if (this.shareNodes == null) {
            this.shareNodes = new ArrayList<IDNumberTreeNode>(10);
        }
        this.shareNodes.add(shareNode);
    }

    public List<IDNumberTreeNode> getShareNodes() {
        return this.shareNodes == null ? new ArrayList(1) : this.shareNodes;
    }

    public IDNumberTreeNode getParent() {
        return this.parent;
    }

    public void setParent(IDNumberTreeNode parent) {
        this.parent = parent;
    }

    public Long getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public Long getCopyfromId() {
        return this.copyFromId;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public String getSearchTxt() {
        return this.number.toLowerCase(Locale.ENGLISH) + "," + this.getName().toLowerCase(Locale.ENGLISH);
    }

    public IDNumberTreeNode getBaseTreeNode() {
        if (this != NotFoundTreeNode && this.copyFromId != 0L) {
            return MemberReader.findMemberByIdEx(this.getModelNumber(), DimEntityNumEnum.getEntieyNumByNumber(this.getDimNumber()), this.copyFromId);
        }
        return this;
    }

    public List<IDNumberTreeNode> getAllChildren(int childType) {
        List<IDNumberTreeNode> nodes = this.childType2AllChildren.get(childType);
        if (nodes == null) {
            nodes = new ArrayList<IDNumberTreeNode>(16);
            this.addAllChildren(childType, nodes);
            this.childType2AllChildren.put(childType, nodes);
        }
        return nodes;
    }

    private void addAllChildren(int childType, List<IDNumberTreeNode> nodes) {
        if (this.children == null) {
            IDNumberTreeNode baseNode;
            if ((childType == 3 || childType == 4) && this.isShare() && this.getCopyfromId() != 0L && NotFoundTreeNode != (baseNode = this.getBaseTreeNode())) {
                baseNode.addAllChildren(childType, nodes);
            }
            return;
        }
        for (IDNumberTreeNode node : this.children) {
            switch (childType) {
                case 0: {
                    nodes.add(node);
                    break;
                }
                case 1: {
                    if (node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
                case 2: {
                    if (!node.isLeaf()) break;
                    nodes.add(node);
                    break;
                }
                case 3: {
                    this.walkAllChildrenIncludeShareNode(false, node, nodes, childType);
                    break;
                }
                case 4: {
                    this.walkAllChildrenIncludeShareNode(true, node, nodes, childType);
                    break;
                }
            }
            if (node.isLeaf()) continue;
            node.addAllChildren(childType, nodes);
        }
    }

    private void walkAllChildrenIncludeShareNode(boolean includeNotLeaf, IDNumberTreeNode node, List<IDNumberTreeNode> nodes, int childType) {
        if (node.isLeaf) {
            if (!node.isShare()) {
                nodes.add(node);
            } else {
                IDNumberTreeNode base = MemberReader.findMemberByIdEx(this.getModelNumber(), DimEntityNumEnum.getEntieyNumByNumber(this.getDimNumber()), node.getCopyfromId());
                if (base.isLeaf()) {
                    nodes.add(node);
                } else {
                    if (includeNotLeaf) {
                        nodes.add(node);
                    }
                    base.addAllChildren(childType, nodes);
                }
            }
        } else if (includeNotLeaf) {
            nodes.add(node);
        }
    }

    public List<IDNumberTreeNode> getAllChildren() {
        return this.getAllChildren(0);
    }

    public List<IDNumberTreeNode> getBrother() {
        ArrayList<IDNumberTreeNode> ids = new ArrayList<IDNumberTreeNode>(10);
        if (this.getParent() == null) {
            return ids;
        }
        for (IDNumberTreeNode node : this.getParent().getChildren()) {
            if (node.getId().equals(this.id)) continue;
            ids.add(node);
        }
        return ids;
    }

    public IDNumberTreeNode parent(Object id) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getId().equals(id)) {
            return this.parent;
        }
        return this.parent.parent(id);
    }

    public List<IDNumberTreeNode> getChildren() {
        if (this.isShare() && this.isLeaf && this.copyFromId != 0L) {
            return this.getBaseTreeNode().getChildren();
        }
        return this.children == null ? new ArrayList(0) : this.children;
    }

    public void setChildren(List<IDNumberTreeNode> nodeList) {
        this.children = nodeList;
    }

    public Set<Long> getChildrenIds() {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (this.children != null) {
            for (IDNumberTreeNode node : this.children) {
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public String getLongNumber() {
        if (StringUtils.isEmpty((String)this.longNumber)) {
            this.longNumber = this.getParent() != null ? this.getParent().getLongNumber() + "!" + this.number : this.number;
        }
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public <T> T getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return (T)this.properties.get(key);
    }

    public IDNumberTreeNode clone() {
        IDNumberTreeNode o = null;
        try {
            o = (IDNumberTreeNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException("IDNumberTreeNode clone not support");
        }
        return o;
    }

    public String toString() {
        return ToStringHelper.reflectionToString(this);
    }

    public Long getAssoStoreMem() {
        return this.assoStoreMem == null ? Long.valueOf(0L) : this.assoStoreMem;
    }

    public void setAssoStoreMem(Long assoStoreMem) {
        this.assoStoreMem = assoStoreMem == 0L ? null : assoStoreMem;
    }
}

