/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.cache;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.cache.IDNumberTreeNode;
import kd.epm.far.common.common.cache.strategy.MemberQueryStrategy;
import kd.epm.far.common.common.enums.DimEntityNumEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class MemberReader {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MemberReader.class);

    public static Map<Long, IDNumberTreeNode> getAllNodeFromCacheEx(String entityNumber, String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, null).getAllNodes(modelNum)).getId2Node();
    }

    public static Map<String, Map<String, IDNumberTreeNode>> getAllNodeByNumberFromCacheEx(String entityNumber, String modelNum) {
        return GlobalCacheServiceHelper.getOrLoadAboutDim(modelNum, entityNumber, () -> MemberQueryStrategy.getStrategy(entityNumber, null).getAllNodes(modelNum)).getNumber2Node();
    }

    public static IDNumberTreeNode findMemberByIdEx(String modelNum, String entityNumber, Long memberId) {
        if (memberId == null) {
            return IDNumberTreeNode.NotFoundTreeNode;
        }
        IDNumberTreeNode member = MemberReader.getAllNodeFromCacheEx(entityNumber, modelNum).get(memberId);
        if (member == null) {
            member = IDNumberTreeNode.NotFoundTreeNode;
            log.error(String.format("model:%s,entityNumber:%s,member:%s is not found.", modelNum, entityNumber, memberId));
        }
        return member;
    }

    public static IDNumberTreeNode findMemberByNumberEx(String modelNum, String dimNum, String number) {
        String entityNumber = DimEntityNumEnum.getEntieyNumByNumber(dimNum);
        IDNumberTreeNode member = MemberReader.searchMemberByNumber(modelNum, entityNumber, dimNum, number);
        if (member == null) {
            log.error(String.format("model:%s,dimNum:%s,number:%s is not found.", modelNum, dimNum, number));
            member = IDNumberTreeNode.NotFoundTreeNode;
        }
        return member;
    }

    private static IDNumberTreeNode searchMemberByNumber(String modelNum, String entityNumber, String dimNum, String number) {
        Map<String, IDNumberTreeNode> number2Node = MemberReader.getAllNodeByNumberFromCacheEx(entityNumber, modelNum).get(dimNum);
        if (number2Node == null) {
            log.error(String.format("model:%s,dim:%s,member:%s is not found.", modelNum, dimNum, number));
            return null;
        }
        return number2Node.get(number);
    }

    public static Long findModelIdByNumEx(String number) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache(CacheKey.PrefixString + "model_id_2_number_" + number, () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])QFilter.of((String)"number=?", (Object[])new Object[]{number}).toArray());
            return dyna == null ? 0L : dyna.getLong("id");
        });
    }

    public static class NodeList {
        private Map<Long, IDNumberTreeNode> id2Node;
        private Map<String, Map<String, IDNumberTreeNode>> number2Node;
        private Map<String, Map<String, List<IDNumberTreeNode>>> number2ShareNode;

        public Map<Long, IDNumberTreeNode> getId2Node() {
            return this.id2Node;
        }

        public void setId2Node(Map<Long, IDNumberTreeNode> id2Node) {
            this.id2Node = id2Node;
        }

        public Map<String, Map<String, IDNumberTreeNode>> getNumber2Node() {
            return this.number2Node;
        }

        public void setNumber2Node(Map<String, Map<String, IDNumberTreeNode>> number2Node) {
            this.number2Node = number2Node;
        }

        public Map<String, Map<String, List<IDNumberTreeNode>>> getNumber2ShareNode() {
            return this.number2ShareNode;
        }

        public void setNumber2ShareNode(Map<String, Map<String, List<IDNumberTreeNode>>> number2ShareNode) {
            this.number2ShareNode = number2ShareNode;
        }
    }
}

