/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.cache.localcache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.cache.ICache;
import kd.epm.far.common.common.cache.localcache.SyncCacheUtil;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public abstract class AbstractLocalCache
implements ICache {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(true, AbstractLocalCache.class);
    private final LocalMemoryCache cache;
    private Set<String> cacheKey = new HashSet<String>(16);
    private ReentrantLock lock = new ReentrantLock();

    protected AbstractLocalCache(LocalMemoryCache cache) {
        this.cache = cache;
    }

    @Override
    public <T> T getOrLoad(String key, GlobalCacheServiceHelper.ILoader<T> loader) {
        LRU lrucache = this.getLocalLRUCache();
        if (lrucache.containsKey(key)) {
            return (T)lrucache.get(key);
        }
        Object value = this.cache.get(key);
        if (value == null || this.checkNotLatest(key)) {
            value = this.reload(key, value, loader);
        }
        this.lockOperation(() -> this.cacheKey.add(key));
        lrucache.put(key, value);
        return (T)value;
    }

    public <T> T reload(String key, T value, GlobalCacheServiceHelper.ILoader<T> loader) {
        log.startWatch();
        value = loader.load();
        this.cache.put(key, value);
        SyncCacheUtil.updateLocalCacheTime(this.cache, key);
        log.infoEnd(String.format("load key:%s data", key));
        return value;
    }

    public boolean checkNotLatest(String key) {
        return SyncCacheUtil.getTimeFromLocalCache(this.cache, key) < SyncCacheUtil.getTimeFromAppCache(key);
    }

    protected boolean isExist(String key) {
        return this.cacheKey.contains(key) && this.cache.contains(key);
    }

    @Override
    public <T> T getIfPresent(String key) {
        return (T)this.cache.get(key);
    }

    @Override
    public void replaceCache(String key, Object v) {
        this.cache.remove(new String[]{key});
        this.cache.put(key, v);
        this.lockOperation(() -> this.cacheKey.add(key));
        this.getLocalLRUCache().put(key, v);
        SyncCacheUtil.updateAppCacheTime(key);
        SyncCacheUtil.updateLocalCacheTime(this.cache, key);
    }

    @Override
    public void invalidateStartsWithKey(String key) {
        this.lockOperation(() -> {
            ArrayList<String> removeKeys = new ArrayList<String>(16);
            removeKeys.add(key);
            this.cacheKey.forEach(k -> {
                if (k.startsWith(key)) {
                    removeKeys.add((String)k);
                    SyncCacheUtil.updateAppCacheTime(k);
                }
            });
            if (!removeKeys.isEmpty()) {
                this.cache.remove(removeKeys.toArray(new String[0]));
                this.cacheKey.removeAll(removeKeys);
            }
        });
    }

    @Override
    public void invalidateByKey(String key) {
        this.lockOperation(() -> this.cacheKey.remove(key));
        this.cache.remove(new String[]{key});
        SyncCacheUtil.updateAppCacheTime(key);
        this.getLocalLRUCache().remove(key);
    }

    @Override
    public void invalidateAll() {
        this.lockOperation(() -> this.cacheKey.clear());
        this.cache.clear();
        this.getLocalLRUCache().clear();
    }

    @Override
    public void put(String key, Object v) {
        this.cache.put(key, v);
        SyncCacheUtil.updateLocalCacheTime(this.cache, key);
        this.lockOperation(() -> this.cacheKey.add(key));
        this.getLocalLRUCache().put(key, v);
    }

    @Override
    public void invalidateByKeys(String ... keys) {
        this.cache.remove(keys);
        this.lockOperation(() -> this.cacheKey.removeAll(Arrays.asList(keys)));
        for (String key : keys) {
            this.getLocalLRUCache().remove(key);
            SyncCacheUtil.updateAppCacheTime(key);
        }
    }

    private void lockOperation(IOperation opt) {
        try {
            this.lock.lock();
            opt.operateEvent();
        }
        finally {
            this.lock.unlock();
        }
    }

    private LRU getLocalLRUCache() {
        return (LRU)ThreadCache.get((Object)(CacheKey.PrefixString + "local-cache"), () -> new LRU());
    }

    private static class LRU
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        protected LRU() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            return this.size() > 50;
        }
    }

    private static interface IOperation {
        public void operateEvent();
    }
}

