/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.cache.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.cache.IDNumberTreeNode;
import kd.epm.far.common.common.cache.MemberReader;
import kd.epm.far.common.common.cache.strategy.IMemberQuery;
import kd.epm.far.common.common.enums.AggOprtEnum;
import kd.epm.far.common.common.enums.StorageTypeEnum;
import kd.epm.far.common.common.util.BcmCollectionUtils;

public abstract class AbstractMemberQuery
implements IMemberQuery {
    public static final String EMPTY_STR = "";

    protected List<String> getProperties() {
        return new ArrayList<String>(16);
    }

    protected String getSelectFields() {
        String selectFields = "id,number,longnumber,name,dimension.number,dimension,model,level,issysmember,aggoprt,parent,copyfrom,dseq,storagetype,isleaf,simplename,parent.storagetype";
        if (!this.getProperties().isEmpty()) {
            selectFields = selectFields + "," + String.join((CharSequence)",", this.getProperties());
        }
        return selectFields;
    }

    protected void addProperties(IDNumberTreeNode node, DynamicObject obj, Map<String, Map<String, IDNumberTreeNode>> dimNumber2Node) {
        this.getProperties().forEach(pro -> node.addProperty((String)pro, obj.get(pro)));
    }

    protected void addQFilter(QFilter filter) {
    }

    protected String getAgg(DynamicObject obj) {
        if (Objects.isNull(obj)) {
            return EMPTY_STR;
        }
        String agg = obj.getString("aggoprt");
        if (StringUtils.isEmpty((String)agg) || "0".equals(agg)) {
            return EMPTY_STR;
        }
        return AggOprtEnum.getAggOprtEnumBySign(obj.getString("aggoprt")).getName();
    }

    protected void setParentAndChild(Map<Long, IDNumberTreeNode> id2Node, DynamicObjectCollection dcs) {
        dcs.forEach(obj -> {
            IDNumberTreeNode baseNode;
            IDNumberTreeNode node = (IDNumberTreeNode)id2Node.get(obj.getLong("id"));
            IDNumberTreeNode pNode = (IDNumberTreeNode)id2Node.get(obj.getLong("parent"));
            if (pNode != null) {
                node.setParent(pNode);
                pNode.addChild(node);
            }
            if (node != null && node.isShare() && (baseNode = (IDNumberTreeNode)id2Node.get(node.getCopyfromId())) != null) {
                baseNode.addShareNode(node);
            }
        });
    }

    protected IDNumberTreeNode createTreeNode(DynamicObject obj, Pair<Long, String> model, MemberReader.NodeList nodeList, Map<String, Tuple<Long, String, String>> dimMap) {
        String dimNum = obj.getString("dimension.number");
        String number = obj.getString("number");
        Tuple dim = dimMap.compute(dimNum, (k, v) -> v == null ? Tuple.create(obj.getLong("dimension"), k, this.getEntityName()) : v);
        Map number2Node = nodeList.getNumber2Node().computeIfAbsent(dimNum, k -> BcmCollectionUtils.unRemoveLinkedMap());
        Map number2ShareNode = nodeList.getNumber2ShareNode().computeIfAbsent(dimNum, k -> BcmCollectionUtils.unRemoveLinkedMap());
        IDNumberTreeNode node = new IDNumberTreeNode(obj.getLong("id"), number, this.getAgg(obj), obj.getInt("dseq"), obj.getInt("level"), dim, StorageTypeEnum.stringToStorageType(obj.getString("storagetype")), obj.getBoolean("isleaf"), model, obj.getLong("copyfrom"), obj.getString("name"));
        if (obj.getLong("copyfrom") == 0L) {
            number2Node.put(number, node);
        } else {
            number2ShareNode.computeIfAbsent(number, k -> new ArrayList(16)).add(node);
        }
        return node;
    }

    @Override
    public MemberReader.NodeList getAllNodes(String modelNum) {
        long modelId = MemberReader.findModelIdByNumEx(modelNum);
        Map<Long, IDNumberTreeNode> id2Node = BcmCollectionUtils.unRemoveLinkedMap();
        Map<String, Map<String, IDNumberTreeNode>> dimNumber2Node = BcmCollectionUtils.unRemoveMap();
        Map<String, Map<String, List<IDNumberTreeNode>>> dimNumber2ShareNode = BcmCollectionUtils.unRemoveMap();
        HashMap dimMap = new HashMap(16);
        Pair<Long, String> model = Pair.onePair(modelId, modelNum);
        MemberReader.NodeList nodeList = new MemberReader.NodeList();
        nodeList.setId2Node(id2Node);
        nodeList.setNumber2ShareNode(dimNumber2ShareNode);
        nodeList.setNumber2Node(dimNumber2Node);
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        this.addQFilter(filter);
        DynamicObjectCollection docs = QueryServiceHelper.query((String)this.getEntityName(), (String)this.getSelectFields(), (QFilter[])filter.toArray());
        if (docs == null || docs.isEmpty()) {
            return nodeList;
        }
        docs.forEach(obj -> {
            IDNumberTreeNode node = this.createTreeNode((DynamicObject)obj, model, nodeList, dimMap);
            this.addProperties(node, (DynamicObject)obj, dimNumber2Node);
            id2Node.put(obj.getLong("id"), node);
        });
        this.setParentAndChild(id2Node, docs);
        return nodeList;
    }
}

