/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.cache.strategy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.cache.IDNumberTreeNode;
import kd.epm.far.common.common.cache.MemberReader;
import kd.epm.far.common.common.cache.strategy.AbstractMemberQuery;
import kd.epm.far.common.common.enums.StorageTypeEnum;

public class EntityMemberQuery
extends AbstractMemberQuery {
    @Override
    public List<String> getProperties() {
        return Arrays.asList("currency.number", "cslscheme.id", "cslscheme.number", "isexchangerate", "orgcode", "parent.number", "isindependentorg");
    }

    @Override
    public String getEntityName() {
        return "bcm_entitymembertree";
    }

    @Override
    public void addQFilter(QFilter filter) {
        filter.and(new QFilter("status", "!=", (Object)"A"));
    }

    @Override
    public void addProperties(IDNumberTreeNode node, DynamicObject obj, Map<String, Map<String, IDNumberTreeNode>> dimNumber2Node) {
        node.setCurrency(obj.getString("currency.number"));
        node.addProperty("cslscheme", obj.get("cslscheme.number"));
        String dimNumber = obj.getString("dimension.number");
        String number = obj.getString("number");
        if (!"Entity".equals(number)) {
            String parentChildNum = obj.getString("parent.number") + "_" + number;
            if (!StorageTypeEnum.isShare(obj.getString("parent.storagetype"))) {
                dimNumber2Node.get(dimNumber).put(parentChildNum, node);
            }
        }
        this.getProperties().forEach(pro -> node.addProperty((String)pro, obj.get(pro)));
    }

    @Override
    protected IDNumberTreeNode createTreeNode(DynamicObject obj, Pair<Long, String> model, MemberReader.NodeList nodeList, Map<String, Tuple<Long, String, String>> dimMap) {
        IDNumberTreeNode node = super.createTreeNode(obj, model, nodeList, dimMap);
        node.setLongNumber(obj.getString("longnumber"));
        return node;
    }
}

