/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.enums;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;

public enum ApplicationTypeEnum {
    CM(ApplicationTypeEnum.getCM(), "1", "cm"),
    RPT(ApplicationTypeEnum.getRPT(), "2", "rpt"),
    UNRPT(ApplicationTypeEnum.getUNRPT(), "3", "unrpt"),
    EB(ApplicationTypeEnum.getEB(), "4", "eb"),
    PUB(ApplicationTypeEnum.getPUB(), "5", "rpt"),
    IEP(ApplicationTypeEnum.getIEP(), "99", "iep"),
    BGBD(ApplicationTypeEnum.getBGBD(), "9", "bgbd"),
    BGMD(ApplicationTypeEnum.getBGMD(), "7", "bgmd"),
    BGM(ApplicationTypeEnum.getBGM(), "10", "bgm"),
    BGC(ApplicationTypeEnum.getBGC(), "11", "bgc"),
    WF(ApplicationTypeEnum.getWF(), "12", "wftask"),
    FAR(ApplicationTypeEnum.getFAR(), "13", "far"),
    FIDM(ApplicationTypeEnum.getFIDM(), "8", "fidm"),
    DI(ApplicationTypeEnum.getDI(), "14", "di");

    public final String name;
    public final String index;
    public final String appnum;

    private ApplicationTypeEnum(String name, String index, String appnum) {
        this.name = name;
        this.index = index;
        this.appnum = appnum;
    }

    public static ApplicationTypeEnum getApplication(String application) {
        if (StringUtils.isEmpty((String)application)) {
            return CM;
        }
        for (ApplicationTypeEnum typeEnum : ApplicationTypeEnum.values()) {
            if (!application.equals(typeEnum.index)) continue;
            return typeEnum;
        }
        return CM;
    }

    public static ApplicationTypeEnum getEnumByNumber(String appNum) {
        if (StringUtils.isEmpty((String)appNum)) {
            return CM;
        }
        for (ApplicationTypeEnum typeEnum : ApplicationTypeEnum.values()) {
            if (!appNum.equals(typeEnum.appnum)) continue;
            return typeEnum;
        }
        return CM;
    }

    public static boolean isEBOrBGMDOrBGBDOrBGMByApp(String appnum) {
        return ApplicationTypeEnum.EB.appnum.equals(appnum) || ApplicationTypeEnum.BGMD.appnum.equals(appnum) || ApplicationTypeEnum.BGBD.appnum.equals(appnum) || ApplicationTypeEnum.BGM.appnum.equals(appnum);
    }

    private static String getCM() {
        return ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868", (String)"ApplicationTypeEnum_0", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getRPT() {
        return ResManager.loadKDString((String)"\u4e2a\u522b\u62a5\u8868", (String)"ApplicationTypeEnum_1", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getUNRPT() {
        return ResManager.loadKDString((String)"\u4e2a\u522b\u62a5\u8868\u672a\u5b8c\u6210", (String)"ApplicationTypeEnum_2", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getEB() {
        return ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97", (String)"ApplicationTypeEnum_3", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getPUB() {
        return ResManager.loadKDString((String)"\u4e2a\u522b\u62a5\u8868\u516c\u7528", (String)"ApplicationTypeEnum_4", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getIEP() {
        return ResManager.loadKDString((String)"\u667a\u80fd\u6838\u7b97", (String)"ApplicationTypeEnum_5", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getBGBD() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91\u57fa\u7840\u8d44\u6599", (String)"ApplicationTypeEnum_6", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getFIDM() {
        return ResManager.loadKDString((String)"\u62ab\u9732\u7ba1\u7406", (String)"ApplicationTypeEnum_11", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getDI() {
        return ResManager.loadKDString((String)"\u96c6\u6210\u7ba1\u7406", (String)"ApplicationTypeEnum_12", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getFAR() {
        return ResManager.loadKDString((String)"\u7ee9\u6548\u5206\u6790", (String)"ApplicationTypeEnum_13", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getBGMD() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91\u9884\u7b97\u4f53\u7cfb", (String)"ApplicationTypeEnum_7", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getBGM() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91\u5168\u9762\u9884\u7b97", (String)"ApplicationTypeEnum_8", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getBGC() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91\u9884\u7b97\u63a7\u5236", (String)"ApplicationTypeEnum_9", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getWF() {
        return ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41", (String)"ApplicationTypeEnum_10", (String)"epm-far-common", (Object[])new Object[0]);
    }

    public String getName() {
        switch (this.index) {
            case "1": {
                return ApplicationTypeEnum.getCM();
            }
            case "2": {
                return ApplicationTypeEnum.getRPT();
            }
            case "3": {
                return ApplicationTypeEnum.getUNRPT();
            }
            case "4": {
                return ApplicationTypeEnum.getEB();
            }
            case "5": {
                return ApplicationTypeEnum.getPUB();
            }
            case "99": {
                return ApplicationTypeEnum.getIEP();
            }
            case "9": {
                return ApplicationTypeEnum.getBGBD();
            }
            case "7": {
                return ApplicationTypeEnum.getBGMD();
            }
            case "8": {
                return ApplicationTypeEnum.getFIDM();
            }
            case "10": {
                return ApplicationTypeEnum.getBGM();
            }
            case "11": {
                return ApplicationTypeEnum.getBGC();
            }
            case "12": {
                return ApplicationTypeEnum.getWF();
            }
            case "13": {
                return ApplicationTypeEnum.getFAR();
            }
        }
        return this.name;
    }

    public String getOIndex() {
        return this.index;
    }

    public String getAppnum() {
        return this.appnum;
    }
}

