/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.enums;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public enum DimTypesEnum {
    ENTITY(DimTypesEnum.getENTITY(), "Entity", "E", true),
    ACCOUNT(DimTypesEnum.getACCOUNT(), "Account", "A", true),
    YEAR(DimTypesEnum.getYEAR(), "Year", "FY", true),
    PERIOD(DimTypesEnum.getPERIOD(), "Period", "P", true),
    SCENARIO(DimTypesEnum.getSCENARIO(), "Scenario", "S", true),
    PROCESS(DimTypesEnum.getPROCESS(), "Process", "BP", true),
    CURRENCY(DimTypesEnum.getCURRENCY(), "Currency", "C", true),
    EBCURRENCY(DimTypesEnum.getCURRENCY(), "CNY", "C", true),
    AUDITTRIAL(DimTypesEnum.getAUDITTRIAL(), "AuditTrail", "AT", true),
    EBAUDITTRIAL(DimTypesEnum.getAUDITTRIAL(), "ATtotal", "AT", true),
    CHANGETYPE(DimTypesEnum.getCHANGETYPE(), "ChangeType", "CT", true),
    EBCHANGETYPE(DimTypesEnum.getCHANGETYPE(), "CurrentPeriod", "CT", true),
    INTERCOMPANY(DimTypesEnum.getINTERCOMPANY(), "InternalCompany", "IC", true),
    EBINTERCOMPANY(DimTypesEnum.getINTERCOMPANY(), "ICNone", "IC", true),
    MULTIGAAP(DimTypesEnum.getMULTIGAAP(), "MultiGAAP", "MG", false),
    PROJECT(DimTypesEnum.getPROJECT(), "Project", "PRO", false),
    BUSINESSPARTNER(DimTypesEnum.getBUSINESSPARTNER(), "BusinessPartner", "CBP", false),
    MULTIBOOK(DimTypesEnum.getMULTIBOOK(), "MultiBook", "MB", false),
    VERSION(DimTypesEnum.getVERSION(), "Version", "V", false),
    EBVERSION(DimTypesEnum.getVERSION(), "VNone", "V", false),
    DATASORT(DimTypesEnum.getDATASORT(), "DataSort", "DS", false),
    DATATYPE(DimTypesEnum.getDATATYPE(), "DataType", "DT", true),
    EBDATATYPE(DimTypesEnum.getDATATYPE(), "Budget", "DT", true),
    MYCOMPANY(DimTypesEnum.getMYCOMPANY(), "MyCompany", "MC", true),
    METRIC(DimTypesEnum.getMETRIC(), "Metric", "M", true);

    private String name;
    private String number;
    private String shortNumber;
    private boolean isPreSeted;

    private DimTypesEnum(String name, String number, String shortNumber, boolean isPreSeted) {
        this.name = name;
        this.number = number;
        this.shortNumber = shortNumber;
        this.isPreSeted = isPreSeted;
    }

    public static String getShortNumberByNumber(String number) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!number.equalsIgnoreCase(t.getNumber())) continue;
            return t.getShortNumber();
        }
        return "";
    }

    public static String getNameByNumber(String number) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!number.equalsIgnoreCase(t.getNumber())) continue;
            return t.getName();
        }
        return "";
    }

    public static String getNumberByShortNumber(String shortNumber) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!shortNumber.equalsIgnoreCase(t.getShortNumber())) continue;
            return t.getNumber();
        }
        return "";
    }

    public static boolean include(String dimension) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!dimension.equalsIgnoreCase(t.getNumber())) continue;
            return true;
        }
        return false;
    }

    public static String getDimNumber(String shortNum, long modelId) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!shortNum.equals(t.getShortNumber())) continue;
            return t.getNumber();
        }
        QFilter filter = new QFilter("shortnumber", "=", (Object)shortNum);
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"number", (QFilter[])new QFilter[]{filter, modelFilter});
        if (dy != null) {
            return dy.getString("number");
        }
        throw new RuntimeException(String.format("not found DimTypesEnum by shortnumber:%s", shortNum));
    }

    public static String getNumberByName(String name) {
        DimTypesEnum[] ft;
        for (DimTypesEnum t : ft = DimTypesEnum.values()) {
            if (!t.getName().equals(name)) continue;
            return t.getNumber();
        }
        return "";
    }

    private static String getENTITY() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"DimTypesEnum_0", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getACCOUNT() {
        return ResManager.loadKDString((String)"\u79d1\u76ee", (String)"DimTypesEnum_1", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getYEAR() {
        return ResManager.loadKDString((String)"\u8d22\u5e74", (String)"DimTypesEnum_2", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getPERIOD() {
        return ResManager.loadKDString((String)"\u671f\u95f4", (String)"DimTypesEnum_3", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getSCENARIO() {
        return ResManager.loadKDString((String)"\u60c5\u666f", (String)"DimTypesEnum_4", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getPROCESS() {
        return ResManager.loadKDString((String)"\u8fc7\u7a0b", (String)"DimTypesEnum_5", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getCURRENCY() {
        return ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DimTypesEnum_6", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getAUDITTRIAL() {
        return ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22", (String)"DimTypesEnum_7", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getCHANGETYPE() {
        return ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"DimTypesEnum_8", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getINTERCOMPANY() {
        return ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7", (String)"DimTypesEnum_9", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getMULTIGAAP() {
        return ResManager.loadKDString((String)"\u51c6\u5219", (String)"DimTypesEnum_10", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getPROJECT() {
        return ResManager.loadKDString((String)"\u9879\u76ee", (String)"DimTypesEnum_11", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getBUSINESSPARTNER() {
        return ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34", (String)"DimTypesEnum_12", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getMULTIBOOK() {
        return ResManager.loadKDString((String)"\u591a\u8d26\u7c3f", (String)"DimTypesEnum_13", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getVERSION() {
        return ResManager.loadKDString((String)"\u7248\u672c", (String)"DimTypesEnum_14", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getDATASORT() {
        return ResManager.loadKDString((String)"\u6570\u636e\u5206\u7c7b", (String)"DimTypesEnum_15", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getDATATYPE() {
        return ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"DimTypesEnum_16", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getMYCOMPANY() {
        return ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7", (String)"DimTypesEnum_17", (String)"epm-far-common", (Object[])new Object[0]);
    }

    private static String getMETRIC() {
        return ResManager.loadKDString((String)"\u5ea6\u91cf", (String)"DimTypesEnum_18", (String)"epm-far-common", (Object[])new Object[0]);
    }

    public boolean isPreSeted() {
        return this.isPreSeted;
    }

    public String getName() {
        switch (this.number) {
            case "Entity": {
                return DimTypesEnum.getENTITY();
            }
            case "Account": {
                return DimTypesEnum.getACCOUNT();
            }
            case "Year": {
                return DimTypesEnum.getYEAR();
            }
            case "Period": {
                return DimTypesEnum.getPERIOD();
            }
            case "Scenario": {
                return DimTypesEnum.getSCENARIO();
            }
            case "Process": {
                return DimTypesEnum.getPROCESS();
            }
            case "Currency": {
                return DimTypesEnum.getCURRENCY();
            }
            case "AuditTrail": {
                return DimTypesEnum.getAUDITTRIAL();
            }
            case "ChangeType": {
                return DimTypesEnum.getCHANGETYPE();
            }
            case "InternalCompany": {
                return DimTypesEnum.getINTERCOMPANY();
            }
            case "MultiGAAP": {
                return DimTypesEnum.getMULTIGAAP();
            }
            case "Project": {
                return DimTypesEnum.getPROJECT();
            }
            case "BusinessPartner": {
                return DimTypesEnum.getBUSINESSPARTNER();
            }
            case "MultiBook": {
                return DimTypesEnum.getMULTIBOOK();
            }
            case "Version": {
                return DimTypesEnum.getVERSION();
            }
            case "DataSort": {
                return DimTypesEnum.getDATASORT();
            }
            case "DataType": {
                return DimTypesEnum.getDATATYPE();
            }
            case "MyCompany": {
                return DimTypesEnum.getMYCOMPANY();
            }
            case "Metric": {
                return DimTypesEnum.getMETRIC();
            }
        }
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getShortNumber() {
        return this.shortNumber;
    }
}

