/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.enums;

import com.google.common.collect.Sets;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;

public enum StorageTypeEnum {
    DEFAULT("", "0"),
    LABEL(StorageTypeEnum.getLABELStr(), "1"),
    STORAGE(StorageTypeEnum.getSTORAGEStr(), "2"),
    SHARE(StorageTypeEnum.getSHAREStr(), "3"),
    UNSHARE(StorageTypeEnum.getUNSHAREStr(), "4"),
    DYNAMIC(StorageTypeEnum.getDYNAMICStr(), "5");

    private static final Set<String> REAL_STORAGE_ENUM_INDEXS;
    public final String name;
    public final String index;

    private StorageTypeEnum(String name, String index) {
        this.name = name;
        this.index = index;
    }

    public static StorageTypeEnum stringToStorageType(String value) {
        if (value == null || value.length() == 0) {
            return DEFAULT;
        }
        if (value.length() > 1) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b : %s", (String)"StorageTypeEnum_4", (String)"epm-far-common", (Object[])new Object[0]), value));
        }
        switch (value.charAt(0)) {
            case '1': {
                return LABEL;
            }
            case '2': {
                return STORAGE;
            }
            case '3': {
                return SHARE;
            }
            case '4': {
                return UNSHARE;
            }
            case '5': {
                return DYNAMIC;
            }
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b : %s", (String)"StorageTypeEnum_4", (String)"epm-far-common", (Object[])new Object[0]), value));
    }

    public static boolean isShare(String storageType) {
        return StorageTypeEnum.isShare(StorageTypeEnum.stringToStorageType(storageType));
    }

    public static boolean isShare(StorageTypeEnum storageType) {
        return SHARE == storageType;
    }

    public static StorageTypeEnum getStorageTypeEnumByIndex(String index) {
        for (StorageTypeEnum storageTypeEnum : StorageTypeEnum.values()) {
            if (!storageTypeEnum.getOIndex().equals(index)) continue;
            return storageTypeEnum;
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b : %s", (String)"StorageTypeEnum_4", (String)"epm-far-common", (Object[])new Object[0]), index));
    }

    public static String getLABELStr() {
        return ResManager.loadKDString((String)"\u6807\u7b7e", (String)"StorageTypeEnum_0", (String)"epm-far-common", (Object[])new Object[0]);
    }

    public static String getSTORAGEStr() {
        return ResManager.loadKDString((String)"\u5b58\u50a8", (String)"StorageTypeEnum_1", (String)"epm-far-common", (Object[])new Object[0]);
    }

    public static String getSHAREStr() {
        return ResManager.loadKDString((String)"\u5171\u4eab", (String)"StorageTypeEnum_2", (String)"epm-far-common", (Object[])new Object[0]);
    }

    public static String getUNSHAREStr() {
        return ResManager.loadKDString((String)"\u4e0d\u5171\u4eab", (String)"StorageTypeEnum_3", (String)"epm-far-common", (Object[])new Object[0]);
    }

    public static String getDYNAMICStr() {
        return ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97", (String)"StorageTypeEnum_5", (String)"epm-far-common", (Object[])new Object[0]);
    }

    public static Set<String> getRealStorageEnumIndexs() {
        return REAL_STORAGE_ENUM_INDEXS;
    }

    public String getName() {
        switch (this.index) {
            case "1": {
                return StorageTypeEnum.getLABELStr();
            }
            case "2": {
                return StorageTypeEnum.getSTORAGEStr();
            }
            case "3": {
                return StorageTypeEnum.getSHAREStr();
            }
            case "4": {
                return StorageTypeEnum.getUNSHAREStr();
            }
            case "5": {
                return StorageTypeEnum.getDYNAMICStr();
            }
        }
        return this.name;
    }

    public String getOIndex() {
        return this.index;
    }

    static {
        REAL_STORAGE_ENUM_INDEXS = Sets.newHashSet((Object[])new String[]{STORAGE.getOIndex(), UNSHARE.getOIndex()});
    }
}

